/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.gui;

import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class LimitedTextDocument
extends PlainDocument {
    private int maxCharLimit;
    private String[] tokenList;

    private void $init$() {
        this.maxCharLimit = 1024;
    }

    public LimitedTextDocument() {
        this(0, null);
    }

    public LimitedTextDocument(int size) {
        this(size, null);
    }

    public void setSize(int size) {
        this.maxCharLimit = size;
    }

    public int getSize() {
        return this.maxCharLimit;
    }

    public LimitedTextDocument(int size, String[] token) {
        this.$init$();
        if (size > 0) {
            this.maxCharLimit = size;
        }
        this.tokenList = token;
    }

    public void insertString(int offs, String text, AttributeSet a) throws BadLocationException {
        if (text == null || text.equals("")) {
            return;
        }
        int length = this.getLength() + text.length();
        if (length <= this.maxCharLimit) {
            super.insertString(offs, text, a);
        } else {
            int index = 0;
            if (this.getLength() == 0) {
                String maxStr = text.substring(0, this.maxCharLimit);
                if (this.tokenList != null) {
                    int lastTokenIndex = -1;
                    int tokenLength = 0;
                    int i = 0;
                    while (i < this.tokenList.length) {
                        String tokenStr = this.tokenList[i];
                        index = maxStr.lastIndexOf(tokenStr);
                        if (index > lastTokenIndex) {
                            lastTokenIndex = index;
                            tokenLength = tokenStr.length();
                        }
                        ++i;
                    }
                    if (lastTokenIndex == -1) {
                        if (text.charAt(this.maxCharLimit) != ' ' && (index = maxStr.lastIndexOf(32)) != -1) {
                            maxStr = maxStr.substring(0, index);
                        }
                    } else if (text.charAt(this.maxCharLimit) != ' ') {
                        index = maxStr.lastIndexOf(32);
                        maxStr = index != -1 ? (index > lastTokenIndex ? maxStr.substring(0, index) : maxStr.substring(0, lastTokenIndex + tokenLength)) : maxStr.substring(0, lastTokenIndex + tokenLength);
                    }
                } else if (text.charAt(this.maxCharLimit) != ' ' && (index = maxStr.lastIndexOf(32)) != -1) {
                    maxStr = maxStr.substring(0, index);
                }
                super.insertString(offs, maxStr, a);
            }
            Toolkit.getDefaultToolkit().beep();
        }
    }
}

