/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.gui.component.comboBox;

import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.event.ListDataListener;
import javax.swing.tree.TreePath;

public class TreeListComboBoxModel
extends DefaultComboBoxModel {
    public static int JLIST_ITEMS = 0;
    public static int JLIST_OPTIONS = 1;
    private JTree m_jTree;
    private JList[] m_jLists;
    private ArrayList m_arrayListSelectFilters;

    public TreeListComboBoxModel() {
    }

    public TreeListComboBoxModel(JTree jTree, JList[] jLists) {
        this.m_jTree = jTree;
        this.m_jLists = jLists;
    }

    public TreeListComboBoxModel(JTree jTree, JList[] jLists, ArrayList arrayListFilters) {
        this(jTree, jLists);
        this.m_arrayListSelectFilters = arrayListFilters;
    }

    public void setTree(JTree jTree) {
        this.m_jTree = jTree;
    }

    public JTree getTree() {
        return this.m_jTree;
    }

    public void setLists(JList[] jLists) {
        this.m_jLists = jLists;
    }

    public JList[] getLists() {
        return this.m_jLists;
    }

    public JList getList(int nIndex) {
        JList jList = null;
        if (this.m_jLists != null && nIndex < this.m_jLists.length) {
            jList = this.m_jLists[nIndex];
        }
        return jList;
    }

    public void setSelectionFilters(ArrayList arrayListFilters) {
        this.m_arrayListSelectFilters = arrayListFilters;
    }

    public ArrayList getSelectionFilters() {
        return this.m_arrayListSelectFilters;
    }

    public Object getSelectedListItem() {
        JList jList;
        Object objSelectedItem = null;
        JList[] jLists = this.getLists();
        if (jLists != null && (jList = jLists[JLIST_ITEMS]) != null) {
            objSelectedItem = jList.getModel().getElementAt(0);
        }
        return objSelectedItem;
    }

    public void setSelectedItem(Object objItem) {
        Object objTreeSelection;
        TreePath treePathSelection;
        super.setSelectedItem(objItem);
        if (this.m_arrayListSelectFilters != null && this.m_arrayListSelectFilters.size() != 0 && objItem != null && this.m_arrayListSelectFilters.contains(objItem.getClass())) {
            return;
        }
        TreePath treePath = treePathSelection = this.m_jTree != null ? this.m_jTree.getSelectionPath() : null;
        if (treePathSelection != null && (objTreeSelection = treePathSelection.getLastPathComponent()) != null && objTreeSelection == objItem) {
            return;
        }
        TreePath treePathNewSelection = this.getTreePath(objItem);
        if (this.m_jTree != null) {
            this.m_jTree.setSelectionPath(treePathNewSelection);
            this.m_jTree.scrollPathToVisible(treePathNewSelection);
        }
        if (this.m_jLists != null) {
            int nIndex = 0;
            while (nIndex < this.m_jLists.length) {
                this.m_jLists[nIndex].setSelectedValue(objItem, true);
                ++nIndex;
            }
        }
    }

    public TreePath getTreePath(Object object) {
        return null;
    }

    public int getSize() {
        int nSize;
        int n = nSize = this.m_jTree != null ? this.m_jTree.getRowCount() : 0;
        if (this.m_jLists != null) {
            int nIndex = 0;
            while (nIndex < this.m_jLists.length) {
                nSize += this.m_jLists[nIndex].getModel().getSize();
                ++nIndex;
            }
        }
        return nSize;
    }

    public Object getElementAt(int nIndex) {
        int nSize;
        int n = nSize = this.m_jTree != null ? this.m_jTree.getRowCount() : 0;
        if (nIndex < nSize) {
            TreePath treePath = this.m_jTree.getPathForRow(nIndex);
            return treePath == null ? null : treePath.getLastPathComponent();
        }
        if (this.m_jLists != null) {
            int i = 0;
            while (i < this.m_jLists.length) {
                if (nIndex < nSize + this.m_jLists[i].getModel().getSize()) {
                    return this.m_jLists[i].getModel().getElementAt(nIndex - nSize);
                }
                nSize += this.m_jLists[i].getModel().getSize();
                ++i;
            }
        }
        return null;
    }

    public void addListDataListener(ListDataListener listDataListener) {
    }

    public void removeListDataListener(ListDataListener listDataListener) {
    }

    private TreePath findObject(Object findObj, Object node, TreePath treePathToNode) {
        if (findObj == node) {
            return treePathToNode;
        }
        if (this.m_jTree != null) {
            int nIndex = 0;
            while (nIndex < this.m_jTree.getModel().getChildCount(node)) {
                TreePath childPath;
                Object childNode = this.m_jTree.getModel().getChild(node, nIndex);
                TreePath treePath = this.findObject(findObj, childNode, childPath = treePathToNode.pathByAddingChild(childNode));
                if (treePath != null) {
                    return treePath;
                }
                ++nIndex;
            }
        }
        return null;
    }
}

