/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.gui.component.qdr.impl;

import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.ListModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import oracle.dss.util.DataAccess2;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.HierarchicalQDR;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.QDR;
import oracle.dss.util.gui.component.DimensionMemberComponentNode;
import oracle.dss.util.gui.component.comboBox.DefaultTreeListComboModel;
import oracle.dss.util.gui.component.comboBox.TreeListComboModel;
import oracle.dss.util.gui.component.qdr.QDRPanelModel;

public class QDRPanelModelImpl
implements QDRPanelModel {
    private HierarchicalQDR m_qdr;
    private DataAccess2 m_dataAccess;
    private Hashtable m_items;
    private String m_labelType;
    private String m_memberLabelType;

    private void $init$() {
        this.m_labelType = "dimLongName";
        this.m_memberLabelType = "longName";
    }

    public QDRPanelModelImpl(QDR qdr, DataAccess2 dataAccess) {
        this(new HierarchicalQDR(qdr), dataAccess);
    }

    public QDRPanelModelImpl(HierarchicalQDR qdr, DataAccess2 dataAccess) {
        this.$init$();
        this.m_items = new Hashtable();
        this.setQDR(qdr);
        this.setDataAccess(dataAccess);
        this.updateItems();
    }

    public HierarchicalQDR getQDR() {
        return this.m_qdr;
    }

    public void setQDR(HierarchicalQDR qdr) {
        this.m_qdr = qdr;
    }

    public void setDataAccess(DataAccess2 dataAccess) {
        this.m_dataAccess = dataAccess;
    }

    public DataAccess2 getDataAccess() {
        return this.m_dataAccess;
    }

    public TreeListComboModel getMembers(String item) {
        String[] types = new String[]{"value", this.m_memberLabelType, "hierarchy", "level", "levelName"};
        List members = null;
        try {
            members = this.m_dataAccess.getUniqueMemberMetadata(item, types, 0, -1);
        }
        catch (Exception e) {
            // empty catch block
        }
        Vector<DimensionMemberComponentNode> v = new Vector<DimensionMemberComponentNode>();
        if (members != null) {
            int i = 0;
            while (i < members.size()) {
                Object[] member = (Object[])members.get(i);
                String hierarchy = QDRPanelModelImpl.makeString(member[2]);
                String memberID = QDRPanelModelImpl.makeString(member[0]);
                String memberLabel = QDRPanelModelImpl.makeString(member[1]);
                String levelID = QDRPanelModelImpl.makeString(member[3]);
                String levelName = QDRPanelModelImpl.makeString(member[4]);
                DimensionMemberComponentNode cn = new DimensionMemberComponentNode(item, hierarchy, memberID, memberLabel, levelID, levelName);
                v.add(cn);
                ++i;
            }
        }
        return new QDRTreeListComboModel(v);
    }

    private static String makeString(Object value) {
        return value == null ? null : value.toString();
    }

    public boolean isAddRemoveSupported() {
        return false;
    }

    public String getNewItem() {
        return null;
    }

    public String getLabel(String item) {
        return (String)this.m_items.get(item);
    }

    public void updateItems() {
        this.m_items.clear();
        int edge = 0;
        while (edge < this.m_dataAccess.getEdgeCount()) {
            try {
                int layer = 0;
                while (layer < this.m_dataAccess.getLayerCount(edge)) {
                    try {
                        String label = this.m_dataAccess.getLayerMetadata(edge, layer, this.m_labelType).toString();
                        String id = this.m_dataAccess.getLayerMetadata(edge, layer, "dimName").toString();
                        this.m_items.put(id, label);
                    }
                    catch (LayerOutOfRangeException le) {
                        // empty catch block
                    }
                    ++layer;
                }
            }
            catch (EdgeOutOfRangeException e) {
                // empty catch block
            }
            ++edge;
        }
    }

    public void setDisplayLabelType(String strDisplayLabelType) {
        this.m_labelType = strDisplayLabelType;
    }

    public String getDisplayLabelType() {
        return this.m_labelType;
    }

    public void setDisplayMemberLabelType(String strDisplayMemberLabelType) {
        this.m_memberLabelType = strDisplayMemberLabelType;
    }

    public String getDisplayMemberLabelType() {
        return this.m_memberLabelType;
    }

    private class QDRTreeListComboModel
    extends DefaultTreeListComboModel {
        DefaultTreeModel m_treeModel;

        public QDRTreeListComboModel(Vector v) {
            DefaultMutableTreeNode root = new DefaultMutableTreeNode();
            int i = 0;
            while (i < v.size()) {
                DefaultMutableTreeNode child = new DefaultMutableTreeNode(v.get(i), false);
                root.add(child);
                ++i;
            }
            this.m_treeModel = new DefaultTreeModel(root);
        }

        public TreeModel getTreeModel() {
            return this.m_treeModel;
        }

        public ListModel[] getListModels() {
            return new ListModel[0];
        }

        public boolean isMultiSelect() {
            return true;
        }
    }
}

