/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.gui.component.tree;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.dss.util.gui.component.tree.Checkable;
import oracle.dss.util.gui.component.tree.VirtualTreeCellRenderer;

public class CheckTreeCellRenderer
extends VirtualTreeCellRenderer {
    private static final ImageIcon m_imgActive = new ImageIcon(ImageUtils.getImageResource(CheckTreeCellRenderer.class, (String)"images/active.gif"));
    private static final ImageIcon m_imgInactive = new ImageIcon(ImageUtils.getImageResource(CheckTreeCellRenderer.class, (String)"images/inactive.gif"));
    private JLabel m_label;
    private JCheckBox m_chkActive;

    public CheckTreeCellRenderer(JTree tree) {
        super(tree);
        this.$init$();
        this.m_chkActive = this.makeCheckBox(tree);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component c = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        if (c instanceof JLabel) {
            this.m_label = (JLabel)c;
        }
        if (value instanceof Checkable) {
            this.m_chkActive.setSelected(((Checkable)value).isChecked());
            this.m_chkActive.setOpaque(false);
            JPanel p = new JPanel(new BorderLayout());
            p.setOpaque(false);
            p.add((Component)this.m_chkActive, "West");
            p.add(c, "Center");
            return p;
        }
        return c;
    }

    JLabel getLabel() {
        return this.m_label;
    }

    JCheckBox getCheckBox() {
        return this.m_chkActive;
    }

    private void $init$() {
        this.m_label = null;
        this.m_chkActive = null;
    }

    private JCheckBox makeCheckBox(JTree tree) {
        JCheckBox c = new JCheckBox();
        c.setIcon(m_imgInactive);
        c.setSelectedIcon(m_imgActive);
        c.setBorder(BorderFactory.createEmptyBorder());
        c.setBorderPainted(false);
        if (tree != null) {
            c.setBackground(tree.getBackground());
            c.setForeground(tree.getForeground());
        }
        return c;
    }
}

