/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.gui.component.tree;

import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JTree;
import oracle.dss.util.gui.component.ComponentNode;
import oracle.dss.util.gui.component.tree.CheckableTreeNodeImpl;
import oracle.dss.util.gui.component.tree.ComponentTreeNode;

public class ComponentTreeNodeImpl
extends CheckableTreeNodeImpl
implements ComponentTreeNode {
    private Hashtable m_hashtableEnv;
    private Vector m_vCachedChildren;

    private void $init$() {
        this.m_hashtableEnv = null;
        this.m_vCachedChildren = null;
    }

    public ComponentTreeNodeImpl(JTree jTree, ComponentNode componentNode, Hashtable hashtableEnv) {
        super(jTree, componentNode);
        this.$init$();
        this.setEnvironment(hashtableEnv);
    }

    public ComponentNode getComponentNode() {
        Object object = this.getUserObject();
        if (object instanceof ComponentNode) {
            return (ComponentNode)object;
        }
        return null;
    }

    public void refresh() {
        this.removeCachedChildren();
        super.refresh();
    }

    public Icon getOpenIcon() {
        return null;
    }

    public Icon getClosedIcon() {
        return null;
    }

    public JTree getTree() {
        Object objComponent;
        JTree jTree = super.getTree();
        if (jTree == null && this.m_hashtableEnv != null && (objComponent = this.m_hashtableEnv.get("tree")) != null && objComponent instanceof JTree) {
            jTree = (JTree)objComponent;
        }
        return jTree;
    }

    public void setEnvironment(Hashtable environment) {
        this.m_hashtableEnv = environment;
    }

    public Hashtable getEnvironment() {
        return this.m_hashtableEnv;
    }

    protected Vector getChildren(int nIndex, int nOffset) {
        if (this.getCachedChildren() == null) {
            this.setCachedChildren(this.getAllChildren());
            if (this.getCachedChildren() != null) {
                this.setSize(this.getCachedChildren().size());
            }
        }
        return ComponentTreeNodeImpl.subVector(this.getCachedChildren(), nIndex, nOffset);
    }

    protected Vector getAllChildren() {
        return null;
    }

    protected Vector getCachedChildren() {
        return this.m_vCachedChildren;
    }

    protected void setCachedChildren(Vector vCachedChildren) {
        this.m_vCachedChildren = vCachedChildren;
    }

    protected void removeCachedChildren() {
        Vector vCachedChildren = this.getCachedChildren();
        if (vCachedChildren != null) {
            int nIndex = vCachedChildren.size() - 1;
            while (nIndex >= 0) {
                vCachedChildren.set(nIndex, null);
                --nIndex;
            }
            this.setCachedChildren(null);
        }
    }

    private static Vector subVector(Vector v, int nIndex, int nOffset) {
        if (v != null) {
            Vector vSub = new Vector();
            try {
                int i = nIndex;
                while (i < nIndex + nOffset) {
                    vSub.add(v.get(i));
                    ++i;
                }
            }
            catch (IndexOutOfBoundsException e) {
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            return vSub;
        }
        return null;
    }
}

