/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.gui.component.tree;

import java.util.Vector;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import oracle.dss.util.gui.component.tree.VirtualTreeCellEditor;
import oracle.dss.util.gui.component.tree.VirtualTreeCellRenderer;
import oracle.dss.util.gui.component.tree.VirtualTreeNode;

public class VirtualTree
extends JTree {
    public static int DEFAULT_PAGE_SIZE = 1000;
    private int m_intPageSize;
    private boolean m_blnVirtual;
    private int[] m_selectedRows;

    public VirtualTree(int intPageSize) {
        this.$init$();
        this.setEditable(true);
        this.setPageSize(intPageSize);
        this.setModel(new DefaultTreeModel(this.makeTreeNodes()));
        this.setCellRenderer(new VirtualTreeCellRenderer(this));
        this.setCellEditor(new VirtualTreeCellEditor((JTree)this, new VirtualTreeCellRenderer(this)));
    }

    public VirtualTree() {
        this(DEFAULT_PAGE_SIZE);
    }

    public void setPageSize(int intPageSize) {
        this.m_intPageSize = intPageSize;
    }

    public int getPageSize() {
        return this.m_intPageSize;
    }

    public void setVirtual(boolean blnVirtual) {
        this.m_blnVirtual = blnVirtual;
    }

    public boolean isVirtual() {
        return this.m_blnVirtual;
    }

    int[] getSelectedRows() {
        return this.m_selectedRows;
    }

    private void $init$() {
        this.m_intPageSize = DEFAULT_PAGE_SIZE;
        this.m_blnVirtual = true;
        this.m_selectedRows = null;
    }

    private TreeNode makeTreeNodes() {
        return new SampleNode(this, new DefaultMutableTreeNode("1"), 1, 20, 0);
    }

    private class SampleNode
    extends VirtualTreeNode {
        private DefaultMutableTreeNode m_node;
        private SampleNode[] m_data;
        private int m_intLevel;

        public SampleNode(JTree tree, DefaultMutableTreeNode node, int i, int intSize, int intLevel) {
            super(tree, null, intSize);
            this.$init$();
            if (node != null) {
                if (node instanceof SampleNode) {
                    this.setUserObject(new String(node.toString() + "." + Integer.toString(i)));
                } else {
                    this.setUserObject(new String(node.toString()));
                }
            }
            this.m_data = new SampleNode[intSize];
            this.m_intLevel = intLevel;
        }

        protected Vector getChildren(int intIndex, int intOffset) {
            Vector<SampleNode> v = new Vector<SampleNode>();
            if (this.m_data != null) {
                try {
                    int i = intIndex;
                    while (i < intOffset + intIndex) {
                        if (this.m_data[i] == null) {
                            this.m_data[i] = new SampleNode(this.getTree(), this, i, this.getSize(), ++this.m_intLevel);
                        }
                        v.addElement(this.m_data[i]);
                        ++i;
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    // empty catch block
                }
            }
            v.trimToSize();
            return v;
        }

        private void $init$() {
            this.m_node = null;
            this.m_data = null;
            this.m_intLevel = 0;
        }
    }
}

