/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.gui.component.tree;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeModel;
import oracle.dss.util.gui.component.tree.ArrowButton;
import oracle.dss.util.gui.component.tree.DeferredTreeNodeImpl;
import oracle.dss.util.gui.component.tree.VirtualTree;

public class VirtualTreeNode
extends DeferredTreeNodeImpl {
    private static final int scrollSpeedThrottle = 60;
    private int m_nScrollUnit;
    private int m_nIndex;
    private int m_nSize;
    private int m_nPageSize;
    private DefaultMutableTreeNode m_nodeUp;
    private DefaultMutableTreeNode m_nodeDown;
    private JButton m_btnArrowUp;
    private JButton m_btnArrowDown;
    private ScrollListener m_scrollListener;
    private Timer m_timerScroll;

    private void $init$() {
        this.m_nScrollUnit = 1;
        this.m_nIndex = 0;
        this.m_nSize = 0;
        this.m_nPageSize = VirtualTree.DEFAULT_PAGE_SIZE;
        this.m_nodeUp = null;
        this.m_nodeDown = null;
        this.m_btnArrowUp = null;
        this.m_btnArrowDown = null;
        this.m_scrollListener = null;
        this.m_timerScroll = null;
    }

    public VirtualTreeNode(JTree jTree, Object objUser, int nSize, int nPageSize) {
        super(jTree, objUser);
        this.$init$();
        this.setSize(nSize);
        this.setPageSize(nPageSize);
        this.initialize();
    }

    public VirtualTreeNode(JTree jTree, Object objUser, int nSize) {
        this(jTree, objUser, nSize, VirtualTreeNode.getPageSize(jTree));
    }

    public void setPageSize(int nPageSize) {
        this.m_nPageSize = nPageSize;
    }

    public int getPageSize() {
        return this.m_nPageSize;
    }

    public void setSize(int nSize) {
        this.m_nSize = nSize;
        this.updateEnabled();
    }

    public int getSize() {
        return this.m_nSize;
    }

    public void scroll(int nOffset) {
        if (this.inBounds(nOffset)) {
            TreeModel treeModel;
            this.m_nIndex += nOffset;
            this.refresh();
            JTree jTree = this.getTree();
            if (jTree != null && (treeModel = jTree.getModel()) instanceof DefaultTreeModel) {
                try {
                    TreeCellEditor editor = jTree.getCellEditor();
                    if (editor != null) {
                        editor.cancelCellEditing();
                    }
                    ((DefaultTreeModel)treeModel).nodeStructureChanged(this);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    protected Vector getChildren() {
        this.updateEnabled();
        return this.getChildren(this.m_nIndex, this.m_nPageSize);
    }

    protected Vector getChildren(int nIndex, int nOffset) {
        return null;
    }

    void setChildren(Vector vChildren) {
        this.addScrollButtons(vChildren);
        this.setParents(vChildren);
        super.setChildren(vChildren);
    }

    private void initialize() {
        this.m_scrollListener = new ScrollListener();
        this.m_timerScroll = new Timer(60, this.m_scrollListener);
        this.m_timerScroll.setInitialDelay(300);
        this.m_btnArrowUp = new ArrowButton(ArrowButton.UP);
        this.m_nodeUp = new DefaultMutableTreeNode(this.m_btnArrowUp);
        this.m_btnArrowUp.addActionListener(new ScrollListener(-1));
        this.m_btnArrowUp.addMouseListener(new 1(this));
        this.m_btnArrowDown = new ArrowButton(ArrowButton.DOWN);
        this.m_nodeDown = new DefaultMutableTreeNode(this.m_btnArrowDown);
        this.m_btnArrowDown.addActionListener(new ScrollListener(1));
        this.m_btnArrowDown.addMouseListener(new 2(this));
        JTree jTree = this.getTree();
        if (jTree != null) {
            this.m_btnArrowUp.setBackground(jTree.getBackground());
            this.m_btnArrowDown.setBackground(jTree.getBackground());
        }
    }

    private boolean isAboveLowerBound(int nOffset) {
        return this.m_nIndex + nOffset >= 0;
    }

    private boolean isBelowUpperBound(int nOffset) {
        return this.m_nIndex + this.m_nPageSize + nOffset <= this.getSize();
    }

    private boolean inBounds(int nOffset) {
        return this.isAboveLowerBound(nOffset) && this.isBelowUpperBound(nOffset);
    }

    private void updateEnabled() {
        if (this.m_btnArrowUp != null) {
            this.m_btnArrowUp.setEnabled(this.isAboveLowerBound(-1));
        }
        if (this.m_btnArrowDown != null) {
            this.m_btnArrowDown.setEnabled(this.isBelowUpperBound(1));
        }
    }

    private void addScrollButtons(Vector vScrollButtons) {
        if (vScrollButtons != null && vScrollButtons.size() < this.getSize()) {
            vScrollButtons.add(0, this.m_nodeUp);
            vScrollButtons.add(this.m_nodeDown);
        }
    }

    private void setParents(Vector vParents) {
        if (vParents != null) {
            Enumeration enumeration = vParents.elements();
            while (enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement();
                if (!(object instanceof MutableTreeNode)) continue;
                ((MutableTreeNode)object).setParent(this);
            }
        }
    }

    private static int getPageSize(JTree jTree) {
        VirtualTree virtualTree = VirtualTreeNode.getVirtualTree(jTree);
        if (virtualTree != null) {
            return virtualTree.getPageSize();
        }
        return VirtualTree.DEFAULT_PAGE_SIZE;
    }

    private static VirtualTree getVirtualTree(JTree jTree) {
        if (jTree instanceof VirtualTree) {
            return (VirtualTree)jTree;
        }
        return null;
    }

    static ScrollListener ra$m_scrollListener(VirtualTreeNode virtualTreeNode) {
        return virtualTreeNode.m_scrollListener;
    }

    static Timer ra$m_timerScroll(VirtualTreeNode virtualTreeNode) {
        return virtualTreeNode.m_timerScroll;
    }

    static int ra$m_nScrollUnit(VirtualTreeNode virtualTreeNode) {
        return virtualTreeNode.m_nScrollUnit;
    }

    static void wa$m_nScrollUnit(VirtualTreeNode virtualTreeNode, int n) {
        virtualTreeNode.m_nScrollUnit = n;
    }

    static JButton ra$m_btnArrowUp(VirtualTreeNode virtualTreeNode) {
        return virtualTreeNode.m_btnArrowUp;
    }

    final class 1
    extends ScrollMouseListener {
        public void mousePressed(MouseEvent me) {
            if (VirtualTreeNode.ra$m_btnArrowUp(VirtualTreeNode.this).isEnabled()) {
                this.setScrollUnit(-1);
                super.mousePressed(me);
            }
        }

        public 1(VirtualTreeNode virtualTreeNode2) {
            super((1)null);
        }
    }

    final class 2
    extends ScrollMouseListener {
        public void mousePressed(MouseEvent me) {
            this.setScrollUnit(1);
            super.mousePressed(me);
        }

        public 2(VirtualTreeNode virtualTreeNode2) {
            super((2)null);
        }
    }

    private class ScrollMouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent me) {
            VirtualTreeNode.ra$m_timerScroll(VirtualTreeNode.this).stop();
            VirtualTreeNode.ra$m_timerScroll(VirtualTreeNode.this).start();
        }

        public void mouseReleased(MouseEvent me) {
            VirtualTreeNode.ra$m_timerScroll(VirtualTreeNode.this).stop();
        }

        public void setScrollUnit(int nScrollUnit) {
            if (VirtualTreeNode.ra$m_scrollListener(VirtualTreeNode.this) != null) {
                VirtualTreeNode.ra$m_scrollListener(VirtualTreeNode.this).setScrollUnit(nScrollUnit);
            }
        }

        private ScrollMouseListener() {
        }

        ScrollMouseListener(1 var2_2) {
            this();
        }

        ScrollMouseListener(2 var2_2) {
            this();
        }
    }

    private class ScrollListener
    implements ActionListener {
        public ScrollListener() {
        }

        public ScrollListener(int nScrollUnit) {
            VirtualTreeNode.wa$m_nScrollUnit(VirtualTreeNode.this, nScrollUnit);
        }

        public void actionPerformed(ActionEvent ae) {
            VirtualTreeNode.this.scroll(VirtualTreeNode.ra$m_nScrollUnit(VirtualTreeNode.this));
        }

        public void setScrollUnit(int nScrollUnit) {
            VirtualTreeNode.wa$m_nScrollUnit(VirtualTreeNode.this, nScrollUnit);
        }

        public int getScrollUnit() {
            return VirtualTreeNode.ra$m_nScrollUnit(VirtualTreeNode.this);
        }
    }
}

