/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.gui.layout;

import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Vector;
import oracle.dss.util.PagingControlAttributes;
import oracle.dss.util.gui.layout.Crosstab;
import oracle.dss.util.gui.layout.Layout;

public class CrosstabLayout
extends Layout {
    protected Crosstab m_crosstab;
    private boolean m_bMeasuresPivotable;
    private Layout.PopupManager m_measuresPopupManager;
    private PagingControlAttributes m_pca;

    private void $init$() {
        this.m_bMeasuresPivotable = true;
        this.m_pca = null;
    }

    public CrosstabLayout() {
        this.$init$();
        this.init();
        this.updateTextUsingCorrectLocale();
    }

    protected void updateTextUsingCorrectLocale() {
        super.updateTextUsingCorrectLocale();
        String rMeasures = this.m_rBundle.getString("Measures");
        this.m_popupManager.setRowName(this.m_rBundle.getString("Row"));
        this.m_popupManager.setColumnName(this.m_rBundle.getString("Column"));
        this.m_popupManager.setMeasureName(rMeasures);
        this.m_measuresPopupManager.setMeasureName(rMeasures);
        this.m_measuresPopupManager.updateTextUsingCorrectLocale();
    }

    private void init() {
        Layout.LayoutPivotListener pivotListener = new Layout.LayoutPivotListener(this);
        this.m_popupManager.setPivotListener(pivotListener);
        this.m_popupManager.setPageLayoutComponent(this.m_pageEdgeLayers);
        this.m_crosstab = new Crosstab();
        this.m_crosstab.addPivotListener(new Layout.LayoutPivotListener(this));
        this.m_crosstab.setPopupManager(this.m_popupManager);
        this.m_measuresPopupManager = new Layout.PopupManager(this);
        this.m_measuresPopupManager.setPivotListener(pivotListener);
        this.m_measuresPopupManager.setShowHideMenuItem(false);
        this.setMeasuresPivotable(true);
        this.m_crosstab.setAlignmentX(0.0f);
        this.add(this.m_crosstab);
        this.m_componentListener = new 1();
        this.addComponentListener(this.m_componentListener);
    }

    public void setPagingControlAttributes(PagingControlAttributes pca) {
        this.m_pca = pca;
        if (this.m_pca != null) {
            this.m_showPageItemsChkBox.setSelected(this.m_pca.isPagingControlVisible());
        }
    }

    public boolean apply() {
        if (this.m_pca != null) {
            this.m_pca.setPagingControlVisible(this.m_bPagingControlVisible);
        }
        return super.apply();
    }

    public String getDescriptionText() {
        if (super.getDescriptionText() != null && super.getDescriptionText().length() > 0) {
            return super.getDescriptionText();
        }
        return this.m_rBundle.getString("crosstabLayoutDesc");
    }

    public void setMeasuresPivotable(boolean pivotable) {
        this.m_bMeasuresPivotable = pivotable;
        if (pivotable) {
            this.m_crosstab.setGridPopupManager(this.m_popupManager);
        } else {
            this.m_crosstab.setGridPopupManager(this.m_measuresPopupManager);
            this.m_popupManager.setMeasureLayoutComponent(null);
        }
    }

    public boolean isMeasuresPivotable() {
        return this.m_bMeasuresPivotable;
    }

    public String getHelpContextID() {
        if (this.m_bPagingControlVisible) {
            return this.getClass().getName() + "_PageCtrl";
        }
        return this.getClass().getName() + "_NoPageCtrl";
    }

    protected void updateLayerDisplay() {
        super.updateLayerDisplay();
        this.addLayersToPagingComponent(this.m_pageEdgeLayers, 2, true, true);
        Vector rowLayers = this.getEdgeLayers(1);
        Object[] arrRowLayers = new String[rowLayers.size()];
        rowLayers.copyInto(arrRowLayers);
        Vector colLayers = this.getEdgeLayers(0);
        Object[] arrColLayers = new String[colLayers.size()];
        colLayers.copyInto(arrColLayers);
        this.m_crosstab.getColumnHeader().setItems((String[])arrColLayers);
        this.m_crosstab.getRowHeader().setItems((String[])arrRowLayers);
        int measureEdge = this.m_layoutAccess.getMeasureEdge();
        if (measureEdge == 1) {
            this.m_crosstab.setDataPointOrientation(1);
        } else {
            this.m_crosstab.setDataPointOrientation(0);
        }
        this.m_crosstab.getDataPointGrid().setItems(this.m_layoutAccess.getMeasures(this.getMemberMetadataLabelType()));
    }

    protected boolean performPivot(int fromEdge, int toEdge, int fromLayer, int toLayer, boolean isPivot) {
        block9: {
            int flags = -1;
            if (fromEdge == toEdge && fromEdge == -1) {
                try {
                    if (super.performPivot(fromEdge, toEdge, fromLayer, toLayer, isPivot)) break block9;
                    String[] measures = null;
                    if (this.m_layoutAccess != null && (measures = this.m_layoutAccess.getMeasures("value")) != null) {
                        int measureCount = measures.length;
                        if (fromLayer > -1 && fromLayer < measureCount && toLayer > -1 && toLayer < measureCount) {
                            Object[] reorderedMeasures = new String[measureCount];
                            Vector<String> vMeasures = new Vector<String>();
                            int i = 0;
                            while (i < measureCount) {
                                vMeasures.addElement(measures[i]);
                                ++i;
                            }
                            String sourceMeasure = measures[fromLayer];
                            String destinationMeasure = measures[toLayer];
                            if (isPivot) {
                                vMeasures.removeElementAt(fromLayer);
                                vMeasures.insertElementAt(sourceMeasure, toLayer);
                            } else {
                                vMeasures.setElementAt(destinationMeasure, fromLayer);
                                vMeasures.setElementAt(sourceMeasure, toLayer);
                            }
                            vMeasures.copyInto(reorderedMeasures);
                            this.m_layoutAccess.setMeasures((String[])reorderedMeasures);
                            boolean bl = true;
                            return bl;
                        }
                    }
                    break block9;
                }
                catch (Exception e) {
                    if (this.m_eh != null) {
                        this.m_eh.error(e, this.getClass().getName(), "performPivot");
                    }
                    break block9;
                }
            }
            return super.performPivot(fromEdge, toEdge, fromLayer, toLayer, isPivot);
        }
        return false;
    }

    final class 1
    extends ComponentAdapter {
        public void componentResized(ComponentEvent e) {
            CrosstabLayout.this.resizeDescriptionLabel();
        }
    }
}

