/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.gui.layout;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dnd.DragGestureEvent;
import oracle.bali.ewt.dnd.DragGestureListener;
import oracle.bali.ewt.dnd.DragGestureRecognizer;
import oracle.bali.ewt.dnd.DragSource;
import oracle.bali.ewt.dnd.DragSourceDragEvent;
import oracle.bali.ewt.dnd.DragSourceDropEvent;
import oracle.bali.ewt.dnd.DragSourceEvent;
import oracle.bali.ewt.dnd.DragSourceListener;
import oracle.bali.ewt.dnd.DropTarget;
import oracle.bali.ewt.dnd.DropTargetDragEvent;
import oracle.bali.ewt.dnd.DropTargetDropEvent;
import oracle.bali.ewt.dnd.DropTargetEvent;
import oracle.bali.ewt.dnd.DropTargetListener;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.SingleAppearanceManager;
import oracle.bali.ewt.model.AbstractTwoDModel;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.pivot.PivotTransfer;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.share.datatransfer.TransferUtils;
import oracle.dss.util.gui.layout.Crosstab;
import oracle.dss.util.gui.layout.Layout;
import oracle.dss.util.gui.layout.LayoutComponent;

public class DataPointGrid
extends Grid
implements LayoutComponent {
    private static final int _DEFAULT_WIDTH = 20;
    private static final int _DEFAULT_HEIGHT = 20;
    private static final int _DROP_FEEDBACK_SIZE = 4;
    private int _edge;
    private int _dragIndex;
    private int _dropIndex;
    private Crosstab _crosstab;
    private GridDS _model;
    private GridListener _listener;
    private GridDragDropAdapter _dragDrop;
    private Layout.PopupManager _popupManager;
    private String _backgroundText;

    private void $init$() {
        this._dragIndex = -1;
        this._dropIndex = -1;
        this._backgroundText = null;
    }

    public DataPointGrid(Crosstab parent, int edge) {
        this.$init$();
        this._crosstab = parent;
        this._edge = edge;
        this._model = new GridDS();
        this.setModel((TwoDModel)this._model);
        this.setDefaultInputHandler(new GridInputHandler(null));
        this._listener = new GridListener(null);
        this.addPropertyChangeListener(this._listener);
        this.enableEvents(4);
        this._dragDrop = new GridDragDropAdapter(this);
    }

    public void setItems(String[] items) {
        this._model.setItems(items);
        this._setSizes();
    }

    public String getItem(int index) {
        return this._model.getElement(index);
    }

    public String[] getItems() {
        int count = this.getOrientation() == 0 ? this._model.getColumnCount() : this._model.getRowCount();
        String[] items = new String[count];
        int i = 0;
        while (i < count) {
            items[i] = this.getItem(i);
            ++i;
        }
        return items;
    }

    public int getEdge() {
        return this._edge;
    }

    public void setEdge(int edge) {
        this._edge = edge;
    }

    public int getSelectedIndex() {
        return this._getSelectedIndex();
    }

    public void clearSelection() {
        try {
            this.deselectAll();
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public int getOrientation() {
        return this._model.getOrientation();
    }

    public void setOrientation(int orientation) {
        this._model.setOrientation(orientation);
        if (orientation == 1 && this.getColumnCount() != 0) {
            this.setColumnWidth(0, -1);
        }
        if (orientation == 1) {
            this.setPreferredColumnsOnScreen(0);
            this.setPreferredRowsOnScreen(3);
        } else {
            this.setPreferredColumnsOnScreen(3);
            this.setPreferredRowsOnScreen(0);
        }
        this._setSizes();
    }

    public void setColumnWidth(int width) {
        if (this.getOrientation() == 1) {
            this.setDefaultColumnWidth(width - 4);
        }
    }

    public void setPopupManager(Layout.PopupManager popupManager) {
        this._popupManager = popupManager;
    }

    public boolean isFocusTraversable() {
        return this.getColumnCount() != 0;
    }

    public Insets getAutoscrollInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public void paintCanvasInterior(Graphics g) {
        super.paintCanvasInterior(g);
        if (this._dragIndex != -1 && this._dropIndex != -1) {
            this._paintDropFeedback(g);
        }
    }

    public void cleanup() {
        this.setModel(null);
        this.setDefaultInputHandler(null);
        this.removePropertyChangeListener(this._listener);
        if (this._dragDrop != null) {
            this._dragDrop.cleanup();
        }
        this._crosstab = null;
        this._model = null;
    }

    public void setBackgroundText(String text) {
        this._backgroundText = text;
    }

    private String getBackgroundText() {
        String[] items;
        if (this._backgroundText != null && this._backgroundText.length() > 0 && ((items = this.getItems()) == null || items.length == 0)) {
            return this._backgroundText;
        }
        return null;
    }

    public void paintComponent(Graphics g) {
        String strText = this.getBackgroundText();
        if (strText == null) {
            super.paintComponent(g);
        } else {
            if (this.isOpaque()) {
                super.paintComponent(g);
            }
            Font curFont = g.getFont();
            g.setColor(Color.lightGray);
            int textWidth = SwingUtilities.computeStringWidth(this.getFontMetrics(curFont), strText);
            FontMetrics fm = g.getFontMetrics();
            int ascent = fm.getMaxAscent();
            int descent = fm.getMaxDescent();
            int baseline = this.getSize().height / 2 - descent / 2 + ascent / 2;
            g.drawString(strText, (this.getWidth() - textWidth) / 2, baseline);
        }
    }

    void firePivotEvent(Object source, int sourceIndex, Object destination, int destinationIndex) {
        if (source == destination && sourceIndex == destinationIndex) {
            return;
        }
        this._crosstab.firePivotEvent(source, sourceIndex, destination, destinationIndex);
    }

    private int _getSelectedIndex() {
        int index = -1;
        Cell cell = this.getSelection().getSingleCell();
        if (cell != null) {
            index = this.getOrientation() == 0 ? cell.column : cell.row;
        }
        return index;
    }

    private void _paintDropFeedback(Graphics g) {
        if (this._dropIndex == this._dragIndex) {
            return;
        }
        Rectangle rect = this.getInnerBounds();
        Dimension bounds = this.getCanvasSize();
        Color oldColor = g.getColor();
        g.setColor(Color.black);
        if (this.getOrientation() == 0) {
            int origin;
            int count = this.getColumnCount();
            int position = this._dropIndex < count ? this.getColumnPosition(this._dropIndex) : (this._dropIndex == count && count != 0 ? this.getColumnPosition(this._dropIndex - 1) + this.getColumnWidth(this._dropIndex - 1) : 0);
            int x = position - 2;
            if (x < rect.x + (origin = -this.getCanvasOriginX())) {
                x = rect.x + origin;
            }
            if (x + 4 > rect.width + origin) {
                x = rect.width + origin - 4;
            }
            g.fillRect(x, 0, 4, rect.height);
        } else {
            int origin;
            int count = this.getRowCount();
            int position = this._dropIndex < count ? this.getRowPosition(this._dropIndex) : (this._dropIndex == count && count != 0 ? this.getRowPosition(this._dropIndex - 1) + this.getRowHeight(this._dropIndex - 1) : 0);
            int y = position - 2;
            if (y < rect.y + (origin = -this.getCanvasOriginY())) {
                y = rect.y + origin;
            }
            if (y + 4 > rect.height + origin) {
                y = rect.height + origin - 4;
            }
            g.fillRect(0, y, rect.width, 4);
        }
        if (oldColor != null) {
            g.setColor(oldColor);
        }
    }

    private void _setSizes() {
        Painter p = this.getDefaultPainter();
        PaintContext context = this.getPaintContext();
        SingleAppearanceManager am = (SingleAppearanceManager)this.getAppearanceManager();
        ImmInsets insets = am.getAppearance().getInsets();
        int extra = insets.left + insets.right + 4;
        int i = 0;
        while (i < this.getColumnCount()) {
            int max = 0;
            int j = 0;
            while (j < this.getRowCount()) {
                context = this.getCellPaintContext(i, j);
                int width = p.getPreferredSize((PaintContext)context).width;
                if (width > max) {
                    max = width;
                }
                ++j;
            }
            if (this.getOrientation() == 0) {
                this.setColumnWidth(i, max + extra);
            } else {
                this.setDefaultColumnWidth(max + extra);
            }
            ++i;
        }
        this.validate();
        this.repaint();
    }

    void setDragItem(int item) {
        this._dragIndex = item;
    }

    void setDropLocation(int drop) {
        if (this._dropIndex != drop) {
            this._dropIndex = drop;
            this.paintImmediateInterior();
        }
    }

    static Crosstab ra$_crosstab(DataPointGrid dataPointGrid) {
        return dataPointGrid._crosstab;
    }

    static Layout.PopupManager ra$_popupManager(DataPointGrid dataPointGrid) {
        return dataPointGrid._popupManager;
    }

    private class GridDS
    extends AbstractTwoDModel {
        private int _orientation = 1;
        private int _otherAxisCount;
        private ArrayOneDModel _itemStore = new ArrayOneDModel(0);

        public void setOrientation(int orientation) {
            if (this._orientation != orientation) {
                int columnCount = this.getColumnCount();
                int rowCount = this.getRowCount();
                this._orientation = orientation;
                int newColumnCount = this.getColumnCount();
                int newRowCount = this.getRowCount();
                int diff = newColumnCount - columnCount;
                if (diff > 0) {
                    int id = 2001;
                    this.fireModelEvent(id, 0, diff);
                } else if (diff < 0) {
                    int id = 2002;
                    this.fireModelEvent(id, 0, -diff);
                }
                diff = newRowCount - rowCount;
                if (diff > 0) {
                    int id = 2004;
                    this.fireModelEvent(id, 0, diff);
                } else if (diff < 0) {
                    int id = 2005;
                    this.fireModelEvent(id, 0, -diff);
                }
            }
        }

        public int getOrientation() {
            return this._orientation;
        }

        public String getElement(int item) {
            return (String)this._itemStore.getData(item);
        }

        public void setItems(Object[] items) {
            int newCount;
            int count = this._itemStore.getItemCount();
            this._itemStore.removeItems(0, count);
            int n = newCount = items == null ? 0 : items.length;
            if (newCount != 0) {
                this._itemStore.addItems(0, items);
            }
            this._fireEvents(count, newCount);
        }

        public int getColumnCount() {
            if (this._orientation == 0) {
                return this._itemStore.getItemCount();
            }
            return this._otherAxisCount;
        }

        public int getRowCount() {
            if (this._orientation == 1) {
                return this._itemStore.getItemCount();
            }
            return this._otherAxisCount;
        }

        public Object getData(int column, int row) {
            int index = this._orientation == 0 ? column : row;
            return this.getElement(index);
        }

        public void setData(int column, int row, Object data) {
        }

        private void _fireEvents(int oldCount, int newCount) {
            int diff = newCount - oldCount;
            if (diff > 0) {
                int id = this._orientation == 0 ? 2001 : 2004;
                this.fireModelEvent(id, 0, diff);
            } else if (diff < 0) {
                int id;
                int n = id = this._orientation == 0 ? 2002 : 2005;
                if (id == 2002 && DataPointGrid.this.getFirstColumnOnScreen() >= newCount && newCount > 0) {
                    DataPointGrid.this.setFirstColumnOnScreen(newCount - 1);
                }
                if (id == 2005 && DataPointGrid.this.getFirstRowOnScreen() >= newCount && newCount > 0) {
                    DataPointGrid.this.setFirstRowOnScreen(newCount - 1);
                }
                this.fireModelEvent(id, 0, -diff);
            }
            if (newCount != 0 && this._otherAxisCount == 0) {
                int id = this._orientation == 0 ? 2004 : 2001;
                this._otherAxisCount = 1;
                this.fireModelEvent(id, 0, 1);
            } else if (newCount == 0 && this._otherAxisCount != 0) {
                int id = this._orientation == 0 ? 2005 : 2002;
                this._otherAxisCount = 0;
                this.fireModelEvent(id, 0, 1);
            }
        }
    }

    private class GridListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            if ("selection".equals(e.getPropertyName()) && !TwoDSelection.getEmptySelection().equals(e.getNewValue())) {
                DataPointGrid.ra$_crosstab(DataPointGrid.this).gridSelectionChanged();
            }
        }

        private GridListener() {
        }

        GridListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class GridInputHandler
    extends CellInputHandler {
        public void mousePressed(MouseEvent e, Grid grid, int column, int row) {
            boolean left = SwingUtilities.isLeftMouseButton(e);
            if (left && e.getClickCount() == 2) {
                int index = DataPointGrid.this.getOrientation() == 0 ? column : row;
                DataPointGrid.ra$_crosstab(DataPointGrid.this).dataPointToAxisItem(index);
                e.consume();
            } else if (SwingUtilities.isRightMouseButton(e)) {
                e.consume();
                String currentItem = (String)DataPointGrid.this.getModel().getData(column, row);
                int offsetX = 0;
                int offsetY = 0;
                int i = 0;
                while (i < column) {
                    offsetX += DataPointGrid.this.getColumnWidth(i);
                    ++i;
                }
                i = 0;
                while (i < row) {
                    offsetY += DataPointGrid.this.getRowHeight(i);
                    ++i;
                }
                Point p = new Point(offsetX + e.getX(), offsetY + e.getY());
                if (DataPointGrid.ra$_popupManager(DataPointGrid.this) != null) {
                    DataPointGrid.ra$_popupManager(DataPointGrid.this).createPopup(DataPointGrid.this, currentItem, (JComponent)((Object)DataPointGrid.this), p);
                }
                DataPointGrid.this.requestFocus(column, row, null);
                try {
                    TwoDSelection s = new TwoDSelection(column, row);
                    DataPointGrid.this.setSelection(s);
                }
                catch (PropertyVetoException pve) {
                    // empty catch block
                }
            }
            super.mousePressed(e, grid, column, row);
        }

        public void keyPressed(KeyEvent e, Grid grid, int column, int row) {
            if (e.isShiftDown() && e.getKeyCode() == 121) {
                e.consume();
                Point p = new Point();
                p.x = DataPointGrid.this.getColumnWidth(0) * column;
                p.y = DataPointGrid.this.getRowHeight(0) * (row + 1);
                String currentItem = (String)DataPointGrid.this.getModel().getData(column, row);
                DataPointGrid.ra$_popupManager(DataPointGrid.this).createPopup(DataPointGrid.this, currentItem, (JComponent)((Object)DataPointGrid.this), p);
            }
            super.keyPressed(e, grid, column, row);
        }

        private GridInputHandler() {
        }

        GridInputHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class GridDragDropAdapter
    implements DropTargetListener,
    DragSourceListener,
    DragGestureListener {
        private DataPointGrid _grid;
        private DropTarget _gridTarget;
        private DragGestureRecognizer _recognizer;

        public GridDragDropAdapter(DataPointGrid grid) {
            this._grid = grid;
            this._recognizer = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer((Component)((Object)grid), 2, (DragGestureListener)this);
            this._gridTarget = new DropTarget((Component)((Object)grid), (DropTargetListener)this);
        }

        public void cleanup() {
            this._gridTarget.setActive(false);
            this._gridTarget.setComponent(null);
            this._recognizer.removeDragGestureListener((DragGestureListener)this);
            this._recognizer = null;
            this._gridTarget = null;
            this._grid = null;
        }

        public void dragEnter(DropTargetDragEvent e) {
        }

        public void dragOver(DropTargetDragEvent e) {
            if (!this._acceptDrag(e)) {
                e.rejectDrag();
                return;
            }
            int index = this._getIndex(e.getLocation());
            this._setDropLocation(index);
        }

        public void dragScroll(DropTargetDragEvent e) {
        }

        public void dragExit(DropTargetEvent e) {
            this._setDropLocation(-1);
        }

        public void dropActionChanged(DropTargetDragEvent e) {
        }

        public void drop(DropTargetDropEvent e) {
            int index;
            e.acceptDrop(1);
            this._setDropLocation(-1);
            Transferable transfer = e.getTransferable();
            Object data = null;
            try {
                data = transfer.getTransferData(PivotTransfer.DATA_FLAVOR);
            }
            catch (UnsupportedFlavorException ufe) {
                data = null;
            }
            catch (IOException ioe) {
                data = null;
            }
            if (data != null && data instanceof PivotTransfer && (index = this._getIndex(e.getLocation())) != -1) {
                PivotTransfer layoutTransfer = (PivotTransfer)data;
                Object source = layoutTransfer.getSource();
                int sourceIndex = layoutTransfer.getIndex();
                DataPointGrid destination = this._grid;
                int destinationIndex = index;
                if (source == destination && destinationIndex > sourceIndex) {
                    --destinationIndex;
                }
                this._grid.firePivotEvent(source, sourceIndex, destination, destinationIndex);
            }
            e.dropComplete(data != null);
        }

        public void dragGestureRecognized(DragGestureEvent e) {
            if (this._grid.getColumnCount() == 0) {
                return;
            }
            Point origin = e.getDragOrigin();
            origin = this._grid.convertOuterToCanvas(origin.x, origin.y);
            int column = this._grid.getColumnAt(origin.x);
            int row = this._grid.getRowAt(origin.y);
            if (column == -1 || row == -1) {
                return;
            }
            int index = this._grid.getOrientation() == 0 ? column : row;
            Image dragImage = null;
            this._grid.setDragItem(index);
            e.startDrag(null, dragImage, origin, PivotTransfer.createTransferable((Object)this._grid, (int)index), (DragSourceListener)this);
        }

        public void dragEnter(DragSourceDragEvent e) {
        }

        public void dragOver(DragSourceDragEvent e) {
        }

        public void dropActionChanged(DragSourceDragEvent e) {
        }

        public void dragExit(DragSourceEvent e) {
        }

        public void dragDropEnd(DragSourceDropEvent e) {
            this._grid.setDragItem(-1);
        }

        private boolean _acceptDrag(DropTargetDragEvent dtde) {
            DataFlavor[] flavors = dtde.getCurrentDataFlavors();
            if (flavors == null) {
                return false;
            }
            int i = 0;
            while (i < flavors.length) {
                if (TransferUtils.supportsDataFlavor((DataFlavor)flavors[i], (DataFlavor)PivotTransfer.DATA_FLAVOR)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        void _setDropLocation(int index) {
            this._grid.setDropLocation(index);
        }

        private int _getIndex(Point p) {
            int index = -1;
            p = this._grid.convertOuterToCanvas(p.x, p.y);
            if (this._grid.getOrientation() == 0) {
                int count = this._grid.getColumnCount();
                if (count == 0) {
                    index = 0;
                } else {
                    int size;
                    int position;
                    index = this._grid.getColumnAt(p.x);
                    if (index == -1) {
                        index = count - 1;
                    }
                    if (p.x > (position = this._grid.getColumnPosition(index)) + (size = this._grid.getColumnWidth(index)) / 2) {
                        ++index;
                    }
                }
            } else {
                int count = this._grid.getRowCount();
                if (count == 0) {
                    index = 0;
                } else {
                    int size;
                    int position;
                    index = this._grid.getRowAt(p.y);
                    if (index == -1) {
                        index = count - 1;
                    }
                    if (p.y > (position = this._grid.getRowPosition(index)) + (size = this._grid.getRowHeight(index)) / 2) {
                        ++index;
                    }
                }
            }
            return index;
        }
    }
}

