/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.gui.layout;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import oracle.dss.util.gui.layout.LayoutComponent;
import oracle.dss.util.gui.layout.PageItem;
import oracle.dss.util.gui.layout.PagingComponent;

public class LayoutPagingComponent
extends PagingComponent
implements LayoutComponent,
FocusListener {
    private int m_edge;
    public static final String COMMAND_POPUP = "SHOW_POPUP";
    private static final KeyStroke _KEY_STROKE_SHIFT_F10 = KeyStroke.getKeyStroke(121, 1);
    private ActionListener m_keyBoardActionListener;
    private MouseListener m_mouseListener;
    protected int lastIndex;

    private void $init$() {
        this.m_keyBoardActionListener = null;
        this.m_mouseListener = null;
        this.lastIndex = -1;
    }

    public LayoutPagingComponent(int edge) {
        this.$init$();
        this.m_edge = edge;
    }

    public int getEdge() {
        return this.m_edge;
    }

    public void setEdge(int edge) {
        this.m_edge = edge;
    }

    public String[] getItems() {
        int count = this.getComponentCount();
        String[] items = new String[count];
        int i = 0;
        while (i < count) {
            items[i] = this.getItem(i).getText();
            ++i;
        }
        return items;
    }

    public void setKeyBoardActionListener(ActionListener l) {
        this.m_keyBoardActionListener = l;
    }

    public ActionListener getKeyBoardActionListener() {
        return this.m_keyBoardActionListener;
    }

    public void setMouseListener(MouseListener ml) {
        this.m_mouseListener = ml;
    }

    public void focusGained(FocusEvent e) {
        int lastIndex;
        int index;
        if (!e.isTemporary() && (index = this.getIndex((PageItem)e.getSource())) == -1 && (lastIndex = this.getLastSelectedIndex()) != -1) {
            int count = this.getComponentCount();
            if (count > 0) {
                PageItem pi = lastIndex > count - 1 ? this.getItem(count - 1) : this.getItem(lastIndex);
                pi.requestFocus();
            } else {
                this.transferFocus();
            }
        }
    }

    public void focusLost(FocusEvent e) {
        PageItem pageItem = (PageItem)e.getSource();
        this.setLastSelectedIndex(this.getIndex(pageItem));
        this.processFocusEvent(e);
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        super.addImpl(comp, constraints, index);
        if (comp instanceof JComponent) {
            JComponent jc = (JComponent)comp;
            jc.registerKeyboardAction(this.m_keyBoardActionListener, COMMAND_POPUP, _KEY_STROKE_SHIFT_F10, 0);
            if (comp instanceof PageItem && this.m_mouseListener != null) {
                PageItem pageItem = (PageItem)((Object)comp);
                pageItem.addFocusListener(this);
                int count = pageItem.getComponentCount();
                int i = 0;
                while (i < count) {
                    pageItem.getComponent(i).addMouseListener(this.m_mouseListener);
                    ++i;
                }
            }
        }
    }

    private void setLastSelectedIndex(int index) {
        this.lastIndex = index;
    }

    private int getLastSelectedIndex() {
        return this.lastIndex;
    }
}

