/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.gui.layout;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterGraphics;
import java.beans.PropertyVetoException;
import java.text.MessageFormat;
import java.util.Dictionary;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.border.GrayPane;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.elaf.EWTPageItemUI;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.graphics.ColorUtils;
import oracle.bali.ewt.graphics.SpacingIcon;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.OneDModelEvent;
import oracle.bali.ewt.model.OneDModelListener;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.FixedAlignmentPainter;
import oracle.bali.ewt.painter.FixedIconPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.PaintContextProxy;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.TextPainter;
import oracle.bali.ewt.pivot.PagingComponent;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.ewt.util.LocaleUtils;
import oracle.bali.ewt.util.MenuUtils;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.share.util.IntegerUtils;

public class PageItem
extends LWComponent
implements Accessible {
    public static final String KEY_SELECTED_VALUE = "pageItem.selectedValue";
    public static final String PROPERTY_SELECTED_INDEX = "selectedIndex";
    private static final int _HINSET = 3;
    private static final int _VINSET = 4;
    private static final String _ACCESS_RESOURCE_BUNDLE = "oracle.bali.ewt.resource.AccessibilityBundle";
    private static final String _RESOURCE_BUNDLE = "oracle.bali.ewt.resource.JEWTBundle";
    private static final String _COMMAND_UP = "up";
    private static final String _COMMAND_DOWN = "down";
    private static final String _COMMAND_SHOW_DIALOG = "showdialog";
    private static final String _TOGGLE_DROP_DOWN_KEY = "TOGGLE_DROP_DOWN";
    private static final String _OK_KEY = "OK";
    private static final String _CANCEL_KEY = "CANCEL";
    private static final String _SELECT_LABEL_KEY = "PAGEITEM.SELECT_LABEL";
    private static final String _TITLE_KEY = "PAGEITEM.SELECT_DIALOG_TITLE";
    private int _selectedIndex;
    private boolean _dragging;
    private boolean _swapping;
    private boolean _selected;
    private OneDModel _model;
    private OneDModelListener _dsListener;
    private boolean _dragEnabled;
    private JPopupMenu _menu;
    private PopupListen _popupListener;
    private LabelComponent _labelComponent;
    private ValueComponent _valueComponent;
    private JDialog _dialog;
    private JLabel _dialogLabel;
    private JList _dialogList;
    private JScrollPane _scrollPane;
    private DialogListen _dialogListener;
    private JButton _ok;
    private JButton _cancel;
    private boolean _editable;
    private Appearance _labelAppearance;
    private Appearance _valueAppearance;
    private Painter _valuePainter;
    private Painter _labelPainter;
    private String _label;
    private boolean _drawRaised;
    private int _minWidth;
    private int _minHeight;
    private Color _dropDownBackground;
    private Icon m_icon;
    private static final int _ALPHA = 60;
    private static final String _OK_NAME = "OK_Button";
    private static final String _CANCEL_NAME = "Cancel_Name";
    private static final String _LIST_NAME = "Values_List";
    private static final String _VALUE_NAME = "Value_Component";
    private static final String _MENU_NAME = "Values_Menu";
    private static final String _LABEL_NAME = "Label_Component";

    public PageItem() {
        this(null);
    }

    public PageItem(String label) {
        this(label, null);
    }

    public PageItem(String label, OneDModel model) {
        this.$init$();
        this._labelComponent = this.getLabelComponent() != null ? this.getLabelComponent() : new LabelComponent();
        this._valueComponent = this.getValueComponent() != null ? this.getValueComponent() : new ValueComponent();
        this._labelComponent.setName(_LABEL_NAME);
        this._valueComponent.setName(_VALUE_NAME);
        this.setLayout(new BorderLayout());
        this.add("West", (Component)((Object)this._labelComponent));
        this.add("East", (Component)((Object)this._valueComponent));
        this._selectedIndex = -1;
        this._dragEnabled = true;
        this._dsListener = new DSListen(null);
        this.setText(label);
        this.setModel(model);
        this.setEditable(model != null);
        this.updateUI();
        this._registerKeyboardActions();
    }

    public void dispose() {
        if (this._labelComponent == null) {
            return;
        }
        this._unregisterKeyboardActions();
        this.setModel(null);
        this._dsListener = null;
        this.removeAll();
        this._labelComponent = null;
        this._valueComponent = null;
        if (this._menu != null) {
            this._menu.addPopupMenuListener(this._popupListener);
            PageItem._removeActionListeners(this._menu, this._popupListener);
            this._menu.removeAll();
            this._menu.setInvoker(null);
        }
        this._menu = null;
        this._popupListener = null;
        this._cleanupDialog();
        this._valueAppearance = null;
        this._labelAppearance = null;
        this._labelPainter = null;
        this._valuePainter = null;
    }

    public void setText(String label) {
        if (this._label != label) {
            String oldAccessibleName = null;
            if (this.accessibleContext != null) {
                oldAccessibleName = this.accessibleContext.getAccessibleName();
            }
            this._label = label;
            AccessibleContext ac = this.accessibleContext;
            if (ac != null && ac.getAccessibleName() != oldAccessibleName) {
                ac.firePropertyChange("AccessibleName", oldAccessibleName, ac.getAccessibleName());
                this._fireFakeSelectionEvent(ac);
            }
            this.revalidate();
            this.repaint();
        }
    }

    public String getText() {
        return this._label;
    }

    public void setModel(OneDModel model) {
        if (this._model != null) {
            this._model.removeModelListener(this._dsListener);
        }
        this._model = model;
        if (this._model != null) {
            this._model.addModelListener(this._dsListener);
        }
        boolean empty = model == null || model.getItemCount() == 0;
        int index = empty ? -1 : 0;
        this.setSelectedIndex(index);
        this.setEditable(empty);
        this.revalidate();
        this.repaint();
    }

    public OneDModel getModel() {
        return this._model;
    }

    public final String getSelectedValue() {
        int index = this.getSelectedIndex();
        if (index == -1) {
            return null;
        }
        Object data = this.getModel().getData(index);
        return data == null ? null : data.toString();
    }

    public int getSelectedIndex() {
        return this._selectedIndex;
    }

    public void setSelectedIndex(int index) {
        if (this._selectedIndex != index) {
            String oldAccessibleName = null;
            if (this.accessibleContext != null) {
                oldAccessibleName = this.accessibleContext.getAccessibleName();
            }
            Integer oldIndex = IntegerUtils.getInteger((int)this._selectedIndex);
            Integer newIndex = IntegerUtils.getInteger((int)index);
            try {
                this.fireVetoableChange(PROPERTY_SELECTED_INDEX, oldIndex, newIndex);
            }
            catch (PropertyVetoException e) {
                return;
            }
            this._selectedIndex = index;
            this.firePropertyChange(PROPERTY_SELECTED_INDEX, oldIndex, newIndex);
            this._fireSelectedIndexChanged(oldIndex, newIndex);
            AccessibleContext ac = this.accessibleContext;
            if (ac != null && ac.getAccessibleName() != oldAccessibleName) {
                ac.firePropertyChange("AccessibleName", oldAccessibleName, ac.getAccessibleName());
                this._fireFakeSelectionEvent(ac);
            }
            this.revalidate();
            this.repaint();
        }
    }

    public void setDropDownVisible(boolean visible) {
        if (this.isDropDownVisible() != visible) {
            if (visible) {
                if (this.isEditable()) {
                    OneDModel ds = this.getModel();
                    int count = ds.getItemCount();
                    JMenuItem menuItem = new JMenuItem(" ");
                    Dimension boundingSize = MenuUtils.getBoundingSize((Component)((Object)this));
                    Point p = this.getLocationOnScreen();
                    p.y += this.getHeight();
                    if (p.y + menuItem.getPreferredSize().height * count > boundingSize.height) {
                        this.setSelected(false);
                        this.setSelectDialogVisible(true);
                        this.setSelected(true);
                    } else {
                        EWTPageItemUI ui = this.getEWTPageItemUI();
                        int x = this._valueComponent.getX();
                        PaintContext context = this.getPaintContext();
                        JPopupMenu menu = this._getMenu();
                        PageItem._removeActionListeners(menu, this._popupListener);
                        menu.removeAll();
                        Icon visibleIcon = ui.getSelectedIcon((JComponent)((Object)this));
                        SpacingIcon spacingIcon = visibleIcon == null ? null : new SpacingIcon(visibleIcon.getIconWidth(), visibleIcon.getIconHeight());
                        int index = this.getSelectedIndex();
                        int i = 0;
                        while (i < count) {
                            Icon icon = i == index ? visibleIcon : spacingIcon;
                            Object data = ds.getData(i);
                            String string = data == null ? null : data.toString();
                            menuItem = new JMenuItem(string, icon);
                            menuItem.setSelected(i == index);
                            menuItem.setActionCommand(IntegerUtils.getString((int)i));
                            menuItem.addActionListener(this._popupListener);
                            menuItem.setBackground(this._dropDownBackground);
                            menu.add(menuItem);
                            ++i;
                        }
                        if (MenuUtils.willPopupFit((JPopupMenu)menu, (Component)((Object)this))) {
                            MenuUtils.showPopupMenu((JPopupMenu)menu, (Component)((Object)this), (int)x, (int)this.getHeight());
                        } else {
                            this.setSelected(false);
                            this.setSelectDialogVisible(true);
                            this.setSelected(true);
                        }
                    }
                }
            } else {
                this._getMenu().setVisible(false);
                this.setSelectDialogVisible(false);
            }
        }
    }

    public boolean isDropDownVisible() {
        return this._getMenu().isVisible() || this.isSelectDialogVisible();
    }

    public void setEditable(boolean editable) {
        if (this._editable != editable) {
            this._editable = editable;
            if (this._valueComponent != null) {
                this._valueComponent.setDropDownIconVisible(editable);
            }
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isEditable() {
        return this._editable && this._getItemCount() != 0;
    }

    public boolean isDragEnabled() {
        return this.isEnabled() && this._dragEnabled && !this.isDropDownVisible();
    }

    public void setDragEnabled(boolean enabled) {
        this._labelComponent.setGrippyVisible(enabled);
        this._dragEnabled = enabled;
    }

    public void setAppearance(Appearance appearance) {
        this._labelAppearance = appearance == null ? null : appearance.copy();
        this.revalidate();
        this.repaint();
    }

    public Appearance getAppearance() {
        return this._getAppearance().copy();
    }

    public void setSelectedValueAppearance(Appearance appearance) {
        this._valueAppearance = appearance == null ? null : appearance.copy();
        this.revalidate();
        this.repaint();
    }

    public Appearance getSelectedValueAppearance() {
        return this._getSelectedValueAppearance().copy();
    }

    public void setPainter(Painter painter) {
        if (this._labelPainter != painter) {
            this._labelPainter = painter;
            this.revalidate();
            this.repaint();
        }
    }

    public Painter getPainter() {
        if (this._labelPainter == null) {
            this._labelPainter = new TextPainter();
        }
        return this._labelPainter;
    }

    public void setSelectedValuePainter(Painter painter) {
        if (this._valuePainter != painter) {
            this._valuePainter = painter;
            this.revalidate();
            this.repaint();
        }
    }

    public Painter getSelectedValuePainter() {
        if (this._valuePainter == null) {
            this._valuePainter = new TextPainter((Object)KEY_SELECTED_VALUE);
        }
        return this._valuePainter;
    }

    public void setDrawRaised(boolean drawRaised) {
        if (this._drawRaised != drawRaised) {
            this._drawRaised = drawRaised;
            this.repaint();
        }
    }

    public boolean isDrawRaised() {
        return this._drawRaised;
    }

    public Icon getIcon() {
        return this.m_icon;
    }

    public void setIcon(Icon icon) {
        this.m_icon = icon;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public String getUIClassID() {
        return "EWTPageItemUI";
    }

    public Object getPaintData(Object key) {
        Object data = null;
        if (KEY_SELECTED_VALUE.equals(key)) {
            data = this.getSelectedValue();
        } else if (PaintContext.LABEL_KEY.equals(key)) {
            data = this._label;
        } else if ("PageItem.drawRaised".equals(key)) {
            data = this.isDrawRaised() ? Boolean.TRUE : Boolean.FALSE;
        }
        return data != null ? data : super.getPaintData(key);
    }

    public void printPage(PaintContext context, Dictionary printProperties, Graphics g) {
        this.freezeRepaints();
        try {
            boolean oldVisible = this._editable;
            boolean oldSelected = this.isSelected();
            boolean oldGrippy = this._labelComponent.isGrippyVisible();
            this._valueComponent.setDropDownIconVisible(false);
            this.setSelected(false);
            this._labelComponent.setGrippyVisible(false);
            if (context == null) {
                context = this.getPrintPaintContext(g);
            }
            super.printPage(context, printProperties, g);
            this._valueComponent.setDropDownIconVisible(oldVisible);
            this.setSelected(oldSelected);
            this._labelComponent.setGrippyVisible(oldGrippy);
        }
        finally {
            this.unfreezeRepaints();
        }
    }

    public Dimension getDocumentSize(PaintContext context, Dictionary printProperties) {
        this.freezeRepaints();
        Dimension size = super.getDocumentSize(context, printProperties);
        try {
            boolean oldVisible = this._editable;
            this._valueComponent.setDropDownIconVisible(false);
            size = this.getPreferredSize();
            this._valueComponent.setDropDownIconVisible(oldVisible);
        }
        finally {
            this.unfreezeRepaints();
        }
        return size;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessiblePageItem();
        }
        return this.accessibleContext;
    }

    public void updateUI() {
        this.setUI((ComponentUI)((EWTPageItemUI)UIManager.getUI((JComponent)((Object)this))));
        if (this._valueComponent != null) {
            this._valueComponent.updateIcon();
        }
        this._dropDownBackground = UIManager.getColor("PivotPopupMenu.background");
        if (this._menu != null) {
            this._menu.setBackground(this._dropDownBackground);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this._cleanupDialog();
    }

    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this._labelComponent.setEnabled(enable);
        this._valueComponent.setEnabled(enable);
    }

    protected LabelComponent getLabelComponent() {
        return this._labelComponent;
    }

    protected ValueComponent getValueComponent() {
        return this._valueComponent;
    }

    protected String getDialogText() {
        return this.getText();
    }

    protected void setSelectDialogVisible(boolean visible) {
        if (this.isSelectDialogVisible() != visible) {
            if (visible) {
                if (this._dialog == null) {
                    this._createDialog();
                }
                String text = this._getTranslatedString(_SELECT_LABEL_KEY);
                MessageFormat form = new MessageFormat(text);
                Object[] args = new Object[]{this.getDialogText()};
                text = form.format(args);
                this._dialogLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)text));
                this._dialogLabel.setText(StringUtils.stripMnemonic((String)text));
                int index = this.getSelectedIndex();
                OneDModel model = this.getModel();
                this._dialogList.setModel(new OneDModelAdapter(model));
                this._dialogList.setVisibleRowCount(model.getItemCount());
                this._dialog.pack();
                int width = this._dialog.getWidth();
                int height = this._dialog.getHeight();
                boolean sizeExceeds = false;
                if (width > WindowUtils.DIALOG_MAXIMUM_WIDTH) {
                    this._scrollPane.setHorizontalScrollBarPolicy(32);
                    sizeExceeds = true;
                }
                if (height > WindowUtils.DIALOG_MAXIMUM_HEIGHT) {
                    this._scrollPane.setVerticalScrollBarPolicy(22);
                    sizeExceeds = true;
                }
                if (sizeExceeds) {
                    this._dialog.pack();
                    width = this._dialog.getWidth();
                    height = this._dialog.getHeight();
                    this._scrollPane.setVerticalScrollBarPolicy(20);
                    this._scrollPane.setHorizontalScrollBarPolicy(30);
                    if (width > WindowUtils.DIALOG_MAXIMUM_WIDTH) {
                        width = WindowUtils.DIALOG_MAXIMUM_WIDTH;
                    }
                    if (height > WindowUtils.DIALOG_MAXIMUM_HEIGHT) {
                        height = WindowUtils.DIALOG_MAXIMUM_HEIGHT;
                    }
                    this._dialog.setSize(width, height);
                }
                this._dialogList.setSelectedIndex(index);
                if (index != -1) {
                    this._dialogList.ensureIndexIsVisible(index);
                }
                this._dialogList.requestFocus();
                PageItem._setWindowLocation(this._dialog, this);
            }
            if (visible) {
                this._minWidth = this._dialog.getWidth();
                this._minHeight = this._dialog.getHeight();
            } else {
                this._minWidth = -1;
                this._minHeight = -1;
            }
            if (this._dialog != null) {
                this._dialog.setVisible(visible);
            }
        }
    }

    private static void _setWindowLocation(Window window, PageItem item) {
        Point p = item.getLocationOnScreen();
        Dimension itemSize = item.getSize();
        Dimension windowSize = window.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (p.y + itemSize.height + windowSize.height <= screenSize.height) {
            if (p.x + windowSize.width <= screenSize.width) {
                window.setLocation(p.x, p.y + itemSize.height);
                return;
            }
            if (p.x + itemSize.width - windowSize.width >= 0) {
                window.setLocation(p.x + itemSize.width - windowSize.width, p.y + itemSize.height);
                return;
            }
        } else if (p.y - windowSize.height >= 0) {
            if (p.x + windowSize.width <= screenSize.width) {
                window.setLocation(p.x, p.y - windowSize.height);
                return;
            }
            if (p.x + itemSize.width - windowSize.width >= 0) {
                window.setLocation(p.x + itemSize.width - windowSize.width, p.y - windowSize.height);
                return;
            }
        }
        WindowUtils.centerWindow((Window)window);
    }

    protected boolean isSelectDialogVisible() {
        return this._dialog == null ? false : this._dialog.isVisible();
    }

    protected JDialog createDialog(Frame owner, String title, boolean modal) {
        return new JDialog(owner, title, modal);
    }

    protected JDialog createDialog(Dialog owner, String title, boolean modal) {
        return new JDialog(owner, title, modal);
    }

    protected void setLabelComponent(LabelComponent labelComponent) {
        this._labelComponent = labelComponent;
    }

    protected void setValueComponent(ValueComponent valueComponent) {
        this._valueComponent = valueComponent;
    }

    void setSelected(boolean selected) {
        if (this.isSelected() != selected) {
            this._selected = selected;
            this.paintImmediateInterior();
        }
    }

    boolean isSelected() {
        return this._selected;
    }

    void setDragging(boolean dragging) {
        if (this.isDragging() != dragging) {
            this._dragging = dragging;
            this.paintImmediateInterior();
        }
    }

    boolean isDragging() {
        return this._dragging;
    }

    void setSwapping(boolean swapping) {
        if (this.isSwapping() != swapping) {
            this._swapping = swapping;
            this.paintImmediateInterior();
        }
    }

    boolean isSwapping() {
        return this._swapping;
    }

    Image getDragImage() {
        Painter grippy = this.getEWTPageItemUI().getGrippyPainter((JComponent)((Object)this));
        PaintContext context = this.getPaintContext();
        int width = this.getWidth();
        int height = this.getHeight();
        Dimension grippySize = grippy.getSize(context, width, height);
        width = grippySize.width + 5;
        Image image = this.createImage(width, height);
        if (image != null) {
            Graphics g = image.getGraphics();
            g.setColor(this._getAppearance().getBackground());
            g.fillRect(0, 0, width, height);
            Border b = this.getBorder();
            int x = 0;
            int y = 0;
            if (b != null) {
                b.paintBorder((Component)((Object)this), g, x, y, width, height);
                Insets insets = b.getBorderInsets((Component)((Object)this));
                if (insets != null) {
                    x += insets.left;
                    y += insets.top;
                    width -= insets.left + insets.right;
                    height -= insets.top + insets.bottom;
                }
            }
            grippy.paint(context, g, x, y, width, height);
        }
        return image;
    }

    private static void _removeActionListeners(JPopupMenu menu, ActionListener listener) {
        int i = 0;
        while (i < menu.getComponentCount()) {
            Component c = menu.getComponent(i);
            if (c instanceof JMenuItem) {
                ((JMenuItem)c).removeActionListener(listener);
            }
            ++i;
        }
    }

    private void _createDialog() {
        this._dialogListener = new DialogListen(null);
        Window w = WindowUtils.getWindow((Component)((Object)this));
        String title = this._getTranslatedString(_TITLE_KEY);
        JDialog d = null;
        if (w instanceof Frame) {
            d = this.createDialog((Frame)w, title, true);
        } else if (w instanceof Dialog) {
            d = this.createDialog((Dialog)w, title, true);
        } else {
            throw new IllegalStateException("PageItem must be in a Frame or Dialog");
        }
        d.addComponentListener(this._dialogListener);
        d.addWindowListener(this._dialogListener);
        d.setBackground(UIManager.getColor("EWTDialog.background"));
        d.getContentPane().setBackground(UIManager.getColor("EWTDialog.background"));
        DialogButtonBar buttonBar = new DialogButtonBar();
        String text = this._getTranslatedString(_OK_KEY);
        JButton ok = new JButton(StringUtils.stripMnemonic((String)text));
        ok.setDefaultCapable(true);
        ok.setMnemonic(StringUtils.getMnemonicKeyCode((String)text));
        ok.setActionCommand(_OK_KEY);
        ok.addActionListener(this._dialogListener);
        ok.setName(_OK_NAME);
        buttonBar.add((Component)ok, DialogButtonBar.CONSTRAINT_YES);
        this._ok = ok;
        text = this._getTranslatedString(_CANCEL_KEY);
        JButton cancel = new JButton(StringUtils.stripMnemonic((String)text));
        cancel.setMnemonic(StringUtils.getMnemonicKeyCode((String)text));
        cancel.setActionCommand(_CANCEL_KEY);
        cancel.addActionListener(this._dialogListener);
        cancel.setName(_CANCEL_NAME);
        this._cancel = cancel;
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        cancel.registerKeyboardAction(this._dialogListener, _CANCEL_KEY, stroke, 2);
        buttonBar.add((Component)cancel, DialogButtonBar.CONSTRAINT_CANCEL);
        this._dialogList = new JList();
        this._dialogList.setName(_LIST_NAME);
        this._dialogList.addMouseListener(this._dialogListener);
        this._dialogList.setVisibleRowCount(10);
        this._dialogList.setSelectionMode(0);
        this._dialogLabel = new JLabel(" ");
        this._dialogLabel.setLabelFor(this._dialogList);
        JPanel middlePanel = new JPanel();
        middlePanel.setLayout(new BorderLayout(2, 2));
        middlePanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        middlePanel.add("North", this._dialogLabel);
        this._scrollPane = new JScrollPane(this._dialogList);
        middlePanel.add("Center", this._scrollPane);
        GrayPane pane = new GrayPane();
        pane.setLayout((LayoutManager)new BorderLayout());
        pane.add("Center", (Component)middlePanel);
        JPanel panel = new JPanel();
        panel.setBorder(new EmptyBorder(8, 8, 8, 8));
        panel.setLayout(new BorderLayout(8, 8));
        panel.add("Center", (Component)pane);
        panel.add("South", (Component)buttonBar);
        Container c = d.getContentPane();
        c.setLayout(new BorderLayout());
        c.add("Center", panel);
        d.getRootPane().setDefaultButton(ok);
        this._dialog = d;
    }

    private void _cleanupDialog() {
        if (this._dialog == null) {
            return;
        }
        this._dialog.removeComponentListener(this._dialogListener);
        this._dialog.removeWindowListener(this._dialogListener);
        this._ok.removeActionListener(this._dialogListener);
        this._cancel.removeActionListener(this._dialogListener);
        this._dialogList.removeMouseListener(this._dialogListener);
        this._dialogList.setModel(new DefaultListModel());
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        this._cancel.unregisterKeyboardAction(stroke);
        this._dialogLabel.setLabelFor(null);
        this._dialog.dispose();
        this._ok = null;
        this._cancel = null;
        this._dialogListener = null;
        this._dialogList = null;
        this._dialogLabel = null;
        this._dialog = null;
    }

    private String _getTranslatedString(String key) {
        ResourceBundle b = ResourceBundle.getBundle(_RESOURCE_BUNDLE, this.getLocale());
        return b.getString(key);
    }

    private int _getItemCount() {
        return this._model == null ? 0 : this._model.getItemCount();
    }

    EWTPageItemUI getEWTPageItemUI() {
        return (EWTPageItemUI)this.ui;
    }

    private JPopupMenu _getMenu() {
        if (this._menu == null) {
            this._menu = new JPopupMenu();
            this._menu.setName(_MENU_NAME);
            this._popupListener = new PopupListen(null);
            this._menu.addPopupMenuListener(this._popupListener);
            this._menu.setBackground(this._dropDownBackground);
        }
        return this._menu;
    }

    private Appearance _getSelectedValueAppearance() {
        if (this._valueAppearance == null) {
            return this._getAppearance();
        }
        return this._valueAppearance;
    }

    private Appearance _getAppearance() {
        if (this._labelAppearance == null) {
            this._labelAppearance = (Appearance)UIManager.get("PageItem.DefaultAppearance");
        }
        return this._labelAppearance;
    }

    private final void _fireFakeSelectionEvent(AccessibleContext ac) {
        Accessible parent = ac.getAccessibleParent();
        if (parent instanceof PagingComponent) {
            PagingComponent pagingComponent = (PagingComponent)parent;
        }
    }

    private final void _fireSelectedIndexChanged(int oldIndex, int newIndex) {
        Object old;
        OneDModel model = this.getModel();
        Object object = oldIndex == -1 ? null : (old = model == null ? null : model.getData(oldIndex));
        Object newValue = newIndex == -1 ? null : (model == null ? null : model.getData(newIndex));
        this._fireSelectedStringChanged(old, newValue);
    }

    private void _fireSelectedStringChanged(Object oldValue, Object newValue) {
        AccessibleContext ac = this.accessibleContext;
        if (ac != null) {
            ac.firePropertyChange("AccessibleVisibleData", oldValue, newValue);
        }
    }

    private void _registerKeyboardActions() {
        KeyListen listener = new KeyListen(null);
        KeyStroke stroke = KeyStroke.getKeyStroke(38, 0);
        this.registerKeyboardAction(listener, _COMMAND_UP, stroke, 0);
        stroke = KeyStroke.getKeyStroke(40, 0);
        this.registerKeyboardAction(listener, _COMMAND_DOWN, stroke, 0);
        stroke = KeyStroke.getKeyStroke(40, 8);
        this.registerKeyboardAction(listener, _COMMAND_SHOW_DIALOG, stroke, 0);
        stroke = KeyStroke.getKeyStroke(32, 0);
        this.registerKeyboardAction(listener, _COMMAND_SHOW_DIALOG, stroke, 0);
    }

    private void _unregisterKeyboardActions() {
        KeyStroke stroke = KeyStroke.getKeyStroke(38, 0);
        this.unregisterKeyboardAction(stroke);
        stroke = KeyStroke.getKeyStroke(40, 0);
        this.unregisterKeyboardAction(stroke);
        stroke = KeyStroke.getKeyStroke(40, 8);
        this.unregisterKeyboardAction(stroke);
        stroke = KeyStroke.getKeyStroke(32, 0);
        this.unregisterKeyboardAction(stroke);
    }

    private void $init$() {
        this._drawRaised = true;
        this._minWidth = -1;
        this._minHeight = -1;
        this.m_icon = null;
    }

    static int mav$_getItemCount(PageItem pageItem) {
        return pageItem._getItemCount();
    }

    static int ra$_selectedIndex(PageItem pageItem) {
        return pageItem._selectedIndex;
    }

    static void mav$_fireSelectedStringChanged(PageItem pageItem, Object object, Object object2) {
        pageItem._fireSelectedStringChanged(object, object2);
    }

    static void wa$_selectedIndex(PageItem pageItem, int n) {
        pageItem._selectedIndex = n;
    }

    static Appearance mav$_getAppearance(PageItem pageItem) {
        return pageItem._getAppearance();
    }

    static Appearance mav$_getSelectedValueAppearance(PageItem pageItem) {
        return pageItem._getSelectedValueAppearance();
    }

    static int ra$_minWidth(PageItem pageItem) {
        return pageItem._minWidth;
    }

    static JDialog ra$_dialog(PageItem pageItem) {
        return pageItem._dialog;
    }

    static int ra$_minHeight(PageItem pageItem) {
        return pageItem._minHeight;
    }

    static JList ra$_dialogList(PageItem pageItem) {
        return pageItem._dialogList;
    }

    protected class AccessiblePageItem
    extends JComponent.AccessibleJComponent {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getAccessibleName() {
            String label = null;
            String labelName = null;
            String selectedName = null;
            int childCount = 0;
            Object object = PageItem.this.getTreeLock();
            synchronized (object) {
                childCount = this.getAccessibleChildrenCount();
                if (childCount > 0) {
                    labelName = this.getAccessibleChild(0).getAccessibleContext().getAccessibleName();
                    selectedName = this.getAccessibleChild(1).getAccessibleContext().getAccessibleName();
                }
            }
            if (childCount > 0) {
                String parentName;
                Accessible parent;
                if (labelName != null) {
                    label = selectedName != null ? labelName + " " + selectedName : labelName;
                } else if (selectedName != null) {
                    label = selectedName;
                }
                if (label != null && (parent = this.getAccessibleParent()) instanceof PagingComponent && (parentName = parent.getAccessibleContext().getAccessibleName()) != null) {
                    label = parentName + " " + label;
                }
            }
            return label;
        }

        public int getAccessibleIndexInParent() {
            Accessible parent = this.getAccessibleParent();
            if (parent instanceof PagingComponent) {
                // empty if block
            }
            return super.getAccessibleIndexInParent();
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = super.getAccessibleStateSet();
            if (PageItem.this.getModel() != null && PageItem.this.getModel().getItemCount() != 0 && PageItem.this.isEditable() && states.contains(AccessibleState.ENABLED)) {
                states.add(AccessibleState.EDITABLE);
            }
            states.add(AccessibleState.SELECTABLE);
            if (PageItem.this.isSelected()) {
                states.add(AccessibleState.SELECTED);
            }
            return states;
        }

        protected AccessiblePageItem() {
            super((JComponent)((Object)PageItem.this));
        }
    }

    private class KeyListen
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (PageItem._COMMAND_UP.equals(cmd)) {
                int i = PageItem.this.getSelectedIndex();
                if (i >= 1) {
                    PageItem.this.setSelectedIndex(--i);
                }
            } else if (PageItem._COMMAND_DOWN.equals(cmd)) {
                int count;
                int i = PageItem.this.getSelectedIndex();
                if (i < (count = PageItem.mav$_getItemCount(PageItem.this)) - 1) {
                    PageItem.this.setSelectedIndex(++i);
                }
            } else if (PageItem._COMMAND_SHOW_DIALOG.equals(cmd)) {
                PageItem.this.setDropDownVisible(true);
            }
        }

        private KeyListen() {
        }

        KeyListen(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class PopupListen
    implements ActionListener,
    PopupMenuListener {
        public void actionPerformed(ActionEvent e) {
            try {
                String cmd = e.getActionCommand();
                int index = Integer.valueOf(cmd);
                PageItem.this.setSelectedIndex(index);
            }
            catch (NumberFormatException excep) {
                // empty catch block
            }
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            PageItem.this.setSelected(false);
            int index = PageItem.this.getSelectedIndex();
            if (index != -1) {
                JPopupMenu menu = (JPopupMenu)e.getSource();
                MenuElement[] me = new MenuElement[]{menu, menu.getSubElements()[index]};
                MenuSelectionManager.defaultManager().setSelectedPath(me);
            }
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            if (PageItem.this.hasFocus()) {
                PageItem.this.setSelected(true);
            }
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        private PopupListen() {
        }

        PopupListen(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class DSListen
    implements OneDModelListener {
        public void itemsAdded(OneDModelEvent e) {
            int index = e.getStartIndex();
            int count = e.getItemCount();
            if (PageItem.ra$_selectedIndex(PageItem.this) >= index) {
                PageItem pageItem = PageItem.this;
                PageItem.wa$_selectedIndex(pageItem, PageItem.ra$_selectedIndex(pageItem) + count);
            }
        }

        public void itemsRemoved(OneDModelEvent e) {
            int index = e.getStartIndex();
            int count = e.getItemCount();
            if (PageItem.ra$_selectedIndex(PageItem.this) >= index && PageItem.ra$_selectedIndex(PageItem.this) <= index + count) {
                Object newValue = null;
                if (PageItem.this.getModel().getItemCount() == 0) {
                    PageItem.wa$_selectedIndex(PageItem.this, -1);
                } else {
                    PageItem.wa$_selectedIndex(PageItem.this, 0);
                    newValue = PageItem.this.getModel().getData(PageItem.ra$_selectedIndex(PageItem.this));
                }
                PageItem.mav$_fireSelectedStringChanged(PageItem.this, null, newValue);
                PageItem.this.revalidate();
                PageItem.this.repaint();
            } else if (PageItem.ra$_selectedIndex(PageItem.this) > index + count) {
                PageItem pageItem = PageItem.this;
                PageItem.wa$_selectedIndex(pageItem, PageItem.ra$_selectedIndex(pageItem) - count);
            }
        }

        public void invalidateItems(OneDModelEvent e) {
            int index = e.getStartIndex();
            int count = e.getItemCount();
            if (PageItem.ra$_selectedIndex(PageItem.this) >= index && PageItem.ra$_selectedIndex(PageItem.this) <= index + count) {
                Object newValue = PageItem.this.getModel().getData(PageItem.ra$_selectedIndex(PageItem.this));
                PageItem.mav$_fireSelectedStringChanged(PageItem.this, null, newValue);
                PageItem.this.revalidate();
                PageItem.this.repaint();
            }
        }

        private DSListen() {
        }

        DSListen(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    protected class LabelComponent
    extends LWComponent
    implements Accessible {
        private boolean _grippyVisible;

        public LabelComponent() {
            this.setOpaque(true);
            this._grippyVisible = true;
            this.enableEvents(16);
        }

        public void setGrippyVisible(boolean visible) {
            this._grippyVisible = visible;
            this.revalidate();
        }

        public boolean isGrippyVisible() {
            return this._grippyVisible;
        }

        public void paintComponent(Graphics g) {
            ItemPaintContext context = new ItemPaintContext(PageItem.this.getPaintContext(), PageItem.mav$_getAppearance(PageItem.this));
            this.__paintInterior((PaintContext)context, g);
        }

        protected void processMouseEvent(MouseEvent e) {
            super.processMouseEvent(e);
            if (e.isConsumed() || !this.isEnabled() || !SwingUtilities.isLeftMouseButton(e) || e.getID() != 501) {
                return;
            }
            PageItem.this.requestFocus();
        }

        protected void drawGrippy(Graphics graphics, boolean bFill) {
            if (graphics != null) {
                graphics.setColor(Color.LIGHT_GRAY);
                Rectangle rectangle = graphics.getClipBounds();
                if (rectangle != null) {
                    int nHeight = (int)rectangle.getHeight();
                    int nDotSize = nHeight / 8;
                    int nIncrement = nDotSize * 2;
                    int nIndent = 2;
                    int nY = nIncrement;
                    if (bFill) {
                        graphics.fillOval(nIndent, nY, nDotSize, nDotSize);
                        graphics.fillOval(nIndent, nY += nIncrement, nDotSize, nDotSize);
                        graphics.fillOval(nIndent, nY += nIncrement, nDotSize, nDotSize);
                    } else {
                        graphics.drawOval(nIndent, nY, nDotSize, nDotSize);
                        graphics.drawOval(nIndent, nY += nIncrement, nDotSize, nDotSize);
                        graphics.drawOval(nIndent, nY += nIncrement, nDotSize, nDotSize);
                    }
                }
            }
        }

        void __drawGrippys(Graphics g, int x, int y, int length, Color highlight, Color dark, boolean isArmed) {
            int darkDots = 0;
            darkDots = length % 2 == 0 ? length / 2 : (length + 1) / 2;
            int whiteDots = length - darkDots;
            if (isArmed) {
                g.setColor(highlight);
                int tempX = x;
                int tempY = y;
                int i = 0;
                while (i < darkDots) {
                    g.drawLine(tempX, tempY, tempX, tempY);
                    tempX += 2;
                    tempY += 2;
                    ++i;
                }
                g.setColor(dark);
                ++x;
                ++y;
                int i2 = 0;
                while (i2 < whiteDots) {
                    g.drawLine(x, y, x, y);
                    x += 2;
                    y += 2;
                    ++i2;
                }
            } else {
                this.drawGrippy(g, true);
            }
        }

        protected Painter paintGrippy(PaintContext context, Graphics g, int x, int y, int width, int height) {
            Object grippy = PageItem.this.getEWTPageItemUI().getGrippyPainter((JComponent)((Object)PageItem.this));
            grippy = new ADFPainter();
            Dimension grippySize = grippy.getSize(context, width, height);
            grippy.paint(context, g, x, y, grippySize.width, height);
            x += grippySize.width;
            width -= grippySize.width;
            return grippy;
        }

        void __paintInterior(PaintContext context, Graphics g) {
            Icon icon;
            Dimension size = this.getSize();
            Appearance a = PageItem.mav$_getAppearance(PageItem.this);
            ImmInsets insets = a.getInsets();
            g.setColor(context.getPaintBackground());
            g.fillRect(0, 0, size.width, size.height);
            g.setFont(context.getPaintFont());
            int x = 0;
            int y = 0;
            int width = size.width;
            int height = size.height;
            if (this._grippyVisible) {
                Painter grippy = this.paintGrippy(context, g, x, y, width, height);
                Dimension grippySize = grippy.getSize(context, width, height);
                x += grippySize.width;
                width -= grippySize.width;
                x += grippySize.width;
                width -= grippySize.width;
            }
            if ((icon = PageItem.this.getIcon()) != null) {
                int nY = (size.height - icon.getIconHeight()) / 2;
                icon.paintIcon(null, g, x, nY);
                x += icon.getIconWidth();
            }
            if (insets != null) {
                x += insets.left;
                y += insets.top;
                width -= insets.left + insets.right;
                height -= insets.top + insets.bottom;
            }
            g.setColor(context.getPaintForeground());
            Painter p = PageItem.this.getPainter();
            p.paint(context, g, x += 3, y, width -= 3, height);
        }

        public Dimension getPreferredSize() {
            Appearance a;
            ImmInsets insets;
            Painter p = PageItem.this.getPainter();
            ItemPaintContext context = new ItemPaintContext(PageItem.this.getPaintContext(), PageItem.mav$_getAppearance(PageItem.this));
            Dimension d = p.getPreferredSize((PaintContext)context);
            d.height += 4;
            if (this._grippyVisible) {
                Painter grippy = PageItem.this.getEWTPageItemUI().getGrippyPainter((JComponent)((Object)PageItem.this));
                Dimension size = grippy.getPreferredSize((PaintContext)context);
                d.width += size.width;
                if (d.height < size.height) {
                    d.height = size.height;
                }
            }
            if ((insets = (a = PageItem.mav$_getAppearance(PageItem.this)).getInsets()) != null) {
                d.width += insets.left + insets.right;
                d.height += insets.top + insets.bottom;
            }
            d.width += 3;
            if (PageItem.this.getIcon() != null) {
                d.width += PageItem.this.getIcon().getIconWidth() + 3;
            }
            return d;
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new LCAccessible(null);
            }
            return this.accessibleContext;
        }

        public class ADFPainter
        extends AbstractPainter {
            private static final int _GRIPPY_SIZE = 2;
            private static final int _GRIPPY_GAP = -1;
            private static final int _GRIPPY_STRIDE = 1;
            private static final int _MIN_GRIPPIES = 3;
            private static final int _MIN_PERP_GRIPPY_SIZE = 6;
            private static final int _MIN_ORIENT_GRIPPY_SIZE = 4;

            public Dimension getMinimumSize(PaintContext context) {
                return new Dimension(6, 4);
            }

            public Dimension getSize(PaintContext context, int width, int height) {
                if (width > 6) {
                    width = 6;
                }
                if (height > 4) {
                    height = 4;
                }
                return new Dimension(width, height);
            }

            public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
                boolean paint;
                int state;
                boolean printing;
                Color savedColor = g.getColor();
                boolean bl = printing = g instanceof PrintGraphics || g instanceof PrinterGraphics;
                if (!printing) {
                    Color grippyColor = UIManager.getColor("EWTPivotPivotGrippy.background");
                    g.setColor(grippyColor);
                    grippyColor = UIManager.getColor("EWTPivotPivotGrippy.border");
                    g.setColor(grippyColor);
                }
                boolean enabled = ((state = context.getPaintState()) & 1) == 0;
                boolean bl2 = paint = printing ? false : enabled;
                if (paint) {
                    int numGrippies = 3;
                    int grippySize = numGrippies * 2 + (numGrippies - 1) * -1;
                    int grippyWidth = 2;
                    int grippyHeight = grippySize;
                    int yOffset = 1;
                    int grippyX = x + (width - grippyWidth) / 2;
                    int grippyY = y + (height - grippyHeight) / 2;
                    int topRightCornerX = grippyX + grippyWidth - 1;
                    int topRightCornerY = grippyY;
                    int bottomLeftCornerX = grippyX;
                    int bottomLeftCornerY = grippyY + grippyHeight - 1;
                    boolean numTopRightCornerDots = true;
                    boolean numBottomLeftCornerDots = true;
                    UIDefaults defaults = context.getPaintUIDefaults();
                    Color highlight = Color.white;
                    Color dark = defaults.getColor("PivotTable.darkGrippy");
                    boolean isArmed = (state & 2) != 0;
                    while (numGrippies > 0) {
                        LabelComponent.this.__drawGrippys(g, grippyX, grippyY, 2, highlight, dark, isArmed);
                        --numGrippies;
                        grippyY += yOffset;
                    }
                }
                g.setColor(savedColor);
            }
        }

        private class LCAccessible
        extends JComponent.AccessibleJComponent {
            public Accessible getAccessibleParent() {
                return PageItem.this;
            }

            public int getAccessibleIndexInParent() {
                return 0;
            }

            public int getAccessibleChildrenCount() {
                return 0;
            }

            public Accessible getAccessibleChild(int i) {
                return null;
            }

            public String getAccessibleName() {
                String label = PageItem.this.getText();
                if (label == null) {
                    label = super.getAccessibleName();
                }
                return label;
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.LABEL;
            }

            private LCAccessible() {
                super((JComponent)((Object)LabelComponent.this));
            }

            LCAccessible(1 var2_2) {
                this();
            }

            public final class 1 {
            }
        }
    }

    protected class ValueComponent
    extends LWComponent
    implements Accessible {
        private Painter _iconPainter;
        private boolean _dropDownIconVisible;

        public ValueComponent() {
            this.setOpaque(true);
            this._dropDownIconVisible = false;
            this.enableEvents(16);
        }

        public void setDropDownIconVisible(boolean visible) {
            this._dropDownIconVisible = visible;
        }

        public void paintComponent(Graphics g) {
            ItemPaintContext context = new ItemPaintContext(PageItem.this.getPaintContext(), PageItem.mav$_getSelectedValueAppearance(PageItem.this));
            this.__paintInterior((PaintContext)context, g);
        }

        protected void processMouseEvent(MouseEvent e) {
            super.processMouseEvent(e);
            if (e.isConsumed() || !this.isEnabled() || !SwingUtilities.isLeftMouseButton(e) || e.getID() != 501) {
                return;
            }
            e.consume();
            PageItem.this.requestFocus();
            PageItem.this.setDropDownVisible(true);
        }

        private Painter _getIconPainter() {
            if (this._iconPainter == null) {
                this.updateIcon();
            }
            return this._iconPainter;
        }

        protected Dimension paintDropDownIcon(PaintContext context, Graphics graphics, int nX, int nY, int nWidth, int nHeight, boolean bStyleJDEVADF) {
            Painter iconPainter = this._getIconPainter();
            Dimension iconSize = iconPainter.getSize(context, nWidth, nHeight);
            int iconX = nX + nWidth - iconSize.width;
            if (bStyleJDEVADF) {
                Insets insets = new Insets(0, 0, 4, 4);
                graphics.setColor(Color.LIGHT_GRAY);
                graphics.drawLine(nX + insets.right, nY + insets.bottom, nX + insets.right, nY + nHeight - insets.bottom);
                iconX = nX + insets.right;
                iconPainter.paint(context, graphics, iconX, nY, iconSize.width, nHeight);
            } else {
                iconPainter.paint(context, graphics, iconX, nY, iconSize.width, nHeight);
            }
            return iconSize;
        }

        void __paintInterior(PaintContext context, Graphics g) {
            Dimension size = this.getSize();
            Appearance a = PageItem.mav$_getSelectedValueAppearance(PageItem.this);
            ImmInsets insets = a.getInsets();
            g.setColor(context.getPaintBackground());
            g.fillRect(0, 0, size.width, size.height);
            g.setFont(context.getPaintFont());
            int x = 0;
            int y = 0;
            int width = size.width;
            int height = size.height;
            if (this._dropDownIconVisible) {
                Dimension iconSize = this.paintDropDownIcon(context, g, x, y, width, height, true);
                width -= iconSize.width;
            }
            if (insets != null) {
                x += insets.left;
                y += insets.top;
                width -= insets.left + insets.right;
                height -= insets.top + insets.bottom;
            }
            g.setColor(context.getPaintForeground());
            Painter p = PageItem.this.getSelectedValuePainter();
            p.paint(context, g, x += 3, y, width -= 3, height);
        }

        public boolean isDropDownIconPressed() {
            boolean bDropDownIconPressed = false;
            if (this._dropDownIconVisible) {
                Dimension size = this.getSize();
                int x = 0;
                boolean y = false;
                int width = size.width;
                int height = size.height;
                Painter iconPainter = this._getIconPainter();
                PaintContext context = this.getPaintContext();
                Dimension iconSize = iconPainter.getSize(context, width, height);
                int iconX = x + width - iconSize.width;
                width -= iconSize.width;
            }
            return bDropDownIconPressed;
        }

        public Dimension getPreferredSize() {
            Appearance a;
            ImmInsets insets;
            Painter p = PageItem.this.getSelectedValuePainter();
            ItemPaintContext context = new ItemPaintContext(PageItem.this.getPaintContext(), PageItem.mav$_getSelectedValueAppearance(PageItem.this));
            Dimension d = p.getPreferredSize((PaintContext)context);
            d.height += 4;
            Painter iconPainter = this._getIconPainter();
            Dimension size = iconPainter.getPreferredSize((PaintContext)context);
            d.width += size.width;
            if (d.height < size.height) {
                d.height = size.height;
            }
            if ((insets = (a = PageItem.mav$_getAppearance(PageItem.this)).getInsets()) != null) {
                d.width += insets.left + insets.right;
                d.height += insets.top + insets.bottom;
            }
            d.width += 3;
            return d;
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void updateIcon(boolean bIsVisible) {
            Icon icon = PageItem.this.getEWTPageItemUI().getDropDownIcon((JComponent)((Object)PageItem.this));
            if (!bIsVisible) {
                // empty if block
            }
            this._iconPainter = new FixedAlignmentPainter((Painter)new FixedIconPainter(icon), 0.5f, 0.5f);
        }

        public void updateIcon() {
            this.updateIcon(true);
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new ICAccessible(null);
            }
            return this.accessibleContext;
        }

        private class ICAccessible
        extends JComponent.AccessibleJComponent
        implements AccessibleAction {
            public int getAccessibleChildrenCount() {
                return 0;
            }

            public Accessible getAccessibleChild(int i) {
                return null;
            }

            public Accessible getAccessibleParent() {
                return PageItem.this;
            }

            public int getAccessibleIndexInParent() {
                return 1;
            }

            public String getAccessibleName() {
                if (PageItem.this.getModel() == null) {
                    return super.getAccessibleName();
                }
                String label = PageItem.this.getSelectedValue();
                if (label == null) {
                    label = super.getAccessibleName();
                }
                return label;
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.COMBO_BOX;
            }

            public AccessibleAction getAccessibleAction() {
                return this;
            }

            public String getAccessibleActionDescription(int i) {
                Locale l = LocaleUtils.getDefaultableLocale((Component)((Object)PageItem.this));
                ResourceBundle b = ResourceBundle.getBundle(PageItem._ACCESS_RESOURCE_BUNDLE, l);
                if (i == 0) {
                    return b.getString(PageItem._TOGGLE_DROP_DOWN_KEY);
                }
                return null;
            }

            public int getAccessibleActionCount() {
                return 1;
            }

            public boolean doAccessibleAction(int i) {
                if (i == 0 && PageItem.this.isEditable()) {
                    PageItem.this.setDropDownVisible(PageItem.this.isDropDownVisible() ^ true);
                    return true;
                }
                return false;
            }

            private ICAccessible() {
                super((JComponent)((Object)ValueComponent.this));
            }

            ICAccessible(1 var2_2) {
                this();
            }

            public final class 1 {
            }
        }
    }

    private class DialogListen
    extends WindowAdapter
    implements ActionListener,
    MouseListener,
    ComponentListener {
        public void windowClosing(WindowEvent e) {
            PageItem.this.setSelectDialogVisible(false);
        }

        public void actionPerformed(ActionEvent e) {
            int index;
            if (PageItem._OK_KEY.equals(e.getActionCommand()) && (index = PageItem.ra$_dialogList(PageItem.this).getSelectedIndex()) != -1) {
                PageItem.this.setSelectedIndex(index);
            }
            PageItem.this.setSelectDialogVisible(false);
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                int index = PageItem.ra$_dialogList(PageItem.this).locationToIndex(e.getPoint());
                if (index != -1) {
                    PageItem.this.setSelectedIndex(index);
                }
                PageItem.this.setSelectDialogVisible(false);
            }
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void componentResized(ComponentEvent e) {
            if (PageItem.ra$_minWidth(PageItem.this) != -1) {
                int width = PageItem.ra$_dialog(PageItem.this).getWidth();
                int height = PageItem.ra$_dialog(PageItem.this).getHeight();
                boolean set = false;
                if (width < PageItem.ra$_minWidth(PageItem.this)) {
                    width = PageItem.ra$_minWidth(PageItem.this);
                    set = true;
                }
                if (height < PageItem.ra$_minHeight(PageItem.this)) {
                    height = PageItem.ra$_minHeight(PageItem.this);
                    set = true;
                }
                if (set) {
                    PageItem.ra$_dialog(PageItem.this).setSize(width, height);
                }
            }
        }

        public void componentHidden(ComponentEvent e) {
        }

        public void componentShown(ComponentEvent e) {
        }

        public void componentMoved(ComponentEvent e) {
        }

        private DialogListen() {
        }

        DialogListen(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static class OneDModelAdapter
    implements ListModel {
        private OneDModel _toAdapt;

        public OneDModelAdapter(OneDModel model) {
            this._toAdapt = model;
        }

        public int getSize() {
            return this._toAdapt.getItemCount();
        }

        public Object getElementAt(int index) {
            return this._toAdapt.getData(index);
        }

        public void addListDataListener(ListDataListener l) {
        }

        public void removeListDataListener(ListDataListener l) {
        }
    }

    private class ItemPaintContext
    extends PaintContextProxy {
        private int _paintState;
        private PaintContext _context;
        private Appearance _appearance;

        public ItemPaintContext(PaintContext context, Appearance a) {
            this._context = context;
            this._appearance = a;
            this._paintState = this._getPaintState();
        }

        protected PaintContext getPaintContext() {
            return this._context;
        }

        public int getPaintState() {
            return this._paintState;
        }

        private int _getPaintState() {
            int state = super.getPaintState();
            if (PageItem.this.isEnabled() && PageItem.this.isSelected()) {
                state |= 0x20;
            }
            return state;
        }

        public Color getPaintForeground() {
            int state = this.getPaintState();
            Color c = null;
            c = PageItem.this.isSwapping() && !PageItem.this.isDragging() ? PageItem.this.getEWTPageItemUI().getSwapForegroundColor((JComponent)((Object)PageItem.this), this.getAppearance()) : ((state & 0x20) == 0 || this._isSelectionTransparent() ? this.getAppearance().getForeground() : this.getAppearance().getSelectForeground());
            return c;
        }

        public Font getPaintFont() {
            int state = this.getPaintState();
            Font font = null;
            if ((state & 0x20) != 0 && !this._isSelectionTransparent()) {
                font = this.getAppearance().getSelectFont();
            }
            if (font == null) {
                font = this.getAppearance().getFont();
            }
            if (font == null) {
                font = super.getPaintFont();
            }
            return font;
        }

        public Color getPaintBackground() {
            return this.getUsefulPaintBackground();
        }

        Color getUsefulPaintBackground() {
            boolean disabled;
            int state = this.getPaintState();
            Color color = null;
            boolean selected = (state & 0x20) != 0;
            boolean active = (state & 4) == 0;
            boolean bl = disabled = (state & 1) != 0;
            if (PageItem.this.isSwapping() && !PageItem.this.isDragging()) {
                return PageItem.this.getEWTPageItemUI().getSwapBackgroundColor((JComponent)((Object)PageItem.this), this.getAppearance());
            }
            if (!PageItem.this.isEnabled()) {
                return UIManager.getColor("PageItem.disabledBackground");
            }
            if (selected) {
                if (active) {
                    color = this.getAppearance().getSelectBackground();
                    if (this._isSelectionTransparent() && color != null) {
                        Color base = this.getAppearance().getBackground();
                        if (base == null) {
                            base = super.getPaintBackground();
                        }
                        if (base != null) {
                            color = ColorUtils.getTransparentColor((Color)base, (Color)color, (int)60);
                        }
                    }
                } else {
                    color = UIManager.getColor("PageItem.inactiveSelectedBackground");
                }
            }
            if (color == null) {
                color = this.getAppearance().getBackground();
            }
            if (color == null) {
                color = super.getPaintBackground();
            }
            return color;
        }

        public float getInteriorAlignmentX() {
            float align;
            Appearance a = this.getAppearance();
            int hJustify = a.getHorizontalJustify();
            if (hJustify == 0) {
                int direction = a.getReadingDirection();
                switch (direction) {
                    case 0: {
                        return super.getInteriorAlignmentX();
                    }
                }
                hJustify = LocaleUtils.getAlignmentForReadingDirection((int)direction);
            }
            switch (hJustify) {
                case 3: {
                    align = 0.5f;
                    break;
                }
                case 2: {
                    align = 1.0f;
                    break;
                }
                default: {
                    align = 0.0f;
                    break;
                }
            }
            return align;
        }

        public float getInteriorAlignmentY() {
            int hJustify = this.getAppearance().getVerticalJustify();
            float align = 0.0f;
            switch (hJustify) {
                case 1: {
                    align = 0.5f;
                    break;
                }
                case 0: {
                    align = 0.0f;
                    break;
                }
                case 2: {
                    align = 1.0f;
                    break;
                }
            }
            return align;
        }

        public int getReadingDirection() {
            int direction = this.getAppearance().getReadingDirection();
            if (direction == 0) {
                direction = super.getReadingDirection();
            }
            return direction;
        }

        public Object getPaintData(Object key) {
            if (key == PaintContext.MNEMONIC_INDEX_KEY) {
                return null;
            }
            return super.getPaintData(key);
        }

        public Appearance getAppearance() {
            return this._appearance;
        }

        private boolean _isSelectionTransparent() {
            Container parent = PageItem.this.getParent();
            return parent instanceof PagingComponent && ((PagingComponent)parent).isSelectionTransparent();
        }
    }
}

