/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.gui.layout;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import oracle.bali.ewt.border.BorderAdapter;
import oracle.bali.ewt.border.UIBorderFactory;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.SeparatorBorderPainter;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.util.LayoutAccess;
import oracle.dss.util.LayoutContext;
import oracle.dss.util.PagingControlAttributes;
import oracle.dss.util.gui.layout.Layout;
import oracle.dss.util.gui.layout.LayoutSpreadTable;

public class TableLayout
extends Layout {
    public static final String HIDE_DUPLICATE_ROWS = "HideDuplicateRows";
    protected static final String m_method_updateLDisplay = "updateLayerDisplay";
    protected static final Border BORDER_SINGLE_LINE = new BorderAdapter((BorderPainter)new SeparatorBorderPainter(1, true, 0));
    private JCheckBox m_duplicateRowsChkBox;
    private LayoutSpreadTable m_table;
    private JScrollPane m_scrollPane;
    private TablePropertyChangeListener m_listener;
    private PagingControlAttributes m_pca;
    private boolean m_bDuplicateRowsControlVisible;

    public TableLayout() {
        this.$init$();
        this.m_listener = new TablePropertyChangeListener(null);
        Layout.LayoutPivotListener pivotListener = new Layout.LayoutPivotListener();
        this.m_duplicateRowsChkBox = new JCheckBox();
        this.m_duplicateRowsChkBox.addItemListener(new 1());
        this.m_table = new LayoutSpreadTable();
        this.m_table.setLayoutPanel(this);
        this.m_table.setEdge(0);
        this.m_table.addPivotListener(pivotListener);
        this.m_table.addPropertyChangeListener(this.m_listener);
        this.m_scrollPane = new JScrollPane((Component)((Object)this.m_table));
        this.m_scrollPane.setVerticalScrollBarPolicy(21);
        this.m_scrollPane.setBorder(BORDER_SINGLE_LINE);
        JPanel centerPnl = new JPanel(new BorderLayout());
        centerPnl.add((Component)this.m_scrollPane, "Center");
        centerPnl.setBorder(UIBorderFactory.getLoweredBevelBorder());
        this.add(centerPnl);
        this.m_popupManager.setPageLayoutComponent(this.m_pageEdgeLayers);
        this.m_popupManager.setColumnLayoutComponent(this.m_table);
        this.m_table.setPopupManager(this.m_popupManager);
        this.m_popupManager.setPivotListener(pivotListener);
        this.updateTextUsingCorrectLocale();
        this.m_componentListener = new 2();
        this.addComponentListener(this.m_componentListener);
    }

    public void setPagingControlAttributes(PagingControlAttributes pca) {
        this.m_pca = pca;
        if (this.m_pca != null) {
            this.m_showPageItemsChkBox.setSelected(this.m_pca.isPagingControlVisible());
        }
    }

    public boolean apply() {
        if (this.m_pca != null) {
            this.m_pca.setPagingControlVisible(this.m_bPagingControlVisible);
        }
        return super.apply();
    }

    public String getDescriptionText() {
        if (super.getDescriptionText() != null && super.getDescriptionText().length() > 0) {
            return super.getDescriptionText();
        }
        return this.m_rBundle.getString("crosstabLayoutDesc");
    }

    public void setDuplicateRowsControlVisible(boolean isVisible) {
        if (this.m_bDuplicateRowsControlVisible != isVisible) {
            this.m_bDuplicateRowsControlVisible = isVisible;
            this.getPagingControlPanelOptions().removeAll();
            if (isVisible) {
                this.getPagingControlPanelOptions().add(this.m_showPageItemsChkBox);
                this.getPagingControlPanelOptions().add(Box.createHorizontalStrut(100));
                this.getPagingControlPanelOptions().add(this.m_duplicateRowsChkBox);
            }
            this.getPagingControlPanelOptions().revalidate();
        }
    }

    public boolean isDuplicateRowsControlVisible() {
        return this.m_bDuplicateRowsControlVisible;
    }

    public void setLayoutAccess(LayoutAccess layoutAccess) {
        this.m_layoutAccess = layoutAccess;
        this.m_layoutAccess.setCursorEvaluation(true);
        if (this.m_layoutAccess.getDataSource() != null) {
            this.m_dataDirector = this.m_layoutAccess.getDataSource().createRelationalDataDirector();
            if (this.m_dataDirector != null) {
                this.m_dataDirector.addDataDirectorListener(this);
            }
        }
        this.updateLayerDisplay();
    }

    public void setLayoutContext(LayoutContext lc) {
        this.m_layoutContext = lc;
        this.setLayoutAccess(this.m_layoutContext.createRelationalLayoutAccess());
    }

    public Component getInitialFocus() {
        if (this.m_showPageItemsChkBox.isEnabled()) {
            return this.m_showPageItemsChkBox;
        }
        if (this.isDuplicateRowsControlVisible()) {
            return this.m_duplicateRowsChkBox;
        }
        return this.m_table;
    }

    public void cleanup(boolean finished) {
        if (finished) {
            this.removeComponentListener(this.m_componentListener);
            this.m_table.removePropertyChangeListener(this.m_listener);
            this.m_table.setItems(null);
            this.m_table.cleanup();
            this.removeAll();
            this.m_duplicateRowsChkBox = null;
            this.m_scrollPane = null;
            this.m_table = null;
            this.m_listener = null;
        }
    }

    public String getHelpContextID() {
        if (this.m_bPagingControlVisible) {
            if (this.m_bDuplicateRowsControlVisible) {
                return this.getClass().getName() + "_PageCtrl_DupCtrl";
            }
            return this.getClass().getName() + "_PageCtrl_NoDupCtrl";
        }
        if (this.m_bDuplicateRowsControlVisible) {
            return this.getClass().getName() + "_NoPageCtrl_DupCtrl";
        }
        return this.getClass().getName() + "_NoPageCtrl_NoDupCtrl";
    }

    protected void updateTextUsingCorrectLocale() {
        super.updateTextUsingCorrectLocale();
        this.m_popupManager.setColumnName(this.m_rBundle.getString("Column"));
        this.m_duplicateRowsChkBox.setText(StringUtils.stripMnemonic((String)this.m_rBundle.getString("Hide Duplicate Rows")));
        this.m_duplicateRowsChkBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_rBundle.getString("Hide Duplicate Rows")));
    }

    protected void updateLayerDisplay() {
        String[] columnItems;
        block5: {
            super.updateLayerDisplay();
            this.addLayersToPagingComponent(this.m_pageEdgeLayers, 2, true, true);
            columnItems = null;
            if (this.m_dataAccess != null) {
                try {
                    int edgeExtent = this.m_dataAccess.getEdgeExtent(0);
                    columnItems = new String[edgeExtent];
                    int col = 0;
                    while (col < edgeExtent) {
                        Object obj = this.m_dataAccess.getMemberMetadata(0, col, col, this.getMemberMetadataLabelType());
                        if (obj != null) {
                            columnItems[col] = obj.toString();
                        }
                        ++col;
                    }
                }
                catch (Exception e) {
                    if (this.m_eh == null) break block5;
                    this.m_eh.error(e, this.getClass().getName(), m_method_updateLDisplay);
                }
            }
        }
        this.m_table.setItems(columnItems);
        this.revalidate();
        this.repaint();
    }

    void deselectAll() {
        this.m_table.clearSelection();
        this.m_pageEdgeLayers.setSelectedItem(null);
    }

    void tableSelectionChanged() {
        this.m_pageEdgeLayers.setSelectedItem(null);
    }

    private void $init$() {
        this.m_pca = null;
        this.m_bDuplicateRowsControlVisible = false;
    }

    final class 1
    implements ItemListener {
        public void itemStateChanged(ItemEvent e) {
            boolean hideDuplicateRows = e.getStateChange() == 1;
            TableLayout.this.firePropertyChange(TableLayout.HIDE_DUPLICATE_ROWS, hideDuplicateRows ^ true, hideDuplicateRows);
        }
    }

    final class 2
    extends ComponentAdapter {
        public void componentResized(ComponentEvent e) {
            TableLayout.this.resizeDescriptionLabel();
        }
    }

    private class TablePropertyChangeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            if ("selection".equals(e.getPropertyName()) && !TwoDSelection.getEmptySelection().equals(e.getNewValue())) {
                TableLayout.this.tableSelectionChanged();
            }
        }

        private TablePropertyChangeListener() {
        }

        TablePropertyChangeListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

