/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.persistence;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class SerializableIdentityHashSet
implements Serializable {
    private final HashSet m_set;

    public SerializableIdentityHashSet() {
        this.m_set = new HashSet();
    }

    public SerializableIdentityHashSet(int initialCapacity) {
        this.m_set = new HashSet(initialCapacity);
    }

    public int size() {
        return this.m_set.size();
    }

    public boolean isEmpty() {
        return this.m_set.isEmpty();
    }

    public boolean contains(Object key) {
        return this.m_set.contains(new IdentityHashKey(key));
    }

    public Iterator iterator() {
        return new IdentityHashMapIterator(this.m_set.iterator());
    }

    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    public Object[] toArray(Object[] a) {
        int _size = this.size();
        if (a.length < _size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), _size);
        }
        Iterator _it = this.m_set.iterator();
        int i = 0;
        while (i < _size) {
            IdentityHashKey _key = (IdentityHashKey)_it.next();
            a[i] = _key.getObject();
            ++i;
        }
        if (a.length > _size) {
            a[_size] = null;
        }
        return a;
    }

    public boolean add(Object key) {
        return this.m_set.add(new IdentityHashKey(key));
    }

    public boolean remove(Object key) {
        return this.m_set.remove(new IdentityHashKey(key));
    }

    public void clear() {
        this.m_set.clear();
    }

    public boolean equals(Object other) {
        if (other instanceof SerializableIdentityHashSet) {
            SerializableIdentityHashSet _typedOther = (SerializableIdentityHashSet)other;
            return this.m_set.equals(_typedOther.m_set);
        }
        if (other instanceof Set) {
            Set _setOther = (Set)other;
            return this.m_set.equals(_setOther);
        }
        return false;
    }

    public int hashCode() {
        return this.m_set.hashCode();
    }

    private static class IdentityHashKey
    implements Serializable {
        private Object _object;

        public IdentityHashKey(Object object) {
            this._object = object;
        }

        public Object getObject() {
            return this._object;
        }

        public boolean equals(Object other) {
            if (other instanceof IdentityHashKey) {
                return this._object == ((IdentityHashKey)other)._object;
            }
            return false;
        }

        public int hashCode() {
            if (this._object != null) {
                return System.identityHashCode(this._object);
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IdentityHashMapIterator
    implements Iterator {
        private final Iterator m_iterator;

        IdentityHashMapIterator(Iterator iterator) {
            this.m_iterator = iterator;
        }

        @Override
        public void remove() {
            this.m_iterator.remove();
        }

        @Override
        public boolean hasNext() {
            return this.m_iterator.hasNext();
        }

        public Object next() {
            Object next = this.m_iterator.next();
            if (next != null) {
                return ((IdentityHashKey)next).getObject();
            }
            return null;
        }
    }
}

