/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.transform;

import java.util.Comparator;
import java.util.Date;
import oracle.dss.util.transform.ComparatorInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonComparator
implements Comparator<ComparatorInterface> {
    protected int m_sortDir;
    protected boolean m_nullsFirst;

    private void $init$() {
        this.m_sortDir = -1;
        this.m_nullsFirst = false;
    }

    public CommonComparator(int sortDir, boolean nullsFirst) {
        this.$init$();
        this.m_sortDir = sortDir;
        this.m_nullsFirst = nullsFirst;
    }

    @Override
    public int compare(ComparatorInterface val1, ComparatorInterface val2) {
        if (val1 == null && val2 == null) {
            return 0;
        }
        if (val1 == null) {
            return -1;
        }
        if (val2 == null) {
            return 1;
        }
        Object data1 = val1.getValue();
        Object data2 = val2.getValue();
        if (data1 == null && data2 == null) {
            return 0;
        }
        if (data1 == null) {
            return this.m_nullsFirst ? -1 : 1;
        }
        if (data2 == null) {
            return this.m_nullsFirst ? 1 : -1;
        }
        if (this.m_sortDir == 1) {
            Object temp = data1;
            data1 = data2;
            data2 = temp;
        }
        if (data1 instanceof Number && data2 instanceof Number) {
            Number d1 = (Number)data1;
            Number d2 = (Number)data2;
            if (d1.doubleValue() > d2.doubleValue()) {
                return 1;
            }
            if (d1.doubleValue() < d2.doubleValue()) {
                return -1;
            }
            return 0;
        }
        if (data1 instanceof String && data2 instanceof String) {
            String d1 = (String)data1;
            String d2 = (String)data2;
            int compVal = d1.compareTo(d2);
            return this._interpretCompVal(compVal);
        }
        if (data1 instanceof Date && data2 instanceof Date) {
            Date d1 = (Date)data1;
            Date d2 = (Date)data2;
            int compVal = d1.compareTo(d2);
            return this._interpretCompVal(compVal);
        }
        return 0;
    }

    private int _interpretCompVal(int compVal) {
        if (compVal > 0) {
            return 1;
        }
        if (compVal < 0) {
            return -1;
        }
        return 0;
    }
}

