/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.transform;

import java.util.Hashtable;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.QDR;
import oracle.dss.util.QDRInterface;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.dss.util.transform.BaseNode;
import oracle.dss.util.transform.BaseProjection;
import oracle.dss.util.transform.CommonTreeProjection;
import oracle.dss.util.transform.CubicDataAccess;
import oracle.dss.util.transform.DataCellInterface;
import oracle.dss.util.transform.EdgeTree;
import oracle.dss.util.transform.EdgeTreeNode;
import oracle.dss.util.transform.LayerInterface;
import oracle.dss.util.transform.MemberInterface;
import oracle.dss.util.transform.StackPack;
import oracle.dss.util.transform.TransformException;
import oracle.dss.util.transform.TransformRuntimeException;
import oracle.dss.util.transform.TransformUtils;
import oracle.dss.util.transform.TreeBasedEdgeTree;
import oracle.dss.util.transform.TreeNode;
import oracle.dss.util.transform.TreeProjection;

public abstract class CommonTreeBasedCubicDataAccess
extends CubicDataAccess {
    protected Hashtable<String, int[]> m_layerEdge;
    protected Hashtable<Integer, EdgeTreeNode> m_repeatSubtrees;
    protected Hashtable<Integer, Boolean> m_firstEdgeBreak;

    private void $init$() {
        this.m_layerEdge = new Hashtable();
        this.m_repeatSubtrees = null;
        this.m_firstEdgeBreak = new Hashtable();
    }

    public CommonTreeBasedCubicDataAccess() throws TransformException {
        super(null, false);
        this.$init$();
    }

    public CommonTreeBasedCubicDataAccess(boolean cache) throws TransformException {
        super(null, cache);
        this.$init$();
    }

    public synchronized void release() {
        this.m_layerEdge.clear();
        this.m_layerEdge = null;
        super.release();
    }

    protected QDR generateQDR() throws TransformException {
        LayerInterface li = this.getDataLayerInterface();
        return new QDR(li != null ? li.getValue() : null);
    }

    protected abstract LayerInterface getDataLayerInterface();

    protected String getDataLayer() throws TransformException {
        if (this.m_cachedDataLayer == null) {
            this.m_cachedDataLayer = this.getProjection().getDataLayer() == null ? null : this.getProjection().getDataLayer().getValue();
        }
        return this.m_cachedDataLayer;
    }

    protected String[][] getLayout() {
        if (this.m_cachedLayout == null) {
            this.m_cachedLayout = this.getProjection().getLayout();
        }
        return this.m_cachedLayout;
    }

    public synchronized void insert(TreeNode[] nodes) throws TransformException {
    }

    protected BaseNode[] _getLayers(int edge) {
        String[][] layout = this.getLayout();
        if (layout != null && layout.length > edge && layout[edge] != null) {
            BaseNode[] nodes = new BaseNode[layout[edge].length];
            int i = 0;
            while (i < layout[edge].length) {
                nodes[i] = new BaseNode(layout[edge][i]);
                ++i;
            }
            return nodes;
        }
        return null;
    }

    protected int getEdgeForLayer(TreeNode node) throws TransformException {
        int[] retVal = this._getLayerAndEdge(node);
        if (retVal != null) {
            return retVal[0];
        }
        return -1;
    }

    protected abstract BaseProjection getProjection();

    private int[] _getLayerAndEdge(TreeNode node) throws TransformException {
        LayerInterface layer = node.getLayer();
        if (layer == null) {
            return null;
        }
        String layerName = layer.getValue();
        if (layerName == null) {
            return null;
        }
        int[] info = this.m_layerEdge.get(layerName);
        if (info != null) {
            return info;
        }
        String[][] layout = this.getLayout();
        int[] val = TransformUtils.getLayerAndEdge(layerName, layout);
        try {
            if (val != null) {
                this.m_layerEdge.put(layerName, val);
            }
        }
        catch (NullPointerException e) {
            throw new TransformException(e.getMessage(), e);
        }
        return val;
    }

    private boolean testStopBuild(int edge, long getToSlice, EdgeTreeNode node) throws TransformException {
        if (getToSlice == (long)-1) {
            return false;
        }
        return this.notAtSlice(node, edge, getToSlice);
    }

    protected void buildTree(TreeNode node, StackPack stacks, int edge, long getToSlice, EdgeTreeNode childrenCompleteNode, boolean[] alwaysAdd) throws TransformException {
        if (stacks.getStack().isEmpty()) {
            stacks.getStack().add(node.getFirstChild());
            stacks.getLastNodeStack().add(node);
            stacks.getParentStack().add(null);
            stacks.getIsSiblingNodeStack().add(false);
        }
        TreeNode t = null;
        EdgeTreeNode myParent = null;
        TreeNode lastNode = null;
        EdgeTreeNode etn = null;
        TreeNode nextSibling = null;
        boolean isSiblingNode = false;
        int index = -1;
        ProcessReturn pr = null;
        while (!stacks.getStack().isEmpty() && !this.testStopBuild(edge, getToSlice, childrenCompleteNode)) {
            index = stacks.getStack().size() - 1;
            t = stacks.getStack().get(index);
            lastNode = stacks.getLastNodeStack().get(index);
            myParent = stacks.getParentStack().get(index);
            isSiblingNode = stacks.getIsSiblingNodeStack().get(index);
            stacks.getStack().remove(index);
            stacks.getLastNodeStack().remove(index);
            stacks.getParentStack().remove(index);
            stacks.getIsSiblingNodeStack().remove(index);
            pr = this.process(t, lastNode, myParent, alwaysAdd);
            etn = pr.m_node;
            if (t != null && pr.m_continue) {
                nextSibling = t.getNextSibling();
                stacks.getStack().add(nextSibling);
                stacks.getLastNodeStack().add(null);
                stacks.getParentStack().add(myParent);
                stacks.getIsSiblingNodeStack().add(true);
            }
            if (t == null || !pr.m_continue) continue;
            stacks.getStack().add(t.getFirstChild());
            stacks.getLastNodeStack().add(t);
            stacks.getParentStack().add(etn);
            stacks.getIsSiblingNodeStack().add(false);
        }
    }

    private ProcessReturn process(TreeNode node, TreeNode lastNode, EdgeTreeNode myParent, boolean[] alwaysAdd) throws TransformException {
        if (node == null) {
            if (this.m_caching && lastNode != null) {
                QDR currQDR = new QDR();
                TreeNode currNode = lastNode;
                while (currNode != null) {
                    if (currNode.getLayer() != null && currNode.getMember() != null && currNode.getLayer().getValue() != null && currNode.getMember().getValue() != null) {
                        currQDR.addDimMemberPair(currNode.getLayer().getValue(), currNode.getMember().getValue());
                    }
                    currNode = currNode.getParent();
                }
                this.m_realQDRs.add(currQDR);
            }
            return new ProcessReturn(null, true);
        }
        TreeBasedEdgeTree et = this.getEdgeTree(node, (long)-1, false);
        if (myParent != null && et.getEdge() != myParent.getEdge()) {
            myParent = null;
        }
        myParent = myParent == null ? et.getRoot() : myParent;
        boolean storeTree = false;
        int edge = et.getEdge();
        int lastNodeEdge = lastNode != null ? this.getEdgeForLayer(lastNode) : edge;
        EdgeTreeNode newTreeNode = null;
        boolean repeats = this.repeats(edge, lastNodeEdge);
        boolean isFirstEdgeBreak = this.isFirstEdgeBreak(edge);
        if (repeats) {
            EdgeTreeNode repeatSubtree;
            if (isFirstEdgeBreak) {
                this.m_firstEdgeBreak.put(edge, false);
            }
            EdgeTreeNode edgeTreeNode = repeatSubtree = this.m_repeatSubtrees != null ? this.m_repeatSubtrees.get(edge) : null;
            if (repeatSubtree == null) {
                storeTree = true;
                newTreeNode = et.addNode(node, myParent, null, TransformUtils.alwaysAdd(alwaysAdd, edge));
                this._storeTree(storeTree, edge, myParent);
            } else {
                newTreeNode = repeatSubtree;
            }
        } else {
            newTreeNode = et.addNode(node, myParent, null, TransformUtils.alwaysAdd(alwaysAdd, edge));
        }
        return new ProcessReturn(newTreeNode, isFirstEdgeBreak ? true : repeats ^ true);
    }

    private boolean isFirstEdgeBreak(int edge) {
        Boolean isFirst = this.m_firstEdgeBreak.get(edge);
        if (isFirst instanceof Boolean) {
            return isFirst;
        }
        return true;
    }

    private void _storeTree(boolean storeTree, int edge, EdgeTreeNode treeNode) {
        if (storeTree) {
            if (this.m_repeatSubtrees == null) {
                this.m_repeatSubtrees = new Hashtable();
            }
            this.m_repeatSubtrees.put(edge, treeNode);
        }
    }

    private boolean repeats(int edge, int lastNodeEdge) {
        BaseProjection proj = this.getProjection();
        if (lastNodeEdge == -1) {
            return false;
        }
        if (proj instanceof TreeProjection) {
            return edge != lastNodeEdge && ((TreeProjection)proj).repeats(edge);
        }
        return false;
    }

    private boolean notAtSlice(EdgeTreeNode node, int edge, long slice) throws TransformException {
        if (edge == -1 || slice == (long)-1) {
            return false;
        }
        try {
            EdgeTree et = this.getEdgeTree(edge, (long)-1, true);
            if (et != null) {
                boolean bl = et.hasSlice(node, slice);
                return bl;
            }
        }
        catch (EdgeOutOfRangeException e) {
            throw new TransformException(e.getMessage(), e);
        }
        return false;
    }

    protected abstract TreeBasedEdgeTree getEdgeTree(TreeNode var1, long var2, boolean var4) throws TransformException;

    public synchronized int getLayerCount(int edge) throws EdgeOutOfRangeException {
        try {
            EdgeTree et = this.getEdgeTree(edge, (long)-1, true);
            if (et != null) {
                int n = et.getLayerCount();
                return n;
            }
        }
        catch (TransformException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
        return 0;
    }

    public synchronized int getEdgeCount() {
        int count = this.getEdgeTreeCount();
        return count > 3 ? count : 3;
    }

    protected LayerInterface getLayerInfo(int edge, int layer) throws EdgeOutOfRangeException, LayerOutOfRangeException {
        try {
            TreeBasedEdgeTree et = (TreeBasedEdgeTree)this.getEdgeTree(edge, (long)-1, true);
            if (et != null) {
                LayerInterface layerInterface = et.getLayerInfo(layer);
                return layerInterface;
            }
        }
        catch (TransformException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
        catch (SliceOutOfRangeException ex) {
            throw new TransformRuntimeException(ex.getMessage(), ex);
        }
        return null;
    }

    protected abstract class ImpliedMeasureCommonTreeProjection
    implements CommonTreeProjection {
        protected CommonTreeProjection m_proj;
        protected ImpliedMeasureTreeNode m_node;
        protected String[][] m_layout;
        protected int m_impliedMeasureEdge;

        private void $init$() {
            this.m_proj = null;
            this.m_node = null;
            this.m_layout = null;
            this.m_impliedMeasureEdge = -1;
        }

        public ImpliedMeasureCommonTreeProjection(CommonTreeProjection proj) {
            this.$init$();
            this.m_proj = proj;
        }

        protected int getLastLayerEdge(String[][] layout, LayerInterface layerInt) throws TransformException {
            if (layerInt == null) {
                return -1;
            }
            int e = 0;
            while (e < layout.length) {
                if (layout[e] != null && layout[e][layout[e].length - 1].equals(layerInt.getValue())) {
                    return e;
                }
                ++e;
            }
            return -1;
        }

        protected int walkTree(String[][] layout, TreeNode currNode) throws TransformException {
            if (currNode == null) {
                return -1;
            }
            int retLayerEdge = this.getLastLayerEdge(layout, currNode.getLayer());
            if (retLayerEdge > -1 && currNode.getFirstChild() == null) {
                return retLayerEdge;
            }
            retLayerEdge = this.walkTree(layout, currNode.getFirstChild());
            if (retLayerEdge == -1) {
                retLayerEdge = this.walkTree(layout, currNode.getNextSibling());
            }
            return retLayerEdge;
        }

        protected int getLength(String[][] str, int e) {
            if (str.length <= e || str[e] == null) {
                return 0;
            }
            return str[e].length;
        }

        protected abstract int findBottom() throws TransformException;

        protected abstract int getNewLength(String[][] var1);

        public String[][] getLayout() {
            if (this.m_layout == null) {
                try {
                    int bottomLayerEdge = this.findBottom();
                    String[][] origLayout = this.m_proj.getLayout();
                    if (bottomLayerEdge == -1) {
                        this.m_layout = origLayout;
                    } else {
                        String[][] newLayout = new String[this.getNewLength(origLayout)][];
                        int e = 0;
                        while (e < newLayout.length) {
                            if (e == bottomLayerEdge) {
                                newLayout[e] = new String[this.getLength(origLayout, e) + 1];
                                newLayout[e][newLayout[e].length - 1] = this.m_proj.getDataLayer().getValue();
                                this.m_impliedMeasureEdge = e;
                            } else {
                                newLayout[e] = new String[this.getLength(origLayout, e)];
                            }
                            int l = 0;
                            while (l < this.getLength(origLayout, e)) {
                                newLayout[e][l] = origLayout[e][l];
                                ++l;
                            }
                            ++e;
                        }
                        this.m_layout = newLayout;
                    }
                }
                catch (TransformException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            return this.m_layout;
        }

        public LayerInterface getDataLayer() {
            return this.m_proj.getDataLayer();
        }

        public MemberInterface[] getDataItems() {
            return this.m_proj.getDataItems();
        }

        public DataCellInterface getData(QDRInterface qdr) {
            return this.m_proj.getData(qdr);
        }
    }

    protected class ImpliedMeasureTreeNode
    implements TreeNode {
        protected TreeNode m_node;
        protected TreeNode m_child;
        protected ImpliedMeasureTreeNode m_sibling;
        protected ImpliedMeasureTreeNode m_parent;
        protected ImpliedMeasureCommonTreeProjection m_proj;

        private void $init$() {
            this.m_node = null;
            this.m_child = null;
            this.m_sibling = null;
            this.m_parent = null;
            this.m_proj = null;
        }

        public ImpliedMeasureTreeNode(TreeNode node, ImpliedMeasureCommonTreeProjection proj) {
            this.$init$();
            this.m_node = node;
            this.m_proj = proj;
        }

        public MemberInterface getMember() {
            return this.m_node.getMember();
        }

        public LayerInterface getLayer() {
            return this.m_node.getLayer();
        }

        private TreeNode getMeasureChildren(TreeNode parent) {
            MemberInterface[] dataItems = this.m_proj.getDataItems();
            TreeNodeImpl retNode = null;
            TreeNodeImpl lastNode = null;
            TreeNodeImpl currNode = null;
            int i = 0;
            while (i < dataItems.length) {
                currNode = new TreeNodeImpl(dataItems[i], this.m_proj.getDataLayer(), parent);
                if (lastNode == null) {
                    retNode = currNode;
                } else {
                    lastNode.setSibling(currNode);
                }
                lastNode = currNode;
                ++i;
            }
            return retNode;
        }

        public TreeNode getFirstChild() {
            if (this.m_child == null) {
                this.m_child = this.m_node.getFirstChild() == null ? this.getMeasureChildren(this.m_node) : new ImpliedMeasureTreeNode(this.m_node.getFirstChild(), this.m_proj);
            }
            return this.m_child;
        }

        public TreeNode getNextSibling() {
            if (this.m_sibling == null && this.m_node.getNextSibling() != null) {
                this.m_sibling = new ImpliedMeasureTreeNode(this.m_node.getNextSibling(), this.m_proj);
            }
            return this.m_sibling;
        }

        public TreeNode getParent() {
            if (this.m_parent == null && this.m_node.getParent() != null) {
                this.m_parent = new ImpliedMeasureTreeNode(this.m_node.getParent(), this.m_proj);
            }
            return this.m_parent;
        }
    }

    protected class TreeNodeImpl
    implements TreeNode {
        protected MemberInterface m_memberInt;
        protected LayerInterface m_layerInt;
        protected TreeNode m_sibling;
        protected TreeNode m_parent;

        private void $init$() {
            this.m_memberInt = null;
            this.m_layerInt = null;
            this.m_sibling = null;
            this.m_parent = null;
        }

        public TreeNodeImpl(MemberInterface memberInt, LayerInterface layerInt, TreeNode parent) {
            this.$init$();
            this.m_memberInt = memberInt;
            this.m_layerInt = layerInt;
            this.m_parent = parent;
        }

        public void setSibling(TreeNode sibling) {
            this.m_sibling = sibling;
        }

        public MemberInterface getMember() {
            return this.m_memberInt;
        }

        public LayerInterface getLayer() {
            return this.m_layerInt;
        }

        public TreeNode getFirstChild() {
            return null;
        }

        public TreeNode getNextSibling() {
            return this.m_sibling;
        }

        public TreeNode getParent() {
            return this.m_parent;
        }
    }

    private class ProcessReturn {
        public EdgeTreeNode m_node;
        public boolean m_continue;

        private void $init$() {
            this.m_node = null;
            this.m_continue = true;
        }

        public ProcessReturn(EdgeTreeNode node, boolean cont) {
            this.$init$();
            this.m_node = node;
            this.m_continue = cont;
        }
    }
}

