/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.transform;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import oracle.dss.util.QDR;
import oracle.dss.util.QDRInterface;
import oracle.dss.util.transform.DataCellInterface;
import oracle.dss.util.transform.DataTable;
import oracle.dss.util.transform.EdgeTree;
import oracle.dss.util.transform.EdgeTreeNode;
import oracle.dss.util.transform.InsertInfo;
import oracle.dss.util.transform.MemberCacheKey;
import oracle.dss.util.transform.MemberCacheKeyPool;
import oracle.dss.util.transform.MemberWrapper;
import oracle.dss.util.transform.ResultTableInsert;
import oracle.dss.util.transform.Row;
import oracle.dss.util.transform.SliceInsertInfo;
import oracle.dss.util.transform.TransformException;
import oracle.dss.util.transform.TransformRuntimeException;
import oracle.dss.util.transform.TransformUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cube
extends ArrayList<EdgeTree>
implements Cloneable {
    protected static final TransformUtils.NullMarker m_nullMarker = new TransformUtils.NullMarker();
    private Hashtable<Integer, Boolean> m_isOutline;
    private boolean m_outlineChecked;

    private void $init$() {
        this.m_isOutline = new Hashtable();
        this.m_outlineChecked = false;
    }

    public Cube() {
        this.$init$();
    }

    public Object clone(boolean caching) {
        Cube cube = (Cube)super.clone();
        cube.clear();
        Iterator iter = super.iterator();
        while (iter.hasNext()) {
            EdgeTree et = (EdgeTree)iter.next();
            if (et != null) {
                try {
                    cube.add((EdgeTree)et.clone(caching));
                    continue;
                }
                catch (CloneNotSupportedException e) {
                    throw new TransformRuntimeException(e.getMessage(), e);
                }
            }
            cube.add(null);
        }
        cube.m_isOutline = (Hashtable)this.m_isOutline.clone();
        return cube;
    }

    public void release() {
        this.m_isOutline.clear();
        this.m_isOutline = null;
        for (EdgeTree tree : this) {
            if (tree == null) continue;
            tree.release();
        }
        this.clear();
    }

    protected boolean isOutline(int edge) {
        if (this.m_outlineChecked) {
            return this.m_isOutline.get(edge);
        }
        this.m_isOutline = new Hashtable();
        boolean anyOutline = false;
        for (EdgeTree tree : this) {
            if (tree == null) continue;
            boolean outline = tree.isOutline();
            if (outline) {
                anyOutline = true;
            }
            this.m_isOutline.put(tree.getEdge(), outline);
        }
        this.m_outlineChecked = true;
        this.m_isOutline.put(-1, anyOutline);
        return this.m_isOutline.get(edge);
    }

    public EdgeTree getEdgeTree(int edge) {
        if (edge < this.getEdgeCount()) {
            return (EdgeTree)this.get(edge);
        }
        return null;
    }

    public int getEdgeCount() {
        return super.size();
    }

    public void setEdgeTree(int edge, EdgeTree et) {
        int currEdgeCount = this.getEdgeCount();
        if (edge < currEdgeCount) {
            this.set(edge, et);
        } else {
            int i = currEdgeCount;
            while (i < edge) {
                this.add(null);
                ++i;
            }
            this.add(et);
        }
    }

    public EdgeTree getColumnEdgeTree() {
        return this.getEdgeTree(0);
    }

    public EdgeTree getRowEdgeTree() {
        return this.getEdgeTree(1);
    }

    public void lockTrees() {
        int count = this.getEdgeCount();
        EdgeTree et = null;
        int i = 0;
        while (i < count) {
            et = (EdgeTree)super.get(i);
            if (et != null) {
                et.lock();
            }
            ++i;
        }
    }

    public void invalidate(QDRInterface[] qdr) throws TransformException {
        EdgeTree et = null;
        int edgeCount = this.getEdgeCount();
        int i = 0;
        while (i < qdr.length) {
            int e = 0;
            while (e < edgeCount) {
                et = this.getEdgeTree(e);
                if (et != null) {
                    et.invalidate(qdr[i]);
                }
                ++e;
            }
            ++i;
        }
    }

    public boolean insert(SliceInsertInfo sliceToInsert) throws TransformException {
        EdgeTree et = null;
        int edgeCount = this.getEdgeCount();
        boolean inserted = false;
        int e = 0;
        while (e < edgeCount) {
            et = this.getEdgeTree(e);
            if (et != null && et.insert(sliceToInsert)) {
                inserted = true;
            }
            ++e;
        }
        return inserted;
    }

    public void delete(QDRInterface[] qdr) throws TransformException {
        EdgeTree et = null;
        int edgeCount = this.getEdgeCount();
        int i = 0;
        while (i < qdr.length) {
            int e = 0;
            while (e < edgeCount) {
                et = this.getEdgeTree(e);
                if (et != null) {
                    et.delete(qdr[i]);
                }
                ++e;
            }
            ++i;
        }
    }

    protected void walkData(ResultTableInsert rti, String[] measList, MemberCacheKeyPool memberKeyPool, Hashtable<MemberCacheKey, Object> dataCache, boolean caching, boolean[] alwaysAdd) throws TransformException {
        EdgeTree.RowInfo[] column = null;
        EdgeTree.RowInfo[] row = null;
        DataTable dt = rti.getResultTable().getDataTable();
        String[][] layout = rti.getResultTable().getProjection().getLayout();
        long rowCount = dt.getRowCount();
        Row rowData = null;
        MemberWrapper[][][] pageVals = null;
        InsertInfo[] edgeInserts = rti.getEdgeInserts(true);
        InsertInfo colInsert = this.getColumnEdgeTree() != null ? InsertInfo.getEdgeInsert(edgeInserts, 0) : null;
        InsertInfo rowInsert = this.getRowEdgeTree() != null ? InsertInfo.getEdgeInsert(edgeInserts, 1) : null;
        QDR[] qdrs = null;
        int r = 0;
        while ((long)r < rowCount) {
            rowData = dt.getRow(r);
            if (this.getColumnEdgeTree() != null && layout.length > 0) {
                column = this.getColumnEdgeTree().addRow(rowData, layout[0], colInsert, TransformUtils.alwaysAdd(alwaysAdd, 0));
            }
            if (this.getRowEdgeTree() != null && layout.length > 1) {
                row = this.getRowEdgeTree().addRow(rowData, layout[1], rowInsert, TransformUtils.alwaysAdd(alwaysAdd, 1));
            }
            pageVals = this.addPageRows(rowData, layout, edgeInserts, alwaysAdd);
            if (caching && (qdrs = this._getQDRs(rti.getResultTable().getProjection().getLayout(), pageVals, column, row)) != null && this.getRealQDRs() != null) {
                int i = 0;
                while (i < qdrs.length) {
                    this.getRealQDRs().add(qdrs[i]);
                    ++i;
                }
            }
            if (rti.getResultTable().isLocalStorage() || rowData.isCalculatedValue()) {
                MemberCacheKey cacheKey = null;
                DataCellInterface value = null;
                if (measList != null) {
                    int m = 0;
                    while (m < measList.length) {
                        cacheKey = row != null && row[0].hasMeasure() ? memberKeyPool.getCacheKeyFromPool(this.getNthMeasureTuple(pageVals, 0), row[m].getValues(), column != null ? column[0].getValues() : null) : (column != null && column[0].hasMeasure() ? memberKeyPool.getCacheKeyFromPool(this.getNthMeasureTuple(pageVals, 0), row != null ? row[0].getValues() : null, column != null ? column[m].getValues() : null) : memberKeyPool.getCacheKeyFromPool(this.getNthMeasureTuple(pageVals, m), row != null ? row[0].getValues() : null, column != null ? column[0].getValues() : null));
                        value = rowData.getCell(measList[m]).getDataCellInterface();
                        this.storeData(value, cacheKey, dataCache);
                        memberKeyPool.returnCacheKeyToPool(cacheKey);
                        ++m;
                    }
                }
            }
            ++r;
        }
    }

    public ArrayList<QDRInterface> getRealQDRs() {
        return null;
    }

    private QDR[] _getQDRs(String[][] layout, MemberWrapper[][][] pageVals, EdgeTree.RowInfo[] column, EdgeTree.RowInfo[] row) throws TransformException {
        if (row != null && row.length > 0 && row[0].hasMeasure()) {
            QDR[] qdrs = new QDR[row.length];
            int m = 0;
            while (m < row.length) {
                qdrs[m] = this._getQDR(layout, this.getNthMeasureTuple(pageVals, 0), row[m].getValues(), column != null ? column[0].getValues() : null);
                ++m;
            }
            return qdrs;
        }
        if (column != null && column[0].hasMeasure()) {
            QDR[] qdrs = new QDR[column.length];
            int m = 0;
            while (m < column.length) {
                qdrs[m] = this._getQDR(layout, this.getNthMeasureTuple(pageVals, 0), row != null ? row[0].getValues() : null, column != null ? column[m].getValues() : null);
                ++m;
            }
            return qdrs;
        }
        QDR[] qdrs = new QDR[pageVals != null && pageVals.length > 0 && pageVals[0] != null ? pageVals[0].length : 0];
        int m = 0;
        while (m < qdrs.length) {
            qdrs[m] = this._getQDR(layout, this.getNthMeasureTuple(pageVals, m), row != null ? row[0].getValues() : null, column != null ? column[0].getValues() : null);
            ++m;
        }
        return qdrs;
    }

    private MemberWrapper[][] getNthMeasureTuple(MemberWrapper[][][] pageVals, int m) {
        if (pageVals == null) {
            return null;
        }
        MemberWrapper[][] retVal = new MemberWrapper[pageVals.length][];
        int e = 0;
        while (e < retVal.length) {
            retVal[e] = pageVals[e] != null && pageVals[e].length > m ? pageVals[e][m] : new MemberWrapper[0];
            ++e;
        }
        return retVal;
    }

    private QDR _getQDR(String[][] layout, MemberWrapper[][] pages, MemberWrapper[] row, MemberWrapper[] col) throws TransformException {
        QDR qdr = new QDR();
        if (pages != null) {
            int e = 2;
            while (e < pages.length + 2) {
                if (pages[e - 2] != null) {
                    int l = 0;
                    while (l < pages[e - 2].length) {
                        qdr.addDimMemberPair(layout[e - 2][l], pages[e - 2][l].getValue());
                        ++l;
                    }
                }
                ++e;
            }
        }
        if (row != null) {
            int l = 0;
            while (l < row.length) {
                qdr.addDimMemberPair(layout[1][l], row[l].getValue());
                ++l;
            }
        }
        if (col != null) {
            int l = 0;
            while (l < col.length) {
                qdr.addDimMemberPair(layout[0][l], col[l].getValue());
                ++l;
            }
        }
        return qdr;
    }

    protected MemberWrapper[][][] addPageRows(Row rowData, String[][] layout, InsertInfo[] edgeInserts, boolean[] alwaysAdd) throws TransformException {
        int edgeCountBeyondRow = this.getEdgeCount() < 2 ? 0 : this.getEdgeCount() - 2;
        MemberWrapper[][][] retVal = new MemberWrapper[edgeCountBeyondRow][][];
        if (edgeCountBeyondRow == 0) {
            return null;
        }
        int i = 0;
        while (i < retVal.length) {
            EdgeTree.RowInfo[] ri;
            if (layout.length > 1 + i + 1 && (ri = this.getEdgeTree(i + 1 + 1).addRow(rowData, layout[1 + i + 1], InsertInfo.getEdgeInsert(edgeInserts, 2 + i), TransformUtils.alwaysAdd(alwaysAdd, 1 + i + 1))) != null) {
                retVal[i] = new MemberWrapper[ri.length][];
                int m = 0;
                while (m < ri.length) {
                    retVal[i][m] = ri[m].getValues();
                    ++m;
                }
            }
            ++i;
        }
        return retVal;
    }

    protected void storeData(DataCellInterface data, MemberCacheKey cacheKey, Hashtable<MemberCacheKey, Object> memberCache) {
        if (data == null) {
            memberCache.put((MemberCacheKey)cacheKey.clone(), m_nullMarker);
        } else {
            memberCache.put((MemberCacheKey)cacheKey.clone(), data);
        }
    }

    private EdgeTreeNode _convertMemberToNode(MemberWrapper[] members) {
        EdgeTreeNode[] nodes = this._convertMemberToNode(new MemberWrapper[][]{members});
        if (nodes == null) {
            return null;
        }
        if (nodes.length == 0) {
            return null;
        }
        return nodes[0];
    }

    private EdgeTreeNode[] _convertMemberToNode(MemberWrapper[][] members) {
        if (members == null) {
            return null;
        }
        EdgeTreeNode[] retVal = new EdgeTreeNode[members.length];
        MemberWrapper[] edgeList = null;
        MemberWrapper member = null;
        int i = 0;
        while (i < retVal.length) {
            edgeList = members[i];
            if (edgeList != null && members[i].length > 0) {
                member = members[i][members[i].length - 1];
                retVal[i] = member != null ? member.getEdgeTreeNode() : null;
            }
            ++i;
        }
        return retVal;
    }

    protected void unlockPageTree(InsertInfo[] edgeInserts) {
    }

    protected String getColumn(InsertInfo[] edgeInserts, int edge) {
        InsertInfo info = InsertInfo.getEdgeInsert(edgeInserts, edge);
        if (info != null) {
            return info.getColumn();
        }
        return null;
    }
}

