/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.transform;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dss.util.ColumnOutOfRangeException;
import oracle.dss.util.DataException;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.QDR;
import oracle.dss.util.QDRInterface;
import oracle.dss.util.QDRMember;
import oracle.dss.util.RowOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.dss.util.transform.BaseProjection;
import oracle.dss.util.transform.CommonComparator;
import oracle.dss.util.transform.ComparatorInterface;
import oracle.dss.util.transform.Cube;
import oracle.dss.util.transform.DataAccessLong;
import oracle.dss.util.transform.DataCellInterface;
import oracle.dss.util.transform.EdgeTree;
import oracle.dss.util.transform.EdgeTreeChildren;
import oracle.dss.util.transform.EdgeTreeNode;
import oracle.dss.util.transform.LayerAndMember;
import oracle.dss.util.transform.LayerInterface;
import oracle.dss.util.transform.LayerMetadataCacheKey;
import oracle.dss.util.transform.LayerMetadataCacheKeyPool;
import oracle.dss.util.transform.MemberCacheKey;
import oracle.dss.util.transform.MemberCacheKeyPool;
import oracle.dss.util.transform.MemberInterface;
import oracle.dss.util.transform.MemberMetadataCacheKey;
import oracle.dss.util.transform.MemberMetadataCacheKeyPool;
import oracle.dss.util.transform.MemberWrapper;
import oracle.dss.util.transform.QDRCacheKey;
import oracle.dss.util.transform.ResultTable;
import oracle.dss.util.transform.ResultTableInsert;
import oracle.dss.util.transform.RowIterator;
import oracle.dss.util.transform.RowProjection;
import oracle.dss.util.transform.TabularDataAccess;
import oracle.dss.util.transform.TransformException;
import oracle.dss.util.transform.TransformRuntimeException;
import oracle.dss.util.transform.TransformUtils;
import oracle.dss.util.transform.TreeNodeWrapperMemberInterface;
import oracle.dss.util.transform.hPosDataCacheKey;
import oracle.dss.util.transform.hPosDataCacheKeyPool;
import oracle.dss.util.transform.hPosMetadataCacheKey;
import oracle.dss.util.transform.hPosMetadataCacheKeyPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CubicDataAccess
extends TabularDataAccess
implements DataAccessLong {
    protected hPosDataCacheKeyPool m_keyPool;
    protected MemberCacheKeyPool m_memberKeyPool;
    protected MemberMetadataCacheKeyPool m_metadataKeyPool;
    protected hPosMetadataCacheKeyPool m_hPosMetadataKeyPool;
    protected LayerMetadataCacheKeyPool m_layerMetadataKeyPool;
    protected boolean m_qdrCaching;
    protected boolean[] m_alwaysAdd;

    private void $init$() {
        this.m_keyPool = null;
        this.m_memberKeyPool = null;
        this.m_metadataKeyPool = null;
        this.m_hPosMetadataKeyPool = null;
        this.m_layerMetadataKeyPool = null;
        this.m_qdrCaching = true;
        this.m_alwaysAdd = null;
    }

    protected CubicDataAccess() throws TransformException {
        this(null, false);
    }

    public CubicDataAccess(ResultTable rt, boolean cache) throws TransformException {
        super(null, cache);
        this.$init$();
        this.init(rt);
    }

    @Override
    protected void initCaches() {
        super.initCaches();
        this.m_keyPool = new hPosDataCacheKeyPool(10);
        this.m_memberKeyPool = new MemberCacheKeyPool(10);
        this.m_metadataKeyPool = new MemberMetadataCacheKeyPool(10);
        this.m_hPosMetadataKeyPool = new hPosMetadataCacheKeyPool(10);
        this.m_layerMetadataKeyPool = new LayerMetadataCacheKeyPool(10);
    }

    @Override
    public synchronized void release() {
        this.m_memberKeyPool = null;
        this.m_keyPool = null;
        this.m_metadataKeyPool = null;
        this.m_hPosMetadataKeyPool = null;
        this.m_layerMetadataKeyPool = null;
        super.release();
    }

    protected String[] getMeasList(BaseProjection proj) throws TransformException {
        MemberInterface[] dataItems = proj.getDataItems();
        String[] measList = null;
        if (dataItems != null) {
            measList = new String[dataItems.length];
            int i = 0;
            while (i < dataItems.length) {
                measList[i] = dataItems[i].getValue();
                ++i;
            }
        }
        return measList;
    }

    public boolean sort(int edge, int slice, int sortDirection, boolean nullsFirst, boolean group) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        if (edge > 1) {
            return false;
        }
        int edgeExtent = this.getEdgeExtent(edge);
        if (group) {
            this.initCaches();
            try {
                EdgeTree et = this.getEdgeTree(edge, 0L, true);
                if (et == null) {
                    boolean bl = false;
                    return bl;
                }
                int layer = et.getLayerCount() - 2;
                long currSlice = 0L;
                EdgeTreeNode node = layer == -1 ? et.getRoot() : et.getNode(layer, currSlice, EdgeTreeNode.GetSlice.GET_ALL_SLICES);
                EdgeTreeChildren children = null;
                while (node != null && currSlice < (long)edgeExtent) {
                    children = node.getModifiableChildren();
                    if (children != null) {
                        children.sort(sortDirection, nullsFirst, this, edge, slice);
                        node.clearSpan();
                        node.clearStart();
                    }
                    currSlice += node.getSpan();
                    node = layer > -1 && currSlice < (long)edgeExtent ? et.getNode(layer, currSlice, EdgeTreeNode.GetSlice.GET_ALL_SLICES) : null;
                }
            }
            catch (TransformException e) {
                throw new TransformRuntimeException(e.getMessage(), e);
            }
        }
        SortTuple[] newRows = new SortTuple[edgeExtent];
        long s = 0L;
        while (s < (long)edgeExtent) {
            newRows[(int)s] = this._getSortTuple(edge, s, slice);
            ++s;
        }
        if (newRows.length > 0) {
            Arrays.sort(newRows, new CommonComparator(sortDirection, nullsFirst));
        }
        this.initCaches();
        try {
            boolean[] alwaysAdd = new boolean[2];
            alwaysAdd[edge] = true;
            MyRowProjection proj = new MyRowProjection(this.getProjection(), newRows, edge);
            ResultTable rt = new ResultTable(proj, this.m_rt != null ? this.m_rt.getAggSpec() : null, true);
            EdgeTree et = this.getEdgeTree(edge, 0L, true);
            if (et != null) {
                et.clearNodes();
            }
            this.m_cube.walkData(new ResultTableInsert(rt, null), this.getMeasList(this.getProjection()), this.m_memberKeyPool, this.m_memberCache, this.m_caching, alwaysAdd);
        }
        catch (TransformException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
        return true;
    }

    private SortTuple _getSortTuple(int edge, long row, long slice) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        try {
            Object dataVal = edge == 0 ? this.getValue(slice, row, "dataValue") : this.getValue(row, slice, "dataValue");
            SortTuple sortTuple = new SortTuple(this._getMemberInterface(edge, row), dataVal);
            return sortTuple;
        }
        catch (ColumnOutOfRangeException e) {
            throw new SliceOutOfRangeException(e.getMessage(), e);
        }
        catch (RowOutOfRangeException e2) {
            throw new SliceOutOfRangeException(e2.getMessage(), e2);
        }
        catch (TransformException e3) {
            throw new TransformRuntimeException(e3.getMessage(), e3);
        }
    }

    private MemberInterface[] _getMemberInterface(int edge, long slice) throws EdgeOutOfRangeException, SliceOutOfRangeException, TransformException {
        EdgeTree et = this.getEdgeTree(edge, slice, true);
        if (et != null) {
            return et.getMembers(slice);
        }
        return null;
    }

    @Override
    protected EdgeTree getEdgeTree(int edge, long slice, boolean checked) throws EdgeOutOfRangeException, TransformException {
        if (checked && edge >= this.getEdgeCount()) {
            throw new EdgeOutOfRangeException(edge, this.getEdgeCount());
        }
        this.updateTree(edge, slice, null);
        return this.m_cube == null ? null : this.m_cube.getEdgeTree(edge);
    }

    private boolean hasData() {
        return this.m_dataItems != null && this.m_dataItems.size() > 0;
    }

    protected void updateTree(int edge, long slice, EdgeTreeNode currNode) throws TransformException {
    }

    private long getExtent(EdgeTree et) throws TransformException {
        if (et == null || et.getLayerCount() == 0 && this.hasData()) {
            return 1L;
        }
        return et.getExtent();
    }

    @Override
    public synchronized long getEdgeExtentLong(int edge) throws EdgeOutOfRangeException {
        if (this.m_cube == null) {
            return 0L;
        }
        try {
            EdgeTree et = null;
            switch (edge) {
                case 0: {
                    et = this.m_cube.getColumnEdgeTree();
                    long l = this.getExtent(et);
                    return l;
                }
                case 1: {
                    et = this.m_cube.getRowEdgeTree();
                    long l = this.getExtent(et);
                    return l;
                }
            }
            long l = super._getEdgeExtentLong(edge);
            return l;
        }
        catch (TransformException e) {
            throw new EdgeOutOfRangeException(e.getMessage(), e);
        }
    }

    @Override
    public synchronized long getAbsoluteFromContext(int edge, long[] hPos, int memberLayer) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        try {
            EdgeTree et = this.getEdgeTree(edge, -1, true);
            if (et != null) {
                boolean nullHPos = hPos == null || hPos.length == 0;
                EdgeTreeNode node = et.getNode(hPos, memberLayer, !nullHPos ? hPos[memberLayer] : 0L);
                long l = node != null ? node.getStart(EdgeTreeNode.GetSlice.GET_ALL_SLICES, -1) : 0L;
                return l;
            }
        }
        catch (TransformException e) {
            throw new SliceOutOfRangeException(e.getMessage(), e);
        }
        return 0L;
    }

    @Override
    public synchronized long getMemberSiblingCount(int edge, long[] hPos, int memberLayer) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        try {
            EdgeTree et = this.getEdgeTree(edge, -1, true);
            if (et != null) {
                boolean nullHPos = hPos == null || hPos.length == 0;
                EdgeTreeNode node = et.getNode(hPos, memberLayer, !nullHPos && memberLayer > 0 ? hPos[memberLayer - 1] : 0L);
                long l = node != null ? node.getParent().getChildCount() : 0L;
                return l;
            }
        }
        catch (TransformException e) {
            throw new SliceOutOfRangeException(e.getMessage(), e);
        }
        return 1L;
    }

    @Override
    public synchronized long[] getMemberHPos(int edge, int layer, long slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        try {
            EdgeTree et = this.getEdgeTree(edge, slice, true);
            if (et != null) {
                EdgeTreeNode node = et.getNode(layer, slice, EdgeTreeNode.GetSlice.GET_ALL_SLICES);
                long[] lArray = node.getHPos();
                return lArray;
            }
        }
        catch (TransformException e) {
            throw new SliceOutOfRangeException(e.getMessage(), e);
        }
        return null;
    }

    @Override
    public synchronized Object getMemberMetadata(int edge, long[] hPos, int memberLayer, long hIndex, String type) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (type.equals("extent")) {
            long slice = this.getAbsoluteFromContext(edge, hPos, memberLayer);
            return this.getMemberExtent(edge, memberLayer, (int)slice);
        }
        if (type.equals("startSlice")) {
            long slice = this.getAbsoluteFromContext(edge, hPos, memberLayer);
            return this.getMemberStartSlice(edge, memberLayer, (int)slice);
        }
        hPosMetadataCacheKey cacheKey = null;
        QDRCacheKey qdrCacheKey = null;
        MemberWrapper[][] pageSet = null;
        if (this.m_caching) {
            try {
                pageSet = this.wrapMembers(this.getPageSet());
                cacheKey = this.m_hPosMetadataKeyPool.getCacheKeyFromPool(pageSet, edge, hPos, memberLayer, hIndex, type);
                Object objResult = this.m_memberMetadataCache.get(cacheKey);
                if (objResult != null) {
                    this.m_hPosMetadataKeyPool.returnCacheKeyToPool(cacheKey);
                    Object var20_12 = objResult instanceof TransformUtils.NullMarker ? null : objResult;
                    return var20_12;
                }
                if (this.m_qdrCaching) {
                    this.m_qdrCaching = false;
                    QDR qdr = TransformUtils.getMemberQDRImpl(this.getLayout(), this.getDataLayer(), (DataAccessLong)this, edge, hPos, memberLayer, 1, false);
                    this.m_qdrCaching = true;
                    qdrCacheKey = this.m_qdrKeyPool.getCacheKeyFromPool(qdr);
                    objResult = this.m_qdrCache.get(qdrCacheKey, type);
                    if (objResult != null) {
                        this.m_qdrKeyPool.returnCacheKeyToPool(qdrCacheKey);
                        this.storeMetadata(objResult, cacheKey, null, null);
                        Object var21_14 = objResult instanceof TransformUtils.NullMarker ? null : objResult;
                        return var21_14;
                    }
                }
            }
            catch (TransformException e) {
                throw new TransformRuntimeException(e.getMessage(), e);
            }
        }
        try {
            EdgeTree et = this.getEdgeTree(edge, -1, true);
            if (et != null) {
                Object objResult = this.getMemberMetadata(et.getNode(hPos, memberLayer, hIndex), type);
                this.storeMetadata(objResult, cacheKey, qdrCacheKey, type);
                Object object = objResult;
                return object;
            }
        }
        catch (TransformException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
        return null;
    }

    @Override
    public synchronized Object getMemberMetadata(int edge, int layer, long slice, String type) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (type.equals("extent")) {
            return this.getMemberExtent(edge, layer, (int)slice);
        }
        if (type.equals("startSlice")) {
            return this.getMemberStartSlice(edge, layer, (int)slice);
        }
        MemberMetadataCacheKey cacheKey = null;
        QDRCacheKey qdrCacheKey = null;
        MemberWrapper[][] pageSet = null;
        if (this.m_caching) {
            try {
                pageSet = this.wrapMembers(this.getPageSet());
                cacheKey = this.m_metadataKeyPool.getCacheKeyFromPool(pageSet, edge, layer, slice, type);
                Object objResult = this.m_memberMetadataCache.get(cacheKey);
                if (objResult != null) {
                    this.m_metadataKeyPool.returnCacheKeyToPool(cacheKey);
                    Object var15_9 = objResult instanceof TransformUtils.NullMarker ? null : objResult;
                    return var15_9;
                }
                if (this.m_qdrCaching) {
                    this.m_qdrCaching = false;
                    QDR qdr = TransformUtils.getMemberQDRImpl(this.getLayout(), this.getDataLayer(), (DataAccessLong)this, edge, layer, slice, 1, false);
                    this.m_qdrCaching = true;
                    qdrCacheKey = this.m_qdrKeyPool.getCacheKeyFromPool(qdr);
                    objResult = this.m_qdrCache.get(qdrCacheKey, type);
                    if (objResult != null) {
                        this.m_qdrKeyPool.returnCacheKeyToPool(qdrCacheKey);
                        this.storeMetadata(objResult, cacheKey, null, null);
                        Object var16_11 = objResult instanceof TransformUtils.NullMarker ? null : objResult;
                        return var16_11;
                    }
                }
            }
            catch (TransformException e) {
                throw new TransformRuntimeException(e.getMessage(), e);
            }
        }
        try {
            EdgeTree et = this.getEdgeTree(edge, slice, true);
            if (et != null) {
                Object objResult = this.getMemberMetadata(et.getNode(layer, slice, EdgeTreeNode.GetSlice.GET_TO_SLICE), type);
                this.storeMetadata(objResult, cacheKey, qdrCacheKey, type);
                Object object = objResult;
                return object;
            }
        }
        catch (TransformException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
        return null;
    }

    @Override
    public synchronized long getEdgeCurrentSliceLong(int edge) throws EdgeOutOfRangeException {
        if (edge >= 2) {
            return 0L;
        }
        return 0L;
    }

    @Override
    public synchronized Object getValue(long row, long column, String type) throws RowOutOfRangeException, ColumnOutOfRangeException {
        try {
            hPosDataCacheKey cacheKey = null;
            MemberWrapper[][] pageSet = null;
            QDRCacheKey qdrCacheKey = null;
            if (this.m_caching) {
                pageSet = this.wrapMembers(this.getPageSet());
                cacheKey = this.m_keyPool.getCacheKeyFromPool(pageSet, row, column, type);
                Object objResult = this.m_dataCache.get(cacheKey);
                if (objResult != null) {
                    this.m_keyPool.returnCacheKeyToPool(cacheKey);
                    Object var13_8 = objResult instanceof TransformUtils.NullMarker ? null : objResult;
                    return var13_8;
                }
                if (this.m_qdrCaching) {
                    this.m_qdrCaching = false;
                    QDR qdr = TransformUtils.getValueQDRImpl(this.getLayout(), this.getDataLayer(), this, row, column, 1, false);
                    this.m_qdrCaching = true;
                    qdrCacheKey = this.m_qdrKeyPool.getCacheKeyFromPool(qdr);
                    DataCellInterface cellInt = (DataCellInterface)this.m_qdrDataCache.get(qdrCacheKey);
                    if (cellInt != null) {
                        this.m_qdrKeyPool.returnCacheKeyToPool(qdrCacheKey);
                        objResult = cellInt.getData(TransformUtils.convertDataMap(type));
                        this.storeData(objResult, cacheKey, null, null);
                        Object var14_11 = objResult instanceof TransformUtils.NullMarker ? null : objResult;
                        return var14_11;
                    }
                }
                if (this.m_clone) {
                    Object var15_12 = null;
                    return var15_12;
                }
            }
            Object object = this.getResultAndCache(cacheKey, row, column, type, qdrCacheKey, false, null);
            return object;
        }
        catch (Exception e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public synchronized void setMetadataValues(QDRInterface[] locations, String[] layer, Map<String, Object>[] metadata) {
        if (locations == null || locations.length == 0 || layer == null || layer.length != locations.length) {
            return;
        }
        try {
            MemberMetadataCacheKey cacheKey = null;
            QDRCacheKey qdrCacheKey = null;
            if (this.m_caching) {
                String type2 = null;
                Map<String, Object> val = null;
                Iterator<String> types = null;
                MemberWrapper[][] pageSet = null;
                int i = 0;
                while (i < locations.length) {
                    int[] edgeLayer;
                    if (metadata != null && metadata.length <= i) {
                        return;
                    }
                    int[] slices = this._getSlicesFromQDR(locations[i], null, null, false);
                    if (slices != null && (edgeLayer = TransformUtils.getLayerAndEdge(layer[i], this.getLayout())) != null && edgeLayer.length > 1) {
                        int edge = edgeLayer[0];
                        val = metadata[i];
                        for (String type2 : val.keySet()) {
                            pageSet = this.wrapMembers(this.getPageSet());
                            cacheKey = this.m_metadataKeyPool.getCacheKeyFromPool(pageSet, edge, edgeLayer[1], slices[edge], type2);
                            this.m_memberMetadataCache.remove(cacheKey);
                            if (this.m_qdrCaching) {
                                this.m_qdrCaching = false;
                                QDR qdr = TransformUtils.getMemberQDRImpl(this.getLayout(), this.getDataLayer(), (DataAccessLong)this, edge, edgeLayer[1], (long)slices[edge], 1, false);
                                this.m_qdrCaching = true;
                                qdrCacheKey = this.m_qdrKeyPool.getCacheKeyFromPool(qdr);
                                this.m_qdrCache.remove(qdrCacheKey, type2);
                                this.storeMetadata(val.get(type2), cacheKey, qdrCacheKey, type2);
                                this.m_qdrKeyPool.returnCacheKeyToPool(qdrCacheKey);
                            } else {
                                this.storeMetadata(val.get(type2), cacheKey, null, type2);
                            }
                            this.m_metadataKeyPool.returnCacheKeyToPool(cacheKey);
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public synchronized void setValues(QDRInterface[] locations, Map<String, Object>[] values) {
        if (locations == null || locations.length == 0) {
            return;
        }
        try {
            hPosDataCacheKey cacheKey = null;
            QDRCacheKey qdrCacheKey = null;
            if (this.m_caching) {
                String type2 = null;
                Map<String, Object> val = null;
                Iterator<String> types = null;
                int i = 0;
                while (i < locations.length) {
                    if (values != null && values.length <= i) {
                        return;
                    }
                    int[] slices = this._getSlicesFromQDR(locations[i], null, null, true);
                    if (slices != null) {
                        val = values[i];
                        for (String type2 : val.keySet()) {
                            cacheKey = this.m_keyPool.getCacheKeyFromPool(this.wrapMembers(this.getPageSet()), slices.length > 1 ? (slices[1] == -1 ? 0 : slices[1]) : -1, slices.length > 0 ? (slices[0] == -1 ? 0 : slices[0]) : -1, type2);
                            Object value = val.get(type2);
                            this.m_dataCache.remove(cacheKey);
                            qdrCacheKey = this.m_qdrKeyPool.getCacheKeyFromPool(locations[i]);
                            this.storeData(value, cacheKey, qdrCacheKey, type2);
                        }
                    }
                    if (!this.m_realQDRs.contains(locations[i])) {
                        this.m_realQDRs.add((QDRInterface)locations[i].clone());
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public synchronized void invalidate(QDRInterface[] qdr) {
        if (qdr == null || qdr.length == 0) {
            return;
        }
        super.invalidate(qdr);
    }

    protected Object processResult(Object objResult, String type, hPosDataCacheKey cacheKey, MemberCacheKey memberKey, QDRCacheKey qdrCacheKey, boolean storeInMemberCache) {
        DataCellInterface cell = null;
        if (objResult instanceof TransformUtils.NullMarker || objResult == null) {
            cell = null;
            objResult = null;
        } else {
            cell = (DataCellInterface)objResult;
            try {
                objResult = cell.getData(TransformUtils.convertDataMap(type));
            }
            catch (TransformException e) {
                throw new TransformRuntimeException(e.getMessage(), e);
            }
        }
        this.storeData(objResult, cacheKey, qdrCacheKey, type);
        if (storeInMemberCache && (this.isLocalStorage() || memberKey != null && memberKey.isCalculatedValue())) {
            this.m_cube.storeData(cell, memberKey, this.m_memberCache);
        }
        return objResult;
    }

    protected MemberWrapper[][] wrapMembers(LayerAndMember[] pageSet) throws TransformException {
        MemberWrapper[][] wrappedPage = null;
        if (pageSet != null) {
            wrappedPage = new MemberWrapper[pageSet.length][];
            int i = 0;
            while (i < wrappedPage.length) {
                if (pageSet[i] != null) {
                    wrappedPage[i] = this._wrapMembers(pageSet[i].m_members);
                }
                ++i;
            }
        }
        return wrappedPage;
    }

    protected Object getResultAndCache(hPosDataCacheKey cacheKey, long row, long column, String type, QDRCacheKey qdrCacheKey, boolean storeInMemberCache, Object newValue) throws EdgeOutOfRangeException, SliceOutOfRangeException, TransformException {
        DataCellInterface dci;
        LayerAndMember colMembers = this.getSliceMemberSet(0, column);
        LayerAndMember rowMembers = this.getSliceMemberSet(1, row);
        LayerAndMember[] pageSet = this.getPageSet();
        MemberWrapper[][] wrappedPage = this.wrapMembers(pageSet);
        MemberCacheKey memberKey = this.m_memberKeyPool.getCacheKeyFromPool(wrappedPage, this._wrapMembers(rowMembers != null ? rowMembers.m_members : null), this._wrapMembers(colMembers != null ? colMembers.m_members : null));
        Object objResult = this.m_memberCache.get(memberKey);
        QDR qdr = this.constructCellQDR(colMembers, rowMembers, pageSet);
        if (newValue != null && (dci = this.getProjection().getData(qdr)) != null) {
            dci.setData(newValue instanceof TransformUtils.NullMarker ? null : newValue, TransformUtils.convertDataMap(type));
        }
        if (!this.isLocalStorage() && objResult == null) {
            objResult = this.getProjection().getData(qdr);
        }
        objResult = this.processResult(objResult, type, cacheKey, memberKey, qdrCacheKey, storeInMemberCache);
        this.m_memberKeyPool.returnCacheKeyToPool(memberKey);
        this.m_keyPool.returnCacheKeyToPool(cacheKey);
        return objResult;
    }

    protected void addMembers(QDR qdr, LayerAndMember members) throws TransformException {
        if (members == null || members.m_members == null) {
            return;
        }
        int i = 0;
        while (i < members.m_members.length) {
            qdr.addDimMemberPair(members.m_layers[i], new QDRMember(0, members.m_members[i].getValue()));
            ++i;
        }
    }

    protected abstract QDR generateQDR() throws TransformException;

    private void _removeCollisions(LayerAndMember[] source, LayerAndMember[] rest) throws TransformException {
        if (source == null || rest == null) {
            return;
        }
        int s = 0;
        while (s < source.length) {
            if (source[s] != null) {
                int r = 0;
                while (r < rest.length) {
                    if (rest[r] != null) {
                        rest[r].removeCollisions(source[s]);
                    }
                    ++r;
                }
            }
            ++s;
        }
    }

    private void removeCollisions(LayerAndMember colMembers, LayerAndMember rowMembers, LayerAndMember[] pageSet) throws TransformException {
        LayerAndMember[] rest = new LayerAndMember[(rowMembers != null ? 1 : 0) + (pageSet != null ? pageSet.length : 0)];
        int pos = 0;
        if (rowMembers != null) {
            rest[pos++] = rowMembers;
        }
        if (pageSet != null) {
            int i = 0;
            while (i < pageSet.length) {
                rest[pos++] = pageSet[i];
                ++i;
            }
        }
        this._removeCollisions(new LayerAndMember[]{colMembers}, rest);
        rest = new LayerAndMember[(colMembers != null ? 1 : 0) + (pageSet != null ? pageSet.length : 0)];
        pos = 0;
        if (colMembers != null) {
            rest[pos++] = colMembers;
        }
        if (pageSet != null) {
            int i = 0;
            while (i < pageSet.length) {
                rest[pos++] = pageSet[i];
                ++i;
            }
        }
        this._removeCollisions(new LayerAndMember[]{rowMembers}, rest);
        rest = new LayerAndMember[(colMembers != null ? 1 : 0) + (rowMembers != null ? 1 : 0)];
        pos = 0;
        if (colMembers != null) {
            rest[pos++] = colMembers;
        }
        if (rowMembers != null) {
            rest[pos++] = rowMembers;
        }
        this._removeCollisions(pageSet, rest);
    }

    protected QDR constructCellQDR(LayerAndMember colMembers, LayerAndMember rowMembers, LayerAndMember[] pageSet) throws TransformException {
        if (this.isCollisions()) {
            this.removeCollisions(colMembers, rowMembers, pageSet);
        }
        QDR qdr = this.generateQDR();
        this.addMembers(qdr, colMembers);
        this.addMembers(qdr, rowMembers);
        if (pageSet != null) {
            int i = 0;
            while (i < pageSet.length) {
                if (pageSet[i] != null) {
                    this.addMembers(qdr, pageSet[i]);
                }
                ++i;
            }
        }
        return qdr;
    }

    protected void storeMetadata(Object metadata, hPosMetadataCacheKey cacheKey, QDRCacheKey qdrCacheKey, String type) {
        if (cacheKey == null) {
            return;
        }
        if (metadata == null) {
            this.m_hPosMetadataCache.put((hPosMetadataCacheKey)cacheKey.clone(), Cube.m_nullMarker);
        } else {
            this.m_hPosMetadataCache.put((hPosMetadataCacheKey)cacheKey.clone(), metadata);
        }
        this.m_hPosMetadataKeyPool.returnCacheKeyToPool(cacheKey);
        this._storeQDRCache(qdrCacheKey, type, metadata);
    }

    protected void storeLayerMetadata(Object metadata, LayerMetadataCacheKey cacheKey) {
        if (cacheKey == null) {
            return;
        }
        if (metadata == null) {
            this.m_layerMetadataCache.put((LayerMetadataCacheKey)cacheKey.clone(), Cube.m_nullMarker);
        } else {
            this.m_layerMetadataCache.put((LayerMetadataCacheKey)cacheKey.clone(), metadata);
        }
        this.m_layerMetadataKeyPool.returnCacheKeyToPool(cacheKey);
    }

    protected void storeMetadata(Object metadata, MemberMetadataCacheKey cacheKey, QDRCacheKey qdrCacheKey, String type) {
        if (cacheKey == null) {
            return;
        }
        if (metadata == null) {
            this.m_memberMetadataCache.put((MemberMetadataCacheKey)cacheKey.clone(), Cube.m_nullMarker);
        } else {
            this.m_memberMetadataCache.put((MemberMetadataCacheKey)cacheKey.clone(), metadata);
        }
        this.m_metadataKeyPool.returnCacheKeyToPool(cacheKey);
        this._storeQDRCache(qdrCacheKey, type, metadata);
    }

    protected void storeData(Object data, hPosDataCacheKey cacheKey, QDRCacheKey qdrCacheKey, String type) {
        if (cacheKey == null) {
            return;
        }
        if (data == null) {
            this.m_dataCache.put((hPosDataCacheKey)cacheKey.clone(), Cube.m_nullMarker);
        } else {
            this.m_dataCache.put((hPosDataCacheKey)cacheKey.clone(), data);
        }
        this.m_keyPool.returnCacheKeyToPool(cacheKey);
        if (qdrCacheKey != null) {
            DataCellInterface cellInt = (DataCellInterface)this.m_qdrDataCache.get(qdrCacheKey);
            boolean newInt = false;
            if (!(cellInt instanceof DataCellInterfaceImpl)) {
                cellInt = new DataCellInterfaceImpl();
                newInt = true;
            }
            if (data == null) {
                ((DataCellInterfaceImpl)cellInt).addType(type, Cube.m_nullMarker);
            } else {
                ((DataCellInterfaceImpl)cellInt).addType(type, data);
            }
            if (newInt) {
                this._storeQDRDataCache(qdrCacheKey, cellInt);
            } else {
                this.m_qdrKeyPool.returnCacheKeyToPool(qdrCacheKey);
            }
        }
    }

    protected LayerAndMember getSliceMemberSet(int edge, long slice) throws EdgeOutOfRangeException, SliceOutOfRangeException, TransformException {
        EdgeTree et = this.getEdgeTree(edge, slice, true);
        if (et != null) {
            return et.getSliceMembers(slice);
        }
        return null;
    }

    protected LayerAndMember getHPosMemberSet(int edge, long[] hPos) throws EdgeOutOfRangeException, TransformException {
        EdgeTree et = this.getEdgeTree(edge, -1, true);
        if (et != null) {
            return et.getHPosMembers(hPos);
        }
        return null;
    }

    private MemberWrapper[] _wrapMembers(TreeNodeWrapperMemberInterface[] members) throws TransformException {
        MemberWrapper[] wrappers;
        MemberWrapper[] memberWrapperArray = wrappers = members != null ? new MemberWrapper[members.length] : null;
        if (wrappers != null) {
            int i = 0;
            while (i < members.length) {
                wrappers[i] = new MemberWrapper(members[i]);
                ++i;
            }
        }
        return wrappers;
    }

    protected LayerAndMember[] getPageSet() throws EdgeOutOfRangeException, TransformException {
        int edgeCount = this.getEdgeCount();
        LayerAndMember[] pageSet = edgeCount > 2 ? new LayerAndMember[edgeCount - 2] : null;
        int e = 2;
        while (e < edgeCount) {
            pageSet[e - 2] = this.getHPosMemberSet(e, TransformUtils.getLongFromIntArray(this.getEdgeCurrentHPos(e)));
            ++e;
        }
        if (pageSet != null && pageSet.length == 0) {
            return null;
        }
        return pageSet;
    }

    @Override
    public synchronized long getSliceMemberCount(int edge, long slice) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        try {
            EdgeTree et = this.getEdgeTree(edge, slice, true);
            if (et != null) {
                long l = et.getDepth(-1, slice);
                return l;
            }
        }
        catch (TransformException e) {
            throw new SliceOutOfRangeException(e.getMessage(), e);
        }
        return 1L;
    }

    @Override
    public synchronized Object getLayerMetadata(int edge, int layer, String type) throws EdgeOutOfRangeException, LayerOutOfRangeException {
        Object objResult;
        LayerMetadataCacheKey cacheKey = null;
        if (this.m_caching && (objResult = this.m_layerMetadataCache.get(cacheKey = this.m_layerMetadataKeyPool.getCacheKeyFromPool(edge, layer, type))) != null) {
            this.m_layerMetadataKeyPool.returnCacheKeyToPool(cacheKey);
            return objResult instanceof TransformUtils.NullMarker ? null : objResult;
        }
        try {
            Object objResult2 = null;
            LayerInterface li = this.getLayerInfo(edge, layer);
            if (li != null) {
                objResult2 = type.equals("dimName") ? li.getValue() : li.getMetadata(TransformUtils.convertLayerMetadataMap(type));
                this.storeLayerMetadata(objResult2, cacheKey);
            }
            String string = objResult2;
            return string;
        }
        catch (TransformException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public synchronized int getSliceMemberCount(int edge, int slice) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        return (int)this.getSliceMemberCount(edge, (long)slice);
    }

    @Override
    public synchronized int getEdgeExtent(int edge) throws EdgeOutOfRangeException {
        return (int)this.getEdgeExtentLong(edge);
    }

    @Override
    public synchronized Object getValue(int row, int col, String type) throws RowOutOfRangeException, ColumnOutOfRangeException {
        return this.getValue((long)row, (long)col, type);
    }

    @Override
    public synchronized boolean setValue(Object data, int row, int col, String type) throws RowOutOfRangeException, ColumnOutOfRangeException {
        try {
            MemberWrapper[][] pageSet = this.wrapMembers(this.getPageSet());
            hPosDataCacheKey cacheKey = null;
            QDRCacheKey qdrCacheKey = null;
            if (this.m_caching) {
                cacheKey = this.m_keyPool.getCacheKeyFromPool(pageSet, row, col, type);
                if (this.m_qdrCaching) {
                    this.m_qdrCaching = false;
                    qdrCacheKey = this.m_qdrKeyPool.getCacheKeyFromPool(TransformUtils.getValueQDRImpl(this.getLayout(), this.getDataLayer(), this, row, col, 0, false));
                    this.m_qdrCaching = true;
                }
            }
            this.getResultAndCache(cacheKey, row, col, type, qdrCacheKey, true, data == null ? TransformUtils.m_nullMarker : data);
        }
        catch (Exception e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
        return true;
    }

    @Override
    public synchronized int getSliceOutlineLayer(int edge, int slice) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        try {
            EdgeTree et = this.getEdgeTree(edge, slice, true);
            if (et != null) {
                int n = et.getLowestLayer(slice);
                return n;
            }
        }
        catch (TransformException e) {
            throw new SliceOutOfRangeException(e.getMessage(), e);
        }
        return 0;
    }

    @Override
    public synchronized int getMemberDepth(int edge, int layer, int slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        try {
            EdgeTree et = this.getEdgeTree(edge, slice, true);
            if (et != null) {
                int n = et.getNodeSize(layer, slice);
                return n;
            }
        }
        catch (TransformException e) {
            throw new SliceOutOfRangeException(e.getMessage(), e);
        }
        return 1;
    }

    @Override
    public synchronized int getMemberStartLayer(int edge, int layer, int slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        try {
            EdgeTree et = this.getEdgeTree(edge, slice, true);
            if (et != null) {
                int n = et.getStartLayer(layer, slice);
                return n;
            }
        }
        catch (TransformException e) {
            throw new SliceOutOfRangeException(e.getMessage(), e);
        }
        return layer;
    }

    @Override
    public synchronized int getMemberLogicalLayer(int edge, int layer, int slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        try {
            EdgeTree et = this.getEdgeTree(edge, slice, true);
            if (et != null) {
                int n = et.getDepth(layer, slice);
                return n;
            }
        }
        catch (TransformException e) {
            throw new SliceOutOfRangeException(e.getMessage(), e);
        }
        return layer;
    }

    @Override
    public synchronized int getMemberExtent(int edge, int layer, int slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        try {
            EdgeTree et = this.getEdgeTree(edge, slice, true);
            if (et != null) {
                int n = (int)et.getSpan(layer, slice);
                return n;
            }
        }
        catch (TransformException e) {
            throw new SliceOutOfRangeException(e.getMessage(), e);
        }
        return 1;
    }

    @Override
    public synchronized int getMemberStartSlice(int edge, int layer, int slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        try {
            EdgeTree et = this.getEdgeTree(edge, slice, true);
            if (et != null) {
                int n = (int)et.getStart(layer, slice);
                return n;
            }
        }
        catch (TransformException e) {
            throw new SliceOutOfRangeException(e.getMessage(), e);
        }
        return 1;
    }

    @Override
    public synchronized Object getMemberMetadata(int edge, int layer, int slice, String type) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        return this.getMemberMetadata(edge, layer, (long)slice, type);
    }

    @Override
    public synchronized QDR getValueQDR(int row, int column, int flags) throws RowOutOfRangeException, ColumnOutOfRangeException {
        try {
            QDR qDR = TransformUtils.getValueQDRImpl(this.getLayout(), this.getDataLayer(), this, row, column, flags, false);
            return qDR;
        }
        catch (TransformException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public synchronized QDR getSliceQDR(int edge, int slice, int flags) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        try {
            QDR qDR = TransformUtils.getSliceQDRImpl(this.getLayout(), this.getDataLayer(), this, 0L, edge, slice, flags, false);
            return qDR;
        }
        catch (TransformException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public synchronized QDR getMemberQDR(int edge, int layer, int slice, int flags) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        try {
            QDR qDR = TransformUtils.getMemberQDRImpl(this.getLayout(), this.getDataLayer(), (DataAccessLong)this, edge, layer, (long)slice, flags, false);
            return qDR;
        }
        catch (TransformException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public synchronized QDR getMemberQDR(int edge, int[] hPos, int memberLayer, int flags) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        try {
            QDR qDR = TransformUtils.getMemberQDRImpl(this.getLayout(), this.getDataLayer(), (DataAccessLong)this, edge, TransformUtils.getLongFromIntArray(hPos), memberLayer, flags, false);
            return qDR;
        }
        catch (TransformException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public synchronized QDR getLayerQDR(int edge, int layer, int flags) throws EdgeOutOfRangeException, LayerOutOfRangeException {
        try {
            QDR qDR = TransformUtils.getLayerQDRImpl(this.getLayout(), this.getDataLayer(), this, edge, layer, flags, false);
            return qDR;
        }
        catch (TransformException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public synchronized int getMemberSiblingCount(int edge, int[] hPos, int memberLayer) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        return (int)this.getMemberSiblingCount(edge, TransformUtils.getLongFromIntArray(hPos), memberLayer);
    }

    @Override
    public synchronized Object getMemberMetadata(int edge, int[] hPos, int memberLayer, int hIndex, String type) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        return this.getMemberMetadata(edge, TransformUtils.getLongFromIntArray(hPos), memberLayer, (long)hIndex, type);
    }

    @Override
    public synchronized int[] getMemberHPos(int edge, int layer, int slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        return TransformUtils.getIntFromLongArray(this.getMemberHPos(edge, layer, (long)slice));
    }

    @Override
    public synchronized int[] getFirstHPos(int edge) throws EdgeOutOfRangeException {
        try {
            int[] nArray = TransformUtils.getIntFromLongArray(super._getFirstHPos(edge));
            return nArray;
        }
        catch (TransformException e) {
            throw new EdgeOutOfRangeException(e.getMessage(), e);
        }
    }

    @Override
    public synchronized int[] getLastHPos(int edge) throws EdgeOutOfRangeException {
        try {
            int[] nArray = TransformUtils.getIntFromLongArray(super._getLastHPos(edge));
            return nArray;
        }
        catch (TransformException e) {
            throw new EdgeOutOfRangeException(e.getMessage(), e);
        }
    }

    @Override
    public synchronized int[] getPrevHPos(int edge, int[] hPos) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        try {
            EdgeTree et = this.getEdgeTree(edge, -1, true);
            if (et != null) {
                int[] nArray = TransformUtils.getIntFromLongArray(et.getPreviousLeafNode(TransformUtils.getLongFromIntArray(hPos)).getHPos());
                return nArray;
            }
        }
        catch (TransformException e) {
            throw new SliceOutOfRangeException(e.getMessage(), e);
        }
        return null;
    }

    @Override
    public synchronized int[] getNextHPos(int edge, int[] hPos) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        try {
            EdgeTree et = this.getEdgeTree(edge, -1, true);
            if (et != null) {
                EdgeTreeNode node = et.getNextLeafNode(TransformUtils.getLongFromIntArray(hPos));
                if (node != null) {
                    int[] nArray = TransformUtils.getIntFromLongArray(node.getHPos());
                    return nArray;
                }
                int[] nArray = null;
                return nArray;
            }
        }
        catch (TransformException e) {
            throw new SliceOutOfRangeException(e.getMessage(), e);
        }
        return null;
    }

    @Override
    public synchronized int[] getSlicesFromQDR(QDRInterface qdr, int[] startSlice, int[] endSlice) {
        return this._getSlicesFromQDR(qdr, startSlice, endSlice, false);
    }

    private int[] _getSlicesFromQDR(QDRInterface qdr, int[] startSlice, int[] endSlice, boolean fail) {
        int edgeCount = this.getEdgeCount();
        int[] retVal = new int[edgeCount];
        int[] outOfBounds = new int[edgeCount];
        int i = 0;
        while (i < retVal.length) {
            retVal[i] = -1;
            outOfBounds[i] = -1;
            ++i;
        }
        if (qdr == null) {
            return retVal;
        }
        EdgeTree et = null;
        EdgeTreeNode node = null;
        String layerName = null;
        QDRMember member = null;
        int edge = 0;
        while (edge < edgeCount) {
            int layerCount = -1;
            try {
                layerCount = this.getLayerCount(edge);
            }
            catch (EdgeOutOfRangeException e) {
                throw new TransformRuntimeException(e.getMessage(), e);
            }
            if (layerCount > 0) {
                String[] edgeVals = new String[layerCount];
                int layer = 0;
                while (layer < layerCount) {
                    try {
                        layerName = (String)this.getLayerMetadata(edge, layer, "dimName");
                    }
                    catch (DataException e) {
                        throw new TransformRuntimeException(e.getMessage(), e);
                    }
                    member = qdr.getDimMember(layerName);
                    if (member != null) {
                        edgeVals[layer] = member.getData() != null ? member.getData().toString() : null;
                    } else {
                        if (fail) {
                            return null;
                        }
                        try {
                            edgeVals[layer] = this.getEdgeTree(edge, 0L, true).getNode(layer, 0L, EdgeTreeNode.GetSlice.GET_ALL_SLICES).getMember().getValue();
                        }
                        catch (Exception e) {
                            throw new TransformRuntimeException(e.getMessage(), e);
                        }
                    }
                    ++layer;
                }
                try {
                    et = this.getEdgeTree(edge, -1, true);
                    node = et.findNode(edgeVals);
                    if (node != null) {
                        retVal[edge] = (int)node.getStart(EdgeTreeNode.GetSlice.GET_ALL_SLICES, -1);
                        if (startSlice != null && edge < startSlice.length && retVal[edge] < startSlice[edge]) {
                            int[] nArray = outOfBounds;
                            return nArray;
                        }
                        if (endSlice != null && edge < endSlice.length && retVal[edge] > endSlice[edge]) {
                            int[] nArray = outOfBounds;
                            return nArray;
                        }
                    }
                }
                catch (Exception e) {
                    throw new TransformRuntimeException(e.getMessage(), e);
                }
            }
            ++edge;
        }
        return retVal;
    }

    @Override
    public synchronized List getUniqueMemberMetadata(int edge, int layer, String[] types, int start, int count) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        return TransformUtils.getUniqueMemberMetadata(this, false, 1000L, edge, layer, types, start, count);
    }

    @Override
    public synchronized List getUniqueMemberMetadata(String layerName, String[] types, int start, int count) throws LayerOutOfRangeException, SliceOutOfRangeException {
        try {
            int[] loc = TransformUtils.getLayerAndEdge(layerName, this.getLayout());
            if (loc != null) {
                List list = TransformUtils.getUniqueMemberMetadata(this, false, 1000L, loc[0], loc[1], types, start, count);
                return list;
            }
            List list = null;
            return list;
        }
        catch (EdgeOutOfRangeException e) {
            throw new LayerOutOfRangeException(e.getMessage(), e);
        }
    }

    @Override
    public synchronized List getCorrespondingMemberMetadata(int edge, int layer, String[] values, String[] types, boolean inDataAccess) throws EdgeOutOfRangeException, LayerOutOfRangeException {
        return TransformUtils.getCorrespondingMemberMetadata(this, edge, layer, values, types, inDataAccess, false);
    }

    @Override
    public synchronized List getCorrespondingMemberMetadata(String layerName, String[] values, String[] types, boolean inDataAccess) throws LayerOutOfRangeException {
        int[] layerAndEdge = TransformUtils.getLayerAndEdge(layerName, this.getLayout());
        if (layerAndEdge == null || layerAndEdge.length < 2) {
            return null;
        }
        try {
            List list = this.getCorrespondingMemberMetadata(layerAndEdge[0], layerAndEdge[1], values, types, inDataAccess);
            return list;
        }
        catch (EdgeOutOfRangeException e) {
            throw new LayerOutOfRangeException(e.getMessage(), e);
        }
    }

    protected long findMember(EdgeTreeNode node, long start, long inc, String comp, boolean reverse, String type, int flags) throws TransformException {
        TreeNodeWrapperMemberInterface mi = null;
        String comp2 = null;
        long count = node.getChildCount();
        long val = start;
        while (reverse && val >= 0L || !reverse && val < count) {
            Object obj;
            mi = node.getChild(val).getMember();
            comp2 = null;
            if (mi != null && (obj = mi.getMetadata(type)) != null) {
                comp2 = obj.toString();
            }
            if ((flags & 0x80) != 0) {
                comp2 = comp2.toUpperCase();
            }
            if (TransformUtils.compareStrings(comp, comp2, flags)) {
                return val;
            }
            val += inc;
        }
        return -1;
    }

    @Override
    public synchronized int findMember(int edge, int[] hPos, int memberLayer, String s, String type, int flags) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        try {
            EdgeTree et = this.getEdgeTree(edge, -1, true);
            if (et != null) {
                boolean nullHPos = hPos == null || hPos.length == 0;
                EdgeTreeNode node = et.getNode(TransformUtils.getLongFromIntArray(hPos), memberLayer - 1, !nullHPos && memberLayer > 0 ? hPos[memberLayer - 1] : 0);
                long start = 0L;
                if (hPos != null && hPos.length > memberLayer && (start = (long)hPos[memberLayer]) < 0L) {
                    start = 0L;
                }
                boolean reverse = false;
                long inc = 1L;
                if ((flags & 0x100) != 0) {
                    reverse = true;
                    inc = -1;
                }
                String comp = null;
                comp = (flags & 0x80) != 0 ? s.toUpperCase() : s;
                int n = (int)this.findMember(node, start, inc, comp, reverse, type, flags);
                return n;
            }
        }
        catch (TransformException e) {
            throw new SliceOutOfRangeException(e.getMessage(), e);
        }
        return -1;
    }

    protected class SortTuple
    implements ComparatorInterface {
        protected MemberInterface[] m_layers;
        protected Object m_data;

        private void $init$() {
            this.m_layers = null;
            this.m_data = null;
        }

        public SortTuple(MemberInterface[] layers, Object data) {
            this.$init$();
            this.m_layers = layers;
            this.m_data = data;
        }

        public Object getValue() {
            return this.m_data;
        }
    }

    protected class MyRowIterator
    implements RowIterator {
        protected int m_row;
        protected SortTuple[] m_rows;
        protected String[] m_columns;

        private void $init$() {
            this.m_row = -1;
            this.m_rows = null;
            this.m_columns = null;
        }

        public MyRowIterator(SortTuple[] rows, BaseProjection proj, int edge) throws TransformException {
            this.$init$();
            this.m_rows = rows;
            if (rows.length > 0) {
                this.m_columns = new String[rows[0].m_layers.length];
                int c = 0;
                while (c < this.m_columns.length) {
                    this.m_columns[c] = proj.getLayout()[edge][c];
                    ++c;
                }
            }
        }

        public boolean hasMoreRows() throws TransformException {
            return this.m_row < this.m_rows.length;
        }

        public boolean nextRow() throws TransformException {
            ++this.m_row;
            return this.hasMoreRows();
        }

        public void close() throws TransformException {
        }

        private int _getColumnIndex(String column) {
            int c = 0;
            while (c < this.m_columns.length) {
                if (column.equals(this.m_columns[c])) {
                    return c;
                }
                ++c;
            }
            return -1;
        }

        public MemberInterface getMember(String column) throws TransformException {
            if (this.m_row < 0 || this.m_row >= this.m_rows.length) {
                return null;
            }
            int c = this._getColumnIndex(column);
            return this.m_rows[this.m_row].m_layers[c];
        }

        public DataCellInterface getCell(String column) throws TransformException {
            return null;
        }

        public String[] getColumns() {
            return this.m_columns;
        }

        public Object getValue(String column) throws TransformException {
            MemberInterface mi = this.getMember(column);
            if (mi != null) {
                return mi.getValue();
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MyRowProjection
    implements RowProjection {
        protected BaseProjection m_proj;
        protected RowIterator m_iter;
        protected int m_edge;

        private void $init$() {
            this.m_proj = null;
            this.m_iter = null;
            this.m_edge = -1;
        }

        public MyRowProjection(BaseProjection proj, SortTuple[] rows, int edge) throws TransformException {
            this.$init$();
            this.m_proj = proj;
            this.m_edge = edge;
            this.m_iter = new MyRowIterator(rows, proj, edge);
        }

        @Override
        public RowIterator getRowIterator() {
            return this.m_iter;
        }

        @Override
        public LayerInterface getLayer(String layer) {
            int[] edgeLayer = TransformUtils.getLayerAndEdge(layer, this.getLayout());
            try {
                LayerInterface layerInterface = CubicDataAccess.this.getLayerInfo(edgeLayer[0], edgeLayer[0]);
                return layerInterface;
            }
            catch (Exception e) {
                throw new TransformRuntimeException(e.getMessage(), e);
            }
        }

        @Override
        public String[][] getLayout() {
            String[][] layout = this.m_proj.getLayout();
            if (layout != null && layout.length > this.m_edge) {
                String[][] retVal = new String[this.m_edge + 1][];
                retVal[this.m_edge] = layout[this.m_edge];
                return retVal;
            }
            return null;
        }

        @Override
        public LayerInterface getDataLayer() {
            return this.m_proj.getDataLayer();
        }

        @Override
        public MemberInterface[] getDataItems() {
            return this.m_proj.getDataItems();
        }

        @Override
        public DataCellInterface getData(Map<String, Object> keyPath) {
            return this.m_proj.getData(keyPath);
        }
    }

    protected class DataCellInterfaceImpl
    implements DataCellInterface {
        Hashtable<String, Object> m_typeData;

        private void $init$() {
            this.m_typeData = new Hashtable();
        }

        public DataCellInterfaceImpl() {
            this.$init$();
        }

        public void addType(String type, Object data) {
            this.m_typeData.put(type, data);
        }

        public Object getData(String type) {
            return this.m_typeData.get(TransformUtils.convertDataType(type));
        }

        public boolean setData(Object value, String type) {
            return false;
        }
    }
}

