/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.transform;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import oracle.dss.util.Utility;
import oracle.dss.util.transform.ColumnValue;
import oracle.dss.util.transform.DataCell;
import oracle.dss.util.transform.DataCellInterface;
import oracle.dss.util.transform.DataColumnProjection;
import oracle.dss.util.transform.LayerInterface;
import oracle.dss.util.transform.MemberCell;
import oracle.dss.util.transform.MemberInterface;
import oracle.dss.util.transform.MixedFrequencyProjection;
import oracle.dss.util.transform.Row;
import oracle.dss.util.transform.RowIterator;
import oracle.dss.util.transform.RowProjection;
import oracle.dss.util.transform.TransformException;
import oracle.dss.util.transform.total.AggBuckets;
import oracle.dss.util.transform.total.AggLocation;
import oracle.dss.util.transform.total.AggSpec;
import oracle.dss.util.transform.total.TotalPlacement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTable {
    protected static final int PROJECTION_STANDARD = 0;
    protected static final int PROJECTION_DATA_COLUMN = 1;
    protected static final int PROJECTION_MIXED_FREQUENCY = 2;
    protected RowProjection m_projection;
    protected int m_projectionType;
    protected int m_memberCount;
    protected int m_cellCount;
    protected Hashtable m_memberLookupTable;
    protected Hashtable m_cellLookupTable;
    protected Row[] m_data;
    protected String[] m_memberLayers;
    protected AggBuckets[] m_aggBucket;
    protected AggSpec[][] m_aggs;

    private void $init$() {
        this.m_projection = null;
        this.m_projectionType = 0;
        this.m_memberCount = -1;
        this.m_cellCount = -1;
        this.m_memberLookupTable = new Hashtable();
        this.m_cellLookupTable = new Hashtable();
        this.m_data = null;
        this.m_memberLayers = null;
        this.m_aggBucket = null;
        this.m_aggs = null;
    }

    protected DataTable() {
        this.$init$();
    }

    public DataTable(RowProjection projection) throws TransformException {
        this(projection, null, false);
    }

    public DataTable(RowProjection projection, AggSpec[][] aggs) throws TransformException {
        this(projection, aggs, false);
    }

    public DataTable(RowProjection projection, AggSpec[][] aggs, boolean includeDataLayerinMembers) throws TransformException {
        this.$init$();
        this.m_projection = projection;
        this.m_aggs = aggs;
        if (aggs != null) {
            this.m_aggBucket = new AggBuckets[aggs.length];
            int i = 0;
            while (i < aggs.length) {
                if (aggs[i] != null) {
                    this.m_aggBucket[i] = new AggBuckets(aggs[i], projection);
                }
                ++i;
            }
        }
        if (projection instanceof DataColumnProjection) {
            this.m_projectionType = 1;
            this.processDataColumnProjection();
        } else if (projection instanceof MixedFrequencyProjection) {
            this.m_projectionType = 2;
            this.processMixedFrequencyProjection();
        } else {
            this.m_projectionType = 0;
            this.processProjection(includeDataLayerinMembers);
        }
    }

    public AggSpec[][] getAggSpec() {
        return this.m_aggs;
    }

    protected Object _copy(DataTable newdt) throws CloneNotSupportedException {
        newdt.m_projection = this.m_projection;
        newdt.m_projectionType = this.m_projectionType;
        if (this.m_aggBucket != null) {
            newdt.m_aggBucket = (AggBuckets[])Utility.arraycopy(this.m_aggBucket);
        }
        newdt.m_memberCount = this.m_memberCount;
        newdt.m_cellCount = this.m_cellCount;
        newdt.m_memberLookupTable = (Hashtable)this.m_memberLookupTable.clone();
        newdt.m_cellLookupTable = (Hashtable)this.m_cellLookupTable.clone();
        if (this.m_data != null) {
            newdt.m_data = new Row[this.m_data.length];
            int i = 0;
            while (i < this.m_data.length) {
                if (this.m_data[i] != null) {
                    newdt.m_data[i] = (Row)this.m_data[i].clone(newdt);
                }
                ++i;
            }
        }
        newdt.m_memberLayers = (String[])this.m_memberLayers.clone();
        return newdt;
    }

    public String[] getColumns() {
        int memberLayers = this.m_memberLayers != null ? this.m_memberLayers.length : 0;
        Enumeration dataEnum = this.m_cellLookupTable.keys();
        Vector<String> dataArray = new Vector<String>();
        while (dataEnum.hasMoreElements()) {
            dataArray.addElement((String)dataEnum.nextElement());
        }
        String[] cols = new String[memberLayers + dataArray.size()];
        int i = 0;
        while (i < memberLayers) {
            cols[i] = this.m_memberLayers[i];
            ++i;
        }
        int i2 = memberLayers;
        while (i2 < cols.length) {
            cols[i2] = (String)dataArray.elementAt(i2 - memberLayers);
            ++i2;
        }
        return cols;
    }

    public Object clone() throws CloneNotSupportedException {
        DataTable newdt = new DataTable();
        return this._copy(newdt);
    }

    public long getRowCount() {
        return this.m_data.length;
    }

    public int getMemberCount() {
        return this.m_memberCount;
    }

    public int getCellCount() {
        return this.m_cellCount;
    }

    public Row getRow(long row) {
        return this.m_data[(int)row];
    }

    public MemberInterface getMember(long row, int member) {
        if (row < this.getRowCount() && row >= 0L && member < this.m_memberCount && member >= 0) {
            return this.m_data[(int)row].getMember(member).getMemberInterface();
        }
        return null;
    }

    public DataCellInterface getCell(long row, int cell) {
        if (row < this.getRowCount() && row >= 0L && cell < this.m_cellCount && cell >= 0) {
            return this.m_data[(int)row].getCell(cell).getDataCellInterface();
        }
        return null;
    }

    public MemberInterface getMember(long row, String colID) {
        return this.getMember(row, this.getMemberIndexFromID(colID));
    }

    public DataCellInterface getCell(long row, String colID) {
        return this.getCell(row, this.getCellIndexFromID(colID));
    }

    public void setMember(long row, int column, MemberCell newMember) {
        if (row < this.getRowCount() && row >= 0L && column < this.m_memberCount && column >= 0) {
            this.m_data[(int)row].setMember(column, newMember);
        }
    }

    public void setCell(long row, int column, DataCell newCell) {
        if (row < this.getRowCount() && row >= 0L && column < this.m_cellCount && column >= 0) {
            this.m_data[(int)row].setCell(column, newCell);
        }
    }

    public void setMember(long row, String colID, MemberCell newMember) {
        this.setMember(row, this.getMemberIndexFromID(colID), newMember);
    }

    public void setCell(long row, String colID, DataCell newCell) {
        this.setCell(row, this.getCellIndexFromID(colID), newCell);
    }

    protected int getMemberIndexFromID(String colID) {
        Integer colNum = (Integer)this.m_memberLookupTable.get(colID);
        if (colNum != null) {
            return colNum;
        }
        return -1;
    }

    protected int getCellIndexFromID(String colID) {
        Integer colNum = (Integer)this.m_cellLookupTable.get(colID);
        if (colNum != null) {
            return colNum;
        }
        return -1;
    }

    public void close() {
        if (this.m_memberLookupTable != null) {
            this.m_memberLookupTable.clear();
        }
        this.m_memberLookupTable = null;
        this.m_memberCount = -1;
        if (this.m_cellLookupTable != null) {
            this.m_cellLookupTable.clear();
        }
        this.m_cellLookupTable = null;
        this.m_cellCount = -1;
        this.m_projection = null;
        if (this.m_data != null) {
            int i = 0;
            while (i < this.m_data.length) {
                if (this.m_data[i] != null) {
                    this.m_data[i].release();
                }
                ++i;
            }
        }
        this.m_data = null;
        this.m_memberLayers = null;
        if (this.m_aggBucket != null) {
            int i = 0;
            while (i < this.m_aggBucket.length) {
                if (this.m_aggBucket[i] != null) {
                    this.m_aggBucket[i].release();
                }
                ++i;
            }
        }
        this.m_aggBucket = null;
    }

    protected void processMixedFrequencyProjection() throws TransformException {
        this.createMemberLookupTable(false);
        this.createCellLookupTable();
        ArrayList rowList = new ArrayList();
        Hashtable indices = new Hashtable();
        RowIterator iter = this.m_projection.getRowIterator();
        while (iter.nextRow()) {
            this.processMixedFrequencyCurrentRow(rowList, indices, iter);
        }
        this.m_data = rowList.toArray(new Row[0]);
    }

    protected void processDataColumnProjection() throws TransformException {
        this.createMemberLookupTable(false);
        this.createCellLookupTable();
        ArrayList<Row> rowList = new ArrayList<Row>();
        RowIterator iter = this.m_projection.getRowIterator();
        ColumnValue[] extraMembers = null;
        while (iter.nextRow()) {
            extraMembers = this._collectAggregatedMembers(iter);
            Row row = this.processDataColumnCurrentRow(rowList, iter, extraMembers);
            if (row == null) continue;
            rowList.add(row);
        }
        this.m_data = this.integrateAggregations(rowList, this.m_aggBucket != null && this.m_aggBucket.length > 0 ? this.m_aggBucket[0] : null);
    }

    private boolean _inLayout(String column) {
        String[][] layout = this.m_projection.getLayout();
        if (layout == null) {
            return false;
        }
        int e = 0;
        while (e < layout.length) {
            if (layout[e] != null) {
                int l = 0;
                while (l < layout[e].length) {
                    if (column.equals(layout[e][l])) {
                        return true;
                    }
                    ++l;
                }
            }
            ++e;
        }
        return false;
    }

    private ColumnValue[] _collectAggregatedMembers(RowIterator iter) throws TransformException {
        if (this.m_aggBucket != null) {
            Vector<ColumnValue> memberVec = new Vector<ColumnValue>();
            Vector<String> colList = new Vector<String>();
            int i = 0;
            while (i < this.m_aggBucket.length) {
                String[] cols;
                if (this.m_aggBucket[i] != null && (cols = this.m_aggBucket[i].getAggColumns()) != null) {
                    int c = 0;
                    while (c < cols.length) {
                        if (cols[c] != null && colList.indexOf(cols[c]) == -1 && !this._inLayout(cols[c])) {
                            colList.addElement(cols[c]);
                            memberVec.addElement(new ColumnValue(cols[c], iter.getValue(cols[c])));
                        }
                        ++c;
                    }
                }
                ++i;
            }
            return memberVec.toArray(new ColumnValue[0]);
        }
        return new ColumnValue[0];
    }

    protected void processProjection(boolean includeDataLayerinMembers) throws TransformException {
        this.createMemberLookupTable(includeDataLayerinMembers);
        this.createCellLookupTable();
        ArrayList<Row> rowList = new ArrayList<Row>();
        Row row = null;
        RowIterator iter = this.m_projection.getRowIterator();
        ColumnValue[] extraMembers = null;
        if (iter != null) {
            while (iter.nextRow()) {
                extraMembers = this._collectAggregatedMembers(iter);
                row = this.processCurrentRow(iter, extraMembers);
                rowList.add(row);
                if (this.m_aggBucket == null || this.m_aggBucket.length <= 0 || this.m_aggBucket[0] == null) continue;
                this.m_aggBucket[0].totalRow(row);
            }
        }
        Row[] data = this.integrateAggregations(rowList, this.m_aggBucket != null && this.m_aggBucket.length > 0 ? this.m_aggBucket[0] : null);
        if (this.m_aggBucket != null) {
            int i = 1;
            while (i < this.m_aggBucket.length) {
                rowList = new ArrayList();
                if (this.m_aggBucket[i] != null && data != null) {
                    int r = 0;
                    while (r < data.length) {
                        rowList.add(data[r]);
                        this.m_aggBucket[i].totalRow(data[r]);
                        ++r;
                    }
                    data = this.integrateAggregations(rowList, this.m_aggBucket[i]);
                }
                ++i;
            }
        }
        this.m_data = data;
    }

    protected Row[] integrateAggregations(ArrayList<Row> rowList, AggBuckets aggBucket) {
        TotalPlacement[] tp;
        if (aggBucket != null && (tp = aggBucket.getTotalPlacements()) != null) {
            int replacePlacement = this.getReplacementPlacement(tp);
            if (replacePlacement > -1) {
                return tp[replacePlacement].getTotalRows().toArray(new Row[0]);
            }
            int placement = 0;
            while (placement < tp.length) {
                if (tp[placement] != null) {
                    rowList.addAll(tp[placement].getTotalRows());
                }
                ++placement;
            }
        }
        return rowList.toArray(new Row[0]);
    }

    protected int getReplacementPlacement(TotalPlacement[] tp) {
        if (tp == null || tp.length > 1) {
            return -1;
        }
        int i = 0;
        while (i < tp.length) {
            if (tp[i] != null && tp[i].getAggLocation() == AggLocation.REPLACE) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected boolean isDataColumnProjection() {
        return this.m_projectionType == 1;
    }

    protected boolean isMixedFrequencyProjection() {
        return this.m_projectionType == 2;
    }

    protected void createMemberLookupTable(boolean includeDataLayerinMembers) throws TransformException {
        String[][] layout = this.m_projection.getLayout();
        LayerInterface dataLayerInt = this.m_projection.getDataLayer();
        String dataLayer = dataLayerInt != null ? dataLayerInt.getValue() : null;
        MemberInterface[] dataItems = this.m_projection.getDataItems();
        Vector<String> vDataItems = new Vector<String>();
        if (dataItems != null) {
            int i = 0;
            while (i < dataItems.length) {
                vDataItems.add(dataItems[i].getValue());
                ++i;
            }
        }
        this.m_memberLookupTable.clear();
        Vector<String> memberLayers = new Vector<String>();
        int index = 0;
        if (layout != null) {
            int edge = 0;
            while (edge < layout.length) {
                if (layout[edge] != null) {
                    int layer = 0;
                    while (layer < layout[edge].length) {
                        if (includeDataLayerinMembers || !dataLayer.equals(layout[edge][layer])) {
                            this.m_memberLookupTable.put(layout[edge][layer], new Integer(index++));
                            memberLayers.add(layout[edge][layer]);
                        }
                        ++layer;
                    }
                }
                ++edge;
            }
        }
        this.m_memberLayers = memberLayers.toArray(new String[index]);
        this.m_memberCount = index;
    }

    protected void createCellLookupTable() throws TransformException {
        this.m_cellLookupTable.clear();
        MemberInterface[] dataItems = this.m_projection.getDataItems();
        if (dataItems != null) {
            this.m_cellCount = dataItems.length;
            int col = 0;
            while (col < this.m_cellCount) {
                this.m_cellLookupTable.put(dataItems[col].getValue(), new Integer(col));
                ++col;
            }
        }
    }

    protected int cellLookup(String dataItemID) {
        Object val = this.m_cellLookupTable.get(dataItemID);
        if (val instanceof Integer) {
            return (Integer)val;
        }
        return -1;
    }

    protected DataCellInterface getCell(RowIterator iter, String col, int colCount) throws TransformException {
        return iter.getCell(col);
    }

    protected MemberInterface getMember(RowIterator iter, String col, int colCount) throws TransformException {
        return iter.getMember(col);
    }

    protected Row processCurrentRow(RowIterator iter, ColumnValue[] extraMembers) throws TransformException {
        MemberCell[] memberCells = new MemberCell[this.m_memberCount];
        int col = 0;
        while (col < this.m_memberCount) {
            memberCells[col] = new MemberCell(this.getMember(iter, this.m_memberLayers[col], col), this.m_memberLayers[col]);
            ++col;
        }
        MemberInterface[] dataItems = this.m_projection.getDataItems();
        DataCell[] cells = null;
        if (dataItems != null) {
            cells = new DataCell[this.m_cellCount];
            String cellColumn = null;
            int col2 = 0;
            while (col2 < this.m_cellCount) {
                cellColumn = dataItems[col2].getValue();
                cells[col2] = new DataCell(this.getCell(iter, cellColumn, this.m_memberCount + col2), cellColumn);
                ++col2;
            }
        }
        return new Row(memberCells, cells, extraMembers, this);
    }

    protected DataColumnProjection getDataColumnProjection() {
        if (this.isDataColumnProjection()) {
            return (DataColumnProjection)this.m_projection;
        }
        return null;
    }

    protected MixedFrequencyProjection getMixedFrequencyProjection() {
        if (this.isMixedFrequencyProjection()) {
            return (MixedFrequencyProjection)this.m_projection;
        }
        return null;
    }

    protected Row updateRow(Row row, ArrayList rowList) throws TransformException {
        if (rowList == null) {
            return null;
        }
        Iterator iter = rowList.iterator();
        Row currRow = null;
        while (iter.hasNext()) {
            currRow = (Row)iter.next();
            if (!row.membersEqual(currRow)) continue;
            currRow.insertData(row.getCells());
            return currRow;
        }
        return null;
    }

    protected Row processDataColumnCurrentRow(ArrayList rowList, RowIterator iter, ColumnValue[] extraMembers) throws TransformException {
        MemberCell[] members = new MemberCell[this.m_memberCount];
        int col = 0;
        while (col < this.m_memberCount) {
            members[col] = new MemberCell(iter.getMember(this.m_memberLayers[col]), this.m_memberLayers[col]);
            ++col;
        }
        String dataID = this.getDataColumnProjection().getDataItemIDColumn();
        String dataCol = this.getDataColumnProjection().getDataColumn();
        DataCell[] cells = new DataCell[this.m_cellCount];
        int cellPos = this.cellLookup(iter.getMember(dataID).getValue());
        if (cellPos >= 0 && cellPos < this.m_cellCount) {
            cells[cellPos] = new DataCell(iter.getCell(dataCol), dataCol);
            Row row = new Row(members, cells, extraMembers, this);
            Row updatedRow = this.updateRow(row, rowList);
            if (updatedRow != null) {
                return updatedRow;
            }
            return row;
        }
        return null;
    }

    protected void processMixedFrequencyCurrentRow(ArrayList rowList, Hashtable indices, RowIterator iter) throws TransformException {
        MixedFrequencyProjection projection = this.getMixedFrequencyProjection();
        MemberCell[] members1 = new MemberCell[this.m_memberCount];
        MemberCell[] members2 = new MemberCell[this.m_memberCount];
        Vector<String> qdrMembers = new Vector<String>();
        int dynamicIndex = -1;
        int col = 0;
        while (col < this.m_memberCount) {
            if (!projection.getDynamicLayer().equals(this.m_memberLayers[col])) {
                members1[col] = new MemberCell(iter.getMember(this.m_memberLayers[col]), this.m_memberLayers[col]);
                members2[col] = new MemberCell(members1[col].getMemberInterface(), this.m_memberLayers[col]);
                qdrMembers.add(members1[col].getMemberInterface().getValue());
            } else {
                dynamicIndex = col;
            }
            ++col;
        }
        Integer value = (Integer)indices.get(qdrMembers);
        if (value == null) {
            value = new Integer(-1);
        }
        int index = value + 1;
        indices.put(qdrMembers, new Integer(index));
        members1[dynamicIndex] = new MemberCell(projection.getDynamicMember(index, 0), Integer.toString(0));
        members2[dynamicIndex] = new MemberCell(projection.getDynamicMember(index, 1), Integer.toString(1));
        DataCell[] cells1 = new DataCell[this.m_cellCount];
        DataCell[] cells2 = new DataCell[this.m_cellCount];
        MemberInterface[] dataItems = this.m_projection.getDataItems();
        DataCellInterface frequency = iter.getCell(projection.getMixedFrequencyLayer());
        int i = 0;
        while (i < dataItems.length) {
            cells1[i] = new DataCell(frequency, projection.getMixedFrequencyLayer());
            cells2[i] = new DataCell(iter.getCell(dataItems[i].getValue()), dataItems[i].getValue());
            ++i;
        }
        Row row1 = new Row(members1, cells1, null, this);
        Row row2 = new Row(members2, cells2, null, this);
        rowList.add(row1);
        rowList.add(row2);
    }
}

