/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.transform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.QDR;
import oracle.dss.util.QDRInterface;
import oracle.dss.util.QDRMember;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.dss.util.transform.BaseNode;
import oracle.dss.util.transform.BaseProjection;
import oracle.dss.util.transform.EdgeTreeBasedCubicDataAccess;
import oracle.dss.util.transform.EdgeTreeNode;
import oracle.dss.util.transform.InsertInfo;
import oracle.dss.util.transform.LayerAndMember;
import oracle.dss.util.transform.MemberInterface;
import oracle.dss.util.transform.MemberWrapper;
import oracle.dss.util.transform.Row;
import oracle.dss.util.transform.SliceInsertInfo;
import oracle.dss.util.transform.TransformException;
import oracle.dss.util.transform.TransformUtils;
import oracle.dss.util.transform.TreeNode;
import oracle.dss.util.transform.TreeNodeWrapperMemberInterface;
import oracle.dss.util.transform.total.AggLocation;
import oracle.dss.util.transform.total.TotalMember;
import oracle.dss.util.transform.total.TotalRow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EdgeTree
implements Cloneable {
    protected BaseNode[] m_layers;
    protected EdgeTreeNode m_root;
    protected boolean m_locked;
    protected int m_edge;
    protected boolean m_noCollapseLeaves;
    protected String[][] m_layout;
    protected boolean m_isOutline;
    protected EdgeTreeBasedCubicDataAccess m_da;
    protected BaseProjection m_projection;
    protected String m_measDim;
    protected String[] m_measList;
    protected long m_extent;

    private void $init$() {
        this.m_layers = null;
        this.m_root = null;
        this.m_locked = false;
        this.m_edge = -1;
        this.m_noCollapseLeaves = false;
        this.m_layout = null;
        this.m_isOutline = false;
        this.m_da = null;
        this.m_projection = null;
        this.m_measDim = null;
        this.m_measList = null;
        this.m_extent = -1;
    }

    public EdgeTree(BaseNode[] nodes, int edge, BaseProjection projection, String measDim, String[] measList, boolean noCollapseLeaves, EdgeTreeBasedCubicDataAccess da, long extent) {
        this.$init$();
        this.m_projection = projection;
        this.m_da = da;
        this.m_layers = nodes;
        this.m_edge = edge;
        this.m_extent = extent;
        this.m_layout = projection.getLayout();
        this.m_noCollapseLeaves = noCollapseLeaves;
        this.m_root = this.getRootEdgeTreeNode(this.m_extent);
        this.m_measDim = measDim;
        this.m_measList = measList;
    }

    public EdgeTreeBasedCubicDataAccess getDataAccess() {
        return this.m_da;
    }

    protected EdgeTreeNode getRootEdgeTreeNode(long extent) {
        return new EdgeTreeNode(this);
    }

    public Object clone(boolean caching) throws CloneNotSupportedException {
        EdgeTree et = (EdgeTree)super.clone();
        if (this.m_layers != null) {
            et.m_layers = new BaseNode[this.m_layers.length];
            int i = 0;
            while (i < this.m_layers.length) {
                if (this.m_layers[i] != null) {
                    et.m_layers[i] = (BaseNode)this.m_layers[i].clone();
                }
                ++i;
            }
        }
        et.m_root = (EdgeTreeNode)this.m_root.clone(et, null, caching);
        if (this.m_layout != null) {
            et.m_layout = (String[][])this.m_layout.clone();
        }
        et.m_da = this.m_da;
        et.m_measDim = this.m_measDim;
        et.m_measList = this.m_measList;
        return et;
    }

    protected void clearNodes() throws TransformException {
        if (this.m_root != null) {
            this.m_root.release();
        }
        this.m_root = this.getRootEdgeTreeNode(this.m_extent);
        this.unlock();
    }

    public void release() {
        this.m_layers = null;
        if (this.m_root != null) {
            this.m_root.release();
        }
        this.m_root = null;
        this.m_layout = null;
    }

    protected boolean isNoCollapseLeaves() {
        return this.m_noCollapseLeaves;
    }

    protected void setOutline(boolean outline) {
        this.m_isOutline = outline;
    }

    protected boolean isOutline() {
        return this.m_isOutline;
    }

    private MemberInterface _getMember(String layer, String[] layers, HashMap<String, MemberInterface> sliceToInsert) {
        int i = 0;
        while (i < layers.length) {
            if (layer.equals(layers[i])) {
                return sliceToInsert.get(layers[i]);
            }
            ++i;
        }
        return null;
    }

    public boolean insert(SliceInsertInfo sliceInsertInfo) throws TransformException {
        HashMap<String, MemberInterface> sliceToInsert = sliceInsertInfo.getSliceToInsert();
        QDR qdrToInsert = new QDR();
        String[] layers = TransformUtils.getLayersFromSliceToInsert(sliceToInsert);
        int i = 0;
        while (i < layers.length) {
            qdrToInsert.addDimMemberPair(layers[i], sliceToInsert.get(layers[i]).getValue());
            ++i;
        }
        EdgeTreeNode currNode = this.m_root;
        QDRMember member = null;
        EdgeTreeNode prevNode = currNode;
        boolean added = false;
        int layer = 0;
        while (layer < this.m_layers.length) {
            member = qdrToInsert.getDimMember(this.m_layers[layer].getName());
            if (member == null) {
                if (layer > 0) {
                    this._insert(prevNode, layer - 1, layers, sliceInsertInfo, false);
                    return true;
                }
                return false;
            }
            Object data = member.getData();
            prevNode = currNode;
            if ((currNode = currNode.findNonAggregateChild(data != null ? data.toString() : null)) == null) {
                currNode = this._insert(prevNode, layer, layers, sliceInsertInfo, false);
                added = true;
            }
            ++layer;
        }
        return added;
    }

    private EdgeTreeNode _insert(EdgeTreeNode prevNode, int layer, String[] layers, SliceInsertInfo sliceInsertInfo, boolean alwaysAdd) throws TransformException {
        QDRMember insertMember;
        String layerName = this.m_layers[layer].getName();
        QDRMember qDRMember = insertMember = sliceInsertInfo.getInsertLocation() != null ? sliceInsertInfo.getInsertLocation().getDimMember(layerName) : null;
        String insertLocation = insertMember != null ? (insertMember.getData() != null ? insertMember.getData().toString() : null) : null;
        boolean before = sliceInsertInfo.isBefore();
        if (insertLocation == null) {
            if (!before) {
                EdgeTreeNode firstNode = prevNode.getFirstChild();
                insertLocation = firstNode != null ? firstNode.getMember().getValue() : null;
                before = true;
            } else {
                EdgeTreeNode lastNode = prevNode.getLastChild();
                insertLocation = lastNode != null ? lastNode.getMember().getValue() : null;
                before = false;
            }
        }
        EdgeTreeNode newNode = this.getEdgeTreeNode(false, prevNode, this._getMember(layerName, layers, sliceInsertInfo.getSliceToInsert()), null, layerName);
        prevNode.addChild(newNode, null, insertLocation, before, alwaysAdd);
        prevNode.clearSpan();
        newNode.clearStarts();
        prevNode.clearStarts();
        return newNode;
    }

    protected abstract EdgeTreeNode getEdgeTreeNode(boolean var1, EdgeTreeNode var2, MemberInterface var3, TreeNode var4, String var5) throws TransformException;

    public void delete(QDRInterface qdr) throws TransformException {
        EdgeTreeNode currNode = this.m_root;
        QDRMember member = null;
        int layer = 0;
        while (layer < this.m_layers.length) {
            member = qdr.getDimMember(this.m_layers[layer].getName());
            if (member == null) break;
            Object data = member.getData();
            if ((currNode = currNode.findNonAggregateChild(data != null ? data.toString() : null)) == null) {
                return;
            }
            ++layer;
        }
        if (currNode != null) {
            currNode.delete();
        }
    }

    public void invalidate(QDRInterface qdr) throws TransformException {
        EdgeTreeNode currNode = this.m_root;
        QDRMember member = null;
        int layer = 0;
        while (layer < this.m_layers.length) {
            member = qdr.getDimMember(this.m_layers[layer].getName());
            if (member == null) {
                if (this.invalidate(currNode)) {
                    currNode.clearSpan();
                    currNode.clearStarts();
                }
                return;
            }
            Object data = member.getData();
            if ((currNode = currNode.findNonAggregateChild(data != null ? data.toString() : null)) == null) {
                return;
            }
            ++layer;
        }
    }

    private boolean invalidate(EdgeTreeNode node) throws TransformException {
        if (node.isRoot()) {
            return false;
        }
        node.invalidate();
        return true;
    }

    public boolean containsColumn(String col) {
        if (this.m_layers == null) {
            return false;
        }
        if (col == null) {
            return true;
        }
        return this.getLayer(col) != -1;
    }

    protected int getLayer(String layerName) {
        if (this.m_layers == null) {
            return -1;
        }
        int i = 0;
        while (i < this.m_layers.length) {
            if (this.m_layers[i].getName().equals(layerName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void unlock() throws TransformException {
        this.m_locked = false;
        if (this.m_root != null) {
            this.m_root.unlock();
        }
    }

    public int getEdge() {
        return this.m_edge;
    }

    public int getLayerCount() {
        return this.m_layers == null ? 0 : this.m_layers.length;
    }

    protected void checkLayerRange(int layer) throws LayerOutOfRangeException {
        if (layer < 0 || layer >= this.getLayerCount()) {
            throw new LayerOutOfRangeException(layer, this.getLayerCount());
        }
    }

    public boolean unlock(String insertCol) throws TransformException {
        if (insertCol == null) {
            this.unlock();
            return true;
        }
        if (this.containsColumn(insertCol)) {
            this.unlock();
            return true;
        }
        return false;
    }

    public void lock() {
        this.m_locked = true;
    }

    public boolean isLocked() {
        return this.m_locked;
    }

    public long getExtent() throws TransformException {
        return this.m_root.getSpan();
    }

    public EdgeTreeNode getRoot() {
        return this.m_root;
    }

    public EdgeTreeNode findNode(String[] values) throws TransformException {
        EdgeTreeNode currNode = this.m_root;
        int i = 0;
        while (i < values.length) {
            if (values[i] == null) {
                if (currNode == this.m_root) {
                    return null;
                }
                return currNode;
            }
            if ((currNode = currNode.findChild(values[i])) == null) {
                return null;
            }
            ++i;
        }
        return currNode;
    }

    public String[] getHPosValues(long[] hPos) throws TransformException {
        if (hPos == null) {
            return null;
        }
        String[] retVal = new String[hPos.length];
        EdgeTreeNode currNode = this.m_root;
        int i = 0;
        while (i < hPos.length) {
            if ((currNode = currNode.getChild(hPos[i])) == null) break;
            retVal[i] = currNode.getMember() != null ? currNode.getMember().getValue() : null;
            ++i;
        }
        return retVal;
    }

    public String[] getSliceValues(long slice) throws TransformException {
        ArrayList<String> vals = new ArrayList<String>();
        EdgeTreeNode currNode = this.m_root;
        while (currNode != null) {
            if ((currNode = currNode.findChild(slice, EdgeTreeNode.GetSlice.GET_ALL_SLICES)) == null) continue;
            vals.add(currNode.getMember().getValue());
        }
        return vals.toArray(new String[0]);
    }

    public boolean hasSlice(EdgeTreeNode node, long slice) throws TransformException {
        if (node == null) {
            return this.m_root.findChild(slice, EdgeTreeNode.GetSlice.GET_NO_SLICES) != null;
        }
        return node.findChild(slice, EdgeTreeNode.GetSlice.GET_NO_SLICES) != null;
    }

    public LayerAndMember getHPosMembers(long[] hPos) throws TransformException {
        if (hPos == null) {
            return null;
        }
        ArrayList<TreeNodeWrapperMemberInterface> members = new ArrayList<TreeNodeWrapperMemberInterface>();
        ArrayList<String> layers = new ArrayList<String>();
        EdgeTreeNode currNode = this.m_root;
        int i = 0;
        while (i < hPos.length) {
            if (hPos[i] > (long)-1) {
                if ((currNode = currNode.getChild(hPos[i])) == null) break;
                members.add(currNode.getMember());
                layers.add(currNode.getLayerName());
            }
            ++i;
        }
        return new LayerAndMember(layers.toArray(new String[0]), this._getMemberArray(members));
    }

    public MemberInterface[] getMembers(long slice) throws SliceOutOfRangeException, TransformException {
        int layerCount = this.getLayerCount();
        MemberInterface[] retVal = new MemberInterface[layerCount];
        EdgeTreeNode currNode = null;
        EdgeTreeNode prevNode = null;
        int l = 0;
        while (l < layerCount) {
            currNode = this.getNode(l, slice, EdgeTreeNode.GetSlice.GET_TO_SLICE);
            if (currNode == prevNode) {
                return retVal;
            }
            retVal[l] = currNode.getMember();
            prevNode = currNode;
            ++l;
        }
        return retVal;
    }

    public LayerAndMember getSliceMembers(long slice) throws SliceOutOfRangeException, TransformException {
        ArrayList<TreeNodeWrapperMemberInterface> vals = new ArrayList<TreeNodeWrapperMemberInterface>();
        ArrayList<String> layers = new ArrayList<String>();
        int layerCount = this.getLayerCount();
        EdgeTreeNode currNode = null;
        EdgeTreeNode prevNode = null;
        int l = 0;
        while (l < layerCount) {
            currNode = this.getNode(l, slice, EdgeTreeNode.GetSlice.GET_TO_SLICE);
            if (currNode != prevNode) {
                layers.add(currNode.getLayerName());
                vals.add(currNode.getMember());
            }
            prevNode = currNode;
            ++l;
        }
        return new LayerAndMember(layers.toArray(new String[0]), this._getMemberArray(vals));
    }

    private TreeNodeWrapperMemberInterface[] _getMemberArray(List<TreeNodeWrapperMemberInterface> members) {
        int size = members.size();
        TreeNodeWrapperMemberInterface[] retVal = new TreeNodeWrapperMemberInterface[size];
        int i = 0;
        while (i < size) {
            retVal[i] = members.get(i);
            ++i;
        }
        return retVal;
    }

    public int getDepth(int layer, long slice) throws TransformException {
        EdgeTreeNode node = this.m_root;
        int depth = 0;
        int physLayer = 0;
        while (node != null && (layer == -1 || layer != -1 && physLayer < layer)) {
            ++physLayer;
            if ((node = node.findChild(slice, EdgeTreeNode.GetSlice.GET_ALL_SLICES)) == null || node.getMember() == null) continue;
            ++depth;
        }
        return depth;
    }

    public long getSpan(int layer, long slice) throws TransformException, SliceOutOfRangeException {
        EdgeTreeNode node = this.getNode(layer, slice, EdgeTreeNode.GetSlice.GET_TO_SLICE);
        if (node != null) {
            return node.getSpan();
        }
        return 0L;
    }

    public long getStart(int layer, long slice) throws TransformException, SliceOutOfRangeException {
        EdgeTreeNode node = this.getNode(layer, slice, EdgeTreeNode.GetSlice.GET_ALL_SLICES);
        if (node != null) {
            return node.getStart(EdgeTreeNode.GetSlice.GET_ALL_SLICES, -1);
        }
        return slice;
    }

    public EdgeTreeNode getNode(long[] hPos, int memberLayer, long hIndex) throws TransformException {
        EdgeTreeNode currNode = this.m_root;
        EdgeTreeNode temp = null;
        int i = 0;
        while (i <= memberLayer) {
            temp = currNode.getChild(i == memberLayer || hPos == null ? hIndex : hPos[i]);
            if (temp == null) {
                return currNode;
            }
            currNode = temp;
            ++i;
        }
        return currNode;
    }

    /*
     * Unable to fully structure code
     */
    public EdgeTreeNode getNode(int layer, long slice, EdgeTreeNode.GetSlice get) throws TransformException, SliceOutOfRangeException {
        if (slice < 0L || slice >= this.getExtent()) {
            throw new SliceOutOfRangeException((int)slice, (int)this.getExtent());
        }
        node = this.m_root;
        lastNonNullNode = this.m_root;
        i = 0;
        while (i <= layer) {
            if (node == null) break;
            lastNonNullNode = node;
            node = node.findChild(slice, get);
            ++i;
        }
        if (node != null) ** GOTO lbl16
        return lastNonNullNode.isRoot() != false ? null : lastNonNullNode;
lbl-1000:
        // 1 sources

        {
            --layer;
            node = node.getParent();
lbl16:
            // 2 sources

            ** while (node != null && node != this.m_root && node.getMember() == null)
        }
lbl17:
        // 1 sources

        return node;
    }

    public int getLowestLayer(long slice) throws TransformException, SliceOutOfRangeException {
        EdgeTreeNode node = this.getNode(this.getLayerCount() - 1, slice, EdgeTreeNode.GetSlice.GET_ALL_SLICES);
        return this.getLayer(node.getLayerName());
    }

    public EdgeTreeNode getFirstLeafNode() throws TransformException {
        EdgeTreeNode node = this.m_root;
        while (!node.isLeaf()) {
            node = node.getFirstChild();
        }
        return node;
    }

    public EdgeTreeNode getLastLeafNode() throws TransformException {
        EdgeTreeNode node = this.m_root;
        while (!node.isLeaf()) {
            node = node.getLastChild();
        }
        return node;
    }

    public EdgeTreeNode getPreviousLeafNode(long[] hPos) throws TransformException {
        EdgeTreeNode thisNode = this.getNode(hPos, hPos.length - 1, hPos[hPos.length - 1]);
        do {
            if (thisNode.getPosition() <= 0L || thisNode.getParent() == null) continue;
            return thisNode.getParent().getChild(thisNode.getPosition() - 1L).getLastLeaf();
        } while ((thisNode = thisNode.getParent()) != null);
        return null;
    }

    public EdgeTreeNode getNextLeafNode(long[] hPos) throws TransformException {
        EdgeTreeNode thisNode = this.getNode(hPos, hPos.length - 1, hPos[hPos.length - 1]);
        do {
            if (thisNode.getParent() == null || thisNode.getPosition() >= thisNode.getParent().getChildCount() - 1L) continue;
            EdgeTreeNode child = thisNode.getParent().getChild(thisNode.getPosition() + 1L);
            return child != null ? child.getFirstLeaf() : null;
        } while ((thisNode = thisNode.getParent()) != null);
        return null;
    }

    public int getStartLayer(int layer, long slice) throws TransformException, SliceOutOfRangeException {
        EdgeTreeNode node = this.getNode(layer, slice, EdgeTreeNode.GetSlice.GET_TO_SLICE);
        return this.getLayer(node.getLayerName());
    }

    public int getNodeSize(int layer, long slice) throws TransformException, SliceOutOfRangeException {
        EdgeTreeNode thisNode = this.getNode(layer, slice, EdgeTreeNode.GetSlice.GET_ALL_SLICES);
        int layerNum = this.getLayer(thisNode.getLayerName());
        if (thisNode.getFirstChild() == null) {
            return this.getLayerCount() - layerNum;
        }
        int nextLayer = this.getLayer(thisNode.getFirstChild().getLayerName());
        return nextLayer - layerNum;
    }

    public RowInfo[] addRow(Row rowData, String[] actualTableNodes, InsertInfo insertInfo, boolean alwaysAdd) throws TransformException {
        EdgeTreeNode currNode = this.m_root;
        EdgeTreeNode temp = null;
        String layerName = null;
        if (this.m_layers == null) {
            return null;
        }
        boolean inserting = false;
        if (actualTableNodes == null) {
            return null;
        }
        MemberWrapper[] newNodeValues = new MemberWrapper[actualTableNodes.length];
        String dimName = null;
        boolean isInsertingTotalMember = false;
        TreeNodeWrapperMemberInterface member = null;
        int layer = 0;
        while (layer < actualTableNodes.length) {
            block22: {
                block23: {
                    block20: {
                        block21: {
                            block13: {
                                member = null;
                                layerName = actualTableNodes[layer];
                                dimName = this.m_layers[layer].getName();
                                if (!layerName.equals(this.m_measDim) || alwaysAdd) break block13;
                                int measCount = this.m_measList != null ? this.m_measList.length : 0;
                                RowInfo[] retRowInfo = new RowInfo[measCount];
                                MemberWrapper[][] measMembers = new MemberWrapper[measCount][];
                                EdgeTreeNode subCurrent = null;
                                int m = 0;
                                while (m < this.m_measList.length) {
                                    block15: {
                                        block14: {
                                            isInsertingTotalMember = false;
                                            member = null;
                                            measMembers[m] = new MemberWrapper[newNodeValues.length];
                                            System.arraycopy(newNodeValues, 0, measMembers[m], 0, newNodeValues.length);
                                            inserting = false;
                                            subCurrent = this._findAndAddNode(rowData, this.m_measList[m], dimName, currNode, true, inserting, insertInfo, alwaysAdd);
                                            if (subCurrent != null) break block14;
                                            if (insertInfo != null) {
                                                return null;
                                            }
                                            break block15;
                                        }
                                        measMembers[m][layer] = new MemberWrapper(subCurrent.getMember());
                                        int l = layer + 1;
                                        while (l < actualTableNodes.length) {
                                            block18: {
                                                block19: {
                                                    block16: {
                                                        block17: {
                                                            member = null;
                                                            layerName = actualTableNodes[l];
                                                            if (isInsertingTotalMember) break block16;
                                                            isInsertingTotalMember = rowData.getMember(layerName).getMemberInterface() instanceof TotalMember ? ((TotalMember)rowData.getMember(layerName).getMemberInterface()).isReplacement() ^ true : false;
                                                            inserting = false;
                                                            temp = this._findAndAddNode(rowData, layerName, this.m_layers[l].getName(), subCurrent, false, inserting, insertInfo, alwaysAdd);
                                                            if (temp != null) break block17;
                                                            if (insertInfo != null) {
                                                                return null;
                                                            }
                                                            break block18;
                                                        }
                                                        subCurrent = temp;
                                                        member = subCurrent.getMember();
                                                        break block19;
                                                    }
                                                    if (!(rowData.getMember(layerName).getMemberInterface() instanceof TotalMember)) {
                                                        member = new TreeNodeWrapperMemberInterface(rowData.getMember(layerName).getMemberInterface());
                                                    }
                                                }
                                                if (member != null) {
                                                    measMembers[m][l] = new MemberWrapper(member);
                                                }
                                            }
                                            ++l;
                                        }
                                        retRowInfo[m] = new RowInfo(this._removeNulls(measMembers[m]), true);
                                    }
                                    ++m;
                                }
                                return retRowInfo;
                            }
                            if (isInsertingTotalMember) break block20;
                            isInsertingTotalMember = rowData.getMember(layerName).getMemberInterface() instanceof TotalMember ? ((TotalMember)rowData.getMember(layerName).getMemberInterface()).isReplacement() ^ true : false;
                            inserting = false;
                            temp = this._findAndAddNode(rowData, layerName, dimName, currNode, false, inserting, insertInfo, alwaysAdd);
                            if (temp != null) break block21;
                            if (insertInfo != null) {
                                return null;
                            }
                            break block22;
                        }
                        currNode = temp;
                        member = currNode.getMember();
                        break block23;
                    }
                    if (!(rowData.getMember(layerName).getMemberInterface() instanceof TotalMember)) {
                        member = new TreeNodeWrapperMemberInterface(rowData.getMember(layerName).getMemberInterface());
                    }
                }
                if (member != null) {
                    newNodeValues[layer] = new MemberWrapper(member);
                }
            }
            ++layer;
        }
        if (this.m_layers.length == 0) {
            return null;
        }
        newNodeValues = this._removeNulls(newNodeValues);
        return new RowInfo[]{new RowInfo(newNodeValues, false)};
    }

    private MemberWrapper[] _removeNulls(MemberWrapper[] newNodeValues) {
        if (newNodeValues != null && newNodeValues.length > 0) {
            Vector<MemberWrapper> tempNodeValues = new Vector<MemberWrapper>();
            int i = 0;
            while (i < newNodeValues.length) {
                if (newNodeValues[i] != null) {
                    tempNodeValues.addElement(newNodeValues[i]);
                }
                ++i;
            }
            if (newNodeValues.length != tempNodeValues.size()) {
                newNodeValues = new MemberWrapper[tempNodeValues.size()];
                int i2 = 0;
                while (i2 < newNodeValues.length) {
                    newNodeValues[i2] = (MemberWrapper)tempNodeValues.elementAt(i2);
                    ++i2;
                }
            }
        }
        return newNodeValues;
    }

    private EdgeTreeNode _findAndAddNode(Row rowData, String colName, String dimName, EdgeTreeNode currNode, boolean isMeasure, boolean inserting, InsertInfo insertInfo, boolean alwaysAdd) throws TransformException {
        QDRMember qdrmember;
        QDRInterface qdr;
        Object actualColumn = null;
        String insertLocationValue = null;
        boolean above = false;
        if (inserting) {
            colName = actualColumn;
        }
        MemberInterface member = null;
        if (isMeasure) {
            MemberInterface[] dataItems = this.m_projection.getDataItems();
            int i = 0;
            while (i < dataItems.length) {
                if (colName.equals(dataItems[i].getValue())) {
                    member = dataItems[i];
                    break;
                }
                ++i;
            }
        } else {
            member = rowData.getMember(colName).getMemberInterface();
        }
        if (member == null) {
            return null;
        }
        EdgeTreeNode childNode = null;
        if (inserting) {
            childNode = currNode.findChild(insertLocationValue);
        } else {
            String currValue = member.getValue();
            if (!alwaysAdd) {
                childNode = currNode.findChild(currValue);
            }
        }
        if (!inserting && insertInfo != null && (qdr = insertInfo.getQDR()) != null && (qdrmember = qdr.getDimMember(dimName)) != null && qdrmember.getData() != null && !qdrmember.getData().equals(childNode != null ? childNode.getMember().getValue() : null)) {
            return null;
        }
        if (childNode == null || inserting) {
            if (rowData instanceof TotalRow && !inserting) {
                above = ((TotalRow)rowData).getAggLocation() == AggLocation.BEFORE;
            }
            childNode = currNode.addChild(this.getEdgeTreeNode(false, currNode, member, null, dimName), null, inserting ? insertLocationValue : null, above, alwaysAdd);
        }
        return childNode;
    }

    public class RowInfo {
        protected MemberWrapper[] m_values;
        protected boolean m_hasMeasure;

        private void $init$() {
            this.m_values = null;
            this.m_hasMeasure = false;
        }

        public RowInfo(MemberWrapper[] values, boolean hasMeasure) {
            this.$init$();
            this.m_values = values;
            this.m_hasMeasure = hasMeasure;
        }

        public MemberWrapper[] getValues() {
            return this.m_values;
        }

        public Object getValue(int i) {
            return this.getValues()[i];
        }

        public boolean hasMeasure() {
            return this.m_hasMeasure;
        }
    }
}

