/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.transform;

import java.util.Hashtable;
import java.util.Map;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.InsertableTreeDataAccess;
import oracle.dss.util.transform.BaseProjection;
import oracle.dss.util.transform.CommonTreeBasedCubicDataAccess;
import oracle.dss.util.transform.CommonTreeProjection;
import oracle.dss.util.transform.Cube;
import oracle.dss.util.transform.DataCellInterface;
import oracle.dss.util.transform.EdgeTreeProjection;
import oracle.dss.util.transform.LayerInterface;
import oracle.dss.util.transform.MemberInterface;
import oracle.dss.util.transform.StackPack;
import oracle.dss.util.transform.TransformException;
import oracle.dss.util.transform.TreeBasedEdgeTree;
import oracle.dss.util.transform.TreeNode;

public class EdgeTreeBasedCubicDataAccess
extends CommonTreeBasedCubicDataAccess
implements InsertableTreeDataAccess {
    protected CommonTreeProjection[] m_projection;
    protected StackPack[] m_stackPack;

    private void $init$() {
        this.m_projection = null;
        this.m_stackPack = null;
    }

    public EdgeTreeBasedCubicDataAccess(EdgeTreeProjection[] projection) throws TransformException {
        super(false);
        this.$init$();
        this.init(projection, this.m_alwaysAdd);
    }

    public EdgeTreeBasedCubicDataAccess(EdgeTreeProjection[] projection, boolean cache) throws TransformException {
        super(cache);
        this.$init$();
        this.init(projection, this.m_alwaysAdd);
    }

    protected EdgeTreeBasedCubicDataAccess(boolean cache) throws TransformException {
        super(cache);
        this.$init$();
    }

    public Object clone() throws CloneNotSupportedException {
        EdgeTreeBasedCubicDataAccess da = (EdgeTreeBasedCubicDataAccess)super.clone();
        da.m_layerEdge = (Hashtable)this.m_layerEdge.clone();
        if (this.m_stackPack != null) {
            da.m_stackPack = new StackPack[this.m_stackPack.length];
            int i = 0;
            while (i < this.m_stackPack.length) {
                if (this.m_stackPack[i] != null) {
                    da.m_stackPack[i] = (StackPack)this.m_stackPack[i].clone();
                }
                ++i;
            }
        }
        return da;
    }

    protected void init(EdgeTreeProjection[] projection, boolean[] alwaysAdd) throws TransformException {
        this.m_cube = new Cube();
        this.initCaches();
        this.m_projection = new EdgeTreeProjection[projection.length];
        this.m_stackPack = new StackPack[projection.length];
        int e = 0;
        while (e < projection.length) {
            TreeNode nodes;
            this.m_projection[e] = projection[e].getDataItems() != null ? new ImpliedMeasureEdgeTreeProjection(projection[e]) : projection[e];
            if (projection[e] != null && (nodes = this.m_projection[e].getNodeTree()) != null) {
                if (this.m_stackPack[e] == null) {
                    this.m_stackPack[e] = new StackPack();
                }
                this.buildTree(nodes, this.m_stackPack[e], e, -1, null, alwaysAdd);
            }
            ++e;
        }
        this.m_cube.lockTrees();
    }

    protected LayerInterface getDataLayerInterface() {
        int e = 0;
        while (e < this.m_projection.length) {
            if (this.m_projection[e] != null) {
                return this.m_projection[e].getDataLayer();
            }
            ++e;
        }
        return null;
    }

    protected BaseProjection getProjection() {
        int e = 0;
        while (e < this.m_projection.length) {
            if (this.m_projection[e] != null) {
                return this.m_projection[e];
            }
            ++e;
        }
        return null;
    }

    protected TreeBasedEdgeTree getEdgeTree(int edge) throws TransformException {
        BaseProjection proj = this.getProjection();
        return new TreeBasedEdgeTree(this._getLayers(edge), edge, proj, proj.getDataLayer().getValue(), this.getMeasList(proj), this.isNoCollapsedLeaves(edge), -1, this);
    }

    private boolean isNoCollapsedLeaves(int edge) {
        if (this.m_projection[edge] instanceof EdgeTreeProjection) {
            return ((EdgeTreeProjection)this.m_projection[edge]).isNoCollapseLeaves();
        }
        return true;
    }

    protected TreeBasedEdgeTree getEdgeTree(TreeNode node, long slice, boolean checked) throws TransformException {
        int edge = this.getEdgeForLayer(node);
        TreeBasedEdgeTree et = null;
        try {
            et = (TreeBasedEdgeTree)super.getEdgeTree(edge, slice, checked);
        }
        catch (EdgeOutOfRangeException e) {
            throw new TransformException(e.getMessage(), e);
        }
        if (et == null) {
            et = this.getEdgeTree(edge);
            this.m_cube.setEdgeTree(edge, et);
        }
        return et;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ImpliedMeasureEdgeTreeProjection
    extends CommonTreeBasedCubicDataAccess.ImpliedMeasureCommonTreeProjection
    implements EdgeTreeProjection {
        protected EdgeTreeProjection m_proj;
        protected CommonTreeBasedCubicDataAccess.ImpliedMeasureTreeNode m_node;
        protected String[][] m_layout;
        protected int m_impliedMeasureEdge;

        private void $init$() {
            this.m_proj = null;
            this.m_node = null;
            this.m_layout = null;
            this.m_impliedMeasureEdge = -1;
        }

        public ImpliedMeasureEdgeTreeProjection(EdgeTreeProjection proj) {
            super(proj);
            this.$init$();
            this.m_proj = proj;
        }

        @Override
        protected int findBottom() throws TransformException {
            String[][] layout = this.m_proj.getLayout();
            if (layout == null) {
                return -1;
            }
            return this.walkTree(layout, this.m_proj.getNodeTree());
        }

        @Override
        protected int getNewLength(String[][] origLayout) {
            return origLayout.length;
        }

        @Override
        public LayerInterface getDataLayer() {
            return this.m_proj.getDataLayer();
        }

        @Override
        public MemberInterface[] getDataItems() {
            return this.m_proj.getDataItems();
        }

        @Override
        public DataCellInterface getData(Map<String, Object> keyPath) {
            return this.m_proj.getData(keyPath);
        }

        @Override
        public TreeNode getNodeTree() {
            if (this.m_node == null) {
                this.m_node = new CommonTreeBasedCubicDataAccess.ImpliedMeasureTreeNode(this.m_proj.getNodeTree(), this);
            }
            return this.m_node;
        }

        @Override
        public boolean isNoCollapseLeaves() {
            return true;
        }
    }
}

