/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.transform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import oracle.dss.util.Utility;
import oracle.dss.util.transform.CommonComparator;
import oracle.dss.util.transform.ComparatorInterface;
import oracle.dss.util.transform.DataAccessLong;
import oracle.dss.util.transform.EdgeTree;
import oracle.dss.util.transform.EdgeTreeNode;
import oracle.dss.util.transform.MemberInterface;
import oracle.dss.util.transform.TransformException;
import oracle.dss.util.transform.TransformRuntimeException;
import oracle.dss.util.transform.TreeNode;
import oracle.dss.util.transform.TreeNodeWrapperMemberInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdgeTreeChildren
extends ArrayList<EdgeTreeNode>
implements Cloneable {
    private Hashtable<String, EdgeTreeNode[]> m_lookupTable;

    private void $init$() {
        this.m_lookupTable = new Hashtable();
    }

    public Object clone(EdgeTree tree, EdgeTreeNode parent, boolean caching) throws CloneNotSupportedException {
        EdgeTreeChildren children = (EdgeTreeChildren)super.clone();
        children.clear();
        Iterator nodes = super.iterator();
        EdgeTreeNode newNode = null;
        while (nodes.hasNext()) {
            EdgeTreeNode node = (EdgeTreeNode)nodes.next();
            if (node != null) {
                newNode = (EdgeTreeNode)node.clone(tree, parent, caching);
                children.add(newNode);
                continue;
            }
            children.add(null);
        }
        children.m_lookupTable = null;
        return children;
    }

    @Override
    public boolean add(EdgeTreeNode node) {
        if (this.duplicate(super.size() - 1, node)) {
            return false;
        }
        boolean retVal = super.add(node);
        try {
            if (node != null) {
                String value = node.getMember().getValue();
                this._updateLookupTable(value, node);
            }
        }
        catch (TransformException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
        return retVal;
    }

    private void _updateLookupTable(String value, EdgeTreeNode location) {
        if (this.m_lookupTable == null) {
            return;
        }
        EdgeTreeNode[] locs = value != null ? this.m_lookupTable.get(value) : null;
        EdgeTreeNode[] newLocs = null;
        if (locs == null) {
            locs = new EdgeTreeNode[]{location};
            newLocs = locs;
        } else {
            newLocs = new EdgeTreeNode[locs.length + 1];
            System.arraycopy(locs, 0, newLocs, 0, locs.length);
            newLocs[locs.length] = location;
        }
        if (value != null) {
            this.m_lookupTable.put(value, newLocs);
        }
    }

    private boolean duplicate(int pos, EdgeTreeNode node) {
        if (pos != -1 && pos < super.size()) {
            EdgeTreeNode existingNode = (EdgeTreeNode)super.get(pos);
            if (node != null && node.equals(existingNode)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void add(int pos, EdgeTreeNode node) {
        if (this.duplicate(pos, node)) {
            return;
        }
        super.add(pos, node);
        if (node != null) {
            try {
                String value = node.getMember().getValue();
                this._updateLookupTable(value, node);
            }
            catch (TransformException e) {
                throw new TransformRuntimeException(e.getMessage(), e);
            }
        }
    }

    public void release() {
        for (EdgeTreeNode node : this) {
            node.release();
        }
        this.clear();
    }

    protected EdgeTreeNode getChild(long pos) {
        if (pos > (long)-1 && pos < (long)this.size()) {
            return (EdgeTreeNode)this.get((int)pos);
        }
        return null;
    }

    public EdgeTreeNode addChild(EdgeTreeNode childNode, TreeNode treeNode, String insertLocation, boolean above, boolean alwaysAdd) throws TransformException {
        EdgeTreeNode alreadyThereNode = this.findChild(childNode);
        if (alreadyThereNode != null && !alwaysAdd) {
            return alreadyThereNode;
        }
        if (insertLocation != null) {
            EdgeTreeNode node = this.findChild(insertLocation);
            if (node != null) {
                long index = node.getPosition();
                if (above) {
                    this._addChild(childNode, treeNode, (int)index);
                } else {
                    this._addChild(childNode, treeNode, (int)index + 1);
                }
            }
        } else {
            this._simpleAddChild(childNode, treeNode, above);
        }
        return childNode;
    }

    private void _simpleAddChild(EdgeTreeNode node, TreeNode treeNode, boolean above) throws TransformException {
        if (node.isTotalNode()) {
            if (above) {
                this._addChild(node, treeNode, 0);
            } else {
                this._addChild(node, treeNode, -1);
            }
        } else {
            int locToInsert = this._getLocationToInsert(above);
            this._addChild(node, treeNode, locToInsert);
        }
    }

    private void _addChild(EdgeTreeNode nodeToAdd, TreeNode node, int pos) throws TransformException {
        if (pos != -1) {
            this.add(pos, nodeToAdd);
        } else {
            this.add(nodeToAdd);
        }
        if (nodeToAdd.needAggregateSibling()) {
            boolean before;
            EdgeTreeNode aggSiblingNode = nodeToAdd.m_tree.getEdgeTreeNode(true, nodeToAdd.getParent(), nodeToAdd.m_value, node, nodeToAdd.getLayerName());
            boolean bl = before = nodeToAdd.getAggregatePosition() == MemberInterface.AggregatePosition.BEFORE;
            if (pos != -1) {
                if (before) {
                    this.add(pos, aggSiblingNode);
                } else {
                    this.add(pos + 1, aggSiblingNode);
                }
            } else if (before) {
                this.add(this.size() - 1, aggSiblingNode);
            } else {
                this.add(aggSiblingNode);
            }
        }
    }

    private int _getLocationToInsert(boolean above) {
        int size;
        int pos = 0;
        if (above) {
            for (EdgeTreeNode node : this) {
                if (!node.isTotalNode()) {
                    return pos;
                }
                ++pos;
            }
            return pos;
        }
        pos = size = this.size();
        int i = size - 1;
        while (i >= 0) {
            if (!((EdgeTreeNode)this.get(i)).isTotalNode()) {
                return pos;
            }
            --pos;
            --i;
        }
        return 0;
    }

    protected void addAggregateSibling(EdgeTreeNode node, TreeNode treeNode, int pos) throws TransformException {
        if (node.needAggregateSibling()) {
            boolean before;
            EdgeTreeNode aggSiblingNode = node.m_tree.getEdgeTreeNode(true, node.getParent(), node.m_value, treeNode, node.getLayerName());
            node.setAllSibling(aggSiblingNode);
            boolean bl = before = node.getAggregatePosition() == MemberInterface.AggregatePosition.BEFORE;
            if (pos != -1) {
                if (before) {
                    this.add(pos, aggSiblingNode);
                } else {
                    this.add(pos + 1, aggSiblingNode);
                }
            } else if (before) {
                this.add(this.size() - 1, aggSiblingNode);
            } else {
                this.add(aggSiblingNode);
            }
        }
    }

    public EdgeTreeNode findChild(String value) throws TransformException {
        if (this.m_lookupTable == null) {
            Iterator children = this.iterator();
            EdgeTreeNode currNode = null;
            while (children.hasNext()) {
                currNode = (EdgeTreeNode)children.next();
                if (!Utility.compareObj(value, currNode.getMember().getValue())) continue;
                return currNode;
            }
            return null;
        }
        EdgeTreeNode[] locs = this.m_lookupTable.get(value);
        if (locs != null) {
            int i = 0;
            while (i < locs.length) {
                if (value.equals(locs[i].getMember().getValue())) {
                    return locs[i];
                }
                ++i;
            }
        }
        return null;
    }

    public EdgeTreeNode findChild(EdgeTreeNode value) throws TransformException {
        if (this.m_lookupTable == null || value.getMember() == null || value.getMember().getValue() == null) {
            Iterator children = this.iterator();
            EdgeTreeNode currNode = null;
            while (children.hasNext()) {
                currNode = (EdgeTreeNode)children.next();
                if (!Utility.compareObj(value, currNode)) continue;
                return currNode;
            }
            return null;
        }
        EdgeTreeNode[] locs = this.m_lookupTable.get(value.getMember().getValue());
        if (locs != null) {
            int i = 0;
            while (i < locs.length) {
                if (value.equals(locs[i])) {
                    return locs[i];
                }
                ++i;
            }
        }
        return null;
    }

    public EdgeTreeNode findChild(String value, boolean nonAggregateOnly) throws TransformException {
        if (this.m_lookupTable != null && !this.m_lookupTable.isEmpty() && value != null) {
            EdgeTreeNode[] locs = this.m_lookupTable.get(value);
            if (locs != null) {
                int i = 0;
                while (i < locs.length) {
                    if (nonAggregateOnly) {
                        if (!locs[i].isAggregateNodeType()) {
                            return locs[i];
                        }
                    } else {
                        return locs[i];
                    }
                    ++i;
                }
            }
        } else {
            Iterator children = this.iterator();
            EdgeTreeNode currNode = null;
            while (children.hasNext()) {
                currNode = (EdgeTreeNode)children.next();
                if (!Utility.compareObj(value, currNode.getMember().getValue())) continue;
                if (nonAggregateOnly) {
                    if (currNode.isAggregateNodeType()) continue;
                    return currNode;
                }
                return currNode;
            }
        }
        return null;
    }

    public EdgeTreeNode findChild(long slice, EdgeTreeNode.GetSlice get) throws TransformException {
        long m = 0L;
        long lower = 0L;
        long upper = this.size() - 1;
        FoundState foundState = FoundState.FOUND;
        while (upper >= 0L) {
            m = (lower + upper) / (long)2;
            foundState = this._foundChild(m, slice, get);
            if (foundState == FoundState.FOUND) {
                EdgeTreeNode child = this.getChild(m);
                if (child != null && slice < child.getStart(EdgeTreeNode.GetSlice.GET_NO_SLICES, slice) + child.getSpan()) {
                    return child;
                }
                return null;
            }
            if (foundState == FoundState.HIGH) {
                lower = m + 1L;
                continue;
            }
            upper = m - 1L;
        }
        return null;
    }

    private FoundState _foundChild(long childLoc, long slice, EdgeTreeNode.GetSlice get) throws TransformException {
        EdgeTreeNode childNode = this.getChild(childLoc);
        long childStart = childNode.getStart(get, -1);
        if (slice == childStart) {
            return FoundState.FOUND;
        }
        if (slice < childStart) {
            return FoundState.LOW;
        }
        EdgeTreeNode nextChild = this.getChild(childLoc + 1L);
        if (nextChild == null) {
            return FoundState.FOUND;
        }
        long nextChildStart = nextChild.getStart(get, -1);
        return slice < nextChildStart ? FoundState.FOUND : FoundState.HIGH;
    }

    private boolean isTotal(EdgeTreeNode node) {
        if (node.isAggregateNodeType()) {
            return true;
        }
        TreeNodeWrapperMemberInterface mi = node.getMember();
        return mi != null ? mi.isTotal() : false;
    }

    public void sort(int sortDir, boolean nullsFirst, DataAccessLong da, int edge, long slice) throws TransformException {
        EdgeNodeSortElement[] children = new EdgeNodeSortElement[super.size()];
        int childCount = 0;
        Iterator iter = super.iterator();
        EdgeTreeNode node = null;
        long otherSlice = -1;
        boolean aggsFirst = false;
        ArrayList<EdgeTreeNode> removeList = new ArrayList<EdgeTreeNode>();
        try {
            while (iter.hasNext()) {
                node = (EdgeTreeNode)iter.next();
                if (!this.isTotal(node)) {
                    otherSlice = node.getStart(EdgeTreeNode.GetSlice.GET_ALL_SLICES, -1);
                    Object dataVal = edge == 0 ? da.getValue(slice, otherSlice, "dataValue") : da.getValue(otherSlice, slice, "dataValue");
                    children[childCount++] = new EdgeNodeSortElement(node, dataVal);
                    removeList.add(node);
                    continue;
                }
                boolean bl = aggsFirst = childCount == 0;
            }
        }
        catch (Exception e) {
            throw new TransformException(e.getMessage(), e);
        }
        iter = removeList.iterator();
        while (iter.hasNext()) {
            super.remove((EdgeTreeNode)iter.next());
        }
        if (childCount != children.length) {
            EdgeNodeSortElement[] newChildren = new EdgeNodeSortElement[childCount];
            System.arraycopy(children, 0, newChildren, 0, newChildren.length);
            children = newChildren;
        }
        Arrays.sort(children, new CommonComparator(sortDir, nullsFirst));
        if (aggsFirst) {
            int i = 0;
            while (i < children.length) {
                super.add(children[i].m_node);
                ++i;
            }
        } else {
            int i = children.length - 1;
            while (i >= 0) {
                super.add(0, children[i].m_node);
                --i;
            }
        }
        if (this.m_lookupTable != null) {
            this.m_lookupTable.clear();
        }
    }

    public EdgeTreeNode getLastChild() {
        return this.getChild(this.size() - 1);
    }

    public void deleteChild(EdgeTreeNode node) {
        this.remove(node);
    }

    public void invalidate() throws TransformException {
        Iterator children = this.iterator();
        EdgeTreeNode currNode = null;
        while (children.hasNext()) {
            currNode = (EdgeTreeNode)children.next();
            currNode.invalidate();
        }
    }

    public void clearStart() throws TransformException {
        Iterator children = this.iterator();
        EdgeTreeNode currNode = null;
        while (children.hasNext()) {
            currNode = (EdgeTreeNode)children.next();
            currNode.clearStart();
        }
    }

    public void unlock() throws TransformException {
        Iterator children = this.iterator();
        EdgeTreeNode currNode = null;
        while (children.hasNext()) {
            currNode = (EdgeTreeNode)children.next();
            currNode.unlock();
        }
    }

    public EdgeTreeChildren() {
        this.$init$();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FoundState
    extends Enum<FoundState> {
        private static final /* synthetic */ FoundState[] $v;
        public static final /* enum */ FoundState FOUND;
        public static final /* enum */ FoundState LOW;
        public static final /* enum */ FoundState HIGH;

        public static FoundState valueOf(String string) {
            return Enum.valueOf(FoundState.class, string);
        }

        public static final FoundState[] values() {
            return (FoundState[])$v.clone();
        }

        static {
            FoundState[] foundStateArray = new FoundState[3];
            foundStateArray[2] = HIGH = new FoundState("HIGH", 2);
            foundStateArray[1] = LOW = new FoundState("LOW", 1);
            foundStateArray[0] = FOUND = new FoundState("FOUND", 0);
            $v = foundStateArray;
        }

        private FoundState(String string2, int n2) {
        }
    }

    protected class EdgeNodeSortElement
    implements ComparatorInterface {
        protected EdgeTreeNode m_node;
        protected Object m_data;

        private void $init$() {
            this.m_node = null;
            this.m_data = null;
        }

        public EdgeNodeSortElement(EdgeTreeNode node, Object data) {
            this.$init$();
            this.m_node = node;
            this.m_data = data;
        }

        public Object getValue() {
            return this.m_data;
        }
    }
}

