/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.transform;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dss.util.Utility;
import oracle.dss.util.transform.EdgeTree;
import oracle.dss.util.transform.EdgeTreeBasedCubicDataAccess;
import oracle.dss.util.transform.EdgeTreeChildren;
import oracle.dss.util.transform.MemberInterface;
import oracle.dss.util.transform.TransformException;
import oracle.dss.util.transform.TreeNode;
import oracle.dss.util.transform.TreeNodeWrapperMemberInterface;
import oracle.dss.util.transform.total.TotalMember;

public class EdgeTreeNode
implements Cloneable {
    protected TreeNodeWrapperMemberInterface m_value;
    private EdgeTreeChildren m_children;
    private EdgeTreeChildren m_collapseChildren;
    protected long m_span;
    protected long m_start;
    protected EdgeTree m_tree;
    protected EdgeTreeNode m_parent;
    protected long m_myPos;
    protected String m_layerName;
    protected boolean m_isCollapsed;
    protected MemberInterface.AggregatePosition m_aggregatePosition;
    protected boolean m_aggregateNodeType;
    protected EdgeTreeNode m_myAllSibling;
    protected boolean m_isAggregateSibling;

    private void $init$() {
        this.m_value = null;
        this.m_children = new EdgeTreeChildren();
        this.m_collapseChildren = null;
        this.m_span = -1;
        this.m_start = -1;
        this.m_tree = null;
        this.m_parent = null;
        this.m_myPos = -1;
        this.m_layerName = null;
        this.m_isCollapsed = false;
        this.m_aggregatePosition = MemberInterface.AggregatePosition.NONE;
        this.m_aggregateNodeType = false;
        this.m_myAllSibling = null;
        this.m_isAggregateSibling = false;
    }

    public EdgeTreeNode(EdgeTree tree) {
        this.$init$();
        this.m_tree = tree;
    }

    public EdgeTreeNode(EdgeTree tree, boolean aggregateNodeType, EdgeTreeNode parent, MemberInterface value, String layerName) throws TransformException {
        this(tree);
        this.m_aggregateNodeType = aggregateNodeType;
        this.m_parent = parent;
        this.setValue(value);
        this.m_layerName = layerName;
        this.setIsOutline();
    }

    public Object clone(EdgeTree tree, EdgeTreeNode parent, boolean caching) throws CloneNotSupportedException {
        EdgeTreeNode node = (EdgeTreeNode)super.clone();
        node.m_children = (EdgeTreeChildren)this.m_children.clone(tree, node, caching);
        if (this.m_collapseChildren != null) {
            node.m_collapseChildren = (EdgeTreeChildren)this.m_collapseChildren.clone(tree, node, caching);
        }
        node.m_tree = tree;
        node.m_parent = parent;
        if (this.m_myAllSibling != null) {
            node.m_myAllSibling = (EdgeTreeNode)this.m_myAllSibling.clone(tree, parent, caching);
        }
        if (caching) {
            try {
                node.m_value = new TreeNodeWrapperMemberInterface(new MemberInterfaceCache(this.m_value));
            }
            catch (TransformException e) {
                throw new CloneNotSupportedException(e.getMessage());
            }
        }
        return node;
    }

    public int hashCode() {
        int hashCode = this.m_value != null ? this.m_value.hashCode() : 0;
        return hashCode + (this.m_isAggregateSibling ? 1 : 0);
    }

    public void release() {
        this.m_value = null;
        if (this.m_children != null) {
            this.m_children.release();
        }
        this.m_children = null;
        if (this.m_collapseChildren != null) {
            this.m_collapseChildren.release();
        }
        this.m_tree = null;
        this.m_parent = null;
        this.m_myAllSibling = null;
    }

    private void setIsOutline() throws TransformException {
        if (!this.m_tree.isOutline() && this.m_aggregateNodeType && this.m_value != null) {
            Object obj = this.m_value.getMetadata("isTotal");
            if (obj instanceof Boolean) {
                if (!((Boolean)obj).booleanValue()) {
                    this.m_tree.setOutline(true);
                }
            } else {
                this.m_tree.setOutline(true);
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof EdgeTreeNode) {
            EdgeTreeNode etn = (EdgeTreeNode)obj;
            if (this.m_value == null && etn.getMember() == null) {
                return true;
            }
            if (this.m_value == null) {
                return false;
            }
            if (etn.getMember() == null) {
                return false;
            }
            try {
                if (Utility.compareObj(this.m_value.getValue(), etn.getMember().getValue())) {
                    boolean bl = this.isAggregateNodeType() == etn.isAggregateNodeType();
                    return bl;
                }
            }
            catch (TransformException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return false;
    }

    protected void setAllSibling(EdgeTreeNode sibling) {
        this.m_myAllSibling = sibling;
        sibling.setIsAggregateSibling(true);
    }

    protected void setIsAggregateSibling(boolean isSibling) {
        this.m_isAggregateSibling = isSibling;
    }

    private boolean isCollapsed() throws TransformException {
        this.m_isCollapsed = this.m_value == null ? false : this.getIsCollapsed(this.m_value);
        return this.m_isCollapsed;
    }

    protected MemberInterface.AggregatePosition getAggregatePosition() throws TransformException {
        this.m_aggregatePosition = this.m_value == null ? MemberInterface.AggregatePosition.NONE : (MemberInterface.AggregatePosition)((Object)this.m_value.getMetadata("memberMetadataAggPosition"));
        return this.m_aggregatePosition;
    }

    public String getLayerName() {
        return this.m_layerName;
    }

    public EdgeTree getEdgeTree() {
        return this.m_tree;
    }

    public int getEdge() {
        return this.m_tree.getEdge();
    }

    protected EdgeTreeChildren getSearchableChildren(GetSlice get, long goToSlice) throws TransformException {
        if (this.isCollapsed()) {
            if (this.m_tree.isNoCollapseLeaves()) {
                return this.getCollapseChildren();
            }
            return new EdgeTreeChildren();
        }
        return this.getChildren(get, goToSlice);
    }

    private EdgeTreeChildren getCollapseChildren() throws TransformException {
        if (this.m_collapseChildren == null) {
            this.m_collapseChildren = this._gatherChildren(this, new EdgeTreeChildren());
        }
        return this.m_collapseChildren;
    }

    private EdgeTreeChildren _gatherChildren(EdgeTreeNode node, EdgeTreeChildren currentChildren) throws TransformException {
        if (node == null) {
            return currentChildren;
        }
        if (node.isModifiableLeaf() && currentChildren.findChild(node) == null) {
            currentChildren.add(node);
        }
        currentChildren = this._gatherChildren(node.getModifiableFirstChild(), currentChildren);
        currentChildren = this._gatherChildren(node.getModifiableNextSibling(), currentChildren);
        return currentChildren;
    }

    protected EdgeTreeChildren getModifiableChildren() throws TransformException {
        return this.m_children;
    }

    private EdgeTreeChildren getChildren(GetSlice get, long goToSlice) throws TransformException {
        EdgeTreeBasedCubicDataAccess da = null;
        switch (1.$sm$oracle$dss$util$transform$EdgeTreeNode$GetSlice[get.ordinal()]) {
            case 1: {
                return this.m_children;
            }
            case 2: {
                da = this.m_tree.getDataAccess();
                if (da == null) break;
                da.updateTree(this.getEdge(), -1, this);
                break;
            }
            case 3: {
                da = this.m_tree.getDataAccess();
                if (da == null) break;
                da.updateTree(this.getEdge(), goToSlice, this);
                break;
            }
        }
        return this.m_children;
    }

    protected void setValue(MemberInterface value) {
        this.m_value = new TreeNodeWrapperMemberInterface(value);
        if (this.m_value != null) {
            this.m_value.setEdgeTreeNode(this);
        }
    }

    protected void delete() throws TransformException {
        if (this.isRoot()) {
            return;
        }
        EdgeTreeNode parent = this.getParent();
        if (parent != null) {
            parent.deleteChild(this);
        }
        this.clearSpan();
        this.clearStarts();
        if (parent != null) {
            parent.clearStarts();
        }
    }

    protected void deleteChild(EdgeTreeNode node) throws TransformException {
        this.getModifiableChildren().deleteChild(node);
    }

    private void deleteSibling() throws TransformException {
        this.m_parent.deleteChild(this.m_myAllSibling);
    }

    private void insertSibling(TreeNode node) throws TransformException {
        EdgeTreeChildren parentChildren = this.m_parent.getModifiableChildren();
        parentChildren.addAggregateSibling(this, node, parentChildren.indexOf(this));
    }

    public void clearStarts() throws TransformException {
        EdgeTreeNode parent = this.getParent();
        while (parent != null) {
            EdgeTreeChildren parentChildren = parent.getModifiableChildren();
            int start = parentChildren.indexOf(this);
            long childCount = parent.getChildCount();
            EdgeTreeNode node = null;
            int i = start + 1;
            while ((long)i < childCount) {
                node = parentChildren.getChild(i);
                node.clearStart();
                ++i;
            }
            parent.clearStarts();
            parent = parent.getParent();
        }
    }

    public void clearStart() throws TransformException {
        this.m_start = -1;
        this.m_collapseChildren = null;
        EdgeTreeChildren children = this.getSearchableChildren(GetSlice.GET_ALL_SLICES, -1);
        children.clearStart();
    }

    public void clearSpan() {
        this.m_span = -1;
        this.m_collapseChildren = null;
        if (this.getParent() != null) {
            this.getParent().clearSpan();
        }
    }

    public void invalidate() throws TransformException {
        this.deleteCachedInfo();
        EdgeTreeChildren children = this.getModifiableChildren();
        if (!this.m_isAggregateSibling) {
            if (this.m_isCollapsed != this.getIsCollapsed(this.m_value)) {
                if (this.m_isCollapsed) {
                    this.insertSibling(null);
                } else {
                    this.deleteSibling();
                }
            } else if (!this.getIsCollapsed(this.m_value) && this.m_value.getMetadata("memberMetadataAggPosition") != this.m_aggregatePosition) {
                this.deleteSibling();
                this.insertSibling(null);
            }
        }
        if (children != null) {
            children.invalidate();
        }
    }

    protected void deleteCachedInfo() {
        this.m_span = -1;
        this.m_start = -1;
        this.m_myPos = -1;
        this.m_collapseChildren = null;
    }

    public void unlock() throws TransformException {
        this.deleteCachedInfo();
        EdgeTreeChildren children = this.getModifiableChildren();
        if (children == null) {
            return;
        }
        children.unlock();
    }

    public TreeNodeWrapperMemberInterface getMember() {
        return this.m_value;
    }

    public boolean isRoot() {
        return this.m_parent == null;
    }

    public EdgeTreeNode getParent() {
        return this.m_parent;
    }

    public long getPosition() throws TransformException {
        if (this.m_myPos == (long)-1 && this.m_parent != null) {
            EdgeTreeChildren children = this.m_parent.getSearchableChildren(GetSlice.GET_ALL_SLICES, -1);
            long pos = children != null ? children.indexOf(this) : -1;
            if (this.m_tree.isLocked()) {
                this.m_myPos = pos;
            }
            return pos;
        }
        return this.m_myPos;
    }

    public long getChildCount() throws TransformException {
        EdgeTreeChildren children = this.getSearchableChildren(GetSlice.GET_ALL_SLICES, -1);
        return children != null ? children.size() : 0;
    }

    public boolean isLeaf() throws TransformException {
        return this.getChildCount() == 0L;
    }

    private long getModifiableChildCount() throws TransformException {
        EdgeTreeChildren children = this.getModifiableChildren();
        return children != null ? children.size() : 0;
    }

    private boolean isModifiableLeaf() throws TransformException {
        return this.getModifiableChildCount() == 0L;
    }

    private EdgeTreeNode getModifiableNextSibling() throws TransformException {
        if (this.getParent() == null) {
            return null;
        }
        EdgeTreeChildren siblings = this.getParent().getModifiableChildren();
        long pos = siblings.indexOf(this);
        if (pos + 1L < (long)siblings.size()) {
            return siblings.getChild(pos + 1L);
        }
        return null;
    }

    private EdgeTreeNode getModifiableFirstChild() throws TransformException {
        EdgeTreeChildren children = this.getModifiableChildren();
        if (children != null) {
            return children.getChild(0L);
        }
        return null;
    }

    public EdgeTreeNode getFirstChild() throws TransformException {
        return this.getChild(0L);
    }

    public EdgeTreeNode getLastChild() throws TransformException {
        EdgeTreeChildren children = this.getSearchableChildren(GetSlice.GET_ALL_SLICES, -1);
        if (children != null) {
            return children.getLastChild();
        }
        return null;
    }

    public EdgeTreeNode getLastLeaf() throws TransformException {
        EdgeTreeNode currNode = this;
        while (currNode != null && !currNode.isLeaf()) {
            currNode = currNode.getLastChild();
        }
        return currNode;
    }

    public EdgeTreeNode getFirstLeaf() throws TransformException {
        EdgeTreeNode currNode = this;
        while (currNode != null && !currNode.isLeaf()) {
            currNode = currNode.getFirstChild();
        }
        return currNode;
    }

    public boolean isAggregateNodeType() {
        return this.m_aggregateNodeType;
    }

    public long[] getHPos() throws TransformException {
        ArrayList<Long> indicies = new ArrayList<Long>();
        EdgeTreeNode node = this;
        while (node != null && !node.isRoot()) {
            indicies.add(new Long(node.getPosition()));
            node = node.getParent();
        }
        long[] hPos = new long[indicies.size()];
        int counter = hPos.length - 1;
        int i = 0;
        while (i < hPos.length) {
            hPos[i] = (Long)indicies.get(counter);
            --counter;
            ++i;
        }
        return hPos;
    }

    protected long getStart(EdgeTreeNode node, GetSlice get, long goToSlice) throws TransformException {
        EdgeTreeChildren childlist = this.getSearchableChildren(get, goToSlice);
        Iterator children = childlist.iterator();
        EdgeTreeNode currNode = null;
        long spanSum = 0L;
        while (children.hasNext()) {
            currNode = (EdgeTreeNode)children.next();
            if (currNode == node) {
                return this.getStart(get, goToSlice) + spanSum;
            }
            spanSum += currNode.getSpan();
        }
        return this.getStart(get, goToSlice);
    }

    public long getStart(GetSlice get, long goToSlice) throws TransformException {
        if (this.m_start == (long)-1) {
            long start = this.m_parent == null ? 0L : this.m_parent.getStart(this, get, goToSlice);
            if (this.m_tree.isLocked()) {
                this.m_start = start;
            } else {
                return start;
            }
        }
        return this.m_start;
    }

    public long getSpan() throws TransformException {
        if (this.m_span == (long)-1) {
            EdgeTreeChildren childlist = this.getSearchableChildren(GetSlice.GET_ALL_SLICES, -1);
            Iterator children = childlist.iterator();
            EdgeTreeNode currNode = null;
            long span = 0L;
            while (children.hasNext()) {
                currNode = (EdgeTreeNode)children.next();
                span += currNode.getSpan();
            }
            if (span == 0L && !this.isRoot()) {
                span = 1L;
            }
            if (this.m_tree.isLocked()) {
                this.m_span = span;
            } else {
                return span;
            }
        }
        return this.m_span;
    }

    public EdgeTreeNode findChild(long slice, GetSlice get) throws TransformException {
        EdgeTreeChildren children = this.getSearchableChildren(get, slice);
        if (children == null) {
            return null;
        }
        return children.findChild(slice, get);
    }

    public EdgeTreeNode addChild(EdgeTreeNode childNode, TreeNode node, String insertLocation, boolean above, boolean alwaysAdd) throws TransformException {
        EdgeTreeChildren children = this.getModifiableChildren();
        return children.addChild(childNode, node, insertLocation, above, alwaysAdd);
    }

    protected boolean needAggregateSibling() throws TransformException {
        return !this.isCollapsed() && this.getAggregatePosition() != MemberInterface.AggregatePosition.NONE;
    }

    public boolean isTotalNode() {
        return this.getMember() instanceof TotalMember;
    }

    protected EdgeTreeNode getChild(long pos) throws TransformException {
        EdgeTreeChildren children = this.getSearchableChildren(GetSlice.GET_ALL_SLICES, -1);
        if (children != null) {
            return children.getChild(pos);
        }
        return null;
    }

    public EdgeTreeNode findNonAggregateChild(String value) throws TransformException {
        EdgeTreeChildren children = this.getSearchableChildren(GetSlice.GET_ALL_SLICES, -1);
        return children.findChild(value, true);
    }

    public EdgeTreeNode findChild(String value) throws TransformException {
        EdgeTreeChildren children = this.getSearchableChildren(GetSlice.GET_ALL_SLICES, -1);
        return children.findChild(value, false);
    }

    private boolean getIsCollapsed(MemberInterface mi) throws TransformException {
        Object obj = mi.getMetadata("memberMetadataIsCollapsed");
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return false;
    }

    static boolean mav$getIsCollapsed(EdgeTreeNode edgeTreeNode, MemberInterface memberInterface) {
        return edgeTreeNode.getIsCollapsed(memberInterface);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class GetSlice
    extends Enum<GetSlice> {
        private static final /* synthetic */ GetSlice[] $v;
        public static final /* enum */ GetSlice GET_NO_SLICES;
        public static final /* enum */ GetSlice GET_ALL_SLICES;
        public static final /* enum */ GetSlice GET_TO_SLICE;

        public static GetSlice valueOf(String string) {
            return Enum.valueOf(GetSlice.class, string);
        }

        public static final GetSlice[] values() {
            return (GetSlice[])$v.clone();
        }

        static {
            GetSlice[] getSliceArray = new GetSlice[3];
            getSliceArray[2] = GET_TO_SLICE = new GetSlice("GET_TO_SLICE", 2);
            getSliceArray[1] = GET_ALL_SLICES = new GetSlice("GET_ALL_SLICES", 1);
            getSliceArray[0] = GET_NO_SLICES = new GetSlice("GET_NO_SLICES", 0);
            $v = getSliceArray;
        }

        private GetSlice(String string2, int n2) {
        }
    }

    protected class MemberInterfaceCache
    implements MemberInterface {
        private boolean m_miIsNull;
        private String m_miValue;
        private boolean m_miIsCollapsed;
        private EdgeTreeNode m_miNode;
        private MemberInterface.AggregatePosition m_miAggPosition;

        private void $init$() {
            this.m_miIsNull = false;
            this.m_miValue = null;
            this.m_miIsCollapsed = false;
            this.m_miNode = null;
            this.m_miAggPosition = null;
        }

        public MemberInterfaceCache(MemberInterface mi) throws TransformException {
            this.$init$();
            if (mi == null) {
                this.m_miIsNull = true;
            } else {
                this.m_miValue = mi.getValue();
                this.m_miIsCollapsed = EdgeTreeNode.mav$getIsCollapsed(EdgeTreeNode.this, mi);
                this.m_miAggPosition = (MemberInterface.AggregatePosition)((Object)mi.getMetadata("memberMetadataAggPosition"));
            }
        }

        public boolean isNull() {
            return this.m_miIsNull;
        }

        public String getValue() throws TransformException {
            return this.m_miValue;
        }

        public Object getMetadata(String type) throws TransformException {
            if (type.equals("value")) {
                return this.getValue();
            }
            if (type.equals("memberMetadataIsCollapsed")) {
                return this.isCollapsed();
            }
            if (type.equals("memberMetadataAggPosition")) {
                return this.getAggregatePosition();
            }
            return null;
        }

        public void setEdgeTreeNode(EdgeTreeNode node) {
            this.m_miNode = node;
        }

        public EdgeTreeNode getEdgeTreeNode() {
            return this.m_miNode;
        }

        private boolean isCollapsed() {
            return this.m_miIsCollapsed;
        }

        private MemberInterface.AggregatePosition getAggregatePosition() {
            return this.m_miAggPosition;
        }
    }

    static class 1 {
        static final /* synthetic */ int[] $sm$oracle$dss$util$transform$EdgeTreeNode$GetSlice;

        static {
            int[] nArray = new int[GetSlice.values().length];
            $sm$oracle$dss$util$transform$EdgeTreeNode$GetSlice = nArray;
            try {
                nArray[GetSlice.GET_NO_SLICES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$dss$util$transform$EdgeTreeNode$GetSlice[GetSlice.GET_ALL_SLICES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$dss$util$transform$EdgeTreeNode$GetSlice[GetSlice.GET_TO_SLICE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
        }
    }
}

