/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.transform;

import java.util.Vector;
import oracle.dss.util.Utility;
import oracle.dss.util.transform.TransformException;
import oracle.dss.util.transform.TreeNodeWrapperMemberInterface;

public class LayerAndMember {
    public TreeNodeWrapperMemberInterface[] m_members;
    public String[] m_layers;

    private void $init$() {
        this.m_members = null;
        this.m_layers = null;
    }

    public LayerAndMember(String[] layers, TreeNodeWrapperMemberInterface[] members) {
        this.$init$();
        this.m_members = members;
        this.m_layers = layers;
    }

    public TreeNodeWrapperMemberInterface getMember(String layer) {
        if (this.m_layers == null || this.m_members == null || this.m_layers.length != this.m_members.length) {
            return null;
        }
        int i = 0;
        while (i < this.m_layers.length) {
            if (this.m_layers[i] != null && this.m_layers[i].equals(layer)) {
                return this.m_members[i];
            }
            ++i;
        }
        return null;
    }

    public void remove(String layer) {
        if (layer == null || this.m_layers == null) {
            return;
        }
        Vector<String> layerVec = new Vector<String>();
        Vector<TreeNodeWrapperMemberInterface> memberVec = new Vector<TreeNodeWrapperMemberInterface>();
        int l = 0;
        while (l < this.m_layers.length) {
            if (!layer.equals(this.m_layers[l])) {
                layerVec.addElement(this.m_layers[l]);
                memberVec.addElement(this.m_members[l]);
            }
            ++l;
        }
        this.setVals(layerVec, memberVec);
    }

    private void setVals(Vector layerVec, Vector memberVec) {
        this.m_layers = layerVec.size() > 0 ? layerVec.toArray(new String[0]) : null;
        this.m_members = memberVec.size() > 0 ? memberVec.toArray(new TreeNodeWrapperMemberInterface[0]) : null;
    }

    public void removeCollisions(LayerAndMember other) throws TransformException {
        Vector<TreeNodeWrapperMemberInterface> memberVec = new Vector<TreeNodeWrapperMemberInterface>();
        Vector<String> layerVec = new Vector<String>();
        if (this.m_layers == null || this.m_members == null || this.m_layers.length != this.m_members.length) {
            return;
        }
        TreeNodeWrapperMemberInterface otherMember = null;
        int i = 0;
        while (i < this.m_layers.length) {
            otherMember = other.getMember(this.m_layers[i]);
            if (!(otherMember == null || this.m_members[i] != null && Utility.compareObj(otherMember.getValue(), this.m_members[i].getValue()))) {
                other.remove(this.m_layers[i]);
            } else {
                layerVec.addElement(this.m_layers[i]);
                memberVec.addElement(this.m_members[i]);
            }
            ++i;
        }
        this.setVals(layerVec, memberVec);
    }
}

