/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.transform;

import oracle.dss.util.transform.MemberWrapper;
import oracle.dss.util.transform.PageKeyHelper;
import oracle.dss.util.transform.TransformException;

public class MemberCacheKey {
    protected MemberWrapper[][] m_hPosPage;
    protected MemberWrapper[] m_row;
    protected MemberWrapper[] m_col;

    private void $init$() {
        this.m_hPosPage = null;
        this.m_row = null;
        this.m_col = null;
    }

    public MemberCacheKey() {
        this.$init$();
    }

    public MemberCacheKey(MemberWrapper[][] page, MemberWrapper[] row, MemberWrapper[] col) {
        this();
        this.setKeyValues(page, row, col);
    }

    public boolean isCalculatedValue() {
        if (this.m_row != null) {
            int i = 0;
            while (i < this.m_row.length) {
                if (this.m_row[i].isTotalMember()) {
                    return true;
                }
                ++i;
            }
        }
        if (this.m_col != null) {
            int i = 0;
            while (i < this.m_col.length) {
                if (this.m_col[i].isTotalMember()) {
                    return true;
                }
                ++i;
            }
        }
        if (this.m_hPosPage != null) {
            int i = 0;
            while (i < this.m_hPosPage.length) {
                if (this.m_hPosPage[i] != null) {
                    int j = 0;
                    while (j < this.m_hPosPage[i].length) {
                        if (this.m_hPosPage[i][j].isTotalMember()) {
                            return true;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    public void setKeyValues(MemberWrapper[][] page, MemberWrapper[] row, MemberWrapper[] col) {
        this.m_hPosPage = page;
        this.m_row = row != null && row.length == 0 ? null : row;
        this.m_col = col != null && col.length == 0 ? null : col;
    }

    public MemberWrapper[] getRow() {
        return this.m_row;
    }

    public MemberWrapper[] getColumn() {
        return this.m_col;
    }

    public MemberWrapper[][] getPage() {
        return this.m_hPosPage;
    }

    public Object clone() {
        return new MemberCacheKey(this.m_hPosPage, this.m_row, this.m_col);
    }

    public boolean equals(Object key) {
        if (key instanceof MemberCacheKey) {
            MemberCacheKey ck = (MemberCacheKey)key;
            try {
                boolean equal;
                boolean bl = equal = this.compareArrays(this.m_row, ck.m_row) && this.compareArrays(this.m_col, ck.m_col);
                if (equal) {
                    boolean bl2 = PageKeyHelper.pageEqual(this.m_hPosPage, ck.m_hPosPage);
                    return bl2;
                }
            }
            catch (TransformException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return false;
    }

    private boolean compareArrays(MemberWrapper[] list1, MemberWrapper[] list2) throws TransformException {
        if (list1 == list2) {
            return true;
        }
        if (list1 == null || list2 == null) {
            return false;
        }
        if (list1.length != list2.length) {
            return false;
        }
        int i = 0;
        while (i < list1.length) {
            if (list1[i] == null ? list2[i] != null : !list1[i].equals(list2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        long hPosCode = PageKeyHelper.hashPage(this.m_hPosPage);
        if (this.m_row != null) {
            int i = 0;
            while (i < this.m_row.length) {
                if (this.m_row[i] != null) {
                    hPosCode += (long)this.m_row[i].hashCode();
                }
                ++i;
            }
        }
        if (this.m_col != null) {
            int i = 0;
            while (i < this.m_col.length) {
                if (this.m_col[i] != null) {
                    hPosCode += (long)this.m_col[i].hashCode();
                }
                ++i;
            }
        }
        return (int)hPosCode;
    }
}

