/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.transform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.dss.util.QDR;
import oracle.dss.util.QDRInterface;
import oracle.dss.util.transform.MemberInterface;
import oracle.dss.util.transform.RowIterator;
import oracle.dss.util.transform.TransformException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepeatMap
extends HashMap<String, HashMap<QDRInterface, List<QDRInterface>>> {
    protected HashMap<String, Boolean> m_cache;

    private void $init$() {
        this.m_cache = new HashMap();
    }

    private boolean storeAndReturn(String layer, boolean retVal) {
        this.m_cache.put(layer, retVal);
        return retVal;
    }

    public boolean repeats(String layer) {
        Boolean answer = this.m_cache.get(layer);
        if (answer != null) {
            return answer;
        }
        HashMap tupleSets = (HashMap)super.get(layer);
        if (tupleSets == null) {
            return this.storeAndReturn(layer, false);
        }
        if (tupleSets.size() <= 1) {
            return this.storeAndReturn(layer, true);
        }
        Set keys = tupleSets.keySet();
        Iterator keyIter = keys.iterator();
        List firstVal = null;
        List currVal = null;
        while (keyIter.hasNext()) {
            if (firstVal == null) {
                firstVal = (List)tupleSets.get((QDRInterface)keyIter.next());
                continue;
            }
            currVal = (List)tupleSets.get((QDRInterface)keyIter.next());
            int firstValSize = firstVal.size();
            if (firstValSize != currVal.size()) {
                return this.storeAndReturn(layer, false);
            }
            if (firstVal.containsAll(currVal)) continue;
            return this.storeAndReturn(layer, false);
        }
        return this.storeAndReturn(layer, true);
    }

    public void addQDR(String layer, QDRInterface key, QDRInterface newTuple) {
        ArrayList<QDRInterface> qdrList;
        HashMap layerMap = (HashMap)super.get(layer);
        if (layerMap == null) {
            layerMap = new HashMap();
            super.put(layer, layerMap);
        }
        if ((qdrList = (ArrayList<QDRInterface>)layerMap.get(key)) == null) {
            qdrList = new ArrayList<QDRInterface>();
            layerMap.put(key, qdrList);
        }
        if (!qdrList.contains(newTuple)) {
            qdrList.add(newTuple);
        }
    }

    private QDRInterface[] getPostQDR(String layer, RowIterator iter, String[][] layout, MemberInterface[] dataItems, String measLayer) throws TransformException {
        ArrayList<QDRInterface> qdrs = new ArrayList<QDRInterface>();
        QDR qdr = new QDR();
        boolean sawMeas = false;
        int e = 0;
        while (e < layout.length) {
            if (layout[e] != null) {
                int l = layout[e].length - 1;
                while (l >= 0) {
                    if (!layout[e][l].equals(measLayer)) {
                        qdr.addDimMemberPair(layout[e][l], (String)iter.getValue(layout[e][l]));
                    }
                    if (layer.equals(layout[e][l])) {
                        if ((sawMeas || layer.equals(measLayer)) && dataItems != null && dataItems.length > 0) {
                            QDRInterface qdrClone = null;
                            int i = 0;
                            while (i < dataItems.length) {
                                try {
                                    qdrClone = (QDRInterface)qdr.clone();
                                }
                                catch (CloneNotSupportedException ex) {
                                    throw new TransformException(ex.getMessage(), ex);
                                }
                                qdrClone.addDimMemberPair(measLayer, dataItems[i].getValue());
                                qdrs.add(qdrClone);
                                ++i;
                            }
                        } else {
                            qdrs.add(qdr);
                        }
                        return qdrs.toArray(new QDRInterface[0]);
                    }
                    if (layout[e][l].equals(measLayer)) {
                        sawMeas = true;
                    }
                    --l;
                }
            }
            ++e;
        }
        return qdrs.toArray(new QDRInterface[0]);
    }

    private QDRInterface[] getPreQDR(String layer, RowIterator iter, String[][] layout, MemberInterface[] dataItems, String measLayer) throws TransformException {
        ArrayList<QDRInterface> qdrs = new ArrayList<QDRInterface>();
        QDR qdr = new QDR();
        boolean sawMeas = false;
        int e = layout.length - 1;
        while (e >= 0) {
            if (layout[e] != null) {
                int l = 0;
                while (l < layout[e].length) {
                    if (layer.equals(layout[e][l])) {
                        if (sawMeas && dataItems != null && dataItems.length > 0) {
                            QDRInterface qdrClone = null;
                            int i = 0;
                            while (i < dataItems.length) {
                                try {
                                    qdrClone = (QDRInterface)qdr.clone();
                                }
                                catch (CloneNotSupportedException ex) {
                                    throw new TransformException(ex.getMessage(), ex);
                                }
                                qdrClone.addDimMemberPair(measLayer, dataItems[i].getValue());
                                qdrs.add(qdrClone);
                                ++i;
                            }
                        } else {
                            qdrs.add(qdr);
                        }
                        return qdrs.toArray(new QDRInterface[0]);
                    }
                    if (layout[e][l].equals(measLayer)) {
                        sawMeas = true;
                    } else {
                        qdr.addDimMemberPair(layout[e][l], (String)iter.getValue(layout[e][l]));
                    }
                    ++l;
                }
            }
            --e;
        }
        return qdrs.toArray(new QDRInterface[0]);
    }

    public void createRepeatTableEntries(String layer, RowIterator iter, String[][] layout, MemberInterface[] dataItems, String meas) throws TransformException {
        Boolean val = this.m_cache.get(layer);
        if (val != null) {
            return;
        }
        QDRInterface[] qdrKeys = this.getPreQDR(layer, iter, layout, dataItems, meas);
        QDRInterface[] qdrValues = this.getPostQDR(layer, iter, layout, dataItems, meas);
        int i = 0;
        while (i < qdrKeys.length) {
            int j = 0;
            while (j < qdrValues.length) {
                this.addQDR(layer, qdrKeys[i], qdrValues[j]);
                ++j;
            }
            ++i;
        }
    }

    public void calculate() {
        Set layers = super.keySet();
        Iterator layerIter = layers.iterator();
        String layer = null;
        while (layerIter.hasNext()) {
            layer = (String)layerIter.next();
            this.repeats(layer);
        }
        super.clear();
    }

    public RepeatMap() {
        this.$init$();
    }
}

