/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.transform;

import oracle.dss.util.transform.DataTable;
import oracle.dss.util.transform.RowProjection;
import oracle.dss.util.transform.TransformException;
import oracle.dss.util.transform.total.AggSpec;

public class ResultTable {
    protected RowProjection m_projection;
    protected DataTable m_dt;

    private void $init$() {
        this.m_projection = null;
        this.m_dt = null;
    }

    public ResultTable(RowProjection projection) throws TransformException {
        this();
        this.m_projection = projection;
        this.m_dt = new DataTable(projection);
    }

    public ResultTable(RowProjection projection, AggSpec[] aggs) throws TransformException {
        this();
        this.m_projection = projection;
        this.m_dt = new DataTable(projection, new AggSpec[][]{aggs});
    }

    public ResultTable(RowProjection projection, AggSpec[][] aggs) throws TransformException {
        this();
        this.m_projection = projection;
        this.m_dt = new DataTable(projection, aggs);
    }

    public ResultTable(RowProjection projection, AggSpec[][] aggs, boolean includeDataLayerInMembers) throws TransformException {
        this();
        this.m_projection = projection;
        this.m_dt = new DataTable(projection, aggs, includeDataLayerInMembers);
    }

    protected ResultTable() {
        this.$init$();
    }

    public AggSpec[][] getAggSpec() {
        return this.m_dt.getAggSpec();
    }

    public void close() throws TransformException {
        if (this.m_projection != null && this.m_projection.getRowIterator() != null) {
            this.m_projection.getRowIterator().close();
        }
        this.m_projection = null;
        if (this.m_dt != null) {
            this.m_dt.close();
        }
        this.m_dt = null;
    }

    public Object clone() throws CloneNotSupportedException {
        ResultTable rt = new ResultTable();
        rt.m_projection = this.m_projection;
        rt.m_dt = (DataTable)this.m_dt.clone();
        return rt;
    }

    public DataTable getDataTable() {
        return this.m_dt;
    }

    public boolean isLocalStorage() {
        return this.getDataTable().isMixedFrequencyProjection();
    }

    public RowProjection getProjection() {
        return this.m_projection;
    }
}

