/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.transform;

import oracle.dss.util.transform.ColumnValue;
import oracle.dss.util.transform.DataCell;
import oracle.dss.util.transform.DataCellInterface;
import oracle.dss.util.transform.DataTable;
import oracle.dss.util.transform.MemberCell;
import oracle.dss.util.transform.MemberInterface;
import oracle.dss.util.transform.TransformException;
import oracle.dss.util.transform.TransformRuntimeException;
import oracle.dss.util.transform.total.TotalMember;

public class Row {
    private MemberCell[] m_members;
    private DataCell[] m_cells;
    private DataTable m_dataTable;
    private ColumnValue[] m_extraMembers;

    private void $init$() {
        this.m_members = null;
        this.m_cells = null;
        this.m_dataTable = null;
        this.m_extraMembers = null;
    }

    public Row(MemberCell[] members, DataCell[] cells, ColumnValue[] extraMembers, DataTable dt) {
        this.$init$();
        this.setMembers(members);
        this.setCells(cells);
        this.setExtraMembers(extraMembers);
        this.m_dataTable = dt;
    }

    public Row(DataTable dt) {
        this.$init$();
        this.m_dataTable = dt;
    }

    public void release() {
        this.m_members = null;
        this.m_cells = null;
        this.m_dataTable = null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Row)) {
            return false;
        }
        Row row = (Row)obj;
        try {
            ColumnValue[] colMembers;
            MemberCell[] members = this.getMembers();
            MemberCell otherMember = null;
            MemberInterface mi1 = null;
            MemberInterface mi2 = null;
            String val1 = null;
            String val2 = null;
            if (members != null) {
                int i = 0;
                while (i < members.length) {
                    if (members[i] != null) {
                        otherMember = row.getMember(members[i].getMemberColumnName());
                        if (otherMember == null) {
                            boolean bl = false;
                            return bl;
                        }
                        mi1 = members[i].getMemberInterface();
                        if (mi1 != null) {
                            val1 = mi1.getValue();
                            mi2 = otherMember.getMemberInterface();
                            if (mi2 == null) {
                                boolean bl = false;
                                return bl;
                            }
                            val2 = mi2.getValue();
                            if (val1 == null) {
                                if (val2 != null) {
                                    boolean bl = false;
                                    return bl;
                                }
                            } else if (!val1.equals(val2)) {
                                boolean bl = false;
                                return bl;
                            }
                        }
                    }
                    ++i;
                }
            }
            DataCell[] data = this.getCells();
            DataCell otherCell = null;
            DataCellInterface di1 = null;
            DataCellInterface di2 = null;
            Object dataval1 = null;
            Object dataval2 = null;
            if (data != null) {
                int i = 0;
                while (i < data.length) {
                    if (data[i] != null) {
                        otherCell = row.getCell(data[i].getDataCellColumnName());
                        if (otherCell == null) {
                            boolean bl = false;
                            return bl;
                        }
                        di1 = data[i].getDataCellInterface();
                        if (mi1 != null) {
                            dataval1 = di1.getData("dataValue");
                            di2 = otherCell.getDataCellInterface();
                            if (di2 == null) {
                                boolean bl = false;
                                return bl;
                            }
                            dataval2 = di2.getData("dataValue");
                            if (dataval1 == null) {
                                if (dataval2 != null) {
                                    boolean bl = false;
                                    return bl;
                                }
                            } else if (!dataval1.equals(dataval2)) {
                                boolean bl = false;
                                return bl;
                            }
                        }
                    }
                    ++i;
                }
            }
            if ((colMembers = this.getExtraMembers()) != null) {
                int i = 0;
                while (i < colMembers.length) {
                    if (colMembers[i] != null) {
                        dataval2 = row.getExtraMemberValue(colMembers[i].getColumn());
                        dataval1 = colMembers[i].getValue();
                        if (dataval1 == null) {
                            if (dataval2 != null) {
                                boolean bl = false;
                                return bl;
                            }
                        } else if (!dataval1.equals(dataval2)) {
                            boolean bl = false;
                            return bl;
                        }
                    }
                    ++i;
                }
            }
        }
        catch (TransformException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
        return true;
    }

    public void setExtraMembers(ColumnValue[] extraMembers) {
        this.m_extraMembers = extraMembers;
    }

    public ColumnValue[] getExtraMembers() {
        return this.m_extraMembers;
    }

    public void setMembers(MemberCell[] members) {
        this.m_members = members;
    }

    public void setCells(DataCell[] cells) {
        this.m_cells = cells;
    }

    public Object clone(DataTable dt) throws CloneNotSupportedException {
        MemberCell[] newMembers = new MemberCell[this.m_members.length];
        int i = 0;
        while (i < newMembers.length) {
            newMembers[i] = this.m_members[i];
            ++i;
        }
        DataCell[] newCells = null;
        if (this.m_cells != null) {
            newCells = new DataCell[this.m_cells.length];
            int i2 = 0;
            while (i2 < newCells.length) {
                newCells[i2] = this.m_cells[i2];
                ++i2;
            }
        }
        ColumnValue[] newExtraMembers = null;
        if (this.m_extraMembers != null) {
            newExtraMembers = new ColumnValue[this.m_extraMembers.length];
            int i3 = 0;
            while (i3 < this.m_extraMembers.length) {
                newExtraMembers[i3] = this.m_extraMembers[i3];
                ++i3;
            }
        }
        return new Row(newMembers, newCells, newExtraMembers, dt);
    }

    public DataCell[] getCells() {
        return this.m_cells;
    }

    public MemberCell[] getMembers() {
        return this.m_members;
    }

    public boolean isCalculatedValue() {
        if (this.m_members == null) {
            return false;
        }
        int i = 0;
        while (i < this.m_members.length) {
            if (this.m_members[i].getMemberInterface() instanceof TotalMember) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public DataTable getDataTable() {
        return this.m_dataTable;
    }

    protected void insertData(DataCell[] cellsToInsert) {
        if (cellsToInsert.length > this.m_cells.length) {
            DataCell[] tempCells = new DataCell[cellsToInsert.length];
            int i = 0;
            while (i < this.m_cells.length) {
                tempCells[i] = cellsToInsert[i] != null ? cellsToInsert[i] : this.m_cells[i];
                ++i;
            }
            int i2 = this.m_cells.length;
            while (i2 < cellsToInsert.length) {
                this.m_cells[i2] = cellsToInsert[i2];
                ++i2;
            }
            this.m_cells = tempCells;
        } else {
            int i = 0;
            while (i < cellsToInsert.length) {
                if (cellsToInsert[i] != null) {
                    this.m_cells[i] = cellsToInsert[i];
                }
                ++i;
            }
        }
    }

    public boolean membersEqual(Row row) throws TransformException {
        if (row == null) {
            return false;
        }
        if (this.m_members == null) {
            return row.m_members == null;
        }
        if (row.m_members == null) {
            return false;
        }
        int memberCount = this.m_members.length;
        if (memberCount != row.m_members.length) {
            return false;
        }
        int i = 0;
        while (i < memberCount) {
            if (!row.inMemberList(this.m_members[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean inMemberList(MemberCell mi) throws TransformException {
        int i = 0;
        while (i < this.m_members.length) {
            if (mi.getMemberInterface().getValue().equals(this.m_members[i].getMemberInterface().getValue())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public MemberCell getMember(int i) {
        if (i >= 0 && i < this.m_members.length) {
            return this.m_members[i];
        }
        return null;
    }

    public DataCell getCell(int i) {
        if (i >= 0 && i < this.m_cells.length) {
            return this.m_cells[i];
        }
        return null;
    }

    public void setMember(int i, MemberCell member) {
        if (i < this.m_members.length) {
            this.m_members[i] = member;
        }
    }

    public void setCell(int i, DataCell cell) {
        if (i < this.m_cells.length) {
            this.m_cells[i] = cell;
        }
    }

    public MemberCell getMember(String colName) {
        return this.getMember(this.m_dataTable.getMemberIndexFromID(colName));
    }

    public Object getExtraMemberValue(String colName) {
        if (this.m_extraMembers != null) {
            int i = 0;
            while (i < this.m_extraMembers.length) {
                if (this.m_extraMembers[i] != null && this.m_extraMembers[i].getColumn().equals(colName)) {
                    return this.m_extraMembers[i].getValue();
                }
                ++i;
            }
        }
        return null;
    }

    public DataCell getCell(String colName) {
        return this.getCell(this.m_dataTable.getCellIndexFromID(colName));
    }
}

