/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.transform;

import java.util.ArrayList;
import java.util.Hashtable;
import oracle.dss.util.QDRInterface;
import oracle.dss.util.transform.BaseNode;
import oracle.dss.util.transform.Cube;
import oracle.dss.util.transform.DataTable;
import oracle.dss.util.transform.InsertInfo;
import oracle.dss.util.transform.MemberCacheKey;
import oracle.dss.util.transform.MemberCacheKeyPool;
import oracle.dss.util.transform.ResultTable;
import oracle.dss.util.transform.ResultTableInsert;
import oracle.dss.util.transform.RowBasedEdgeTree;
import oracle.dss.util.transform.TransformException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RowBasedCube
extends Cube {
    protected ArrayList<QDRInterface> m_realQDRs;

    private void $init$() {
        this.m_realQDRs = new ArrayList();
    }

    public RowBasedCube(ResultTable rt, String[] measList, MemberCacheKeyPool memberCacheKeyPool, Hashtable<MemberCacheKey, Object> dataCache, boolean caching, boolean[] alwaysAdd) throws TransformException {
        this.$init$();
        this.setup(rt, measList, memberCacheKeyPool, dataCache, caching, alwaysAdd);
    }

    @Override
    public ArrayList<QDRInterface> getRealQDRs() {
        return this.m_realQDRs;
    }

    protected void setup(ResultTable rt, String[] measList, MemberCacheKeyPool memberCacheKeyPool, Hashtable<MemberCacheKey, Object> dataCache, boolean caching, boolean[] alwaysAdd) throws TransformException {
        if (rt == null) {
            return;
        }
        int edgeCount = rt.getProjection().getLayout().length;
        DataTable dt = rt.getDataTable();
        if (dt == null) {
            return;
        }
        int e = 0;
        while (e < edgeCount) {
            if (rt.getProjection().getLayout()[e] != null) {
                BaseNode[] nodes = new BaseNode[rt.getProjection().getLayout()[e].length];
                int layer = 0;
                while (layer < nodes.length) {
                    nodes[layer] = new BaseNode(rt.getProjection().getLayout()[e][layer]);
                    ++layer;
                }
                this.setEdgeTree(e, new RowBasedEdgeTree(nodes, rt.getProjection().getDataLayer(), measList, rt.getProjection(), e));
            }
            ++e;
        }
        this.walkData(rt, measList, memberCacheKeyPool, dataCache, caching, alwaysAdd);
    }

    protected void addIn(ResultTableInsert[] rti, String[] measList, MemberCacheKeyPool memberCacheKeyPool, Hashtable<MemberCacheKey, Object> dataCache, boolean[] alwaysAdd) throws TransformException {
        if (rti == null) {
            return;
        }
        int i = 0;
        while (i < rti.length) {
            this.unlockTrees(rti[i].getEdgeInserts(false));
            this.walkData(rti[i], measList, memberCacheKeyPool, dataCache, false, alwaysAdd);
            ++i;
        }
        this.lockTrees();
    }

    protected void unlockTrees(InsertInfo[] edgeInserts) throws TransformException {
        if (this.getEdgeTree(0) != null && this.getEdgeTree(0).unlock(this.getColumn(edgeInserts, 0))) {
            return;
        }
        if (this.getEdgeTree(1) != null && this.getEdgeTree(1).unlock(this.getColumn(edgeInserts, 1))) {
            return;
        }
        super.unlockPageTree(edgeInserts);
    }

    protected void walkData(ResultTable rt, String[] measList, MemberCacheKeyPool memberCacheKeyPool, Hashtable<MemberCacheKey, Object> dataCache, boolean caching, boolean[] alwaysAdd) throws TransformException {
        this.walkData(new ResultTableInsert(rt, null), measList, memberCacheKeyPool, dataCache, caching, alwaysAdd);
    }
}

