/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.transform;

import oracle.dss.util.QDR;
import oracle.dss.util.transform.CubicDataAccess;
import oracle.dss.util.transform.LayerInterface;
import oracle.dss.util.transform.ResultTable;
import oracle.dss.util.transform.ResultTableInsert;
import oracle.dss.util.transform.RowBasedCube;
import oracle.dss.util.transform.TransformException;

public class RowBasedCubicDataAccess
extends CubicDataAccess {
    protected RowBasedCubicDataAccess() throws TransformException {
        this(null, false);
    }

    public RowBasedCubicDataAccess(ResultTable rt) throws TransformException {
        super(null, false);
        this.init(rt);
    }

    public RowBasedCubicDataAccess(ResultTable rt, boolean cache) throws TransformException {
        super(null, cache);
        this.init(rt);
    }

    public synchronized void insert(ResultTableInsert[] rti) throws TransformException {
        if (this.m_cube instanceof RowBasedCube) {
            ((RowBasedCube)this.m_cube).addIn(rti, this.getMeasList(), this.m_memberKeyPool, this.m_memberCache, this.m_alwaysAdd);
        }
    }

    protected QDR generateQDR() throws TransformException {
        LayerInterface li = this.m_rt != null ? this.m_rt.getProjection().getDataLayer() : null;
        return new QDR(li != null ? li.getValue() : null);
    }

    protected void init(ResultTable rt) throws TransformException {
        super.init(rt);
        if (rt == null) {
            return;
        }
        this.initCaches();
        if (this.getLayout() == null) {
            return;
        }
        this.m_cube = new RowBasedCube(this.m_rt, this.getMeasList(), this.m_memberKeyPool, this.m_memberCache, this.m_caching, this.m_alwaysAdd);
        this.m_realQDRs = ((RowBasedCube)this.m_cube).getRealQDRs();
        this.m_cube.lockTrees();
    }

    private String[] getMeasList() throws TransformException {
        return this.getMeasList(this.m_rt.getProjection());
    }
}

