/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.transform;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import oracle.dss.util.transform.MemberInterface;
import oracle.dss.util.transform.RowIterator;
import oracle.dss.util.transform.RowProjection;
import oracle.dss.util.transform.RowsetRecord;
import oracle.dss.util.transform.TransformException;
import oracle.dss.util.transform.TransformRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RowsetCollection
implements Collection<RowsetRecord> {
    protected RowProjection m_projection;
    protected String[] m_cols;
    protected int m_size;
    protected String[] m_colsForColumnType;
    protected HashMap<String, String> m_map;

    private void $init$() {
        this.m_projection = null;
        this.m_cols = null;
        this.m_size = -1;
        this.m_colsForColumnType = null;
        this.m_map = null;
    }

    public RowsetCollection(RowProjection projection) {
        this.$init$();
        this.m_projection = projection;
        this.m_cols = this.m_projection.getRowIterator().getColumns();
    }

    public void setColumnMap(HashMap<String, String> map) {
        this.m_map = map;
    }

    public String getMappedKey(String key) {
        String retVal;
        if (this.m_map != null && (retVal = this.m_map.get(key)) != null) {
            return retVal;
        }
        return key;
    }

    public String[] getColumns() {
        return this.m_cols;
    }

    public boolean isDataItem(String col) throws TransformException {
        MemberInterface[] dataItems = this.m_projection.getDataItems();
        String columnType = "value";
        if (dataItems != null) {
            int i = 0;
            while (i < dataItems.length) {
                String name;
                if (dataItems[i] != null && col.equals(name = (String)dataItems[i].getMetadata(columnType))) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    public int size() {
        if (this.m_size == -1) {
            try {
                RowIterator iter = this.m_projection.getRowIterator();
                this.m_size = 0;
                while (iter.hasMoreRows()) {
                    ++this.m_size;
                    iter.nextRow();
                }
            }
            catch (TransformException e) {
                throw new TransformRuntimeException(e.getMessage(), e);
            }
        }
        return this.m_size;
    }

    @Override
    public boolean contains(Object o) {
        for (RowsetRecord record : this) {
            if (!record.equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c == null) {
            return false;
        }
        for (RowsetRecord record : c) {
            if (this.contains(record)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof RowsetCollection)) {
            return false;
        }
        RowsetCollection coll = (RowsetCollection)o;
        if (this.size() == coll.size()) {
            return this.containsAll(coll);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        for (RowsetRecord record : this) {
            hash += record.hashCode();
        }
        return hash;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean add(RowsetRecord o) {
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends RowsetRecord> c) {
        return false;
    }

    @Override
    public Object[] toArray() {
        Object[] recs = new RowsetRecord[this.size()];
        int count = 0;
        for (RowsetRecord record : this) {
            recs[count++] = record;
        }
        return recs;
    }

    public RowsetRecord[] toArray(Object[] obj) {
        return (RowsetRecord[])this.toArray();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return false;
    }

    @Override
    public boolean remove(Object o) {
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return false;
    }

    @Override
    public void clear() {
    }

    @Override
    public Iterator<RowsetRecord> iterator() {
        return new RowsetIterator(this, this.m_projection.getRowIterator());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RowsetIterator
    implements Iterator<RowsetRecord> {
        protected RowsetCollection m_coll;
        protected RowIterator m_iter;

        private void $init$() {
            this.m_coll = null;
            this.m_iter = null;
        }

        public RowsetIterator(RowsetCollection c, RowIterator iter) {
            this.$init$();
            this.m_coll = c;
            this.m_iter = iter;
        }

        @Override
        public boolean hasNext() {
            try {
                boolean bl = this.m_iter.hasMoreRows();
                return bl;
            }
            catch (TransformException e) {
                throw new TransformRuntimeException(e.getMessage(), e);
            }
        }

        @Override
        public void remove() {
        }

        @Override
        public RowsetRecord next() {
            try {
                RowsetRecord rec;
                RowsetRecord rowsetRecord = rec = new RowsetRecord(this.m_iter, this.m_coll);
                return rowsetRecord;
            }
            catch (TransformException e) {
                throw new TransformRuntimeException(e.getMessage(), e);
            }
        }
    }
}

