/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.transform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dss.util.ColumnOutOfRangeException;
import oracle.dss.util.DataAccess;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.HierarchicalQDR;
import oracle.dss.util.HierarchicalQDRMember;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.QDR;
import oracle.dss.util.QDRInterface;
import oracle.dss.util.QDRMember;
import oracle.dss.util.RowOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.dss.util.transform.DataAccessLong;
import oracle.dss.util.transform.MemberInterface;
import oracle.dss.util.transform.TransformException;
import oracle.dss.util.transform.TransformRuntimeException;
import oracle.dss.util.transform.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformUtils {
    public static final NullMarker m_nullMarker = new NullMarker();

    public static String convertLayerMetadata(String type) {
        if (type == null) {
            return null;
        }
        if (type.equals("dimName")) {
            return "dimName";
        }
        if (type.equals("dimLongName")) {
            return "dimLongName";
        }
        if (type.equals("dimLongPluralName")) {
            return "dimLongPluralName";
        }
        if (type.equals("dimIsMeasure")) {
            return "dimIsMeasure";
        }
        if (type.equals("dimCanPivot")) {
            return "dimCanPivot";
        }
        return type;
    }

    protected static boolean alwaysAdd(boolean[] alwaysAdd, int edge) {
        if (alwaysAdd == null || alwaysAdd.length <= edge) {
            return false;
        }
        return alwaysAdd[edge];
    }

    public static String convertLayerMetadataMap(String type) {
        if (type == null) {
            return null;
        }
        if (type.equals("dimName")) {
            return "dimName";
        }
        if (type.equals("dimLongName") || type.equals("dimMediumName") || type.equals("dimShortName") || type.equals("dimDisplayName")) {
            return "dimLongName";
        }
        if (type.equals("dimLongPluralName") || type.equals("dimShortPluralName")) {
            return "dimLongPluralName";
        }
        if (type.equals("dimIsMeasure")) {
            return "dimIsMeasure";
        }
        if (type.equals("dimCanPivot")) {
            return "dimCanPivot";
        }
        return type;
    }

    public static String convertDataMap(String type) {
        if (type == null) {
            return null;
        }
        if (type.equals("dataValue")) {
            return "dataValue";
        }
        if (type.equals("dataFormattedValue")) {
            return "dataFormattedValue";
        }
        if (type.equals("dataType")) {
            return "dataType";
        }
        if (type.equals("dataIsEditable")) {
            return "dataIsEditable";
        }
        return type;
    }

    public static String convertDataType(String type) {
        if (type == null) {
            return null;
        }
        if (type.equals("dataValue")) {
            return "dataValue";
        }
        if (type.equals("dataFormattedValue")) {
            return "dataFormattedValue";
        }
        if (type.equals("dataType")) {
            return "dataType";
        }
        if (type.equals("dataIsEditable")) {
            return "dataIsEditable";
        }
        return type;
    }

    public static String convertMetadataMap(String type) {
        if (type == null) {
            return null;
        }
        if (type.equals("value")) {
            return "value";
        }
        if (type.equals("shortName") || type.equals("mediumName") || type.equals("longName")) {
            return "longName";
        }
        if (type.equals("extent")) {
            return "extent";
        }
        if (type.equals("hierLevel")) {
            return "hierLevel";
        }
        if (type.equals("drillState")) {
            return "drillState";
        }
        if (type.equals("isTotal")) {
            return "isTotal";
        }
        if (type.equals("startSlice")) {
            return "startSlice";
        }
        return type;
    }

    public static String convertMemberMetadata(String type) {
        if (type == null) {
            return null;
        }
        if (type.equals("value")) {
            return "value";
        }
        if (type.equals("longName")) {
            return "longName";
        }
        if (type.equals("extent")) {
            return "extent";
        }
        if (type.equals("hierLevel")) {
            return "hierLevel";
        }
        if (type.equals("drillState")) {
            return "drillState";
        }
        if (type.equals("isTotal")) {
            return "isTotal";
        }
        if (type.equals("startSlice")) {
            return "startSlice";
        }
        return type;
    }

    public static QDR getQDRFromTreeNode(TreeNode node) throws TransformException {
        if (node == null) {
            return null;
        }
        QDR qdr = new QDR();
        while (node != null && node.getParent() != null) {
            qdr.addDimMemberPair(node.getLayer().getValue(), new QDRMember(0, node.getMember().getValue()));
            node = node.getParent();
        }
        return qdr;
    }

    public static QDRInterface getQDRFromMap(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        Set<String> keys = map.keySet();
        Iterator<String> iter = keys.iterator();
        String layer = null;
        Object val = null;
        QDR qdr = new QDR();
        while (iter.hasNext()) {
            val = map.get(layer = iter.next());
            qdr.addDimMemberPair(layer, val != null ? val.toString() : null);
        }
        return qdr;
    }

    public static int[] getIntFromLongArray(long[] hPos) {
        if (hPos == null) {
            return null;
        }
        int[] retVal = new int[hPos.length];
        int i = 0;
        while (i < retVal.length) {
            retVal[i] = (int)hPos[i];
            ++i;
        }
        return retVal;
    }

    public static long[] getLongFromIntArray(int[] hPos) {
        if (hPos == null) {
            return null;
        }
        long[] retVal = new long[hPos.length];
        int i = 0;
        while (i < hPos.length) {
            retVal[i] = hPos[i];
            ++i;
        }
        return retVal;
    }

    public static String[] getLayersFromSliceToInsert(HashMap<String, MemberInterface> sliceToInsert) {
        Set<String> keys = sliceToInsert.keySet();
        return keys.toArray(new String[0]);
    }

    public static boolean comparehPos(long[] hPos1, long[] hPos2) {
        if (hPos1 == null && hPos2 == null) {
            return true;
        }
        if (hPos1 == null || hPos2 == null) {
            return false;
        }
        if (hPos1.length != hPos2.length) {
            return false;
        }
        int i = 0;
        while (i < hPos1.length) {
            if (hPos1[i] != hPos2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static QDR generateQDR(String dataLayer, boolean hierarchicalQDR) {
        QDR qdr = null;
        qdr = hierarchicalQDR ? TransformUtils.getHierarchicalQDR(dataLayer) : new QDR(dataLayer);
        return qdr;
    }

    public static QDR getValueQDRImpl(String[][] layout, String dataLayer, DataAccessLong da, long row, long column, int flags, boolean hierarchicalQDR) throws RowOutOfRangeException, ColumnOutOfRangeException {
        QDR qdr = TransformUtils.generateQDR(dataLayer, hierarchicalQDR);
        try {
            qdr = TransformUtils.getValueQDR(layout, da, qdr, row, column, hierarchicalQDR);
        }
        catch (EdgeOutOfRangeException e) {
            Logger.getLogger("oracle.dss.util.transform").log(Level.SEVERE, "Bad row or column", e);
        }
        if (flags == 1) {
            int count = da.getEdgeCount();
            try {
                if (count > 2) {
                    qdr = TransformUtils.getSliceQDR(layout, da, qdr, 2, da.getEdgeCurrentSliceLong(2), hierarchicalQDR);
                }
            }
            catch (EdgeOutOfRangeException e) {
                Logger.getLogger("oracle.dss.util.transform").log(Level.SEVERE, "Bad edge", e);
            }
            catch (SliceOutOfRangeException se) {
                throw new TransformRuntimeException(se.getMessage(), se);
            }
            int i = 3;
            while (i < count) {
                try {
                    qdr = TransformUtils.getSliceQDR(layout, da, qdr, i, 0L, hierarchicalQDR);
                }
                catch (EdgeOutOfRangeException e) {
                    Logger.getLogger("oracle.dss.util.transform").log(Level.SEVERE, "Bad edge", e);
                }
                catch (SliceOutOfRangeException se) {
                    throw new TransformRuntimeException(se.getMessage(), se);
                }
                ++i;
            }
        }
        return qdr;
    }

    public static QDR getSliceQDRImpl(String[][] layout, String dataLayer, DataAccessLong da, long pageSlice, int edge, long slice, int flags, boolean hierarchicalQDR) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        return TransformUtils.getSliceQDR(layout, dataLayer, da, pageSlice, edge, slice, flags, hierarchicalQDR);
    }

    public static QDR getMemberQDRImpl(String[][] layout, String dataLayer, DataAccessLong da, int edge, int layer, long slice, int flags, boolean hierarchicalQDR) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        QDR qdr = TransformUtils.generateQDR(dataLayer, hierarchicalQDR);
        int l = 0;
        while (l <= layer) {
            qdr = TransformUtils.getMemberQDR(layout, da, qdr, edge, l, slice, hierarchicalQDR);
            ++l;
        }
        if (flags == 1 && edge != 2) {
            qdr = TransformUtils.getSliceQDR(layout, da, qdr, 2, da.getEdgeCurrentSliceLong(2), hierarchicalQDR);
        }
        return qdr;
    }

    public static QDR getMemberQDRImpl(String[][] layout, String dataLayer, DataAccessLong da, int edge, long[] hPos, int memberLayer, int flags, boolean hierarchicalQDR) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        QDR qdr = TransformUtils.generateQDR(dataLayer, hierarchicalQDR);
        int l = 0;
        while (l <= memberLayer) {
            qdr = TransformUtils.getMemberQDR(layout, da, qdr, edge, hPos, l, hierarchicalQDR);
            ++l;
        }
        if (flags == 1 && edge != 2) {
            qdr = TransformUtils.getSliceQDR(layout, da, qdr, 2, da.getEdgeCurrentSliceLong(2), hierarchicalQDR);
        }
        return qdr;
    }

    public static QDR getLayerQDRImpl(String[][] layout, String dataLayer, DataAccessLong da, int edge, int layer, int flags, boolean hierarchicalQDR) throws EdgeOutOfRangeException, LayerOutOfRangeException {
        QDR qdr = TransformUtils.generateQDR(dataLayer, hierarchicalQDR);
        qdr = TransformUtils.getLayerQDR(layout, da, qdr, edge, layer, hierarchicalQDR);
        if (edge != 2 && flags == 1) {
            try {
                qdr = TransformUtils.getSliceQDR(layout, da, qdr, 2, da.getEdgeCurrentSliceLong(2), hierarchicalQDR);
            }
            catch (SliceOutOfRangeException se) {
                throw new TransformRuntimeException(se.getMessage(), se);
            }
        }
        return qdr;
    }

    protected static QDR getLayerQDR(String[][] layout, DataAccessLong da, QDR qdr, int edge, int layer, boolean hierarchicalQDR) throws EdgeOutOfRangeException, LayerOutOfRangeException {
        String dim = TransformUtils.getItem(layout, edge, layer);
        if (dim == null) {
            return qdr;
        }
        if (hierarchicalQDR) {
            String hier = null;
            if (dim != null) {
                try {
                    hier = (String)da.getMemberMetadata(edge, layer, 0L, "hierarchy");
                }
                catch (SliceOutOfRangeException e) {
                    Logger.getLogger("oracle.dss.util.transform").log(Level.SEVERE, "Bad slice", e);
                }
            }
            ((HierarchicalQDR)qdr).addDimMemberPair(dim, null, hier, null);
        } else {
            qdr.addDimMemberPair(dim, (String)null);
        }
        return qdr;
    }

    protected static QDR getMemberQDR(String[][] layout, DataAccessLong da, QDR qdr, int edge, long[] hPos, int memberLayer, boolean hierarchicalQDR) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        Object aggObj;
        boolean agg;
        boolean total;
        String dim = TransformUtils.getItem(layout, edge, memberLayer);
        if (dim == null) {
            return qdr;
        }
        String member = TransformUtils._makeString(da.getMemberMetadata(edge, hPos, memberLayer, hPos[memberLayer], "value"));
        int type = 0;
        Object totalObj = da.getMemberMetadata(edge, hPos, memberLayer, hPos[memberLayer], "isTotal");
        boolean bl = total = totalObj instanceof Boolean ? (Boolean)totalObj : false;
        if (total) {
            type = 4;
        }
        boolean bl2 = agg = (aggObj = da.getMemberMetadata(edge, hPos, memberLayer, hPos[memberLayer], "isAgg")) instanceof Boolean ? (Boolean)aggObj : false;
        if (agg) {
            type = 5;
        }
        if (hierarchicalQDR) {
            String hier = null;
            String level = null;
            if (dim != null && (hier = TransformUtils._makeString(da.getMemberMetadata(edge, hPos, memberLayer, hPos[memberLayer], "hierarchy"))) != null) {
                level = TransformUtils._makeString(da.getMemberMetadata(edge, hPos, memberLayer, hPos[memberLayer], "level"));
            }
            HierarchicalQDRMember qdrMem = new HierarchicalQDRMember(type, member, hier, level);
            ((HierarchicalQDR)qdr).addDimMemberPair(dim, qdrMem);
        } else {
            QDRMember qdrMem = new QDRMember(type, member);
            qdr.addDimMemberPair(dim, qdrMem);
        }
        return qdr;
    }

    protected static QDR getMemberQDR(String[][] layout, DataAccessLong da, QDR qdr, int edge, int layer, long slice, boolean hierarchicalQDR) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        Object aggObj;
        boolean agg;
        boolean total;
        String dim = TransformUtils.getItem(layout, edge, layer);
        if (dim == null) {
            return qdr;
        }
        int type = 0;
        String member = TransformUtils._makeString(da.getMemberMetadata(edge, layer, (int)slice, "value"));
        Object totalObj = da.getMemberMetadata(edge, layer, (int)slice, "isTotal");
        boolean bl = total = totalObj instanceof Boolean ? (Boolean)totalObj : false;
        if (total) {
            type = 4;
        }
        boolean bl2 = agg = (aggObj = da.getMemberMetadata(edge, layer, (int)slice, "isAgg")) instanceof Boolean ? (Boolean)aggObj : false;
        if (agg) {
            type = 5;
        }
        if (hierarchicalQDR) {
            String hier = null;
            String level = null;
            if (dim != null && (hier = TransformUtils._makeString(da.getMemberMetadata(edge, layer, (int)slice, "hierarchy"))) != null) {
                level = TransformUtils._makeString(da.getMemberMetadata(edge, layer, (int)slice, "level"));
            }
            ((HierarchicalQDR)qdr).addDimMemberPair(dim, new HierarchicalQDRMember(type, member, hier, level));
        } else {
            qdr.addDimMemberPair(dim, new QDRMember(type, member));
        }
        return qdr;
    }

    protected static QDR getSliceQDR(String[][] layout, String dataLayer, DataAccessLong da, long pageSlice, int edge, long slice, int flags, boolean hierarchicalQDR) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        QDR qdr = TransformUtils.generateQDR(dataLayer, hierarchicalQDR);
        qdr = TransformUtils.getSliceQDR(layout, da, qdr, edge, slice, hierarchicalQDR);
        if (flags == 1 && edge != 2 && da.getEdgeCount() > 2) {
            qdr = TransformUtils.getSliceQDR(layout, da, qdr, 2, pageSlice, hierarchicalQDR);
        }
        return qdr;
    }

    protected static QDR getValueQDR(String[][] layout, DataAccessLong da, QDR qdr, long row, long column, boolean hierarchicalQDR) throws EdgeOutOfRangeException, RowOutOfRangeException, ColumnOutOfRangeException {
        try {
            TransformUtils.addEdgeToQDR(layout, da, qdr, 0, column, hierarchicalQDR);
        }
        catch (SliceOutOfRangeException se) {
            throw new ColumnOutOfRangeException(column, -1, se);
        }
        try {
            TransformUtils.addEdgeToQDR(layout, da, qdr, 1, row, hierarchicalQDR);
        }
        catch (SliceOutOfRangeException se) {
            throw new RowOutOfRangeException(row, -1, se);
        }
        return qdr;
    }

    protected static QDR getSliceQDR(String[][] layout, DataAccessLong da, QDR qdr, int edge, long slice, boolean hierarchicalQDR) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        TransformUtils.addEdgeToQDR(layout, da, qdr, edge, slice, hierarchicalQDR);
        return qdr;
    }

    protected static void addEdgeToQDR(String[][] layout, DataAccessLong da, QDR qdr, int edge, long index, boolean hierarchicalQDR) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        String dimName = null;
        long limit = da.getSliceMemberCount(edge, index);
        int depth = 0;
        while ((long)depth < limit) {
            dimName = TransformUtils.getItem(layout, edge, depth);
            if (dimName != null) {
                try {
                    Object aggObj;
                    boolean agg;
                    boolean total;
                    int type = 0;
                    Object value = da.getMemberMetadata(edge, depth, (int)index, "value");
                    Object totalObj = da.getMemberMetadata(edge, depth, (int)index, "isTotal");
                    boolean bl = total = totalObj instanceof Boolean ? (Boolean)totalObj : false;
                    if (total) {
                        type = 4;
                    }
                    boolean bl2 = agg = (aggObj = da.getMemberMetadata(edge, depth, (int)index, "isAgg")) instanceof Boolean ? (Boolean)aggObj : false;
                    if (agg) {
                        type = 5;
                    }
                    if (hierarchicalQDR) {
                        String hier = null;
                        String level = null;
                        hier = TransformUtils._makeString(da.getMemberMetadata(edge, depth, (int)index, "hierarchy"));
                        if (hier != null) {
                            level = TransformUtils._makeString(da.getMemberMetadata(edge, depth, (int)index, "level"));
                        }
                        ((HierarchicalQDR)qdr).addDimMemberPair(dimName, new HierarchicalQDRMember(type, (String)value, hier, level));
                    } else {
                        qdr.addDimMemberPair(dimName, new QDRMember(type, value));
                    }
                }
                catch (LayerOutOfRangeException e) {
                    throw new TransformRuntimeException(e.getMessage(), e);
                }
            }
            ++depth;
        }
    }

    protected static String getItem(String[][] layout, int edge, int layer) {
        if (layout != null && edge < layout.length && layer < layout[edge].length) {
            return layout[edge][layer];
        }
        return null;
    }

    public static String _makeString(Object obj) {
        return obj == null ? null : obj.toString();
    }

    protected static HierarchicalQDR getHierarchicalQDR(String measureDim) {
        return new HierarchicalQDR(measureDim);
    }

    public static List getUniqueMemberMetadata(DataAccessLong da, boolean isSymmetric, long parentLimit, int edge, int layer, String[] types, long start, long count) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        List retVal = new ArrayList<Object[]>();
        if (types == null) {
            return retVal;
        }
        if (isSymmetric) {
            long[] context = new long[layer];
            long numVals = da.getMemberSiblingCount(edge, context, layer);
            int i = 0;
            while ((long)i < numVals) {
                retVal.add(TransformUtils.getArrayOfMetadataTypes(da, edge, context, layer, i, types));
                ++i;
            }
            return retVal;
        }
        ArrayList uniqueTrack = new ArrayList();
        long[] hPos = new long[da.getLayerCount(edge)];
        Object[] rets = TransformUtils._accumulateMembers(da, edge, 0, layer, hPos, parentLimit, count > (long)-1 ? count + start : (long)-1, 0L, retVal, uniqueTrack, types);
        retVal = (List)rets[0];
        if (start > 0L) {
            return new ArrayList(retVal.subList((int)start, retVal.size()));
        }
        return retVal;
    }

    private static Object[] _accumulateMembers(DataAccessLong da, int edge, int layer, int walkLayer, long[] hPos, long parentLimit, long uniqueLimit, long parentCount, List currentSet, List uniqueSet, String[] types) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (uniqueLimit > (long)-1 && (long)uniqueSet.size() >= uniqueLimit || parentCount > (long)-1 && parentCount >= parentLimit) {
            return new Object[]{currentSet, uniqueSet, new Long(parentCount)};
        }
        long count = da.getMemberSiblingCount(edge, hPos, layer);
        List currentSetTemp = currentSet;
        List uniqueSetTemp = uniqueSet;
        if (layer == walkLayer) {
            long i = 0L;
            while (i < count) {
                int pos;
                Object value = da.getMemberMetadata(edge, hPos, walkLayer, i, "value");
                if (value != null && (pos = uniqueSetTemp.indexOf(value)) == -1) {
                    uniqueSetTemp.add(value);
                    currentSetTemp.add(TransformUtils.getArrayOfMetadataTypes(da, edge, hPos, walkLayer, i, types));
                    if (uniqueLimit > (long)-1 && (long)uniqueSetTemp.size() >= uniqueLimit) break;
                }
                ++i;
            }
            return new Object[]{currentSetTemp, uniqueSetTemp, new Long(parentCount)};
        }
        long parents = parentCount;
        long i = 0L;
        while (i < count) {
            hPos[layer] = i;
            Object[] rets = TransformUtils._accumulateMembers(da, edge, layer + 1, walkLayer, hPos, parentLimit, uniqueLimit, parents, currentSetTemp, uniqueSetTemp, types);
            currentSetTemp = (List)rets[0];
            uniqueSetTemp = (List)rets[1];
            parents = ((Long)rets[2]).intValue();
            if (parentLimit > (long)-1 && ++parents >= parentLimit) break;
            ++i;
        }
        return new Object[]{currentSetTemp, uniqueSetTemp, new Long(parentCount)};
    }

    public static int[] getLayerAndEdge(String layerName, String[][] layout) {
        int e = 0;
        while (e < layout.length) {
            if (layout[e] != null) {
                int l = 0;
                while (l < layout[e].length) {
                    if (layout[e][l] != null && layout[e][l].equals(layerName)) {
                        int[] val = new int[]{e, l};
                        return val;
                    }
                    ++l;
                }
            }
            ++e;
        }
        return null;
    }

    private static long[] _findMember(DataAccess da, int edge, int layer, int walkLayer, int[] hPos, String value) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (layer == walkLayer) {
            int pos = da.findMember(edge, hPos, walkLayer, value, "value", 1);
            if (pos == -1) {
                return null;
            }
            hPos[walkLayer] = pos;
            return TransformUtils.getLongFromIntArray(hPos);
        }
        long count = da.getMemberSiblingCount(edge, hPos, layer);
        long i = 0L;
        while (i < count) {
            hPos[layer] = (int)i;
            long[] rethPos = TransformUtils._findMember(da, edge, layer + 1, walkLayer, hPos, value);
            if (rethPos != null) {
                return rethPos;
            }
            ++i;
        }
        return null;
    }

    public static List getCorrespondingMemberMetadata(DataAccess da, int edge, int layer, String[] values, String[] types, boolean inDataAccess, boolean isSymmetric) throws EdgeOutOfRangeException, LayerOutOfRangeException {
        ArrayList<Object[]> retVal = new ArrayList<Object[]>();
        if (!inDataAccess) {
            return retVal;
        }
        if (values == null || types == null) {
            return retVal;
        }
        int i = 0;
        while (i < values.length) {
            if (isSymmetric) {
                long[] context = new long[layer + 1];
                long pos = -1;
                try {
                    pos = da.findMember(edge, TransformUtils.getIntFromLongArray(context), layer, values[i], "value", 1);
                }
                catch (SliceOutOfRangeException e) {
                    throw new LayerOutOfRangeException(e.getMessage(), e);
                }
                if (pos == (long)-1) {
                    retVal.add(null);
                } else {
                    try {
                        retVal.add(TransformUtils.getArrayOfMetadataTypes((DataAccessLong)((Object)da), edge, context, layer, pos, types));
                    }
                    catch (SliceOutOfRangeException e) {
                        throw new LayerOutOfRangeException(e.getMessage(), e);
                    }
                }
            } else {
                long[] context = new long[layer + 1];
                long[] hPos = null;
                try {
                    hPos = TransformUtils._findMember(da, edge, 0, layer, TransformUtils.getIntFromLongArray(context), values[i]);
                }
                catch (SliceOutOfRangeException e) {
                    throw new LayerOutOfRangeException(e.getMessage(), e);
                }
                if (hPos != null) {
                    try {
                        retVal.add(TransformUtils.getArrayOfMetadataTypes((DataAccessLong)((Object)da), edge, hPos, layer, hPos[layer], types));
                    }
                    catch (SliceOutOfRangeException e) {
                        throw new LayerOutOfRangeException(e.getMessage(), e);
                    }
                } else {
                    retVal.add(null);
                }
            }
            ++i;
        }
        return retVal;
    }

    public static Object[] getArrayOfMetadataTypes(DataAccessLong da, int edge, long[] hPos, int memberLayer, long index, String[] types) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        Object[] retArray = new Object[types.length];
        int i = 0;
        while (i < types.length) {
            retArray[i] = da.getMemberMetadata(edge, hPos, memberLayer, index, types[i]);
            ++i;
        }
        return retArray;
    }

    public static boolean compareStrings(String s1, String s2, int flags) {
        if (s2 == null) {
            return false;
        }
        if ((flags & 2) > 0) {
            return s2.indexOf(s1) > -1;
        }
        if ((flags & 4) > 0) {
            return s2.startsWith(s1);
        }
        if ((flags & 8) > 0) {
            return s2.endsWith(s1);
        }
        return s2.equals(s1);
    }

    public static class NullMarker {
    }
}

