/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.transform;

import java.util.Hashtable;
import java.util.Map;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.InsertableTreeDataAccess;
import oracle.dss.util.transform.BaseProjection;
import oracle.dss.util.transform.CommonTreeBasedCubicDataAccess;
import oracle.dss.util.transform.Cube;
import oracle.dss.util.transform.DataCellInterface;
import oracle.dss.util.transform.LayerInterface;
import oracle.dss.util.transform.MemberInterface;
import oracle.dss.util.transform.StackPack;
import oracle.dss.util.transform.TransformException;
import oracle.dss.util.transform.TreeBasedEdgeTree;
import oracle.dss.util.transform.TreeNode;
import oracle.dss.util.transform.TreeProjection;

public class TreeBasedCubicDataAccess
extends CommonTreeBasedCubicDataAccess
implements InsertableTreeDataAccess {
    protected TreeProjection m_projection;

    private void $init$() {
        this.m_projection = null;
    }

    public TreeBasedCubicDataAccess(TreeProjection projection) throws TransformException {
        this(projection, false, null);
    }

    public TreeBasedCubicDataAccess(TreeProjection projection, boolean cache) throws TransformException {
        this(projection, cache, null);
    }

    public TreeBasedCubicDataAccess(TreeProjection projection, boolean cache, boolean[] alwaysAdd) throws TransformException {
        super(cache);
        this.$init$();
        this.m_alwaysAdd = alwaysAdd;
        this.init(projection, this.m_alwaysAdd);
    }

    public Object clone() throws CloneNotSupportedException {
        TreeBasedCubicDataAccess da = (TreeBasedCubicDataAccess)super.clone();
        da.m_layerEdge = (Hashtable)this.m_layerEdge.clone();
        return da;
    }

    protected void init(TreeProjection projection, boolean[] alwaysAdd) throws TransformException {
        this.m_cube = new Cube();
        this.m_projection = projection.getDataItems() != null ? new ImpliedMeasureTreeProjection(projection) : projection;
        this.initCaches();
        TreeNode nodes = this.m_projection.getNodeTree();
        if (nodes == null) {
            return;
        }
        StackPack stackPack = new StackPack();
        this.buildTree(nodes, stackPack, -1, -1, null, alwaysAdd);
        this.m_cube.lockTrees();
    }

    protected LayerInterface getDataLayerInterface() {
        return this.m_projection.getDataLayer();
    }

    protected BaseProjection getProjection() {
        return this.m_projection;
    }

    protected TreeBasedEdgeTree getEdgeTree(TreeNode node, long slice, boolean checked) throws TransformException {
        int edge = this.getEdgeForLayer(node);
        TreeBasedEdgeTree et = null;
        try {
            et = (TreeBasedEdgeTree)super.getEdgeTree(edge, slice, checked);
        }
        catch (EdgeOutOfRangeException e) {
            throw new TransformException(e.getMessage(), e);
        }
        if (et == null) {
            et = new TreeBasedEdgeTree(this._getLayers(edge), edge, (BaseProjection)this.m_projection, this.m_projection.getDataLayer().getValue(), this.getMeasList(this.m_projection), this.m_projection.isNoCollapseLeaves(edge), -1, null);
            this.m_cube.setEdgeTree(edge, et);
        }
        return et;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ImpliedMeasureTreeProjection
    implements TreeProjection {
        protected TreeProjection m_proj;
        protected ImpliedMeasureTreeNode m_node;
        protected String[][] m_layout;
        protected int m_impliedMeasureEdge;

        private void $init$() {
            this.m_proj = null;
            this.m_node = null;
            this.m_layout = null;
            this.m_impliedMeasureEdge = -1;
        }

        public ImpliedMeasureTreeProjection(TreeProjection proj) {
            this.$init$();
            this.m_proj = proj;
        }

        private int getLastLayerEdge(String[][] layout, LayerInterface layerInt) throws TransformException {
            if (layerInt == null) {
                return -1;
            }
            int e = 0;
            while (e < layout.length) {
                if (layout[e] != null && layout[e][layout[e].length - 1].equals(layerInt.getValue())) {
                    return e;
                }
                ++e;
            }
            return -1;
        }

        private int findBottom() throws TransformException {
            String[][] layout = this.m_proj.getLayout();
            if (layout == null) {
                return -1;
            }
            if (this.placeDataItemsAlone()) {
                if (layout.length == 1) {
                    return 1;
                }
                int i = 0;
                while (i < Math.min(layout.length, 2)) {
                    if (layout[i] == null || layout[i].length == 0) {
                        return i;
                    }
                    ++i;
                }
            }
            return this.walkTree(layout, this.m_proj.getNodeTree());
        }

        private int walkTree(String[][] layout, TreeNode currNode) throws TransformException {
            if (currNode == null) {
                return -1;
            }
            int retLayerEdge = this.getLastLayerEdge(layout, currNode.getLayer());
            if (retLayerEdge > -1 && currNode.getFirstChild() == null) {
                return retLayerEdge;
            }
            retLayerEdge = this.walkTree(layout, currNode.getFirstChild());
            if (retLayerEdge == -1) {
                retLayerEdge = this.walkTree(layout, currNode.getNextSibling());
            }
            return retLayerEdge;
        }

        private int getNewLength(String[][] origLayout) {
            if (this.placeDataItemsAlone() && origLayout.length == 1) {
                return 2;
            }
            return origLayout.length;
        }

        private int getLength(String[][] str, int e) {
            if (str.length <= e || str[e] == null) {
                return 0;
            }
            return str[e].length;
        }

        @Override
        public String[][] getLayout() {
            if (this.m_layout == null) {
                try {
                    int bottomLayerEdge = this.findBottom();
                    String[][] origLayout = this.m_proj.getLayout();
                    if (bottomLayerEdge == -1) {
                        this.m_layout = origLayout;
                    } else {
                        String[][] newLayout = new String[this.getNewLength(origLayout)][];
                        int e = 0;
                        while (e < newLayout.length) {
                            if (e == bottomLayerEdge) {
                                newLayout[e] = new String[this.getLength(origLayout, e) + 1];
                                newLayout[e][newLayout[e].length - 1] = this.m_proj.getDataLayer().getValue();
                                this.m_impliedMeasureEdge = e;
                            } else {
                                newLayout[e] = new String[this.getLength(origLayout, e)];
                            }
                            int l = 0;
                            while (l < this.getLength(origLayout, e)) {
                                newLayout[e][l] = origLayout[e][l];
                                ++l;
                            }
                            ++e;
                        }
                        this.m_layout = newLayout;
                    }
                }
                catch (TransformException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            return this.m_layout;
        }

        @Override
        public LayerInterface getDataLayer() {
            return this.m_proj.getDataLayer();
        }

        @Override
        public MemberInterface[] getDataItems() {
            return this.m_proj.getDataItems();
        }

        @Override
        public boolean placeDataItemsAlone() {
            return this.m_proj.placeDataItemsAlone();
        }

        @Override
        public DataCellInterface getData(Map<String, Object> keyPath) {
            return this.m_proj.getData(keyPath);
        }

        @Override
        public TreeNode getNodeTree() {
            if (this.m_node == null) {
                this.m_node = new ImpliedMeasureTreeNode(this.m_proj.getNodeTree(), this);
            }
            return this.m_node;
        }

        @Override
        public boolean isNoCollapseLeaves(int edge) {
            if (edge == this.m_impliedMeasureEdge) {
                return true;
            }
            return this.m_proj.isNoCollapseLeaves(edge);
        }

        @Override
        public boolean repeats(int edge) {
            return this.m_proj.repeats(edge);
        }
    }

    protected class ImpliedMeasureTreeNode
    implements TreeNode {
        protected TreeNode m_node;
        protected TreeNode m_child;
        protected ImpliedMeasureTreeNode m_sibling;
        protected ImpliedMeasureTreeNode m_parent;
        protected ImpliedMeasureTreeProjection m_proj;

        private void $init$() {
            this.m_node = null;
            this.m_child = null;
            this.m_sibling = null;
            this.m_parent = null;
            this.m_proj = null;
        }

        public ImpliedMeasureTreeNode(TreeNode node, ImpliedMeasureTreeProjection proj) {
            this.$init$();
            this.m_node = node;
            this.m_proj = proj;
        }

        public MemberInterface getMember() {
            return this.m_node.getMember();
        }

        public LayerInterface getLayer() {
            return this.m_node.getLayer();
        }

        private TreeNode getMeasureChildren(TreeNode parent) {
            MemberInterface[] dataItems = this.m_proj.getDataItems();
            CommonTreeBasedCubicDataAccess.TreeNodeImpl retNode = null;
            CommonTreeBasedCubicDataAccess.TreeNodeImpl lastNode = null;
            CommonTreeBasedCubicDataAccess.TreeNodeImpl currNode = null;
            int i = 0;
            while (i < dataItems.length) {
                currNode = new CommonTreeBasedCubicDataAccess.TreeNodeImpl(dataItems[i], this.m_proj.getDataLayer(), parent);
                if (lastNode == null) {
                    retNode = currNode;
                } else {
                    lastNode.setSibling(currNode);
                }
                lastNode = currNode;
                ++i;
            }
            return retNode;
        }

        public TreeNode getFirstChild() {
            if (this.m_child == null) {
                this.m_child = this.m_node.getFirstChild() == null ? this.getMeasureChildren(this.m_node) : new ImpliedMeasureTreeNode(this.m_node.getFirstChild(), this.m_proj);
            }
            return this.m_child;
        }

        public TreeNode getNextSibling() {
            if (this.m_sibling == null && this.m_node.getNextSibling() != null) {
                this.m_sibling = new ImpliedMeasureTreeNode(this.m_node.getNextSibling(), this.m_proj);
            }
            return this.m_sibling;
        }

        public TreeNode getParent() {
            if (this.m_parent == null && this.m_node.getParent() != null) {
                this.m_parent = new ImpliedMeasureTreeNode(this.m_node.getParent(), this.m_proj);
            }
            return this.m_parent;
        }
    }
}

