/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.transform;

import java.util.HashMap;
import oracle.dss.util.LayerMetadataMap;
import oracle.dss.util.MetadataMap;
import oracle.dss.util.QDR;
import oracle.dss.util.QDRInterface;
import oracle.dss.util.transform.DataCellInterface;
import oracle.dss.util.transform.LayerInterface;
import oracle.dss.util.transform.MemberInterface;
import oracle.dss.util.transform.TransformException;
import oracle.dss.util.transform.TransformUtils;
import oracle.dss.util.transform.TreeCollection;
import oracle.dss.util.transform.TreeMapper;
import oracle.dss.util.transform.TreeNode;
import oracle.dss.util.transform.TreeProjection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeRecord
extends HashMap {
    protected TreeNode m_node;
    protected TreeProjection m_proj;
    protected Object m_nullValue;
    protected QDR m_qdr;
    protected TreeMapper m_mapper;

    private void $init$() {
        this.m_node = null;
        this.m_proj = null;
        this.m_nullValue = null;
        this.m_qdr = null;
        this.m_mapper = null;
    }

    public TreeRecord(TreeNode node, TreeProjection proj, Object nullValue, TreeMapper mapper) {
        this.$init$();
        this.m_node = node;
        this.m_proj = proj;
        this.m_nullValue = nullValue;
        this.m_mapper = mapper;
    }

    @Override
    public Object get(Object key) {
        String attr = (String)key;
        try {
            TreeCollection coll;
            if (this.m_mapper != null) {
                Class mapClass = this.m_mapper.getMapClass(attr);
                String mapType = this.m_mapper.getMapType(attr);
                if (mapClass != null && mapClass.equals(LayerMetadataMap.class) && mapType != null) {
                    Object object = this.getLayer().getMetadata(TransformUtils.convertLayerMetadataMap(mapType));
                    return object;
                }
                if (mapClass != null && mapClass.equals(MetadataMap.class) && mapType != null) {
                    String mm = TransformUtils.convertMetadataMap(mapType);
                    Object object = this.getMember().getMetadata(mm);
                    return object;
                }
            }
            if (attr.startsWith("layerInterface")) {
                LayerInterface layerInterface = this.getLayer();
                return layerInterface;
            }
            if (attr.startsWith("memberInterface")) {
                MemberInterface memberInterface = this.getMember();
                return memberInterface;
            }
            if (attr.toUpperCase().equals("ID")) {
                String id = this.getMember().getValue();
                if (id == null) {
                    Object object = this.m_nullValue;
                    return object;
                }
                String string = id;
                return string;
            }
            if (attr.toUpperCase().equals("LABEL")) {
                Object object = this.getMember().getMetadata("longName");
                return object;
            }
            if (attr.equals("dataValue")) {
                DataCellInterface dci = this.getDataValue(this.getQDR());
                if (dci != null) {
                    Object object = dci.getData("dataValue");
                    return object;
                }
                Object var18_16 = null;
                return var18_16;
            }
            TreeCollection treeCollection = coll = this.getCollection();
            return treeCollection;
        }
        catch (TransformException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private QDR getQDR() throws TransformException {
        if (this.m_qdr == null) {
            this.m_qdr = TransformUtils.getQDRFromTreeNode(this.m_node);
        }
        return this.m_qdr;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof TreeRecord) {
            TreeRecord rec = (TreeRecord)o;
            return this.m_node.equals(rec.m_node);
        }
        return false;
    }

    @Override
    public int hashCode() {
        TreeCollection tc = this.getCollection();
        return this.m_node.hashCode() + (tc != null ? tc.hashCode() : 0);
    }

    public TreeNode getTreeNode() {
        return this.m_node;
    }

    public TreeCollection getCollection() {
        TreeNode node = this.m_node.getFirstChild();
        if (node != null) {
            return new TreeCollection(node, this.m_proj, this.m_nullValue, this.m_mapper);
        }
        return null;
    }

    public LayerInterface getLayer() throws TransformException {
        if (this.m_mapper != null) {
            return this.m_mapper.getLayer(this.m_node);
        }
        return this.m_node.getLayer();
    }

    public MemberInterface getMember() throws TransformException {
        if (this.m_mapper != null) {
            return this.m_mapper.getMember(this.m_node);
        }
        return this.m_node.getMember();
    }

    public DataCellInterface getDataValue(QDRInterface qdr) {
        return this.m_proj.getData(qdr);
    }
}

