/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.transform;

import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.transform.BaseProjection;
import oracle.dss.util.transform.Cube;
import oracle.dss.util.transform.EdgeTreeBasedCubicDataAccess;
import oracle.dss.util.transform.EdgeTreeNode;
import oracle.dss.util.transform.StackPack;
import oracle.dss.util.transform.TransformException;
import oracle.dss.util.transform.TreeBasedEdgeTree;
import oracle.dss.util.transform.TreeNode;
import oracle.dss.util.transform.VirtualEdgeTreeProjection;
import oracle.dss.util.transform.VirtualTreeBasedEdgeTree;
import oracle.dss.util.transform.VirtualTreeNode;

public class VirtualEdgeTreeBasedCubicDataAccess
extends EdgeTreeBasedCubicDataAccess {
    public VirtualEdgeTreeBasedCubicDataAccess(VirtualEdgeTreeProjection[] projection, boolean cache) throws TransformException {
        super(cache);
        this.init(projection);
    }

    protected void init(VirtualEdgeTreeProjection[] projection) throws TransformException {
        this.m_cube = new Cube();
        this.initCaches();
        this.m_projection = new VirtualEdgeTreeProjection[projection.length];
        this.m_stackPack = new StackPack[projection.length];
        int e = 0;
        while (e < projection.length) {
            TreeNode nodes;
            this.m_projection[e] = projection[e];
            if (projection[e] != null && (nodes = this.m_projection[e].getNodeTree()) != null) {
                if (this.m_stackPack[e] == null) {
                    this.m_stackPack[e] = new StackPack();
                }
                this.buildTree(nodes, this.m_stackPack[e], e, 0L, null, this.m_alwaysAdd);
            }
            ++e;
        }
        this.m_cube.lockTrees();
    }

    public Object clone() throws CloneNotSupportedException {
        VirtualEdgeTreeBasedCubicDataAccess da = (VirtualEdgeTreeBasedCubicDataAccess)super.clone();
        return da;
    }

    public synchronized long getEdgeExtentLong(int edge) throws EdgeOutOfRangeException {
        long extent;
        if (edge < this.m_projection.length && this.m_projection[edge] instanceof VirtualEdgeTreeProjection && (extent = this._getExtent(edge)) > (long)-1) {
            return extent;
        }
        return super.getEdgeExtentLong(edge);
    }

    protected TreeBasedEdgeTree getEdgeTree(int edge) throws TransformException {
        return new VirtualTreeBasedEdgeTree(this._getLayers(edge), edge, (BaseProjection)this.m_projection[edge], this.m_projection[edge].getDataLayer().getValue(), this.getMeasList(this.m_projection[edge]), true, this._getExtent(edge), this);
    }

    private long _getExtent(int edge) {
        if (edge < this.m_projection.length && this.m_projection[edge] instanceof VirtualEdgeTreeProjection) {
            return ((VirtualTreeNode)this.m_projection[edge].getNodeTree()).getExtent();
        }
        return -1;
    }

    protected void updateTree(int edge, long slice, EdgeTreeNode currNode) throws TransformException {
        if (slice == (long)-1 && currNode == null) {
            return;
        }
        this.buildTree(this.m_projection[edge].getNodeTree(), this.m_stackPack[edge], edge, slice, currNode, this.m_alwaysAdd);
    }
}

