/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.transform.total;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;
import oracle.dss.util.QDR;
import oracle.dss.util.QDRMember;
import oracle.dss.util.transform.LayerInterface;
import oracle.dss.util.transform.MemberCell;
import oracle.dss.util.transform.MemberInterface;
import oracle.dss.util.transform.Row;
import oracle.dss.util.transform.RowProjection;
import oracle.dss.util.transform.TransformException;
import oracle.dss.util.transform.total.AggColumn;
import oracle.dss.util.transform.total.AggSpec;
import oracle.dss.util.transform.total.TotalMember;
import oracle.dss.util.transform.total.TotalPlacement;
import oracle.dss.util.transform.total.TotalRow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggBuckets {
    protected AggSpec[] m_aggs;
    protected LinkedHashMap<QDR, TotalRow>[] m_buckets;
    protected RowProjection m_projection;

    private void $init$() {
        this.m_aggs = null;
        this.m_buckets = null;
        this.m_projection = null;
    }

    public AggBuckets(AggSpec[] aggs, RowProjection projection) {
        this.$init$();
        this.m_projection = projection;
        this.m_aggs = aggs;
        this.m_buckets = new LinkedHashMap[this.m_aggs.length];
    }

    public String[] getAggColumns() {
        Vector<String> colRet = new Vector<String>();
        if (this.m_aggs != null) {
            int i = 0;
            while (i < this.m_aggs.length) {
                AggColumn[] cols;
                if (this.m_aggs[i] != null && (cols = this.m_aggs[i].getColumnsToAggregate()) != null) {
                    int j = 0;
                    while (j < cols.length) {
                        String col;
                        if (cols[j] != null && (col = cols[j].getColumn()) != null && colRet.indexOf(col) == -1) {
                            colRet.addElement(col);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return colRet.toArray(new String[0]);
    }

    private int getEdgeForColumn(AggColumn col) {
        String[][] layout = this.m_projection.getLayout();
        if (layout == null || col == null) {
            return -1;
        }
        int e = 0;
        while (e < layout.length) {
            if (layout[e] != null) {
                int l = 0;
                while (l < layout[e].length) {
                    if (col.getColumn().equals(layout[e][l])) {
                        return e;
                    }
                    ++l;
                }
            }
            ++e;
        }
        return -1;
    }

    public void release() {
        if (this.m_aggs != null) {
            int i = 0;
            while (i < this.m_aggs.length) {
                if (this.m_aggs[i] != null) {
                    this.m_aggs[i].release();
                }
                ++i;
            }
        }
        this.m_projection = null;
        if (this.m_buckets != null) {
            int i = 0;
            while (i < this.m_buckets.length) {
                if (this.m_buckets[i] != null) {
                    this.m_buckets[i].clear();
                }
                ++i;
            }
        }
        this.m_buckets = null;
    }

    protected boolean isGroupingColumn(String col, AggSpec spec) {
        AggColumn[] cols = spec.getColumnsToAggregate();
        int c = 0;
        while (c < cols.length) {
            if (cols[c].getColumn().equals(col)) {
                return true;
            }
            ++c;
        }
        return false;
    }

    protected boolean isDataItem(String col) throws TransformException {
        MemberInterface[] dataItems = this.m_projection.getDataItems();
        int i = 0;
        while (i < dataItems.length) {
            if (col.equals(dataItems[i].getValue())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected List<String> getGroupingColumns(AggSpec spec) throws TransformException {
        ArrayList<String> groupingColumns = new ArrayList<String>();
        String[][] layout = this.m_projection.getLayout();
        int e = 0;
        while (e < layout.length) {
            if (layout[e] != null) {
                int l = 0;
                while (l < layout[e].length) {
                    if (!this.isGroupingColumn(layout[e][l], spec) && !this.isDataItem(layout[e][l])) {
                        groupingColumns.add(layout[e][l]);
                    }
                    ++l;
                }
            }
            ++e;
        }
        return groupingColumns;
    }

    protected QDR getGroupingKey(Row row, AggSpec spec) throws TransformException {
        List<String> cols = this.getGroupingColumns(spec);
        LayerInterface li = this.m_projection.getDataLayer();
        QDR qdr = new QDR(li != null ? li.getValue() : null);
        for (String col : cols) {
            if (col.equals(qdr.getMeasureDim())) continue;
            qdr.addDimMemberPair(col, new QDRMember(0, row.getMember(col).getMemberInterface().getValue()));
        }
        return qdr;
    }

    public void totalRow(Row row) throws TransformException {
        if (this.m_aggs == null) {
            return;
        }
        QDR groupingKey = null;
        TotalRow currRow = null;
        int i = 0;
        while (i < this.m_aggs.length) {
            block10: {
                block9: {
                    AggColumn[] columns = this.m_aggs[i].getColumnsToAggregate();
                    if (!(row instanceof TotalRow) || columns == null) break block9;
                    boolean skip = false;
                    int c = 0;
                    while (c < columns.length) {
                        MemberCell cell;
                        String colName;
                        if (columns[c] != null && (colName = columns[c].getColumn()) != null && (cell = row.getMember(colName)) != null && cell.getMemberInterface() instanceof TotalMember) {
                            skip = true;
                            break;
                        }
                        ++c;
                    }
                    if (skip) break block10;
                }
                groupingKey = this.getGroupingKey(row, this.m_aggs[i]);
                if (this.m_buckets[i] == null) {
                    this.m_buckets[i] = new LinkedHashMap();
                }
                if ((currRow = this.m_buckets[i].get(groupingKey)) == null) {
                    this.m_buckets[i].put(groupingKey, new TotalRow(row, this.m_projection, this.m_aggs[i]));
                    currRow = this.m_buckets[i].get(groupingKey);
                }
                currRow.aggregate(row, groupingKey);
            }
            ++i;
        }
    }

    public TotalPlacement[] getTotalPlacements() {
        if (this.m_buckets != null) {
            Collection<TotalRow> values = null;
            TotalPlacement[] placements = new TotalPlacement[this.m_buckets.length];
            int bucket = 0;
            while (bucket < this.m_buckets.length) {
                ArrayList<TotalRow> totals = new ArrayList<TotalRow>();
                if (this.m_buckets[bucket] != null) {
                    values = this.m_buckets[bucket].values();
                    for (TotalRow total : values) {
                        if (!total.include()) continue;
                        totals.add(total);
                    }
                    placements[bucket] = new TotalPlacement(totals, this.m_aggs[bucket].getOptions().getAggLocation());
                }
                ++bucket;
            }
            return placements;
        }
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        AggBuckets retVal = new AggBuckets(this.m_aggs, this.m_projection);
        retVal.m_buckets = (LinkedHashMap[])this.m_buckets.clone();
        return retVal;
    }
}

