/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.transform.total;

import java.util.ArrayList;
import oracle.dss.util.QDR;
import oracle.dss.util.transform.DataCell;
import oracle.dss.util.transform.DataCellInterface;
import oracle.dss.util.transform.DataTable;
import oracle.dss.util.transform.LayerInterface;
import oracle.dss.util.transform.MemberCell;
import oracle.dss.util.transform.Row;
import oracle.dss.util.transform.RowProjection;
import oracle.dss.util.transform.TransformException;
import oracle.dss.util.transform.total.AggColumn;
import oracle.dss.util.transform.total.AggLocation;
import oracle.dss.util.transform.total.AggMethod;
import oracle.dss.util.transform.total.AggSpec;
import oracle.dss.util.transform.total.AggType;
import oracle.dss.util.transform.total.TotalData;
import oracle.dss.util.transform.total.TotalMember;

public class TotalRow
extends Row {
    protected AggSpec m_spec;
    protected RowProjection m_projection;
    protected long m_aggedRowCount;
    protected ArrayList<Row> m_rowsSeen;

    private void $init$() {
        this.m_spec = null;
        this.m_projection = null;
        this.m_aggedRowCount = 0L;
        this.m_rowsSeen = new ArrayList();
    }

    public TotalRow(Row row, RowProjection projection, AggSpec spec) throws TransformException {
        this(row.getDataTable());
        this.m_spec = spec;
        this.m_projection = projection;
        this.setMembers(this.getTotalMembers(row.getMembers(), spec));
        this.setCells(this.getTotalCells(row.getCells()));
    }

    public boolean isCalculatedValue() {
        return true;
    }

    protected TotalRow(DataTable dt) {
        super(dt);
        this.$init$();
    }

    public void release() {
        if (this.m_spec != null) {
            this.m_spec.release();
        }
        this.m_spec = null;
        this.m_projection = null;
        super.release();
    }

    public boolean totalDuplicates() {
        return this.m_spec.getOptions().totalDuplicates();
    }

    public AggLocation getAggLocation() {
        return this.m_spec.getOptions().getAggLocation();
    }

    public TotalData getTotalData() {
        return this.m_spec.getOptions().getTotalData();
    }

    public void aggregate(Row row, QDR groupingKey) throws TransformException {
        if (!this.totalDuplicates() && row != null) {
            if (this.m_rowsSeen.contains(row)) {
                return;
            }
            this.m_rowsSeen.add(row);
        }
        ++this.m_aggedRowCount;
        int cellCount = this.getCells().length;
        int i = 0;
        while (i < cellCount) {
            ((DataCellImpl)this.getCells()[i].getDataCellInterface()).aggregate(row.getCells()[i], groupingKey);
            ++i;
        }
    }

    public boolean include() {
        return this.m_spec.getOptions().allowSingleTotals() || this.m_aggedRowCount > 1L;
    }

    public Object clone(DataTable dt) throws CloneNotSupportedException {
        TotalRow row = new TotalRow(dt);
        row.m_spec = this.m_spec;
        row.m_projection = this.m_projection;
        row.setMembers(this.getMembers());
        DataCell[] di = this.getCells();
        DataCell[] newDI = new DataCell[di.length];
        int i = 0;
        while (i < newDI.length) {
            newDI[i] = new DataCell((DataCellImpl)((DataCellImpl)di[i].getDataCellInterface()).clone(), di[i].getDataCellColumnName());
            ++i;
        }
        row.setCells(newDI);
        return row;
    }

    protected MemberCell[] getTotalMembers(MemberCell[] members, AggSpec spec) throws TransformException {
        if (members == null) {
            return null;
        }
        MemberCell[] retVal = new MemberCell[members.length];
        AggColumn[] aggColumns = spec.getColumnsToAggregate();
        boolean isReplacement = spec.getOptions().getAggLocation() == AggLocation.REPLACE;
        int i = 0;
        while (i < retVal.length) {
            int c = 0;
            while (c < aggColumns.length) {
                if (aggColumns[c].getColumn().equals(members[i].getMemberColumnName())) {
                    retVal[i] = new MemberCell(new TotalMember(aggColumns[c].getMemberInterface(), isReplacement), members[i].getMemberColumnName());
                    break;
                }
                retVal[i] = members[i];
                ++c;
            }
            ++i;
        }
        return retVal;
    }

    protected DataCell[] getTotalCells(DataCell[] cells) {
        if (cells == null) {
            return null;
        }
        DataCell[] retVal = new DataCell[cells.length];
        int i = 0;
        while (i < retVal.length) {
            retVal[i] = new DataCell(new DataCellImpl(cells[i]), cells[i].getDataCellColumnName());
            ++i;
        }
        return retVal;
    }

    protected class DataCellImpl
    implements DataCellInterface {
        protected DataCell m_internalImpl;
        protected Object m_value;
        protected Object m_value2;
        protected Number m_statVal;
        protected Long m_count;
        protected AggType m_aggType;
        protected String m_columnName;

        private void $init$() {
            this.m_internalImpl = null;
            this.m_value = null;
            this.m_value2 = null;
            this.m_statVal = null;
            this.m_count = new Long(0L);
            this.m_aggType = null;
            this.m_columnName = null;
        }

        public DataCellImpl(DataCell internal) {
            this.$init$();
            this.m_internalImpl = internal;
        }

        public Object clone() throws CloneNotSupportedException {
            DataCellImpl dci = new DataCellImpl(this.m_internalImpl);
            dci.m_value = this.m_value;
            dci.m_value2 = this.m_value2;
            dci.m_statVal = this.m_statVal;
            dci.m_count = this.m_count;
            dci.m_aggType = this.m_aggType;
            dci.m_columnName = this.m_columnName;
            return dci;
        }

        public void aggregate(DataCell cell, QDR groupingKey) throws TransformException {
            if (cell == null) {
                return;
            }
            Object newVal = cell.getDataCellInterface().getData("dataValue");
            if (this.m_value != null && !(this.m_value instanceof Number)) {
                return;
            }
            if (newVal != null && !(newVal instanceof Number)) {
                return;
            }
            this.m_columnName = cell.getDataCellColumnName();
            AggType aggType = this.getAggType(groupingKey);
            switch (1.$sm$oracle$dss$util$transform$total$AggType[aggType.ordinal()]) {
                case 5: {
                    this.m_value = this.sum((Number)this.m_value, (Number)newVal);
                    break;
                }
                case 6: {
                    this.m_value = this.min((Number)this.m_value, (Number)newVal);
                    break;
                }
                case 7: {
                    this.m_value = this.max((Number)this.m_value, (Number)newVal);
                    break;
                }
                case 1: {
                    this.m_value = this.sum((Number)this.m_value, (Number)newVal);
                    this.countValue((Number)newVal);
                    break;
                }
                case 2: {
                    this.countValue((Number)newVal);
                    break;
                }
                case 3: 
                case 4: {
                    if (this.m_value2 != null && !(this.m_value2 instanceof Number)) {
                        return;
                    }
                    Number n = (Number)newVal;
                    this.m_value = this.sum((Number)this.m_value, n);
                    if (n != null) {
                        double dN = n.doubleValue();
                        this.m_value2 = this.sum((Number)this.m_value2, dN * dN);
                    }
                    this.countValue((Number)newVal);
                    break;
                }
            }
        }

        public Object getData(String type) throws TransformException {
            if (type.equals("dataValue") || type.equals("dataFormattedValue")) {
                TotalData totalData;
                switch (1.$sm$oracle$dss$util$transform$total$AggType[this.m_aggType.ordinal()]) {
                    case 1: {
                        TotalData totalData2;
                        Number retVal = this.div((Number)this.m_value, this.m_count);
                        if (type.equals("dataFormattedValue") && (totalData2 = TotalRow.this.getTotalData()) != null) {
                            return totalData2.getFormattedData(retVal, this.m_columnName, this.m_aggType);
                        }
                        return retVal;
                    }
                    case 2: {
                        TotalData totalData3;
                        if (type.equals("dataFormattedValue") && (totalData3 = TotalRow.this.getTotalData()) != null) {
                            return totalData3.getFormattedData(this.m_count, this.m_columnName, this.m_aggType);
                        }
                        return this.m_count;
                    }
                    case 3: 
                    case 4: {
                        TotalData totalData4;
                        if (this.m_statVal == null) {
                            if (this.m_count == 0L) {
                                return null;
                            }
                            double sum = ((Number)this.m_value).doubleValue();
                            long count = this.m_count;
                            double mean = this.div(sum, count).doubleValue();
                            double sumOfSquares = ((Number)this.m_value2).doubleValue();
                            double variance = (sumOfSquares - sum * mean) / (double)count;
                            this.m_statVal = this.m_aggType == AggType.VARIANCE ? Double.valueOf(variance) : Double.valueOf(Math.sqrt(variance));
                            this.m_count = null;
                            this.m_value = null;
                            this.m_value2 = null;
                        }
                        if (type.equals("dataFormattedValue") && (totalData4 = TotalRow.this.getTotalData()) != null) {
                            return totalData4.getFormattedData(this.m_statVal, this.m_columnName, this.m_aggType);
                        }
                        return this.m_statVal;
                    }
                }
                if (type.equals("dataFormattedValue") && (totalData = TotalRow.this.getTotalData()) != null) {
                    return totalData.getFormattedData(this.m_value, this.m_columnName, this.m_aggType);
                }
                return this.m_value;
            }
            return this.m_internalImpl.getDataCellInterface().getData(type);
        }

        protected void countValue(Number newVal) {
            if (newVal != null) {
                this.m_count = this.m_count + 1L;
            }
        }

        protected Number min(Number oper1, Number oper2) {
            if (oper1 == null && oper2 != null) {
                return oper2;
            }
            if (oper1 != null && oper2 == null) {
                return oper1;
            }
            if (oper1 instanceof Integer) {
                int val1 = oper1.intValue();
                if (oper2 instanceof Integer) {
                    return Math.min(val1, oper2.intValue());
                }
                if (oper2 instanceof Long) {
                    return Math.min((long)val1, oper2.longValue());
                }
                if (oper2 instanceof Float) {
                    return Float.valueOf(Math.min((float)val1, oper2.floatValue()));
                }
                if (oper2 instanceof Double) {
                    return Math.min((double)val1, oper2.doubleValue());
                }
            } else if (oper1 instanceof Long) {
                long val1 = oper1.longValue();
                if (oper2 instanceof Integer) {
                    return Math.min(val1, (long)oper2.intValue());
                }
                if (oper2 instanceof Long) {
                    return Math.min(val1, oper2.longValue());
                }
                if (oper2 instanceof Float) {
                    return Float.valueOf(Math.min((float)val1, oper2.floatValue()));
                }
                if (oper2 instanceof Double) {
                    return Math.min((double)val1, oper2.doubleValue());
                }
            } else if (oper1 instanceof Float) {
                float val1 = oper1.floatValue();
                if (oper2 instanceof Integer) {
                    return Float.valueOf(Math.min(val1, (float)oper2.intValue()));
                }
                if (oper2 instanceof Long) {
                    return Float.valueOf(Math.min(val1, (float)oper2.longValue()));
                }
                if (oper2 instanceof Float) {
                    return Float.valueOf(Math.min(val1, oper2.floatValue()));
                }
                if (oper2 instanceof Double) {
                    return Math.min((double)val1, oper2.doubleValue());
                }
            } else if (oper1 instanceof Double) {
                double val1 = oper1.doubleValue();
                if (oper2 instanceof Integer) {
                    return Math.min(val1, (double)oper2.intValue());
                }
                if (oper2 instanceof Long) {
                    return Math.min(val1, (double)oper2.longValue());
                }
                if (oper2 instanceof Float) {
                    return Math.min(val1, (double)oper2.floatValue());
                }
                if (oper2 instanceof Double) {
                    return Math.min(val1, oper2.doubleValue());
                }
            }
            return null;
        }

        protected Number max(Number oper1, Number oper2) {
            if (oper1 == null && oper2 != null) {
                return oper2;
            }
            if (oper1 != null && oper2 == null) {
                return oper1;
            }
            if (oper1 instanceof Integer) {
                int val1 = oper1.intValue();
                if (oper2 instanceof Integer) {
                    return Math.max(val1, oper2.intValue());
                }
                if (oper2 instanceof Long) {
                    return Math.max((long)val1, oper2.longValue());
                }
                if (oper2 instanceof Float) {
                    return Float.valueOf(Math.max((float)val1, oper2.floatValue()));
                }
                if (oper2 instanceof Double) {
                    return Math.max((double)val1, oper2.doubleValue());
                }
            } else if (oper1 instanceof Long) {
                long val1 = oper1.longValue();
                if (oper2 instanceof Integer) {
                    return Math.max(val1, (long)oper2.intValue());
                }
                if (oper2 instanceof Long) {
                    return Math.max(val1, oper2.longValue());
                }
                if (oper2 instanceof Float) {
                    return Float.valueOf(Math.max((float)val1, oper2.floatValue()));
                }
                if (oper2 instanceof Double) {
                    return Math.max((double)val1, oper2.doubleValue());
                }
            } else if (oper1 instanceof Float) {
                float val1 = oper1.floatValue();
                if (oper2 instanceof Integer) {
                    return Float.valueOf(Math.max(val1, (float)oper2.intValue()));
                }
                if (oper2 instanceof Long) {
                    return Float.valueOf(Math.max(val1, (float)oper2.longValue()));
                }
                if (oper2 instanceof Float) {
                    return Float.valueOf(Math.max(val1, oper2.floatValue()));
                }
                if (oper2 instanceof Double) {
                    return Math.max((double)val1, oper2.doubleValue());
                }
            } else if (oper1 instanceof Double) {
                double val1 = oper1.doubleValue();
                if (oper2 instanceof Integer) {
                    return Math.max(val1, (double)oper2.intValue());
                }
                if (oper2 instanceof Long) {
                    return Math.max(val1, (double)oper2.longValue());
                }
                if (oper2 instanceof Float) {
                    return Math.max(val1, (double)oper2.floatValue());
                }
                if (oper2 instanceof Double) {
                    return Math.max(val1, oper2.doubleValue());
                }
            }
            return null;
        }

        protected Number sum(Number oper1, Number oper2) {
            if (oper1 == null && oper2 != null) {
                return oper2;
            }
            if (oper1 != null && oper2 == null) {
                return oper1;
            }
            if (oper1 instanceof Integer) {
                int val1 = oper1.intValue();
                if (oper2 instanceof Integer) {
                    return val1 + oper2.intValue();
                }
                if (oper2 instanceof Long) {
                    return (long)val1 + oper2.longValue();
                }
                if (oper2 instanceof Float) {
                    return Float.valueOf((float)val1 + oper2.floatValue());
                }
                if (oper2 instanceof Double) {
                    return (double)val1 + oper2.doubleValue();
                }
            } else if (oper1 instanceof Long) {
                long val1 = oper1.longValue();
                if (oper2 instanceof Integer) {
                    return val1 + (long)oper2.intValue();
                }
                if (oper2 instanceof Long) {
                    return val1 + oper2.longValue();
                }
                if (oper2 instanceof Float) {
                    return Float.valueOf((float)val1 + oper2.floatValue());
                }
                if (oper2 instanceof Double) {
                    return (double)val1 + oper2.doubleValue();
                }
            } else if (oper1 instanceof Float) {
                float val1 = oper1.floatValue();
                if (oper2 instanceof Integer) {
                    return Float.valueOf(val1 + (float)oper2.intValue());
                }
                if (oper2 instanceof Long) {
                    return Float.valueOf(val1 + (float)oper2.longValue());
                }
                if (oper2 instanceof Float) {
                    return Float.valueOf(val1 + oper2.floatValue());
                }
                if (oper2 instanceof Double) {
                    return (double)val1 + oper2.doubleValue();
                }
            } else if (oper1 instanceof Double) {
                double val1 = oper1.doubleValue();
                if (oper2 instanceof Integer) {
                    return val1 + (double)oper2.intValue();
                }
                if (oper2 instanceof Long) {
                    return val1 + (double)oper2.longValue();
                }
                if (oper2 instanceof Float) {
                    return val1 + (double)oper2.floatValue();
                }
                if (oper2 instanceof Double) {
                    return val1 + oper2.doubleValue();
                }
            }
            return null;
        }

        protected Number div(Number oper1, Long oper2) {
            long val2 = oper2;
            if (oper1 instanceof Integer) {
                return (int)((long)oper1.intValue() / val2);
            }
            if (oper1 instanceof Long) {
                return oper1.longValue() / val2;
            }
            if (oper1 instanceof Float) {
                return Float.valueOf(oper1.floatValue() / (float)val2);
            }
            if (oper1 instanceof Double) {
                return oper1.doubleValue() / (double)val2;
            }
            return null;
        }

        protected boolean isGroupingMatch(QDR qdr, QDR groupingKey) {
            return qdr.isSupersetOf(groupingKey);
        }

        protected AggType getAggType(QDR groupingKey) throws TransformException {
            if (this.m_aggType != null) {
                return this.m_aggType;
            }
            AggMethod[] methods = TotalRow.this.m_spec.getAggMethods();
            if (methods == null) {
                this.m_aggType = AggType.NONE;
                return this.m_aggType;
            }
            QDR qdr = null;
            String measColName = this.m_internalImpl.getDataCellColumnName();
            int i = 0;
            while (i < methods.length) {
                qdr = methods[i].getQDR();
                if (qdr == null) {
                    this.m_aggType = methods[i].getAggType();
                    return this.m_aggType;
                }
                QDR groupingKeyClone = (QDR)groupingKey.clone();
                LayerInterface li = TotalRow.this.m_projection.getDataLayer();
                groupingKeyClone.addDimMemberPair(li != null ? li.getValue() : null, measColName);
                boolean groupingMatch = this.isGroupingMatch(qdr, groupingKeyClone);
                if (groupingMatch) {
                    this.m_aggType = methods[i].getAggType();
                    return this.m_aggType;
                }
                if (this.m_aggType == null) {
                    this.m_aggType = AggType.NONE;
                }
                ++i;
            }
            return this.m_aggType;
        }

        public boolean setData(Object value, String type) throws TransformException {
            return this.m_internalImpl.getDataCellInterface().setData(value, type);
        }

        static class 1 {
            static final /* synthetic */ int[] $sm$oracle$dss$util$transform$total$AggType;

            static {
                int[] nArray = new int[AggType.values().length];
                $sm$oracle$dss$util$transform$total$AggType = nArray;
                try {
                    nArray[AggType.AVERAGE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    1.$sm$oracle$dss$util$transform$total$AggType[AggType.COUNT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    1.$sm$oracle$dss$util$transform$total$AggType[AggType.VARIANCE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    1.$sm$oracle$dss$util$transform$total$AggType[AggType.STDDEV.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    1.$sm$oracle$dss$util$transform$total$AggType[AggType.SUM.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    1.$sm$oracle$dss$util$transform$total$AggType[AggType.MIN.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    1.$sm$oracle$dss$util$transform$total$AggType[AggType.MAX.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
            }
        }
    }
}

