/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.xml;

import java.io.Serializable;
import java.util.Vector;
import oracle.dss.util.persistence.ObjectScope;
import org.w3c.dom.Node;

public abstract class BaseNode
implements Serializable {
    public static final int NONE = 0;
    public static final int NEWLINE = 1;
    public static final int FULL = 2;
    public static final String NEW_LINE = System.getProperty("line.separator");
    public static final String INDENT = "    ";
    public static final String LT_STR = "&#60;";
    public static final String GT_STR = "&#62;";
    public static final String AMP_STR = "&#38;";
    public static final String APOS_STR = "&#39;";
    public static final String QUOT_STR = "&#34;";
    public static final String SPACE_STR = " ";
    public static final int LT = 60;
    public static final int GT = 62;
    public static final int AMP = 38;
    public static final int APOS = 39;
    public static final int QUOT = 34;
    public static final int SPACE_CHAR = 32;
    public static final String NULL_VAL = "NULL";
    protected String m_name;
    protected Node m_node;
    protected ObjectScope m_scope;
    protected Vector m_nodes;
    protected StringBuffer m_buffer;
    protected StringBuffer m_post;
    protected static final int s_bufSize = 150;

    BaseNode(ObjectScope scope, Node node) {
        this.m_scope = scope;
        this.m_node = node;
    }

    public BaseNode(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public Object getImplObject() {
        return this.m_node;
    }

    void initBuffer() {
        if (this.m_buffer == null) {
            this.m_buffer = new StringBuffer(150);
        }
    }

    void initVector() {
        if (this.m_nodes == null) {
            this.m_nodes = new Vector(10, 50);
        }
    }

    Node getDOMElement() {
        return this.m_node;
    }

    ObjectScope getScope() {
        return this.m_scope;
    }

    void finishAll(StringBuffer buffer, String indent, int mode) {
        String _indent = null;
        String _newline = null;
        if (mode == 1) {
            _indent = "";
            _newline = NEW_LINE;
        } else if (mode == 2) {
            _indent = INDENT;
            _newline = NEW_LINE;
        } else {
            _indent = "";
            _newline = "";
        }
        if (this.m_buffer != null && this.m_post != null) {
            buffer.append(indent);
            buffer.append(this.m_buffer);
            if (this.m_post.length() == 2) {
                buffer.append(this.m_post);
            } else {
                buffer.append(">");
            }
            buffer.append(_newline);
            this.finishChildren(buffer, indent, mode, _indent, _newline);
        } else if (this.m_buffer != null && this.m_post == null) {
            buffer.append(indent);
            buffer.append(this.m_buffer);
            buffer.append(_newline);
        } else if (this.m_post != null) {
            buffer.append(indent);
            buffer.append("<");
            buffer.append(this.m_name);
            buffer.append(">");
            buffer.append(_newline);
            this.finishChildren(buffer, indent, mode, _indent, _newline);
        } else {
            buffer.append(indent);
            buffer.append("<");
            buffer.append(this.m_name);
            buffer.append("/>");
            buffer.append(_newline);
        }
    }

    private void finishChildren(StringBuffer buffer, String indent, int mode, String _indent, String _newline) {
        if (this.m_nodes != null) {
            int i = 0;
            while (i < this.m_nodes.size()) {
                Object _obj = this.m_nodes.elementAt(i);
                if (_obj instanceof BaseNode) {
                    ((BaseNode)_obj).finishAll(buffer, indent + _indent, mode);
                } else {
                    buffer.append(indent);
                    buffer.append(_indent);
                    buffer.append(_obj.toString());
                    buffer.append(_newline);
                }
                ++i;
            }
            buffer.append(indent);
            buffer.append(this.m_post);
            buffer.append(_newline);
        }
    }

    int getRequiredCapacity(int indentSize, int mode) {
        int _adj = 0;
        int _indentSize = 0;
        int _newlineSize = 0;
        if (mode == 1) {
            _newlineSize = NEW_LINE.length();
        } else if (mode == 2) {
            _indentSize = INDENT.length();
            _newlineSize = NEW_LINE.length();
        }
        if (this.m_buffer != null && this.m_post != null) {
            _adj = _adj + indentSize + this.m_buffer.length();
            _adj = this.m_post.length() == 2 ? (_adj += 2) : ++_adj;
            _adj += _newlineSize;
            if (this.m_nodes != null) {
                int i = 0;
                while (i < this.m_nodes.size()) {
                    Object _obj = this.m_nodes.elementAt(i);
                    _adj = _obj instanceof BaseNode ? (_adj += ((BaseNode)_obj).getRequiredCapacity(indentSize + _indentSize, mode)) : _adj + indentSize + _indentSize + _obj.toString().length() + _newlineSize;
                    ++i;
                }
                _adj = _adj + indentSize + this.m_post.length() + _newlineSize;
            }
        } else if (this.m_buffer != null && this.m_post == null) {
            _adj = _adj + indentSize + this.m_buffer.length() + _newlineSize;
        } else if (this.m_post != null) {
            _adj = _adj + this.m_name.length() + 2 + indentSize + _newlineSize;
            if (this.m_nodes != null) {
                int i = 0;
                while (i < this.m_nodes.size()) {
                    Object _obj = this.m_nodes.elementAt(i);
                    _adj = _obj instanceof BaseNode ? (_adj += ((BaseNode)_obj).getRequiredCapacity(indentSize + _indentSize, mode)) : _adj + indentSize + _indentSize + _obj.toString().length() + _newlineSize;
                    ++i;
                }
                _adj = _adj + indentSize + this.m_post.length() + _newlineSize;
            }
        } else {
            _adj = _adj + this.m_name.length() + 3 + indentSize + _newlineSize;
        }
        return _adj;
    }

    public static String createEscapes(String inStr) {
        if (inStr.indexOf(34) > -1 || inStr.indexOf(39) > -1 || inStr.indexOf(60) > -1 || inStr.indexOf(62) > -1 || inStr.indexOf(38) > -1) {
            char ch = '\u0000';
            int strLen = inStr.length();
            int incLen = Math.min(strLen, 20) * 4;
            StringBuffer buffer = new StringBuffer(strLen + incLen);
            int i = 0;
            while (i < strLen) {
                ch = inStr.charAt(i);
                switch (ch) {
                    case '\"': {
                        buffer.append(QUOT_STR);
                        break;
                    }
                    case '\'': {
                        buffer.append(APOS_STR);
                        break;
                    }
                    case '<': {
                        buffer.append(LT_STR);
                        break;
                    }
                    case '>': {
                        buffer.append(GT_STR);
                        break;
                    }
                    case '&': {
                        buffer.append(AMP_STR);
                        break;
                    }
                    default: {
                        buffer.append(ch);
                    }
                }
                ++i;
            }
            return buffer.toString();
        }
        return inStr;
    }

    String createCDATA(String inStr) {
        return inStr;
    }

    public String toString() {
        if (this.m_buffer != null) {
            return this.m_buffer.toString();
        }
        return super.toString();
    }
}

