/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.xml;

import java.util.Vector;

public class CharacterMap {
    private Vector m_maps = new Vector(10, 10);

    public void addMapping(char from, char to) {
        this.m_maps.addElement(new Character(from));
        this.m_maps.addElement(new Character(to));
    }

    public void addMapping(String from, String to) {
        this.m_maps.addElement(from);
        this.m_maps.addElement(to);
    }

    public void removeMapping(char mapping) {
        int _index = this.m_maps.indexOf(new Character(mapping));
        if (_index > -1) {
            this.m_maps.removeElementAt(_index);
            this.m_maps.removeElementAt(_index + 1);
        }
    }

    public void removeMapping(String mapping) {
        int _index = this.m_maps.indexOf(mapping);
        if (_index > -1) {
            this.m_maps.removeElementAt(_index);
            this.m_maps.removeElementAt(_index + 1);
        }
    }

    public Vector getMappings() {
        if (this.m_maps == null) {
            return new Vector(0);
        }
        Vector<Object> _v = new Vector<Object>(this.m_maps.size() / 2);
        int i = 0;
        while (i < this.m_maps.size()) {
            Object _elem = this.m_maps.elementAt(i);
            if (_elem instanceof Character) {
                Character _key = (Character)_elem;
                Character _val = (Character)this.m_maps.elementAt(i + 1);
                _v.addElement(new CharHolder(_key, _val));
            } else if (_elem instanceof String) {
                String _key = (String)_elem;
                String _val = (String)this.m_maps.elementAt(i + 1);
                _v.addElement(new StringHolder(_key, _val));
            }
            i += 2;
        }
        return _v;
    }

    class StringHolder {
        private String _key;
        private String _val;

        StringHolder(String key, String value) {
            this._key = key;
            this._val = value;
        }

        String getKey() {
            return this._key;
        }

        String getValue() {
            return this._val;
        }
    }

    class CharHolder {
        private Character _key;
        private Character _val;

        CharHolder(Character key, Character value) {
            this._key = key;
            this._val = value;
        }

        char getKey() {
            return this._key.charValue();
        }

        char getValue() {
            return this._val.charValue();
        }
    }
}

