/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.searchbar;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import javax.swing.Timer;
import oracle.ide.searchbar.Provider;
import oracle.ide.searchbar.Result;
import oracle.ide.searchbar.ResultContext;
import oracle.ideimpl.searchbar.ProviderReference;
import oracle.ideimpl.searchbar.ResultModel;
import oracle.javatools.util.Executors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BaseController {
    protected ResultModel model;
    protected Collection<ProviderReference> providerRefs;
    protected ExecutorService searchExecutor;
    private BusyTimer busyTimer;
    protected PanelResultContext currentContext;
    protected volatile int nActiveSearches;
    private String lastSearch;

    private void $init$() {
        this.model = new ResultModel();
        this.busyTimer = new BusyTimer();
        this.nActiveSearches = 0;
        this.lastSearch = "";
    }

    public BaseController(Collection<ProviderReference> providerRefs) {
        this.$init$();
        this.providerRefs = providerRefs;
    }

    BaseController(BaseController bc) {
        this.$init$();
        this.providerRefs = bc.providerRefs;
        this.searchExecutor = bc.searchExecutor;
        this.currentContext = bc.currentContext;
        this.lastSearch = bc.lastSearch;
        this.model = bc.model;
        this.nActiveSearches = bc.nActiveSearches;
        this.busyTimer = bc.busyTimer;
    }

    void startSearch(String search) {
        this.lastSearch = search;
        this.searchExecutor = java.util.concurrent.Executors.newCachedThreadPool(Executors.namedThreadFactory((String)"searchbar"));
        this.currentContext = new PanelResultContext(this.model.getAllResults());
        this.nActiveSearches = 0;
        for (ProviderReference p : this.providerRefs) {
            this.searchExecutor.submit(new SearchTask(p.provider(), this.currentContext, search));
        }
        this.model.setRunning(true);
        this.busyTimer.setCoalesce(true);
        this.busyTimer.setRepeats(true);
        this.busyTimer.start();
    }

    void stopSearch(boolean clearResults) {
        if (this.currentContext == null) {
            return;
        }
        this.currentContext.detach();
        this.currentContext = null;
        Executors.shutdownNow((ExecutorService)this.searchExecutor);
        if (clearResults) {
            this.model.clear();
        }
    }

    Collection<Provider> getProviders() {
        ArrayList<Provider> pList = new ArrayList<Provider>();
        for (ProviderReference pRef : this.providerRefs) {
            pList.add(pRef.provider());
        }
        return pList;
    }

    void disconnect() {
        this.searchExecutor = null;
        this.currentContext = null;
    }

    ResultModel getModel() {
        return this.model;
    }

    String getLastSearch() {
        return this.lastSearch;
    }

    static BusyTimer ra$busyTimer(BaseController baseController) {
        return baseController.busyTimer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PanelResultContext
    extends ResultContext {
        private boolean attached;
        private Collection<Result<?>> prevResults;

        private void $init$() {
            this.attached = true;
        }

        public PanelResultContext(Collection<Result<?>> previousResults) {
            this.$init$();
            this.prevResults = previousResults;
        }

        public void detach() {
            this.attached = false;
            this.cancel();
        }

        @Override
        public void add(Result<?> result) {
            EventQueue.invokeLater(new 1(this, result));
        }

        @Override
        public Collection<Result<?>> getPreviousResults() {
            return this.prevResults;
        }

        @Override
        public Collection<Result<?>> getPreviousResults(Provider<?> provider) {
            ArrayList pResults = new ArrayList();
            for (Result<?> r : this.prevResults) {
                if (!r.provider().equals(provider)) continue;
                pResults.add(r);
            }
            return pResults;
        }

        @Override
        public void delete(Result<?> result) {
            EventQueue.invokeLater(new 2(this, result));
        }

        @Override
        public void deleteAll(Provider provider) {
            EventQueue.invokeLater(new 3(this, provider));
        }

        static boolean ra$attached(PanelResultContext panelResultContext) {
            return panelResultContext.attached;
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ Result v$result;
            final /* synthetic */ PanelResultContext this$0;

            public void run() {
                if (PanelResultContext.ra$attached(this.this$0)) {
                    this.this$0.BaseController.this.model.add(this.v$result);
                }
            }

            public 1(PanelResultContext panelResultContext, Result result) {
                this.v$result = result;
                this.this$0 = panelResultContext;
            }
        }

        final class 2
        implements Runnable {
            private final /* synthetic */ Result v$result;
            final /* synthetic */ PanelResultContext this$0;

            public void run() {
                if (PanelResultContext.ra$attached(this.this$0)) {
                    this.this$0.BaseController.this.model.delete(this.v$result);
                }
            }

            public 2(PanelResultContext panelResultContext, Result result) {
                this.v$result = result;
                this.this$0 = panelResultContext;
            }
        }

        final class 3
        implements Runnable {
            private final /* synthetic */ Provider v$provider;
            final /* synthetic */ PanelResultContext this$0;

            public void run() {
                if (PanelResultContext.ra$attached(this.this$0)) {
                    this.this$0.BaseController.this.model.deleteAll(this.v$provider);
                }
            }

            public 3(PanelResultContext panelResultContext, Provider provider) {
                this.v$provider = provider;
                this.this$0 = panelResultContext;
            }
        }
    }

    private class SearchTask
    implements Runnable {
        private final Provider provider;
        private final ResultContext context;
        private final String text;

        SearchTask(Provider provider, ResultContext context, String text) {
            this.provider = provider;
            this.context = context;
            this.text = text;
        }

        public void run() {
            ++BaseController.this.nActiveSearches;
            this.provider.rematch(this.text, this.context);
            this.provider.search(this.text, this.context);
            --BaseController.this.nActiveSearches;
        }
    }

    private class BusyTimer
    extends Timer
    implements ActionListener {
        private long startTime;
        private long delay;

        private void $init$() {
            this.startTime = 0L;
            this.delay = 50;
        }

        BusyTimer() {
            super(100, null);
            this.$init$();
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean searches;
            boolean busy = System.currentTimeMillis() > this.startTime + this.delay;
            boolean bl = searches = BaseController.this.nActiveSearches != 0;
            if (!searches) {
                BaseController.ra$busyTimer(BaseController.this).stop();
            }
            BaseController.this.model.setRunning(busy && searches);
        }

        public void start() {
            this.startTime = System.currentTimeMillis();
            super.start();
        }
    }
}

