/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.searchbar;

import java.util.logging.Level;
import javax.ide.util.MetaClass;
import oracle.ide.ExtensionRegistry;
import oracle.ide.searchbar.Provider;
import oracle.ide.searchbar.Result;
import oracle.ide.searchbar.ResultContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProviderReference {
    private final MetaClass<Provider> providerClass;
    private final String name;
    private Provider provider;

    public ProviderReference(String name, MetaClass<Provider> providerClass) {
        this.name = name;
        this.providerClass = providerClass;
    }

    public String name() {
        return this.name;
    }

    public synchronized Provider provider() {
        try {
            if (this.provider == null) {
                this.provider = (Provider)this.providerClass.newInstance();
            }
        }
        catch (Exception e) {
            ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, "Failed to create searchbar provider from class " + this.providerClass.getClassName(), e);
            this.provider = new NullProvider(null);
        }
        return this.provider;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NullProvider
    extends Provider<Object> {
        @Override
        public void search(String searchText, ResultContext context) {
        }

        @Override
        public void open(Result<Object> result) {
            throw new IllegalStateException();
        }

        private NullProvider() {
        }

        NullProvider(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

