/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.searchbar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractListModel;
import oracle.ide.searchbar.Result;

final class ResultListModel
extends AbstractListModel {
    private int maxVisibleResults;
    private final List<Result> allResults;
    private final List<Result> visibleModel;
    private final Comparator<Result> resultComparator;

    private void $init$() {
        this.maxVisibleResults = 7;
        this.allResults = Collections.synchronizedList(new ArrayList());
        this.visibleModel = new ArrayList<Result>();
        this.resultComparator = new WeightComparator(null);
    }

    ResultListModel() {
        this.$init$();
    }

    void clear() {
        this.allResults.clear();
        this.updateVisibleModel();
    }

    void add(Result result) {
        if (!this.allResults.contains(result)) {
            this.allResults.add(result);
        }
    }

    boolean remove(Result result) {
        int i = this.allResults.indexOf(result);
        if (i != -1) {
            this.allResults.remove(result);
            int j = this.visibleModel.indexOf(result);
            if (j != -1) {
                this.visibleModel.remove(result);
                this.fireIntervalRemoved(this, j, j);
            }
            this.updateVisibleModel();
            return true;
        }
        return false;
    }

    public int getSize() {
        return this.visibleModel.size();
    }

    public Object getElementAt(int index) {
        return this.visibleModel.get(index);
    }

    Result resultAt(int index) {
        return this.visibleModel.get(index);
    }

    Result[] getAllResults() {
        return this.allResults.toArray(new Result[this.allResults.size()]);
    }

    int getTotalSize() {
        return this.allResults.size();
    }

    void setMaxVisibleCount(int i) {
        if (i != this.maxVisibleResults) {
            this.maxVisibleResults = i;
            this.updateVisibleModel();
        }
    }

    int getMaxVisibleCount() {
        return this.maxVisibleResults;
    }

    void updateVisibleModel() {
        ArrayList<Result> copy = new ArrayList<Result>(this.allResults);
        Collections.sort(copy, this.resultComparator);
        this.visibleModel.clear();
        this.visibleModel.addAll(copy.subList(0, Math.min(this.maxVisibleResults, copy.size())));
        int newSize = this.visibleModel.size();
        if (newSize > 0) {
            this.fireContentsChanged(this, 0, newSize - 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WeightComparator
    implements Comparator<Result> {
        @Override
        public int compare(Result o1, Result o2) {
            int result = o2.weight() - o1.weight();
            if (result == 0) {
                return o1.displayText().compareTo(o2.displayText());
            }
            return result;
        }

        private WeightComparator() {
        }

        WeightComparator(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

