/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.searchbar;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Timer;
import oracle.ide.searchbar.Provider;
import oracle.ide.searchbar.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResultModel {
    private List<Result<?>> results;
    private List<Result<?>> pendingResults;
    private List<ResultListener> resultListeners;
    private boolean isRunning;
    private Timer pendingTimer;
    private static int PENDING_INT = 500;
    static int SOFT_LIMIT = 1000;
    private int totalCount;

    private void $init$() {
        this.results = new ArrayList();
        this.pendingResults = new ArrayList();
        this.resultListeners = new ArrayList<ResultListener>();
        this.isRunning = false;
        this.totalCount = 0;
    }

    ResultModel() {
        this.$init$();
        this.pendingTimer = new Timer(PENDING_INT, new 1());
        this.pendingTimer.setCoalesce(true);
        this.pendingTimer.setRepeats(true);
    }

    int getTotalResultCount() {
        return this.totalCount;
    }

    public void add(Result<?> result) {
        this.pendingResults.add(result);
        if (!this.pendingTimer.isRunning()) {
            this.pendingTimer.start();
        }
    }

    private void addPendingResults() {
        if (this.pendingResults.size() > 0) {
            this.totalCount += this.pendingResults.size();
            ArrayList addedResults = new ArrayList();
            if (this.results.size() < SOFT_LIMIT) {
                for (Result<?> r : this.pendingResults) {
                    if (this.results.contains(r)) continue;
                    this.results.add(r);
                    addedResults.add(r);
                    if (this.results.size() >= SOFT_LIMIT) break;
                }
            }
            this.fireNewResults(addedResults);
            this.pendingResults.clear();
        }
    }

    void clear() {
        this.results.clear();
        this.pendingResults.clear();
        this.fireClearResults();
        this.totalCount = 0;
    }

    Collection<Result<?>> getAllResults() {
        this.addPendingResults();
        ArrayList allResults = new ArrayList(this.results);
        return allResults;
    }

    void delete(Result result) {
        this.results.remove(result);
        this.pendingResults.remove(result);
        this.fireDeletedResult(result);
        --this.totalCount;
    }

    void deleteAll(Provider provider) {
        this.addPendingResults();
        ArrayList newResults = new ArrayList();
        ArrayList deletedResults = new ArrayList();
        for (Result<?> r : this.results) {
            if (!r.provider().equals(provider)) {
                newResults.add(r);
                continue;
            }
            deletedResults.add(r);
        }
        this.results = newResults;
        this.fireDeletedResults(deletedResults);
        this.totalCount -= deletedResults.size();
    }

    void setRunning(boolean isRunning) {
        if (isRunning) {
            this.totalCount = this.results.size();
        }
        if (this.isRunning == isRunning) {
            return;
        }
        this.isRunning = isRunning;
        if (!isRunning) {
            this.addPendingResults();
            this.pendingTimer.stop();
        }
        this.fireRunningChange();
    }

    boolean isRunning() {
        return this.isRunning;
    }

    void addResultListener(ResultListener rl) {
        if (!this.resultListeners.contains(rl)) {
            this.resultListeners.add(rl);
        }
    }

    void removeResultListener(ResultListener rl) {
        this.resultListeners.remove(rl);
    }

    private void fireDeletedResult(Result result) {
        for (ResultListener l : this.resultListeners) {
            l.deletedResult(result);
        }
    }

    private void fireDeletedResults(Collection<Result<?>> results) {
        for (ResultListener l : this.resultListeners) {
            l.deletedResults(results);
        }
    }

    private void fireNewResults(Collection<Result<?>> newResults) {
        for (ResultListener l : this.resultListeners) {
            l.newResults(newResults);
        }
    }

    private void fireClearResults() {
        for (ResultListener l : this.resultListeners) {
            l.clearResults();
        }
    }

    private void fireRunningChange() {
        for (ResultListener l : this.resultListeners) {
            l.runningChange(this.isRunning);
        }
    }

    static void mav$addPendingResults(ResultModel resultModel) {
        resultModel.addPendingResults();
    }

    final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ResultModel.mav$addPendingResults(ResultModel.this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    interface ResultListener {
        public void newResults(Collection<Result<?>> var1);

        public void clearResults();

        public void runningChange(boolean var1);

        public void deletedResult(Result var1);

        public void deletedResults(Collection<Result<?>> var1);
    }
}

