/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.searchbar;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.searchbar.Provider;
import oracle.ide.searchbar.Result;
import oracle.ideimpl.searchbar.Bundle;
import oracle.ideimpl.searchbar.ColorProvider;
import oracle.ideimpl.searchbar.ResultListModel;
import oracle.ideimpl.searchbar.ResultListRenderer;
import oracle.ideimpl.searchbar.ResultModel;
import oracle.ideimpl.searchbar.ShowAllProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ResultPanel
extends JPanel
implements ResultModel.ResultListener {
    private final Map<Provider, JList> listMap;
    private final Map<JList, JLabel> labelMap;
    private ListSelectionModel selectedListModel;
    private final ListSelectionListener selectionTracker;
    private final Action selectNextRow;
    private final Action selectPreviousRow;
    private final MouseMotionListener autoSelectListener;
    private final MouseListener mouseClick;
    private final ListDataListener listDataListener;
    private boolean isRunning;
    private final Collection<ActionListener> actionListeners;
    private GridBagLayout gbl;
    private JLabel statusLabel;
    private ShowAllProvider showAllProvider;
    private final int MAX_RESULTS;

    private void $init$() {
        this.listMap = new LinkedHashMap<Provider, JList>();
        this.labelMap = new LinkedHashMap<JList, JLabel>();
        this.selectionTracker = new SelectionTracker(null);
        this.selectNextRow = new SelectNextRow(null);
        this.selectPreviousRow = new SelectPreviousRow(null);
        this.autoSelectListener = new MouseAutoSelect(null);
        this.mouseClick = new MouseClick(null);
        this.listDataListener = new RevalidateOnUpdateListener(null);
        this.isRunning = false;
        this.actionListeners = new CopyOnWriteArrayList<ActionListener>();
        this.MAX_RESULTS = 30;
    }

    ResultPanel(ShowAllProvider showAllProvider) {
        this.$init$();
        this.showAllProvider = showAllProvider;
        this.init();
    }

    private void init() {
        this.setBackground(UIManager.getColor("List.background"));
        this.gbl = new GridBagLayout();
        this.setLayout(this.gbl);
        this.statusLabel = new JLabel(Bundle.get("SEARCHING_RESULTS"));
        this.statusLabel.setBorder(BorderFactory.createEmptyBorder(7, 0, 9, 0));
        this.add(Box.createHorizontalStrut(40));
        this.add(this.statusLabel);
    }

    @Override
    public void newResults(Collection<Result<?>> results) {
        ArrayList<JList> listsToUpdate = new ArrayList<JList>();
        for (Result<?> result : results) {
            JList list = this.listMap.get(result.provider());
            if (list == null) {
                list = this.addProviderList(result.provider());
            }
            if (!listsToUpdate.contains(list)) {
                listsToUpdate.add(list);
            }
            this.model(list).add(result);
        }
        this.updateVisibleCount();
        this.updateStatus();
        for (JList list : listsToUpdate) {
            this.model(list).updateVisibleModel();
        }
    }

    @Override
    public void deletedResult(Result result) {
        JList list = this.listMap.get(result.provider());
        this.model(list).remove(result);
        if (this.model(list).getSize() == 0) {
            this.destroyList(result.provider());
        }
        this.updateVisibleCount();
        this.updateStatus();
    }

    @Override
    public void deletedResults(Collection<Result<?>> results) {
        for (Result<?> result : results) {
            JList list = this.listMap.get(result.provider());
            if (list == null) continue;
            this.model(list).remove(result);
            if (this.model(list).getSize() != 0) continue;
            this.destroyList(result.provider());
        }
        this.updateVisibleCount();
        this.updateStatus();
    }

    private void updateVisibleCount() {
        ArrayList<JList> listOfLists = new ArrayList<JList>(this.listMap.values());
        int spareCapacity = this.updateVisibleCount(listOfLists, 30);
        this.allocateSpareCapacity(listOfLists, spareCapacity);
    }

    private int updateVisibleCount(List<JList> listOfLists, int totalCount) {
        if (listOfLists.size() == 0) {
            return 0;
        }
        if (listOfLists.size() == 1) {
            listOfLists.get(0).setVisibleRowCount(totalCount);
            return 0;
        }
        int remainingListsCount = listOfLists.size();
        int rowsPerList = totalCount / remainingListsCount;
        int spareRows = 0;
        for (JList list : listOfLists) {
            this.model(list).setMaxVisibleCount(rowsPerList);
            int totalItems = this.model(list).getTotalSize();
            int spareCapacity = rowsPerList - totalItems;
            if (spareCapacity <= 0) continue;
            spareRows += spareCapacity;
        }
        return spareRows;
    }

    private void allocateSpareCapacity(List<JList> listOfLists, int spareCount) {
        boolean stillUpdating = true;
        while (spareCount > 0 && stillUpdating) {
            stillUpdating = false;
            for (JList list : listOfLists) {
                ResultListModel model = this.model(list);
                if (model.getTotalSize() <= model.getMaxVisibleCount()) continue;
                model.setMaxVisibleCount(model.getMaxVisibleCount() + 1);
                stillUpdating = true;
                --spareCount;
            }
        }
    }

    public void addActionListener(ActionListener al) {
        this.actionListeners.add(al);
    }

    public void removeActionListener(ActionListener al) {
        this.actionListeners.remove(al);
    }

    private void fireActionPerformed() {
        ActionEvent e = new ActionEvent(this, 1001, null);
        for (ActionListener l : this.actionListeners) {
            l.actionPerformed(e);
        }
    }

    public Collection<Result> results() {
        ArrayList<Result> results = new ArrayList<Result>();
        for (JList list : this.listMap.values()) {
            ResultListModel model = this.model(list);
            int i = 0;
            while (i < model.getSize()) {
                results.add(model.resultAt(i));
                ++i;
            }
        }
        return results;
    }

    public Result selection() {
        if (this.selectedListModel == null) {
            return null;
        }
        for (JList list : this.listMap.values()) {
            if (this.selectedListModel != list.getSelectionModel()) continue;
            return (Result)list.getModel().getElementAt(this.selectedListModel.getMinSelectionIndex());
        }
        return null;
    }

    @Override
    public void clearResults() {
        Provider[] providerArray = this.listMap.keySet().toArray(new Provider[this.listMap.keySet().size()]);
        int n = 0;
        while (n < providerArray.length) {
            Provider p = providerArray[n];
            JList list = this.listMap.get(p);
            if (list != null) {
                this.destroyList(p);
            }
            ++n;
        }
        this.updateStatus();
        this.revalidate();
    }

    void setRunning(boolean isRunning) {
        this.isRunning = isRunning;
        this.updateStatus();
    }

    private void updateStatus() {
        if (!this.isRunning) {
            if (this.listMap.size() == 0) {
                this.statusLabel.setText(Bundle.get("NO_RESULTS"));
                this.statusLabel.setVisible(true);
            } else {
                this.statusLabel.setVisible(false);
            }
        } else if (this.listMap.size() == 0) {
            this.statusLabel.setText(Bundle.get("SEARCHING_RESULTS"));
            this.statusLabel.setVisible(true);
        } else {
            this.statusLabel.setVisible(false);
        }
    }

    Action selectNextRowAction() {
        return this.selectNextRow;
    }

    Action selectPreviousRowAction() {
        return this.selectPreviousRow;
    }

    private ResultListModel model(JList list) {
        return (ResultListModel)list.getModel();
    }

    private void destroyList(Provider p) {
        JList list = this.listMap.get(p);
        list.getModel().removeListDataListener(this.listDataListener);
        list.setModel(new DefaultListModel());
        list.setCellRenderer(null);
        list.getSelectionModel().removeListSelectionListener(this.selectionTracker);
        list.getActionMap().remove("selectNextRow");
        list.getActionMap().remove("selectNextRowExtendSelection");
        list.getActionMap().remove("selectNextRowChangeLead");
        list.getActionMap().remove("selectPreviousRow");
        list.getActionMap().remove("selectPreviousRowExtendSelection");
        list.getActionMap().remove("selectPreviousRowChangeLead");
        list.removeMouseMotionListener(this.autoSelectListener);
        list.removeMouseListener(this.mouseClick);
        this.remove(this.labelMap.get(list));
        this.remove(list);
        this.listMap.remove(p);
        if (this.listMap.size() == 1 && this.listMap.get(this.showAllProvider) != null) {
            this.destroyList(this.showAllProvider);
        }
        this.relayout();
    }

    private JList addProviderList(Provider provider) {
        if (this.listMap.size() == 0) {
            JList showAllList = this.createList(this.showAllProvider);
            this.model(showAllList).add(this.showAllProvider.createShowAllResult(this));
            this.model(showAllList).updateVisibleModel();
        }
        JList list = this.createList(provider);
        this.relayout();
        return list;
    }

    private JList createList(Provider provider) {
        JList list = new JList();
        Border border = BorderFactory.createEmptyBorder(4, 2, 0, 2);
        list.setModel(new ResultListModel());
        list.setCellRenderer(ResultListRenderer.getInstance());
        list.setSelectionMode(0);
        list.getSelectionModel().addListSelectionListener(this.selectionTracker);
        list.getActionMap().put("selectNextRow", this.selectNextRow);
        list.getActionMap().put("selectNextRowExtendSelection", this.selectNextRow);
        list.getActionMap().put("selectNextRowChangeLead", this.selectNextRow);
        list.getActionMap().put("selectPreviousRow", this.selectPreviousRow);
        list.getActionMap().put("selectPreviousRowExtendSelection", this.selectPreviousRow);
        list.getActionMap().put("selectPreviousRowChangeLead", this.selectPreviousRow);
        list.addMouseMotionListener(this.autoSelectListener);
        list.addMouseListener(this.mouseClick);
        list.setOpaque(false);
        list.setFocusable(false);
        list.getModel().addListDataListener(this.listDataListener);
        list.setBorder(border);
        JLabel label = new JLabel(provider.name());
        label.setVerticalAlignment(1);
        label.setOpaque(false);
        label.setForeground(UIManager.getColor(ColorProvider.PROVIDER_FOREGROUND));
        label.setBorder(BorderFactory.createEmptyBorder(6, 2, 4, 2));
        this.labelMap.put(list, label);
        this.add(label);
        this.add(list);
        this.listMap.put(provider, list);
        return list;
    }

    int getListsVisibleCount() {
        return this.listMap.size();
    }

    private void relayout() {
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 1, new Insets(0, 0, 0, 0), 2, 0);
        int x = 0;
        int y = 0;
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Component c = componentArray[n];
            gbc.ipady = 4;
            gbc.gridx = x;
            gbc.gridy = y;
            gbc.weightx = x == 0 ? 0 : 10;
            if (++x > 1) {
                x = 0;
                ++y;
            }
            this.gbl.setConstraints(c, gbc);
            ++n;
        }
    }

    @Override
    protected void paintChildren(Graphics g) {
        int i = 4;
        while (i < this.getComponentCount()) {
            JList list = (JList)this.getComponent(i + 1);
            g.setColor(UIManager.getColor(ColorProvider.STRIPE_BACKGROUND));
            g.fillRect(0, list.getY(), this.getWidth(), list.getHeight());
            i += 4;
        }
        super.paintChildren(g);
    }

    @Override
    public void runningChange(boolean isRunning) {
        this.setRunning(isRunning);
    }

    static Map ra$listMap(ResultPanel resultPanel) {
        return resultPanel.listMap;
    }

    static ListSelectionModel ra$selectedListModel(ResultPanel resultPanel) {
        return resultPanel.selectedListModel;
    }

    static void mav$fireActionPerformed(ResultPanel resultPanel) {
        resultPanel.fireActionPerformed();
    }

    static void wa$selectedListModel(ResultPanel resultPanel, ListSelectionModel listSelectionModel) {
        resultPanel.selectedListModel = listSelectionModel;
    }

    private class SelectPreviousRow
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            int currentSelection;
            if (ResultPanel.ra$listMap(ResultPanel.this).isEmpty()) {
                return;
            }
            int n = currentSelection = ResultPanel.ra$selectedListModel(ResultPanel.this) == null ? -1 : ResultPanel.ra$selectedListModel(ResultPanel.this).getMinSelectionIndex();
            if (currentSelection > 0 && ResultPanel.ra$selectedListModel(ResultPanel.this) != null) {
                ResultPanel.ra$selectedListModel(ResultPanel.this).setSelectionInterval(currentSelection - 1, currentSelection - 1);
                return;
            }
            JList lastList = null;
            for (JList list : ResultPanel.ra$listMap(ResultPanel.this).values()) {
                if (list.getSelectionModel() == ResultPanel.ra$selectedListModel(ResultPanel.this)) {
                    if (lastList != null) {
                        lastList.setSelectedIndex(lastList.getModel().getSize() - 1);
                    }
                    return;
                }
                if (list.getModel().getSize() <= 0) continue;
                lastList = list;
            }
            if (lastList != null) {
                lastList.setSelectedIndex(lastList.getModel().getSize() - 1);
            }
        }

        private SelectPreviousRow() {
        }

        SelectPreviousRow(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class SelectNextRow
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            if (ResultPanel.ra$listMap(ResultPanel.this).isEmpty()) {
                return;
            }
            int currentSelection = ResultPanel.ra$selectedListModel(ResultPanel.this) == null ? -1 : ResultPanel.ra$selectedListModel(ResultPanel.this).getMinSelectionIndex();
            boolean candidateList = false;
            for (JList list : ResultPanel.ra$listMap(ResultPanel.this).values()) {
                if ((candidateList || currentSelection == -1) && list.getModel().getSize() > 0) {
                    list.setSelectedIndex(0);
                    return;
                }
                if (list.getSelectionModel() != ResultPanel.ra$selectedListModel(ResultPanel.this)) continue;
                int newSelection = currentSelection + 1;
                if (newSelection < list.getModel().getSize()) {
                    ResultPanel.ra$selectedListModel(ResultPanel.this).setSelectionInterval(newSelection, newSelection);
                    return;
                }
                candidateList = true;
            }
        }

        private SelectNextRow() {
        }

        SelectNextRow(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class MouseClick
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            if (e.getSource() instanceof JList) {
                JList list = (JList)e.getSource();
                Result result = (Result)list.getSelectedValue();
                if (result == null) {
                    return;
                }
                ResultPanel.mav$fireActionPerformed(ResultPanel.this);
            }
        }

        private MouseClick() {
        }

        MouseClick(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class MouseAutoSelect
    extends MouseMotionAdapter {
        public void mouseMoved(MouseEvent e) {
            int location;
            JList list = (JList)e.getSource();
            if (list.getCellBounds(location = list.locationToIndex(e.getPoint()), location).contains(e.getPoint())) {
                list.setSelectedIndex(location);
            }
        }

        private MouseAutoSelect() {
        }

        MouseAutoSelect(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class SelectionTracker
    implements ListSelectionListener {
        private boolean lock;

        private void $init$() {
            this.lock = false;
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (this.lock) {
                return;
            }
            this.lock = true;
            try {
                if (e.getSource() != ResultPanel.ra$selectedListModel(ResultPanel.this) && ResultPanel.ra$selectedListModel(ResultPanel.this) != null) {
                    ResultPanel.ra$selectedListModel(ResultPanel.this).clearSelection();
                }
                if (e.getFirstIndex() == -1 || e.getLastIndex() == -1) {
                    ResultPanel.wa$selectedListModel(ResultPanel.this, null);
                } else {
                    ResultPanel.wa$selectedListModel(ResultPanel.this, (ListSelectionModel)e.getSource());
                }
            }
            finally {
                this.lock = false;
            }
        }

        private SelectionTracker() {
            this.$init$();
        }

        SelectionTracker(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class RevalidateOnUpdateListener
    implements ListDataListener {
        public void intervalAdded(ListDataEvent e) {
            ResultPanel.this.revalidate();
        }

        public void intervalRemoved(ListDataEvent e) {
            ResultPanel.this.revalidate();
        }

        public void contentsChanged(ListDataEvent e) {
            ResultPanel.this.revalidate();
        }

        private RevalidateOnUpdateListener() {
        }

        RevalidateOnUpdateListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

