/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.searchbar;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import oracle.ide.Addin;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.extension.RegisteredByExtension;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ideimpl.searchbar.ColorProvider;
import oracle.ideimpl.searchbar.QuickSearchCommand;
import oracle.ideimpl.searchbar.SearchBarController;
import oracle.ideimpl.searchbar.SearchBarHook;
import oracle.ideimpl.searchbar.ShowAllEditorAddin;
import oracle.ideimpl.searchbar.ShowAllNode;
import oracle.javatools.ui.search.SearchField;

@RegisteredByExtension(value="oracle.ide.searchbar")
final class SearchBarAddin
implements Addin {
    public void initialize() {
        if (Boolean.getBoolean("ide.searchbar.disabled")) {
            return;
        }
        Ide.addIdeListener((IdeListener)new 1());
        this.initializeAccelerators();
        ColorProvider.updateUIManager();
    }

    private void initializeAccelerators() {
        KeyStrokeContextRegistry r = Ide.getKeyStrokeContextRegistry();
        r.addAcceleratorDefinitionFile(SearchBarAddin.class.getClassLoader(), "oracle/ideimpl/searchbar/accelerators.xml");
    }

    private void initializeAfterMainWindowOpens() {
        SearchBarHook hook = SearchBarHook.get();
        if (hook == null) {
            return;
        }
        if (hook.providers() == null) {
            return;
        }
        if (hook.providers().isEmpty()) {
            return;
        }
        SearchField searchField = this.createSearchField();
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.add((Component)searchField, "After");
        new SearchBarController(searchField, hook.providers());
        EditorManager.getEditorManager().register((EditorAddin)new ShowAllEditorAddin(), new Class[]{ShowAllNode.class});
    }

    private SearchField createSearchField() {
        SearchField searchField = new SearchField();
        searchField.setStyle(SearchField.Style.FILTER);
        QuickSearchCommand.setSearchField(searchField);
        searchField.getTextField().setColumns(15);
        return searchField;
    }

    SearchBarAddin() {
    }

    static void mav$initializeAfterMainWindowOpens(SearchBarAddin searchBarAddin) {
        searchBarAddin.initializeAfterMainWindowOpens();
    }

    final class 1
    implements IdeListener {
        public void addinsLoaded(IdeEvent e) {
        }

        public void mainWindowClosing(IdeEvent e) {
        }

        public void mainWindowOpened(IdeEvent e) {
            SearchBarAddin.mav$initializeAfterMainWindowOpens(SearchBarAddin.this);
        }
    }
}

