/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.searchbar;

import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import oracle.ide.Ide;
import oracle.ide.searchbar.Result;
import oracle.ide.view.View;
import oracle.ideimpl.searchbar.BaseController;
import oracle.ideimpl.searchbar.ProviderReference;
import oracle.ideimpl.searchbar.ResultContainer;
import oracle.ideimpl.searchbar.ShowAllProvider;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SearchBarController
extends BaseController {
    private final ResultContainer resultContainer;
    private final Action openResultAction;
    private final Action escapeAction;
    private final SearchField searchField;

    private void $init$() {
        this.openResultAction = new OpenResultAction(null);
        this.escapeAction = new EscapeAction(null);
    }

    public SearchBarController(SearchField searchField, Collection<ProviderReference> providers) {
        super(providers);
        this.$init$();
        this.searchField = searchField;
        searchField.addSearchListener((SearchListener)new SL(null));
        this.resultContainer = new ResultContainer(searchField, new ShowAllProvider(this));
        this.resultContainer.addActionListener(this.openResultAction);
        searchField.getTextField().addFocusListener((FocusListener)new 1());
        this.installSearchFieldKeyboardActions();
    }

    private void bindKey(JComponent c, String key, String actionName, Action action) {
        c.getInputMap(1).put(KeyStroke.getKeyStroke(key), actionName);
        c.getActionMap().put(actionName, action);
    }

    private void unbindKey(JComponent c, String key) {
        KeyStroke stroke = KeyStroke.getKeyStroke(key);
        c.getInputMap(1).remove(stroke);
        c.getInputMap(0).remove(stroke);
    }

    private void installSearchFieldKeyboardActions() {
        this.unbindKey((JComponent)this.searchField, "UP");
        this.unbindKey((JComponent)this.searchField, "DOWN");
        this.unbindKey((JComponent)this.searchField, "ENTER");
        this.unbindKey((JComponent)this.searchField, "ESCAPE");
        this.bindKey((JComponent)this.searchField, "UP", "selectPreviousRow", this.resultContainer.selectPreviousRowAction());
        this.bindKey((JComponent)this.searchField, "DOWN", "selectNextRow", this.resultContainer.selectNextRowAction());
        this.bindKey((JComponent)this.searchField, "ENTER", "openSelectedAction", this.openResultAction);
        this.bindKey((JComponent)this.searchField, "ESCAPE", "escapeAction", this.escapeAction);
    }

    private void hidePopup() {
        this.resultContainer.hideResults();
        super.stopSearch(true);
    }

    private void showPopup() {
        this.resultContainer.showResults(this.model);
    }

    @Override
    protected void stopSearch(boolean clearResults) {
        super.stopSearch(clearResults);
        if (clearResults) {
            this.hidePopup();
        }
    }

    @Override
    protected void startSearch(String searchText) {
        super.startSearch(searchText);
        this.showPopup();
    }

    static SearchField ra$searchField(SearchBarController searchBarController) {
        return searchBarController.searchField;
    }

    static ResultContainer ra$resultContainer(SearchBarController searchBarController) {
        return searchBarController.resultContainer;
    }

    static void mav$hidePopup(SearchBarController searchBarController) {
        searchBarController.hidePopup();
    }

    final class 1
    implements FocusListener {
        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            SearchBarController.mav$hidePopup(SearchBarController.this);
        }
    }

    private class SL
    implements SearchListener {
        public void searchPerformed(SearchEvent se) {
            if (se.isFromClear() || se.getSearchText() == null || se.getSearchText().trim().length() == 0) {
                SearchBarController.this.stopSearch(true);
            } else {
                SearchBarController.this.stopSearch(false);
                SearchBarController.this.startSearch(se.getSearchText());
            }
        }

        public void searchCategoryChanged(SearchEvent se) {
        }

        private SL() {
        }

        SL(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class OpenResultAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            Result selection = SearchBarController.ra$resultContainer(SearchBarController.this).selection();
            if (selection == null) {
                return;
            }
            selection.open();
            SearchBarController.ra$searchField(SearchBarController.this).clear();
            this.transferFocusAfterOpen();
        }

        private void transferFocusAfterOpen() {
            if (SearchBarController.ra$searchField(SearchBarController.this).hasFocus()) {
                return;
            }
            View lastView = Ide.getMainWindow().getLastActiveView();
            if (lastView == null) {
                return;
            }
            lastView.getGUI().requestFocus();
        }

        private OpenResultAction() {
        }

        OpenResultAction(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class EscapeAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            View lastView = Ide.getMainWindow().getLastActiveView();
            if (lastView != null) {
                lastView.getGUI().requestFocus();
            }
        }

        private EscapeAction() {
        }

        EscapeAction(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

