/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.searchbar;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.ide.extension.ElementName;
import javax.ide.util.MetaClass;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.extension.RegisteredByExtension;
import oracle.ide.searchbar.Provider;
import oracle.ideimpl.searchbar.ProviderReference;
import oracle.javatools.data.HashStructure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RegisteredByExtension(value="oracle.ide.searchbar")
public final class SearchBarHook
extends HashStructureHook {
    private Collection<ProviderReference> providers;
    private static final ElementName NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "searchbar");

    public static SearchBarHook get() {
        return (SearchBarHook)ExtensionRegistry.getExtensionRegistry().getHook(NAME);
    }

    Collection<ProviderReference> providers() {
        if (this.providers == null) {
            List providers = this.getHashStructure().getAsList("provider");
            if (providers == null) {
                return Collections.emptyList();
            }
            ArrayList<ProviderReference> result = new ArrayList<ProviderReference>(providers.size());
            for (Object o : providers) {
                HashStructure hsProvider = (HashStructure)o;
                String name = hsProvider.getString("name");
                MetaClass clazz = LazyClassAdapter.getInstance((HashStructure)hsProvider).getMetaClass("class");
                result.add(new ProviderReference(name, (MetaClass<Provider>)clazz));
            }
            this.providers = result;
            this.dispose();
        }
        return this.providers;
    }

    public ProviderReference referenceFor(Provider provider) {
        for (ProviderReference ref : this.providers()) {
            if (provider != ref.provider()) continue;
            return ref;
        }
        throw new IllegalArgumentException("No ProviderReference for Provider " + provider);
    }
}

