/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.searchbar;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.editor.Editor;
import oracle.ide.model.UpdateMessage;
import oracle.ide.peek.Peek;
import oracle.ide.peek.PeekableNiceTable;
import oracle.ide.searchbar.Provider;
import oracle.ide.searchbar.Result;
import oracle.ideimpl.searchbar.BaseController;
import oracle.ideimpl.searchbar.Bundle;
import oracle.ideimpl.searchbar.ResultModel;
import oracle.ideimpl.searchbar.ShowAllNode;
import oracle.ideimpl.searchbar.ShowAllProvider;
import oracle.ideimpl.searchbar.ShowAllTableModel;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.controls.nicetable.NiceTableCellRenderer;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;

class ShowAllEditor
extends Editor {
    private JPanel mainPanel;
    private NiceTable table;
    private ShowAllTableModel tableModel;
    private SearchField searchField;
    private BaseController controller;
    private ShowAllResultsL showAllResultsL;
    private JComboBox kindCombo;
    private JLabel resultsLabel;
    private JLabel busyLabel;
    private static EmptyIcon emptyIcon;

    ShowAllEditor() {
        this.setEditorAttribute("scrollable", false);
    }

    public void open() {
    }

    public void close() {
        this.controller.stopSearch(true);
        this.controller.getModel().removeResultListener(this.showAllResultsL);
        this.controller.getModel().clear();
        this.tableModel.clear();
        this.controller.disconnect();
        super.close();
    }

    public Component getGUI() {
        if (this.mainPanel == null) {
            this.mainPanel = this.createUI();
            this.setController(ShowAllNode.getInstance().passController());
            this.updateResultsLabel();
        }
        return this.mainPanel;
    }

    private JPanel createUI() {
        JPanel panel = new JPanel(new BorderLayout(10, 5));
        panel.setBackground(UIManager.getColor("TextField.background"));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add((Component)this.createControlBar(), "North");
        panel.add((Component)this.createTable(), "Center");
        panel.setPreferredSize(new Dimension(100, 100));
        return panel;
    }

    private JComponent createControlBar() {
        JPanel panel = new JPanel();
        panel.setBackground(UIManager.getColor("TextField.background"));
        this.searchField = new SearchField();
        this.searchField.getTextField().setColumns(40);
        this.searchField.setStyle(SearchField.Style.FILTER);
        this.searchField.addSearchListener((SearchListener)new SearchFieldL(null));
        this.installSearchFieldKeyboardActions();
        this.kindCombo = new JComboBox();
        this.kindCombo.setRenderer(new KindRenderer(null));
        this.kindCombo.addActionListener(new 1());
        String kindText = Bundle.get("KIND_FILTER_LABEL");
        JLabel kindLabel = new JLabel(StringUtils.stripMnemonic((String)kindText));
        kindLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)kindText));
        kindLabel.setLabelFor(this.kindCombo);
        panel.add((Component)this.searchField);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(kindLabel);
        panel.add(this.kindCombo);
        return panel;
    }

    private void updateBusy(boolean busy) {
        Icon icon = OracleIcons.getIcon((String)"throbber.gif");
        if (emptyIcon == null) {
            emptyIcon = new EmptyIcon(icon.getIconWidth(), icon.getIconHeight());
        }
        this.busyLabel.setIcon(busy ? icon : emptyIcon);
    }

    private JComponent createTable() {
        this.tableModel = new ShowAllTableModel();
        this.table = new ShowAllTable(null);
        this.table.setModel((TableModel)this.tableModel);
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)((Object)new TableResultRenderer(null)));
        this.table.setSorted(true);
        this.table.setColumnSelectorAvailable(true);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(220);
        this.table.getColumnModel().getColumn(1).setWidth(120);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(320);
        this.table.setSelectionMode(0);
        this.table.addMouseListener((MouseListener)new DoubleClickL(null));
        JScrollPane sp = new JScrollPane((Component)this.table);
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        this.resultsLabel = new JLabel(String.format("RESULTS_LABEL", 0));
        this.busyLabel = new JLabel();
        this.updateBusy(false);
        JPanel headerPanel = new JPanel(new BorderLayout(5, 5));
        headerPanel.add((Component)this.resultsLabel, "Before");
        headerPanel.add((Component)this.busyLabel, "After");
        headerPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        headerPanel.setOpaque(false);
        panel.setOpaque(false);
        panel.add((Component)headerPanel, "North");
        panel.add((Component)sp, "Center");
        return panel;
    }

    private void bindKey(JComponent c, String key, String actionName, Action action) {
        c.getInputMap(1).put(KeyStroke.getKeyStroke(key), actionName);
        c.getActionMap().put(actionName, action);
    }

    private void unbindKey(JComponent c, String key) {
        KeyStroke stroke = KeyStroke.getKeyStroke(key);
        c.getInputMap(1).remove(stroke);
        c.getInputMap(0).remove(stroke);
    }

    private void installSearchFieldKeyboardActions() {
        this.unbindKey((JComponent)this.searchField, "UP");
        this.unbindKey((JComponent)this.searchField, "DOWN");
        this.unbindKey((JComponent)this.searchField, "ENTER");
        this.bindKey((JComponent)this.searchField, "UP", "selectPreviousRow", new SelectPrevAction(null));
        this.bindKey((JComponent)this.searchField, "DOWN", "selectNextRow", new SelectNextAction(null));
        this.bindKey((JComponent)this.searchField, "ENTER", "openSelectedAction", new OpenAction(null));
    }

    public void update(Object observed, UpdateMessage change) {
    }

    public void activate() {
        this.updateContents();
        super.activate();
    }

    public void updateContents() {
        BaseController newController = ShowAllNode.getInstance().passController();
        if (newController != null) {
            this.setController(newController);
        }
    }

    private void setController(BaseController newController) {
        if (this.controller != null) {
            this.controller.getModel().removeResultListener(this.showAllResultsL);
            this.controller.getModel().clear();
            this.tableModel.clear();
            this.controller.disconnect();
        }
        this.controller = newController;
        this.populateFilters();
        this.showAllResultsL = new ShowAllResultsL(null);
        this.controller.getModel().addResultListener(this.showAllResultsL);
        this.tableModel.addResults(this.controller.getModel().getAllResults());
        this.searchField.setText(this.controller.getLastSearch(), true);
        this.updateBusy(this.controller.getModel().isRunning());
    }

    private void populateFilters() {
        Vector<Provider> providerV = new Vector<Provider>();
        providerV.add(new ShowAllProvider(this.controller));
        providerV.addAll(this.controller.getProviders());
        this.kindCombo.setModel(new DefaultComboBoxModel<Object>(providerV.toArray()));
    }

    private void updateResultsLabel() {
        int n = this.controller.getModel().getTotalResultCount();
        if (this.tableModel.getRowCount() >= ResultModel.SOFT_LIMIT) {
            this.resultsLabel.setText(String.format(Bundle.get("RESULTS_LABEL_LIMIT"), n, this.tableModel.getRowCount()));
        } else {
            this.resultsLabel.setText(String.format(Bundle.get("RESULTS_LABEL"), n));
        }
    }

    static ShowAllTableModel ra$tableModel(ShowAllEditor showAllEditor) {
        return showAllEditor.tableModel;
    }

    static void mav$updateResultsLabel(ShowAllEditor showAllEditor) {
        showAllEditor.updateResultsLabel();
    }

    static void mav$updateBusy(ShowAllEditor showAllEditor, boolean bl) {
        showAllEditor.updateBusy(bl);
    }

    static NiceTable ra$table(ShowAllEditor showAllEditor) {
        return showAllEditor.table;
    }

    static BaseController ra$controller(ShowAllEditor showAllEditor) {
        return showAllEditor.controller;
    }

    static JComboBox ra$kindCombo(ShowAllEditor showAllEditor) {
        return showAllEditor.kindCombo;
    }

    final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            ShowAllEditor.ra$tableModel(ShowAllEditor.this).filterProvider((Provider)ShowAllEditor.ra$kindCombo(ShowAllEditor.this).getSelectedItem());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ShowAllResultsL
    implements ResultModel.ResultListener {
        @Override
        public void newResults(Collection<Result<?>> results) {
            ShowAllEditor.ra$tableModel(ShowAllEditor.this).addResults(results);
            ShowAllEditor.mav$updateResultsLabel(ShowAllEditor.this);
        }

        @Override
        public void clearResults() {
            ShowAllEditor.ra$tableModel(ShowAllEditor.this).clear();
            ShowAllEditor.mav$updateResultsLabel(ShowAllEditor.this);
        }

        @Override
        public void runningChange(boolean isRunning) {
            ShowAllEditor.mav$updateBusy(ShowAllEditor.this, isRunning);
            ShowAllEditor.mav$updateResultsLabel(ShowAllEditor.this);
        }

        @Override
        public void deletedResult(Result result) {
            ShowAllEditor.ra$tableModel(ShowAllEditor.this).removeResult(result);
            ShowAllEditor.mav$updateResultsLabel(ShowAllEditor.this);
        }

        @Override
        public void deletedResults(Collection<Result<?>> results) {
            ShowAllEditor.ra$tableModel(ShowAllEditor.this).removeResults(results);
            ShowAllEditor.mav$updateResultsLabel(ShowAllEditor.this);
        }

        private ShowAllResultsL() {
        }

        ShowAllResultsL(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class TableResultRenderer
    extends NiceTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof Result) {
                label.setIcon(column == 0 ? ((Result)value).displayIcon() : null);
                label.setText(ShowAllEditor.ra$tableModel(ShowAllEditor.this).getColumnText((Result)value, column));
            }
            return label;
        }

        private TableResultRenderer() {
        }

        TableResultRenderer(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class OpenAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            int i = ShowAllEditor.ra$table(ShowAllEditor.this).convertRowToModelIndex(ShowAllEditor.ra$table(ShowAllEditor.this).getSelectedRow());
            if (i < 0) {
                return;
            }
            Result r = (Result)ShowAllEditor.ra$tableModel(ShowAllEditor.this).getValueAt(i, 0);
            r.open();
        }

        private OpenAction() {
        }

        OpenAction(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class SelectNextAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            int i = ShowAllEditor.ra$table(ShowAllEditor.this).getSelectedRow();
            i = Math.min(i + 1, ShowAllEditor.ra$table(ShowAllEditor.this).getRowCount() - 1);
            ShowAllEditor.ra$table(ShowAllEditor.this).getSelectionModel().setSelectionInterval(i, i);
        }

        private SelectNextAction() {
        }

        SelectNextAction(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class SelectPrevAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            int i = ShowAllEditor.ra$table(ShowAllEditor.this).getSelectedRow();
            i = Math.max(i - 1, 0);
            ShowAllEditor.ra$table(ShowAllEditor.this).getSelectionModel().setSelectionInterval(i, i);
        }

        private SelectPrevAction() {
        }

        SelectPrevAction(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class DoubleClickL
    extends MouseAdapter {
        public void mouseClicked(MouseEvent me) {
            if (me.getClickCount() == 2 && ShowAllEditor.ra$table(ShowAllEditor.this).getSelectedRow() != -1) {
                Result r = (Result)ShowAllEditor.ra$tableModel(ShowAllEditor.this).getValueAt(ShowAllEditor.ra$table(ShowAllEditor.this).convertRowToModelIndex(ShowAllEditor.ra$table(ShowAllEditor.this).getSelectedRow()), 0);
                r.open();
            }
        }

        private DoubleClickL() {
        }

        DoubleClickL(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class SearchFieldL
    implements SearchListener {
        public void searchPerformed(SearchEvent se) {
            if (se.getSearchText() == null || se.getSearchText().equals("") || se.isFromClear()) {
                ShowAllEditor.ra$controller(ShowAllEditor.this).stopSearch(true);
            } else {
                ShowAllEditor.ra$controller(ShowAllEditor.this).stopSearch(false);
                ShowAllEditor.ra$controller(ShowAllEditor.this).startSearch(se.getSearchText());
            }
        }

        public void searchCategoryChanged(SearchEvent se) {
        }

        private SearchFieldL() {
        }

        SearchFieldL(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class EmptyIcon
    implements Icon {
        int w;
        int h;

        public EmptyIcon(int width, int height) {
            this.w = width;
            this.h = height;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        public int getIconWidth() {
            return this.w;
        }

        public int getIconHeight() {
            return this.h;
        }
    }

    private class KindRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Provider p = (Provider)value;
            label.setText(p instanceof ShowAllProvider ? Bundle.get("KIND_FILTER_ALL") : p.name());
            return label;
        }

        private KindRenderer() {
        }

        KindRenderer(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class ShowAllTable
    extends PeekableNiceTable {
        public Peek createPeek(int row, int col) {
            if (col != 0) {
                return null;
            }
            Result r = (Result)ShowAllEditor.ra$tableModel(ShowAllEditor.this).getValueAt(ShowAllEditor.ra$table(ShowAllEditor.this).convertRowToModelIndex(row), 0);
            return r.provider().peek(r, (JComponent)ShowAllEditor.ra$table(ShowAllEditor.this), ShowAllEditor.ra$table(ShowAllEditor.this).getCellRect(row, col, true));
        }

        private ShowAllTable() {
        }

        ShowAllTable(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

