/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.searchbar;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import oracle.ide.searchbar.Provider;
import oracle.ide.searchbar.Result;
import oracle.ide.util.StringComparator;
import oracle.ideimpl.searchbar.Bundle;
import oracle.ideimpl.searchbar.ShowAllProvider;
import oracle.javatools.controls.nicetable.NiceTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ShowAllTableModel
extends AbstractTableModel
implements NiceTableModel {
    private List<Result> filteredResults;
    private List<Result> allResults;
    private Provider filterProvider;
    static String[] columns = new String[]{Bundle.get("TABLE_COLUMN_NAME"), Bundle.get("TABLE_COLUMN_KIND"), Bundle.get("TABLE_COLUMN_LOCATION")};

    private void $init$() {
        this.filteredResults = new ArrayList<Result>();
        this.allResults = new ArrayList<Result>();
    }

    @Override
    public int getRowCount() {
        return this.filteredResults.size();
    }

    @Override
    public int getColumnCount() {
        return columns.length;
    }

    @Override
    public String getColumnName(int colIndex) {
        return columns[colIndex];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Result r = this.filteredResults.get(rowIndex);
        return r;
    }

    public String getColumnText(Result result, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return result.displayText();
            }
            case 1: {
                return result.provider().name();
            }
            case 2: {
                return result.displayLocation();
            }
        }
        return "";
    }

    public void clear() {
        this.filteredResults.clear();
        this.allResults.clear();
        this.fireTableDataChanged();
    }

    private boolean filter(Result r) {
        if (this.filterProvider == null || this.filterProvider instanceof ShowAllProvider) {
            return true;
        }
        return this.filterProvider.equals(r.provider());
    }

    public void addResults(Collection<Result<?>> newResults) {
        int i = this.filteredResults.size() - 1;
        for (Result<?> r : newResults) {
            this.allResults.add(r);
            if (!this.filter(r)) continue;
            this.filteredResults.add(r);
        }
        this.fireTableRowsInserted(i, this.filteredResults.size() - 1);
    }

    public void removeResults(Collection<Result<?>> deletedResults) {
        for (Result<?> r : deletedResults) {
            this.allResults.remove(r);
            this.filteredResults.remove(r);
        }
        this.fireTableDataChanged();
    }

    public void removeResult(Result deletedResult) {
        int i = this.filteredResults.indexOf(deletedResult);
        this.allResults.remove(deletedResult);
        this.filteredResults.remove(deletedResult);
        if (i >= 0) {
            this.fireTableRowsDeleted(i, i);
        }
    }

    void filterProvider(Provider provider) {
        this.filterProvider = provider;
        this.filteredResults.clear();
        for (Result r : this.allResults) {
            if (!this.filter(r)) continue;
            this.filteredResults.add(r);
        }
        this.fireTableDataChanged();
    }

    public int getColumnAlignment(int column) {
        return 2;
    }

    public Comparator getColumnSortComparator(int column) {
        return new ResultComparator(column);
    }

    ShowAllTableModel() {
        this.$init$();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResultComparator
    extends StringComparator {
        int column;

        private void $init$() {
            this.column = 0;
        }

        ResultComparator(int column) {
            this.$init$();
            this.column = column;
        }

        public int compare(Object p1, Object p2) {
            if (p1 instanceof Result && p2 instanceof Result) {
                switch (this.column) {
                    case 0: {
                        p1 = ((Result)p1).displayText();
                        p2 = ((Result)p2).displayText();
                        break;
                    }
                    case 1: {
                        p1 = ((Result)p1).provider().name();
                        p2 = ((Result)p2).provider().name();
                        break;
                    }
                    case 2: {
                        p1 = ((Result)p1).displayLocation();
                        p2 = ((Result)p2).displayLocation();
                        break;
                    }
                }
            }
            return super.compare(p1, p2);
        }
    }
}

