/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.parser.defaults;

import java.util.ArrayList;
import oracle.dbtools.migration.parser.defaults.OracleSQLConstants;
import oracle.dbtools.migration.translation.api.ITranslationContext;
import oracle.dbtools.migration.translation.api.components.TranslationDataType;
import oracle.dbtools.migration.translation.api.components.TranslationParameter;
import oracle.dbtools.migration.translation.api.exceptions.TranslationObjectNotFoundException;
import oracle.dbtools.migration.translation.api.objects.TranslationColumn;
import oracle.dbtools.migration.translation.api.objects.TranslationDBObjectReference;
import oracle.dbtools.migration.translation.api.objects.TranslationDatabase;
import oracle.dbtools.migration.translation.api.prefs.TranslationPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTranslationContext
implements ITranslationContext {
    private TranslationPreferences m_prefs = null;
    private static final String NOTALLOWEDCHARS = " ' .@`!\"%^&*()-+=[]{};:,.<>?/~''\u00a3";
    private static final String TEMPORARYNAME = "#";
    private static final String TEMPTABLEPREFIX = "tt_";
    private static final String DIGITS = "0123456789";
    private static final String EXTRAALLOWED = "_$";

    @Override
    public TranslationPreferences getTranslationPreferences(Object object) {
        return this.m_prefs;
    }

    @Override
    public TranslationDatabase getExpectedTargetDatabase(Object object) {
        return null;
    }

    @Override
    public TranslationDatabase getSourceDatabase(Object object) throws TranslationObjectNotFoundException {
        return null;
    }

    @Override
    public TranslationDataType getTargetDataType(TranslationDataType translationDataType, Object object) {
        return null;
    }

    @Override
    public void completeSourceObject(TranslationDBObjectReference translationDBObjectReference, Object object) throws TranslationObjectNotFoundException {
    }

    @Override
    public void completeSourceColumn(TranslationColumn translationColumn, Object object) throws TranslationObjectNotFoundException {
    }

    @Override
    public TranslationDBObjectReference getTargetDBObjectReference(TranslationDBObjectReference translationDBObjectReference, Object object) throws TranslationObjectNotFoundException {
        if (translationDBObjectReference == null) {
            return null;
        }
        TranslationDBObjectReference translationDBObjectReference2 = new TranslationDBObjectReference(translationDBObjectReference);
        translationDBObjectReference2.setServerName(DefaultTranslationContext.createValidIdentifier(translationDBObjectReference.getServerName(), "server"));
        translationDBObjectReference2.setDatabaseName(DefaultTranslationContext.createValidIdentifier(translationDBObjectReference.getDatabaseName(), "database"));
        translationDBObjectReference2.setOwnerName(DefaultTranslationContext.createValidIdentifier(translationDBObjectReference.getOwnerName(), "owner"));
        translationDBObjectReference2.setObjName(DefaultTranslationContext.createValidIdentifier(translationDBObjectReference.getObjName(), "object"));
        translationDBObjectReference2.setPartName(DefaultTranslationContext.createValidIdentifier(translationDBObjectReference.getPartName(), "part"));
        return translationDBObjectReference2;
    }

    protected static String createValidIdentifier(String string, String string2) {
        if (string == null || string.trim().equals("")) {
            return string;
        }
        String string3 = string;
        if (string3.trim().equals("\"\"")) {
            return string3;
        }
        if (string3.trim().startsWith("'") && string3.trim().endsWith("'")) {
            return string3;
        }
        string3 = DefaultTranslationContext.removeQuoteCharacters(string3);
        int n = -999999996;
        try {
            n = Integer.parseInt(string3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n != -999999996) {
            return string3;
        }
        string3 = DefaultTranslationContext.leftTrimNonAlphaNumeric(string3);
        string3 = DefaultTranslationContext.firstCharCheck(string3, string2);
        string3 = DefaultTranslationContext.temporaryObjectCheck(string3);
        string3 = DefaultTranslationContext.removeInvalidCharacters(string3);
        string3 = DefaultTranslationContext.trimToSize(string3, 30);
        string3 = DefaultTranslationContext.modifyReservedNames(string3);
        return string3;
    }

    private static String temporaryObjectCheck(String string) {
        if (string.trim().startsWith(TEMPORARYNAME)) {
            // empty if block
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static String removeInvalidCharacters(String string) {
        void var6_9;
        char[] cArray = string.toCharArray();
        int n = 0;
        for (char n2 : cArray) {
            if (NOTALLOWEDCHARS.indexOf(n2) != -1) {
                cArray[n] = 95;
            }
            if (n != 0 && TEMPORARYNAME.indexOf(n2) != -1 && (n != 1 || cArray[0] != '#')) {
                cArray[n] = 95;
            }
            ++n;
        }
        n = 0;
        Object object = new StringBuffer();
        char[] cArray2 = cArray;
        int n2 = cArray2.length;
        boolean bl = false;
        while (var6_9 < n2) {
            char c = cArray2[var6_9];
            if (c == '_') {
                if (cArray.length > n + 1 && cArray[n + 1] != '_') {
                    ((StringBuffer)object).append(c);
                }
            } else {
                ((StringBuffer)object).append(c);
            }
            ++n;
            ++var6_9;
        }
        return ((StringBuffer)object).toString();
    }

    private static String modifyReservedNames(String string) {
        if (OracleSQLConstants.isSignificantWord(string) || OracleSQLConstants.isRservedWord(string)) {
            string = string + "_";
        }
        return string;
    }

    private static String trimToSize(String string, int n) {
        if (string != null && string.trim().length() > n) {
            string = string.trim().substring(0, n);
        }
        return string;
    }

    private static String firstCharCheck(String string, String string2) {
        char c = string.charAt(0);
        if (" ' .@`!\"%^&*()-+=[]{};:,.<>?/~''\u00a3_$0123456789".indexOf(c) != -1) {
            string = "A" + string;
        }
        return string;
    }

    private static String leftTrimNonAlphaNumeric(String string) {
        int n = 0;
        for (char c : string.toCharArray()) {
            if (" ' .@`!\"%^&*()-+=[]{};:,.<>?/~''\u00a3_$".indexOf(c) == -1) break;
            ++n;
        }
        return string.substring(n);
    }

    protected static String removeQuoteCharacters(String string) {
        if (string != null && (string.trim().startsWith("[") && string.trim().endsWith("]") || string.trim().startsWith("\"") && string.trim().endsWith("\""))) {
            string = string.trim().substring(1, string.length() - 1);
        }
        return string;
    }

    @Override
    public ArrayList<TranslationColumn> getSourceColumns(TranslationDBObjectReference translationDBObjectReference) {
        return null;
    }

    @Override
    public ArrayList<TranslationColumn> getTargetColumns(TranslationDBObjectReference translationDBObjectReference) throws TranslationObjectNotFoundException {
        return null;
    }

    @Override
    public ArrayList<TranslationParameter> getSourceParameters(TranslationDBObjectReference translationDBObjectReference) throws TranslationObjectNotFoundException {
        return null;
    }

    @Override
    public ArrayList<TranslationParameter> getTargetParameters(TranslationDBObjectReference translationDBObjectReference) throws TranslationObjectNotFoundException {
        return null;
    }

    @Override
    public ArrayList<TranslationDBObjectReference> getObjectsDependentOnThisSource(TranslationDBObjectReference translationDBObjectReference) throws TranslationObjectNotFoundException {
        return null;
    }

    @Override
    public ArrayList<TranslationDBObjectReference> getObjectsDependentOnThisTarget(TranslationDBObjectReference translationDBObjectReference) throws TranslationObjectNotFoundException {
        return null;
    }

    @Override
    public ArrayList<TranslationDBObjectReference> getSourceObjectsThisDependsOn(TranslationDBObjectReference translationDBObjectReference) throws TranslationObjectNotFoundException {
        return null;
    }

    @Override
    public ArrayList<TranslationDBObjectReference> getTargetObjectsThisDependsOn(TranslationDBObjectReference translationDBObjectReference) throws TranslationObjectNotFoundException {
        return null;
    }

    @Override
    public ArrayList<String> getEmulationFuncsForSchema(Object object) {
        return null;
    }

    @Override
    public ArrayList<String> getEmulationFuncsForConnection(Object object) {
        return null;
    }

    @Override
    public void addInfoKeyValue(String string, String string2) {
    }

    @Override
    public String getInfoKeyValue(String string) {
        return null;
    }

    @Override
    public void clearInfoKey() {
    }

    @Override
    public void setPreferences(TranslationPreferences translationPreferences) {
        this.m_prefs = translationPreferences;
    }
}

