/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.parser.defaults.expression;

import java.util.Hashtable;
import oracle.dbtools.migration.parser.defaults.expression.DefaultArithmeticOperator;
import oracle.dbtools.migration.parser.defaults.expression.DefaultBitwiseOperator;
import oracle.dbtools.migration.parser.defaults.expression.DefaultComparisonOperator;
import oracle.dbtools.migration.parser.defaults.expression.DefaultLogicalOperator;
import oracle.dbtools.migration.parser.defaults.expression.DefaultPipeConcatOperator;
import oracle.dbtools.migration.parser.defaults.expression.DefaultPlusOperator;
import oracle.dbtools.migration.parser.plugin.IExpressionOperator;
import oracle.dbtools.migration.parser.plugin.IExpressionOperatorMapper;

public class DefaultExpressionOperatorMapper
implements IExpressionOperatorMapper {
    protected static Hashtable<String, IExpressionOperator> m_operatorMap;

    public DefaultExpressionOperatorMapper() {
        this.initOperatorMapping();
    }

    private void initOperatorMapping() {
        DefaultLogicalOperator defaultLogicalOperator = new DefaultLogicalOperator();
        DefaultArithmeticOperator defaultArithmeticOperator = new DefaultArithmeticOperator();
        DefaultBitwiseOperator defaultBitwiseOperator = new DefaultBitwiseOperator();
        DefaultComparisonOperator defaultComparisonOperator = new DefaultComparisonOperator();
        m_operatorMap = new Hashtable();
        m_operatorMap.put("+", new DefaultPlusOperator());
        m_operatorMap.put("||", new DefaultPipeConcatOperator());
        m_operatorMap.put("-", defaultArithmeticOperator);
        m_operatorMap.put("*", defaultArithmeticOperator);
        m_operatorMap.put("/", defaultArithmeticOperator);
        m_operatorMap.put("%", defaultArithmeticOperator);
        m_operatorMap.put("&", defaultBitwiseOperator);
        m_operatorMap.put("|", defaultBitwiseOperator);
        m_operatorMap.put("^", defaultBitwiseOperator);
        m_operatorMap.put("~", defaultBitwiseOperator);
        m_operatorMap.put("=", defaultComparisonOperator);
        m_operatorMap.put("!=", defaultComparisonOperator);
        m_operatorMap.put(">", defaultComparisonOperator);
        m_operatorMap.put(">=", defaultComparisonOperator);
        m_operatorMap.put("<", defaultComparisonOperator);
        m_operatorMap.put("<=", defaultComparisonOperator);
        m_operatorMap.put("AND", defaultLogicalOperator);
        m_operatorMap.put("ANY", defaultLogicalOperator);
        m_operatorMap.put("ALL", defaultLogicalOperator);
        m_operatorMap.put("BETWEEN", defaultLogicalOperator);
        m_operatorMap.put("EXISTS", defaultLogicalOperator);
        m_operatorMap.put("IN", defaultLogicalOperator);
        m_operatorMap.put("LIKE", defaultLogicalOperator);
        m_operatorMap.put("NOT", defaultLogicalOperator);
        m_operatorMap.put("OR", defaultLogicalOperator);
        m_operatorMap.put("SOME", defaultLogicalOperator);
    }

    public IExpressionOperator getOperator(String string) {
        return m_operatorMap.get(string);
    }
}

